/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.dupont;

import com.kingdee.bos.bi.model.common.dupont.DupontConfig;
import com.kingdee.bos.bi.model.common.dupont.DupontModel;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureDimensionNode;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureTreeModel;
import com.kingdee.bos.bi.model.common.mm.metric.MetricDimensionNode;
import com.kingdee.bos.bi.model.common.mm.metric.MetricModel;
import com.kingdee.bos.bi.model.common.mm.org.OrgDimensionNode;
import com.kingdee.bos.bi.model.common.mm.org.OrgModel;
import com.kingdee.bos.bi.model.common.mm.period.PeriodDimensionNode;
import com.kingdee.bos.bi.model.common.mm.period.PeriodTreeModel;
import com.kingdee.bos.bi.model.common.mm.year.YearDimensionNode;
import com.kingdee.bos.bi.model.common.mm.year.YearTreeModel;
import com.kingdee.bos.bi.model.ui.dialog.dupont.DefaultMeasureSelector;
import com.kingdee.bos.bi.model.ui.dialog.dupont.DefaultOrgSelector;
import com.kingdee.bos.bi.model.ui.dialog.dupont.DefaultPeriodSelector;
import com.kingdee.bos.bi.model.ui.dialog.dupont.DefaultYearSelector;
import com.kingdee.bos.bi.model.ui.dialog.dupont.FontSelector;
import com.kingdee.bos.bi.model.ui.dialog.dupont.SourceAppModelSelector;
import com.kingdee.bos.bi.model.ui.dialog.dupont.SpecialStyleAttributes;
import com.kingdee.bos.bi.model.ui.dialog.dupont.SupplyAppModel;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DupontModelDialog
extends TypicalDialog {
    private InnerUI _ui;
    private boolean _isReadOnly;

    public DupontModelDialog() {
    }

    public DupontModelDialog(Dialog owner) {
        super(owner);
    }

    public DupontModelDialog(Frame owner) {
        super(owner);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        parent.add((Component)this._ui.getCtrl(), thisCell);
    }

    protected void todoInit() {
        this._ui = new InnerUI();
    }

    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
        this._ui.setReadOnly(isReadOnly);
        this._ui.txaDiscription.setEnabled(!isReadOnly);
        this._ui._btnSyncNodeDelete.setEnabled(!isReadOnly);
        this._ui._btnSyncNodeSelect.setEnabled(!isReadOnly);
        if (isReadOnly) {
            this.btnOk.setVisible(false);
            this.btnCancel.setText("\u5173\u95ed");
        }
    }

    protected boolean verify() {
        if (this.getDiscriptionTxt().length() > 2000) {
            WindowUtil.msgboxWarning((Object)"\u8bf4\u660e\u6587\u5b57\u7684\u6700\u5927\u957f\u5ea6\u4e3a2000\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        String result = this._ui.verify();
        if (result == null) {
            return true;
        }
        WindowUtil.msgboxWarning((Object)result, (String)this.getTitle(), (Component)((Object)this));
        return false;
    }

    protected void onCancel() {
        if (!this._isReadOnly && this._ui.isDirty()) {
            int askResult = WindowUtil.msgboxYesNoCancel((Component)((Object)this), (Object)"\u662f\u5426\u4fdd\u5b58\u5bf9\u5f53\u524d\u7684\u4fee\u6539\uff1f", (String)this.getTitle());
            if (askResult == 2) {
                return;
            }
            if (askResult == 0) {
                this.onOk();
                return;
            }
        }
        super.onCancel();
    }

    public void setSupplyer(ISupplyer supplyer) {
        this._ui.setSupplyer(supplyer);
    }

    public void setModel(DupontModel model) {
        this._ui.setModel(model);
    }

    public DupontModel getModel() {
        return this._ui.getModel();
    }

    public String getDiscriptionTxt() {
        return this._ui.getDiscriptionTxt();
    }

    public void setDiscriptionTxt(String discription) {
        this._ui.setDiscriptionTxt(discription);
    }

    public static interface ISupplyer {
        public SupplyAppModel[] getSourceAppModels();

        public MetricDimensionNode getMetricTree(String var1);

        public OrgDimensionNode getOrgTree(String var1);

        public YearDimensionNode getYearModel(String var1);

        public PeriodDimensionNode getPeriodModel(String var1);

        public MeasureDimensionNode getMeasureModel(String var1);
    }

    private static class InnerUI {
        private KDPanel _panAll;
        private KDPromptBox _f7SourceApp;
        private KDTabbedPane _tabDivide;
        private KDTextField _txtTitle;
        private KDTextArea txaDiscription;
        private KDPanel panSetting;
        private KDPromptBox f7PridictFont;
        private KDComboColor cPridictColor;
        private KDTree _tree;
        private KDTree _tree4SyncNode;
        private KDList _lstSyncNode;
        private KDWorkButton _btnSyncNodeSelect;
        private KDWorkButton _btnSyncNodeDelete;
        private KDCheckBox _chkShowOrg;
        private KDCheckBox _chkShowPeriod;
        private KDCheckBox _chkShowMeasure;
        private KDPromptBox _f7DefaultOrg;
        private KDPromptBox _f7DefaultYear;
        private KDPromptBox _f7DefaultPeriod;
        private KDPromptBox _f7DefaultMeasure;
        private ISupplyer _supplyer;
        private boolean _isDirty;

        public InnerUI() {
            this.init();
        }

        private void init() {
            this._f7SourceApp = new KDPromptBox();
            this._f7SourceApp.setEditable(false);
            this._f7SourceApp.addDataChangeListener((DataChangeListener)new SourceAppChangeHandler());
            KDLabelContainer lbcSourceApp = CtrlSwingUtilities.createLabelContainer((JComponent)this._f7SourceApp, (String)"\u6765\u6e90\u4e8e\u5e94\u7528\u6a21\u578b", (int)120);
            this._txtTitle = new KDTextField();
            KDLabelContainer lbcTitle = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtTitle, (String)"\u6807\u9898", (int)120);
            this._tree = new KDTree();
            this._tree.setShowsRootHandles(true);
            this._tree4SyncNode = new KDTree();
            this._tree4SyncNode.setShowsRootHandles(true);
            this._lstSyncNode = new KDList();
            this._btnSyncNodeSelect = new KDWorkButton("\u2192");
            this._btnSyncNodeSelect.setToolTipText("\u6dfb\u52a0");
            this._btnSyncNodeDelete = new KDWorkButton("\u2190");
            this._btnSyncNodeDelete.setToolTipText("\u5220\u9664");
            DefineSyncNodeHandler defineSyncNodeHandler = new DefineSyncNodeHandler();
            this._btnSyncNodeSelect.addActionListener((ActionListener)defineSyncNodeHandler);
            this._btnSyncNodeDelete.addActionListener((ActionListener)defineSyncNodeHandler);
            this._chkShowOrg = new KDCheckBox("\u63d0\u4f9b\u7ec4\u7ec7\u8fc7\u6ee4");
            this._chkShowPeriod = new KDCheckBox("\u63d0\u4f9b\u8d22\u52a1\u671f\u95f4\u8fc7\u6ee4");
            this._chkShowMeasure = new KDCheckBox("\u63d0\u4f9b\u5ea6\u91cf\u8fc7\u6ee4");
            this._f7DefaultOrg = new KDPromptBox();
            this._f7DefaultYear = new KDPromptBox();
            this._f7DefaultPeriod = new KDPromptBox();
            this._f7DefaultMeasure = new KDPromptBox();
            this._f7DefaultOrg.setEditable(false);
            this._f7DefaultYear.setEditable(false);
            this._f7DefaultPeriod.setEditable(false);
            this._f7DefaultMeasure.setEditable(false);
            this._f7DefaultOrg.setSelector((KDPromptSelector)new DefaultOrgSelector((JComponent)this._f7DefaultOrg));
            this._f7DefaultYear.setSelector((KDPromptSelector)new DefaultYearSelector((JComponent)this._f7DefaultYear));
            this._f7DefaultPeriod.setSelector((KDPromptSelector)new DefaultPeriodSelector((JComponent)this._f7DefaultPeriod));
            this._f7DefaultMeasure.setSelector((KDPromptSelector)new DefaultMeasureSelector((JComponent)this._f7DefaultMeasure));
            ModelDirtyHandler dirtyHandler = new ModelDirtyHandler();
            this._txtTitle.addKeyListener((KeyListener)dirtyHandler);
            this._f7SourceApp.addDataChangeListener((DataChangeListener)dirtyHandler);
            this._f7DefaultOrg.addDataChangeListener((DataChangeListener)dirtyHandler);
            this._f7DefaultYear.addDataChangeListener((DataChangeListener)dirtyHandler);
            this._f7DefaultPeriod.addDataChangeListener((DataChangeListener)dirtyHandler);
            this._f7DefaultMeasure.addDataChangeListener((DataChangeListener)dirtyHandler);
            this._chkShowOrg.addActionListener((ActionListener)dirtyHandler);
            this._chkShowPeriod.addActionListener((ActionListener)dirtyHandler);
            this._chkShowMeasure.addActionListener((ActionListener)dirtyHandler);
            this._tree.addTreeExpansionListener((TreeExpansionListener)dirtyHandler);
            this._btnSyncNodeSelect.addActionListener((ActionListener)dirtyHandler);
            this._btnSyncNodeDelete.addActionListener((ActionListener)dirtyHandler);
            this._tabDivide = new KDTabbedPane();
            this._tabDivide.setForcedHide(true);
            this._tabDivide.addTab("\u5e03\u5c40", (Component)this.createTab_TreeState());
            this._tabDivide.addTab("\u8fc7\u6ee4", (Component)this.createTab_Filter());
            this._tabDivide.addTab("\u5173\u8054", (Component)this.createTab_SyncNode());
            this._tabDivide.addTab("\u8bbe\u7f6e", (Component)this.createTab_Setting());
            this._tabDivide.addTab("\u5907\u6ce8", (Component)this.getDiscriptionPanel());
            TableLayout2 layout = new TableLayout2(3, 1);
            layout.setFixedHeight(0, 20);
            layout.setRowSpacing(0, 3);
            layout.setFixedHeight(1, 20);
            layout.setRowSpacing(1, 8);
            layout.setRatableHeight(2, 100);
            this._panAll = new KDPanel((LayoutManager)layout);
            this._panAll.add((Component)lbcTitle, (Object)TableLayout2.param((int)0, (int)0));
            this._panAll.add((Component)lbcSourceApp, (Object)TableLayout2.param((int)1, (int)0));
            this._panAll.add((Component)this._tabDivide, (Object)TableLayout2.param((int)2, (int)0));
        }

        public String getDiscriptionTxt() {
            return this.txaDiscription.getText().trim();
        }

        public void setDiscriptionTxt(String discription) {
            if (discription != null) {
                this.txaDiscription.setText(discription);
            }
        }

        private KDPanel getDiscriptionPanel() {
            KDPanel panDiscription = new KDPanel();
            panDiscription.setCustomInsets(new Insets(8, 8, 8, 8));
            TableLayout2 tly = new TableLayout2(2, 1);
            tly.setFixedHeight(0, 21);
            tly.setRatableHeight(1, 100);
            panDiscription.setLayout((LayoutManager)tly);
            KDLabel lblDiscription = new KDLabel("\u8bf4\u660e\uff08\u6a21\u578b\u8bbe\u8ba1\u8005\u5907\u6ce8\uff09\uff1a");
            this.txaDiscription = new KDTextArea();
            KDScrollPane scrpDiscription = new KDScrollPane((Component)this.txaDiscription);
            panDiscription.add((Component)lblDiscription, (Object)TableLayout2.param((int)0, (int)0));
            panDiscription.add((Component)scrpDiscription, (Object)TableLayout2.param((int)1, (int)0));
            return panDiscription;
        }

        private JComponent createGroup_Filter() {
            KDCheckBox chkShowYear = new KDCheckBox("\u63d0\u4f9b\u5e74\u8fc7\u6ee4\uff08\u5fc5\u6709\uff09");
            chkShowYear.setSelected(true);
            chkShowYear.setEnabled(false);
            TableLayout2 layout = new TableLayout2(5, 1);
            layout.setRowsSpacing(TableLayout2.ALL, 3);
            layout.setFixedHeight(TableLayout2.ALL, 20);
            layout.setRatableHeight(4, 100);
            KDPanel pan = new KDPanel((LayoutManager)layout);
            pan.setOpaque(false);
            pan.setCustomInsets(new Insets(8, 8, 0, 8));
            pan.add((Component)this._chkShowOrg, (Object)TableLayout2.param((int)0, (int)0));
            pan.add((Component)chkShowYear, (Object)TableLayout2.param((int)1, (int)0));
            pan.add((Component)this._chkShowPeriod, (Object)TableLayout2.param((int)2, (int)0));
            pan.add((Component)this._chkShowMeasure, (Object)TableLayout2.param((int)3, (int)0));
            KDContainer ctn = new KDContainer();
            ctn.setTitle("\u8fc7\u6ee4\u5668");
            ctn.setEnableActive(false);
            ctn.getContentPane().setLayout(new BorderLayout());
            ctn.getContentPane().add((Component)pan, "Center");
            return ctn;
        }

        private JComponent createGroup_Default() {
            KDLabelContainer lbcDefaultOrg = CtrlSwingUtilities.createLabelContainer((JComponent)this._f7DefaultOrg, (String)"\u7ec4\u7ec7", (int)60);
            KDLabelContainer lbcDefaultYear = CtrlSwingUtilities.createLabelContainer((JComponent)this._f7DefaultYear, (String)"\u5e74", (int)60);
            KDLabelContainer lbcDefaultPeriod = CtrlSwingUtilities.createLabelContainer((JComponent)this._f7DefaultPeriod, (String)"\u8d22\u52a1\u671f\u95f4", (int)60);
            KDLabelContainer lbcDefaultMeasure = CtrlSwingUtilities.createLabelContainer((JComponent)this._f7DefaultMeasure, (String)"\u5ea6\u91cf", (int)60);
            TableLayout2 layout = new TableLayout2(5, 1);
            layout.setRowsSpacing(TableLayout2.ALL, 3);
            layout.setFixedHeight(TableLayout2.ALL, 20);
            layout.setRatableHeight(4, 100);
            KDPanel pan = new KDPanel((LayoutManager)layout);
            pan.setOpaque(false);
            pan.setCustomInsets(new Insets(8, 8, 0, 8));
            pan.add((Component)lbcDefaultOrg, (Object)TableLayout2.param((int)0, (int)0));
            pan.add((Component)lbcDefaultYear, (Object)TableLayout2.param((int)1, (int)0));
            pan.add((Component)lbcDefaultPeriod, (Object)TableLayout2.param((int)2, (int)0));
            pan.add((Component)lbcDefaultMeasure, (Object)TableLayout2.param((int)3, (int)0));
            KDContainer ctn = new KDContainer();
            ctn.setTitle("\u521d\u59cb\u72b6\u6001\u9ed8\u8ba4\u503c");
            ctn.setEnableActive(false);
            ctn.getContentPane().setLayout(new BorderLayout());
            ctn.getContentPane().add((Component)pan, "Center");
            return ctn;
        }

        private JComponent createTab_TreeState() {
            KDTreeView tv = new KDTreeView(this._tree);
            tv.setTitle("\u8bbe\u7f6e\u675c\u90a6\u6811\u521d\u59cb\u5c55\u5f00\u72b6\u6001");
            KDPanel panTree = new KDPanel((LayoutManager)new BorderLayout());
            panTree.setCustomInsets(new Insets(8, 8, 8, 8));
            panTree.add((Component)tv, (Object)"Center");
            return panTree;
        }

        private JComponent createTab_Filter() {
            TableLayout2 lyFilter = new TableLayout2(2, 2);
            lyFilter.setFixedHeight(0, 140);
            lyFilter.setRatableHeight(1, 100);
            lyFilter.setColsSpacing(TableLayout2.ALL, 6);
            lyFilter.setRatableWidth(0, 618);
            lyFilter.setRatableWidth(1, 382);
            KDPanel panFilter = new KDPanel((LayoutManager)lyFilter);
            panFilter.setCustomInsets(new Insets(8, 8, 8, 8));
            panFilter.add((Component)this.createGroup_Default(), (Object)TableLayout2.param((int)0, (int)0));
            panFilter.add((Component)this.createGroup_Filter(), (Object)TableLayout2.param((int)0, (int)1));
            return panFilter;
        }

        private JComponent createTab_Setting() {
            TableLayout2 lySetting = new TableLayout2(3, 3);
            lySetting.setRowSpacing(0, 5);
            lySetting.setFixedHeight(0, 20);
            lySetting.setFixedHeight(1, 20);
            lySetting.setRatableHeight(2, 100);
            lySetting.setFixedWidth(0, 100);
            lySetting.setFixedWidth(1, 160);
            lySetting.setRatableWidth(2, 100);
            this.panSetting = new KDPanel((LayoutManager)lySetting);
            this.panSetting.setCustomInsets(new Insets(15, 20, 8, 8));
            DupontConfig dc = new DupontConfig(new HashMap());
            KDLabel lblFont = new KDLabel("\u9884\u6d4b\u7684\u5b57\u4f53\uff1a");
            this.panSetting.add((Component)lblFont, (Object)TableLayout2.param((int)0, (int)0));
            this.f7PridictFont = new KDPromptBox();
            this.f7PridictFont.setEditable(false);
            this.panSetting.add((Component)this.f7PridictFont, (Object)TableLayout2.param((int)0, (int)1));
            KDLabel lblBackColor = new KDLabel("\u9884\u6d4b\u7684\u80cc\u666f\uff1a");
            this.panSetting.add((Component)lblBackColor, (Object)TableLayout2.param((int)1, (int)0));
            this.cPridictColor = new KDComboColor();
            this.panSetting.add((Component)this.cPridictColor, (Object)TableLayout2.param((int)1, (int)1));
            this.loadConfig(dc);
            return this.panSetting;
        }

        private void loadConfig(DupontConfig dc) {
            SpecialStyleAttributes saPredict = SpecialStyleAttributes.getDefaultSA();
            saPredict.setFontName(dc.getPridictFontname());
            saPredict.setFontSize(dc.getPridictFontsize());
            saPredict.setFontColor(dc.getPridictFontColor());
            saPredict.setBold(dc.getPridictFontBold());
            saPredict.setItalic(dc.getPridictFontItalic());
            saPredict.setStrikeThrough(dc.getPridictFontStrikethrough());
            saPredict.setUnderline(dc.getPridictFontUnderline());
            this.f7PridictFont.setValue((Object)saPredict);
            this.f7PridictFont.getComponent(0).setFont(saPredict.createFont());
            ((KDPromptBox.DefaultEditor)this.f7PridictFont.getComponent(0)).setCustomForegroundColor(saPredict.getFontColor());
            this.f7PridictFont.setSelector((KDPromptSelector)new FontSelector(this.f7PridictFont, (JComponent)this.panSetting, saPredict, dc));
            this.cPridictColor.setColor(dc.getPridictBackColor());
        }

        private DupontConfig getConfig() {
            DupontConfig dc = new DupontConfig();
            SpecialStyleAttributes sa = (SpecialStyleAttributes)((Object)this.f7PridictFont.getValue());
            dc.setPridictFontname(sa.getFontName());
            dc.setPridictFontsize(sa.getFontSize());
            dc.setPridictFontBold(sa.isBold());
            dc.setPridictFontItalic(sa.isItalic());
            dc.setPridictFontColor(sa.getFontColor());
            dc.setPridictFontUnderline(sa.isUnderline());
            dc.setPridictFontStrikethrough(sa.isStrikeThrough());
            dc.setPridictBackColor(this.cPridictColor.getColor());
            return dc;
        }

        private JComponent createTab_SyncNode() {
            KDLabel lab = new KDLabel("\u8bbe\u7f6e\u9884\u6d4b\u8fc7\u7a0b\u7684\u5173\u8054\u6307\u6807\u2014\u2014\u5f53\u7528\u6237\u505a\u9884\u6d4b\u65f6\u6539\u52a8\u4e00\u4e2a\u6307\u6807\u7684\u503c\uff0c\u5173\u8054\u7684\u6307\u6807\u5c06\u81ea\u52a8\u6539\u6210\u76f8\u540c\u7684\u503c\u3002");
            KDTreeView tv = new KDTreeView(this._tree4SyncNode);
            tv.setTitle("\u5907\u9009\u6307\u6807\uff08[Ctrl]+\u9f20\u6807\u591a\u9009\uff09");
            tv.setShowButton(false);
            KDLabel labSelected = new KDLabel("\u5df2\u5b9a\u4e49\u7684\u5173\u8054\u6307\u6807\uff1a ");
            TableLayout2 ly = new TableLayout2(6, 3);
            ly.setRowsSpacing(TableLayout2.ALL, 3);
            ly.setFixedHeight(0, 20);
            ly.setFixedHeight(1, 17);
            ly.setRatableHeight(2, 45);
            ly.setFixedHeight(3, 23);
            ly.setFixedHeight(4, 23);
            ly.setRatableHeight(5, 55);
            ly.setColsSpacing(TableLayout2.ALL, 6);
            ly.setRatableWidth(new int[]{0, 2}, 1);
            ly.setFixedWidth(1, 40);
            KDPanel pan = new KDPanel((LayoutManager)ly);
            pan.setCustomInsets(new Insets(8, 8, 8, 8));
            pan.add((Component)lab, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)2));
            pan.add((Component)tv, (Object)TableLayout2.param((int)1, (int)0, (int)5, (int)0));
            pan.add((Component)this._btnSyncNodeSelect, (Object)TableLayout2.param((int)3, (int)1));
            pan.add((Component)this._btnSyncNodeDelete, (Object)TableLayout2.param((int)4, (int)1));
            pan.add((Component)labSelected, (Object)TableLayout2.param((int)1, (int)2));
            pan.add((Component)new KDScrollPane((Component)this._lstSyncNode), (Object)TableLayout2.param((int)2, (int)2, (int)5, (int)2));
            return pan;
        }

        private DefaultOrgSelector getOrgSelector() {
            return (DefaultOrgSelector)this._f7DefaultOrg.getSelector();
        }

        private DefaultYearSelector getYearSelector() {
            return (DefaultYearSelector)this._f7DefaultYear.getSelector();
        }

        private DefaultPeriodSelector getPeriodSelector() {
            return (DefaultPeriodSelector)this._f7DefaultPeriod.getSelector();
        }

        private DefaultMeasureSelector getMeasureSelector() {
            return (DefaultMeasureSelector)this._f7DefaultMeasure.getSelector();
        }

        public void setReadOnly(boolean isReadOnly) {
            this._txtTitle.setEnabled(!isReadOnly);
            this._f7SourceApp.setEnabled(!isReadOnly);
            this._tree.setEnabled(!isReadOnly);
            this._chkShowOrg.setEnabled(!isReadOnly);
            this._chkShowPeriod.setEnabled(!isReadOnly);
            this._chkShowMeasure.setEnabled(!isReadOnly);
            this._f7DefaultOrg.setEnabled(!isReadOnly);
            this._f7DefaultYear.setEnabled(!isReadOnly);
            this._f7DefaultPeriod.setEnabled(!isReadOnly);
            this._f7DefaultMeasure.setEnabled(!isReadOnly);
        }

        public boolean isDirty() {
            return this._isDirty;
        }

        public JComponent getCtrl() {
            return this._panAll;
        }

        public void setSupplyer(ISupplyer supplyer) {
            this._supplyer = supplyer;
            this._f7SourceApp.setSelector((KDPromptSelector)new SourceAppModelSelector((JComponent)this._f7SourceApp, supplyer));
        }

        public void setModel(DupontModel model) {
            if (model == null) {
                this._f7SourceApp.setData(null);
                this._chkShowOrg.setSelected(false);
                this._chkShowPeriod.setSelected(false);
                this._chkShowMeasure.setSelected(false);
                this._f7DefaultOrg.setData(null);
                this._f7DefaultYear.setData(null);
                this._f7DefaultPeriod.setData(null);
                this._f7DefaultMeasure.setData(null);
                this.updateTreeCtrl(null);
            } else {
                this._txtTitle.setText(model.getTitle());
                this.loadConfig(model.getDupontConfig());
                String refAppModelId = model.getRefAppModel();
                SupplyAppModel sourceAppModel = ((SourceAppModelSelector)this._f7SourceApp.getSelector()).getAppointData(refAppModelId);
                this._f7SourceApp.setData((Object)sourceAppModel);
                this._chkShowOrg.setSelected(model.isShowOrgFilter());
                this._chkShowPeriod.setSelected(model.isShowPeriodFilter());
                this._chkShowMeasure.setSelected(model.isShowMeasureFilter());
                InnerUI.retakeTreeDesignInfo(model.getMetricTree(), sourceAppModel.getMetricTreeRoot());
                this.updateTreeCtrl(model.getMetricTree());
                this.updateMMSupply(refAppModelId);
                OrgModel org = model.getDefaultOrg();
                if (org != null && org.getName() == null) {
                    org = this.getOrgSelector().getAppointData(org);
                }
                this._f7DefaultOrg.setData((Object)org);
                this.getOrgSelector().setSelected(org);
                YearTreeModel year = model.getDefaultYear();
                if (year != null && year.getName() == null) {
                    year = this.getYearSelector().getAppointData(year);
                }
                this._f7DefaultYear.setData((Object)year);
                this.getYearSelector().setSelected(year);
                PeriodTreeModel period = model.getDefaultPeriod();
                if (period != null) {
                    period = this.getPeriodSelector().getAppointData(period);
                }
                this._f7DefaultPeriod.setData((Object)period);
                this.getPeriodSelector().setSelected(period);
                MeasureTreeModel[] measures = model.getDefaultMeasures();
                if (measures != null) {
                    measures = this.getMeasureSelector().getAppointData(measures);
                }
                this._f7DefaultMeasure.setData((Object)new DefaultMeasureSelector.ReturnValue(measures));
                this.getMeasureSelector().setSelected(measures);
                DupontModel.SyncNodePair[] snps = model.getSyncNodePairs();
                int c = snps.length;
                for (int i = 0; i < c; ++i) {
                    this._lstSyncNode.addElement((Object)snps[i]);
                }
            }
        }

        private void updateTreeCtrl(MetricDimensionNode moNode) {
            if (moNode == null) {
                DefaultKingdeeTreeNode ctrlTreeRoot = new DefaultKingdeeTreeNode((Object)"\u9690\u85cf\u7684\u6839");
                this._tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)ctrlTreeRoot));
                this._tree.setRootVisible(false);
                DefaultKingdeeTreeNode ctrlTreeRoot2 = new DefaultKingdeeTreeNode((Object)"\u65e0\u53ef\u9009\u5185\u5bb9");
                this._tree4SyncNode.setModel((TreeModel)new KingdeeTreeModel((TreeNode)ctrlTreeRoot2));
            } else {
                DefaultKingdeeTreeNode ctrlTreeRoot = this.treeModel2Ui(moNode);
                this._tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)ctrlTreeRoot));
                this._tree.setRootVisible(true);
                this.expandTreeCtrl(ctrlTreeRoot);
                DefaultKingdeeTreeNode ctrlTreeRoot2 = this.treeModel2Ui(moNode);
                this._tree4SyncNode.setModel((TreeModel)new KingdeeTreeModel((TreeNode)ctrlTreeRoot2));
                this._tree4SyncNode.expandAllNodes(true, (TreeNode)ctrlTreeRoot2);
            }
        }

        private DefaultKingdeeTreeNode treeModel2Ui(MetricDimensionNode moNode) {
            DefaultKingdeeTreeNode ctrlNode = new DefaultKingdeeTreeNode();
            ctrlNode.setText(moNode.getMetricModel().getText4UI());
            ctrlNode.setUserObject((Object)moNode.getMetricModel());
            for (int i = 0; i < moNode.getChildCount(); ++i) {
                ctrlNode.add((MutableTreeNode)this.treeModel2Ui(moNode.getChild(i)));
            }
            return ctrlNode;
        }

        private void expandTreeCtrl(DefaultKingdeeTreeNode ctrlNode) {
            MetricModel model = (MetricModel)((Object)ctrlNode.getUserObject());
            if (Boolean.TRUE == model.getExtProps("expand")) {
                this._tree.expandPath(new TreePath(ctrlNode.getPath()));
                for (int i = 0; i < ctrlNode.getChildCount(); ++i) {
                    this.expandTreeCtrl((DefaultKingdeeTreeNode)ctrlNode.getChildAt(i));
                }
            }
        }

        public DupontModel getModel() {
            DupontModel model = new DupontModel();
            model.setTitle(this._txtTitle.getText());
            model.setDupontConfig(this.getConfig());
            model.setRefAppModel(((SupplyAppModel)this._f7SourceApp.getData()).getName());
            model.setMetricTree(this.treeUi2Model((DefaultKingdeeTreeNode)this._tree.getModel().getRoot()));
            DefaultMeasureSelector.ReturnValue measuresReturn = (DefaultMeasureSelector.ReturnValue)this._f7DefaultMeasure.getData();
            MeasureTreeModel[] measures = measuresReturn == null ? null : measuresReturn.getResults();
            model.setDefaultMeasures(measures);
            model.setDefaultOrg((OrgModel)((Object)this._f7DefaultOrg.getData()));
            model.setDefaultPeriod((PeriodTreeModel)((Object)this._f7DefaultPeriod.getData()));
            model.setDefaultYear((YearTreeModel)((Object)this._f7DefaultYear.getData()));
            model.setShowMeasureFilter(this._chkShowMeasure.isSelected());
            model.setShowOrgFilter(this._chkShowOrg.isSelected());
            model.setShowPeriodFilter(this._chkShowPeriod.isSelected());
            model.clearAllSyncNodePairs();
            int c = this._lstSyncNode.getElementCount();
            for (int i = 0; i < c; ++i) {
                model.addSyncNodePair((DupontModel.SyncNodePair)this._lstSyncNode.getElement(i));
            }
            return model;
        }

        private MetricDimensionNode treeUi2Model(DefaultKingdeeTreeNode ctrlNode) {
            MetricModel model = (MetricModel)((Object)ctrlNode.getUserObject());
            MetricDimensionNode moNode = new MetricDimensionNode();
            moNode.setMetricModel(model);
            if (this._tree.isExpanded(new TreePath(ctrlNode.getPath()))) {
                model.setExtProps("expand", Boolean.TRUE);
            } else {
                model.setExtProps("expand", Boolean.FALSE);
            }
            for (int i = 0; i < ctrlNode.getChildCount(); ++i) {
                moNode.addChild(this.treeUi2Model((DefaultKingdeeTreeNode)ctrlNode.getChildAt(i)));
            }
            return moNode;
        }

        public String verify() {
            MetricDimensionNode treeWithName;
            if (this._f7SourceApp.getData() == null) {
                return "\u672a\u9009\u62e9\u5e94\u7528\u6a21\u578b\u3002";
            }
            DefaultKingdeeTreeNode ctrlTreeRoot = (DefaultKingdeeTreeNode)this._tree.getModel().getRoot();
            if (!(ctrlTreeRoot.getUserObject() instanceof MetricModel)) {
                return "\u65e0\u6548\u7684\u5e94\u7528\u6a21\u578b\uff0c\u6ca1\u6709\u6307\u6807\u6811\u3002";
            }
            MetricDimensionNode tree = this.treeUi2Model((DefaultKingdeeTreeNode)this._tree.getModel().getRoot());
            if (!InnerUI.checkMetricTree(tree, treeWithName = ((SupplyAppModel)this._f7SourceApp.getData()).getMetricTreeRoot())) {
                return "\u6307\u6807\u6811\u88ab\u4fee\u6539\uff0c\u9700\u91cd\u65b0\u5f15\u5165\u5e94\u7528\u6a21\u578b\u3002";
            }
            String checkDefaultValueResult = this.retakeDefaultValueDesignInfo();
            if (checkDefaultValueResult != null) {
                return checkDefaultValueResult + StringUtil.RETURN + "\u8bf7\u4fee\u6539\u3002";
            }
            return null;
        }

        private void updateMMSupply(String refAppModelId) {
            OrgDimensionNode org = null;
            YearDimensionNode year = null;
            PeriodDimensionNode period = null;
            MeasureDimensionNode measure = null;
            if (refAppModelId != null) {
                org = this._supplyer.getOrgTree(refAppModelId);
                year = this._supplyer.getYearModel(refAppModelId);
                period = this._supplyer.getPeriodModel(refAppModelId);
                measure = this._supplyer.getMeasureModel(refAppModelId);
            }
            this.getOrgSelector().setSupply(org);
            this.getYearSelector().setSupply(year);
            this.getPeriodSelector().setSupply(period);
            this.getMeasureSelector().setSupply(measure);
        }

        private String retakeDefaultValueDesignInfo() {
            MeasureTreeModel[] measures;
            OrgModel org = (OrgModel)((Object)this._f7DefaultOrg.getData());
            if (org != null && org.getName() != null && (org = this.getOrgSelector().getAppointData(org)).getName() == null) {
                return "\u7ec4\u7ec7\u9ed8\u8ba4\u503c\u201c" + org.getNumber() + "\u201d\u4e0d\u5b58\u5728\u3002";
            }
            YearTreeModel year = (YearTreeModel)((Object)this._f7DefaultYear.getData());
            if (year != null && year.getName() != null && (year = this.getYearSelector().getAppointData(year)).getName() == null) {
                return "\u5e74\u9ed8\u8ba4\u503c\u201c" + year.getNumber() + "\u201d\u4e0d\u5b58\u5728\u3002";
            }
            PeriodTreeModel period = (PeriodTreeModel)((Object)this._f7DefaultPeriod.getData());
            if (period != null && (period = this.getPeriodSelector().getAppointData(period)).getName() == null) {
                return "\u8d22\u52a1\u671f\u95f4\u9ed8\u8ba4\u503c\u201c" + period.getNumber() + "\u201d\u4e0d\u5b58\u5728\u3002";
            }
            DefaultMeasureSelector.ReturnValue measuresReturn = (DefaultMeasureSelector.ReturnValue)this._f7DefaultMeasure.getData();
            MeasureTreeModel[] measureTreeModelArray = measures = measuresReturn == null ? null : measuresReturn.getResults();
            if (measures != null) {
                measures = this.getMeasureSelector().getAppointData(measures);
                for (int i = 0; i < measures.length; ++i) {
                    if (measures[i].getName() != null) continue;
                    return "\u5ea6\u91cf\u9ed8\u8ba4\u503c\u201c" + measures[i].getNumber() + "\u201d\u4e0d\u5b58\u5728\u3002";
                }
            }
            return null;
        }

        private static void retakeTreeDesignInfo(MetricDimensionNode node, MetricDimensionNode nodeWithName) {
            InnerUI.retakeTreeDesignInfo(node, nodeWithName, false);
        }

        private static boolean checkMetricTree(MetricDimensionNode node, MetricDimensionNode nodeWithName) {
            return InnerUI.retakeTreeDesignInfo(node, nodeWithName, true);
        }

        private static boolean retakeTreeDesignInfo(MetricDimensionNode node, MetricDimensionNode nodeWithName, boolean isJustCheck) {
            if (node == null || nodeWithName == null) {
                return false;
            }
            MetricModel model = node.getMetricModel();
            MetricModel modelWithName = nodeWithName.getMetricModel();
            if (StringUtil.equals((String)model.getNumber(), (String)modelWithName.getNumber())) {
                if (!isJustCheck) {
                    model.setName(modelWithName.getName());
                }
                if (node.getChildCount() == nodeWithName.getChildCount()) {
                    boolean result = true;
                    int c = node.getChildCount();
                    for (int i = 0; i < c; ++i) {
                        result = InnerUI.retakeTreeDesignInfo(node.getChild(i), nodeWithName.getChild(i), isJustCheck) && result;
                    }
                    return result;
                }
                return false;
            }
            return false;
        }

        private class DefineSyncNodeHandler
        implements ActionListener {
            private DefineSyncNodeHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InnerUI.this._btnSyncNodeSelect == e.getSource()) {
                    this.select();
                } else if (InnerUI.this._btnSyncNodeDelete == e.getSource()) {
                    this.delete();
                }
            }

            private void select() {
                if (InnerUI.this._tree4SyncNode.getSelectionCount() < 2) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u5728\u5907\u9009\u6307\u6807\u91cc\u9009\u4e2d\u81f3\u5c11\u4e8c\u4e2a\u8282\u70b9\u3002\u952e\u76d8[Ctrl]+\u9f20\u6807\u5355\u51fb\u591a\u9009\u3002", (String)"\u8bbe\u7f6e\u5173\u8054\u6307\u6807", (Component)InnerUI.this._panAll);
                    return;
                }
                TreePath[] selecteds = InnerUI.this._tree4SyncNode.getSelectionPaths();
                DupontModel.SyncNodePair snp = new DupontModel.SyncNodePair();
                int c = selecteds.length;
                for (int i = 0; i < c; ++i) {
                    int j;
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)selecteds[i].getLastPathComponent();
                    MetricModel model = (MetricModel)((Object)node.getUserObject());
                    String number = model.getNumber();
                    int c2 = InnerUI.this._lstSyncNode.getElementCount();
                    for (j = 0; j < c2; ++j) {
                        DupontModel.SyncNodePair p = (DupontModel.SyncNodePair)InnerUI.this._lstSyncNode.getElement(j);
                        if (p.getOthers(number) == null) continue;
                        WindowUtil.msgboxInfo((Object)("\u6307\u6807[" + number + "]\u5728\u5df2\u5b9a\u4e49\u5217\u8868\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5b9a\u4e49\u3002\u5982\u679c\u9700\u8981\u52a0\u5165\u65b0\u6307\u6807\uff0c\u8bf7\u628a\u539f\u6709\u5b9a\u4e49\u5220\u9664\uff0c\u91cd\u65b0\u8bbe\u7f6e\u3002"), (String)"\u8bbe\u7f6e\u5173\u8054\u6307\u6807", (Component)InnerUI.this._panAll);
                        return;
                    }
                    for (j = i + 1; j < c; ++j) {
                        DefaultKingdeeTreeNode nodeAnother = (DefaultKingdeeTreeNode)selecteds[j].getLastPathComponent();
                        if (!node.isNodeAncestor((TreeNode)nodeAnother) && !node.isNodeDescendant((DefaultMutableTreeNode)nodeAnother)) continue;
                        String numberAnother = ((MetricModel)((Object)nodeAnother.getUserObject())).getNumber();
                        WindowUtil.msgboxInfo((Object)("\u6307\u6807[" + number + "]\u548c[" + numberAnother + "]\u5b58\u5728\u4e0a\u4e0b\u7ea7\u5173\u7cfb\uff0c\u4e0d\u5141\u8bb8\u5173\u8054\u3002"), (String)"\u8bbe\u7f6e\u5173\u8054\u6307\u6807", (Component)InnerUI.this._panAll);
                        return;
                    }
                    snp.addMetricNumber(model.getNumber());
                }
                InnerUI.this._lstSyncNode.addElement((Object)snp);
                InnerUI.this._lstSyncNode.setSelectedValue((Object)snp, true);
            }

            private void delete() {
                if (InnerUI.this._lstSyncNode.getSelectedIndex() < 0) {
                    WindowUtil.msgboxInfo((Object)"\u5220\u9664\u76ee\u6807\u4e0d\u660e\u786e\uff0c\u8bf7\u5148\u9009\u4e2d\u5df2\u5b9a\u4e49\u7684\u5173\u8054\u6307\u6807\u3002", (String)"\u8bbe\u7f6e\u5173\u8054\u6307\u6807", (Component)InnerUI.this._panAll);
                    return;
                }
                if (!WindowUtil.msgboxYesNo((Component)InnerUI.this._panAll, (Object)"\u60a8\u786e\u5b9a\u5220\u9664\u9009\u4e2d\u7684\u5df2\u5b9a\u4e49\u5173\u8054\u6307\u6807\u5417\uff1f", (String)"\u8bbe\u7f6e\u5173\u8054\u6307\u6807")) {
                    return;
                }
                int[] selecteds = InnerUI.this._lstSyncNode.getSelectedIndices();
                for (int i = selecteds.length - 1; i >= 0; --i) {
                    InnerUI.this._lstSyncNode.removeElementAt(selecteds[i]);
                }
            }
        }

        private class ModelDirtyHandler
        extends KeyAdapter
        implements DataChangeListener,
        ActionListener,
        TreeExpansionListener {
            private ModelDirtyHandler() {
            }

            public void dataChanged(DataChangeEvent eventObj) {
                this.makeDirty();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.makeDirty();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                this.makeDirty();
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                this.makeDirty();
            }

            private void makeDirty() {
                if (!InnerUI.this._panAll.isShowing()) {
                    return;
                }
                InnerUI.this._isDirty = true;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                this.makeDirty();
            }
        }

        private class SourceAppChangeHandler
        implements DataChangeListener {
            private SourceAppChangeHandler() {
            }

            public void dataChanged(DataChangeEvent eventObj) {
                SupplyAppModel sam = (SupplyAppModel)InnerUI.this._f7SourceApp.getData();
                MetricDimensionNode moRoot = sam == null ? null : sam.getMetricTreeRoot();
                InnerUI.this.updateTreeCtrl(moRoot);
                InnerUI.this.updateMMSupply(sam == null ? null : sam.getName());
            }
        }
    }
}

