/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.dupont;

import com.kingdee.bos.bi.model.common.formularengine.FormularParser;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringParsingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.CompositeExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.VarExpr;
import com.kingdee.bos.bi.model.common.mm.metric.MetricDimensionNode;
import com.kingdee.bos.bi.model.common.mm.metric.MetricModel;
import com.kingdee.bos.bi.model.ui.dialog.dupont.AbstractF7Selector;
import com.kingdee.bos.bi.model.ui.dialog.dupont.DupontModelDialog;
import com.kingdee.bos.bi.model.ui.dialog.dupont.SupplyAppModel;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

class SourceAppModelSelector
extends AbstractF7Selector {
    private static final Logger log = LogUtil.getPackageLogger(SourceAppModelSelector.class);
    private KDList _lstAppModel;
    private KDWorkButton _btnCheck;
    private KDTextArea _txaPrompt;
    private DupontModelDialog.ISupplyer _supplyer;
    private int _checkResult;

    public SourceAppModelSelector(JComponent parentCtrl, DupontModelDialog.ISupplyer supplyer) {
        super(parentCtrl);
        this._supplyer = supplyer;
        this.init();
    }

    private void init() {
        Object[] supplys = this._supplyer.getSourceAppModels();
        this._lstAppModel = new KDList(supplys);
        this._lstAppModel.setSelectionMode(0);
        this._lstAppModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SourceAppModelSelector.this.clearCheckResult();
            }
        });
        this._btnCheck = new KDWorkButton("\u6821\u9a8c\u9009\u4e2d\u6a21\u578b\u662f\u5426\u9002\u7528\u4e8e\u675c\u90a6\u5206\u6790");
        this._btnCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SourceAppModelSelector.this.check();
            }
        });
        this._txaPrompt = new KDTextArea();
        this._txaPrompt.setEditable(false);
        this.addControls();
    }

    private void addControls() {
        TableLayout2 layout = new TableLayout2(4, 2);
        layout.setFixedHeight(0, 20);
        layout.setRatableHeight(1, 8);
        layout.setFixedHeight(2, 22);
        layout.setRatableHeight(3, 2);
        layout.setRowsSpacing(TableLayout2.ALL, 3);
        layout.setFixedWidth(0, 200);
        layout.setRatableWidth(1, 100);
        KDPanel pan = this.getPanel();
        pan.setLayout((LayoutManager)layout);
        pan.add((Component)new KDLabel("\u5907\u9009\u5e94\u7528\u6a21\u578b\uff1a"), (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)1));
        pan.add((Component)new KDScrollPane((Component)this._lstAppModel), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
        pan.add((Component)this._btnCheck, (Object)TableLayout2.param((int)2, (int)0));
        pan.add((Component)new KDScrollPane((Component)this._txaPrompt), (Object)TableLayout2.param((int)3, (int)0, (int)3, (int)1));
    }

    public Object getData() {
        return this._lstAppModel.getSelectedValue();
    }

    @Override
    protected void initDialog(KDDialog dialog) {
        dialog.setTitle("\u9009\u62e9\u5e94\u7528\u6a21\u578b");
        dialog.setSize(400, 500);
    }

    @Override
    protected boolean checkWhenOk() {
        if (this._checkResult == 0) {
            this.check();
        }
        return this._checkResult > 0;
    }

    private void check() {
        SupplyAppModel selected = (SupplyAppModel)this.getData();
        if (selected == null) {
            this._checkResult = 0;
            this._txaPrompt.setText("\u8bf7\u9009\u62e9\u4e00\u4e2a\u5e94\u7528\u6a21\u578b\u3002");
            return;
        }
        if (this.isChecked(selected)) {
            return;
        }
        MetricDimensionNode root = this._supplyer.getMetricTree(selected.getName());
        if (root == null) {
            this._checkResult = -1;
            this._txaPrompt.setText("\u4e0d\u80fd\u6b63\u786e\u83b7\u53d6\u76f8\u5173\u7684\u6307\u6807\u6a21\u578b\u3002");
            return;
        }
        String result = this.checkCanUse(root);
        if (result != null) {
            this._checkResult = -1;
            this._txaPrompt.setText(result);
        } else {
            this._checkResult = 1;
            this._txaPrompt.setText("\u9002\u7528\u3002");
            selected.setMetricTreeRoot(root);
        }
    }

    private boolean isChecked(SupplyAppModel selected) {
        if (selected.getMetricTreeRoot() != null) {
            this._checkResult = 1;
            this._txaPrompt.setText("\u9002\u7528\u3002");
            return true;
        }
        return false;
    }

    private void clearCheckResult() {
        SupplyAppModel selected = (SupplyAppModel)this.getData();
        if (!this.isChecked(selected)) {
            this._txaPrompt.setText("");
            this._checkResult = 0;
        }
    }

    private String checkCanUse(MetricDimensionNode node) {
        int cc = node.getChildCount();
        MetricModel model = node.getMetricModel();
        String formula = model.getFormula();
        if (cc == 0 && !StringUtil.isEmptyString((String)formula)) {
            return "\u53f6\u5b50\u8282\u70b9\u201c" + model.getText4UI() + "\u201d\u4e0d\u80fd\u6709\u516c\u5f0f\u3002";
        }
        FormularParser parser = new FormularParser();
        AbstractExpr expr = null;
        try {
            expr = parser.parse(formula);
        }
        catch (StringParsingException e) {
            log.error((Object)"", (Throwable)e);
            return "\u8282\u70b9\u201c" + model.getText4UI() + "\u201d\u7684\u516c\u5f0f " + formula + " \u4e0d\u80fd\u6b63\u786e\u89e3\u6790\u3002";
        }
        HashSet allVars = new HashSet();
        this.pickAllVar(expr, allVars);
        for (int i = 0; i < cc; ++i) {
            MetricDimensionNode child = node.getChild(i);
            MetricModel childModel = child.getMetricModel();
            String childNumber = childModel.getNumber();
            String childNumberWithMark = childModel.getNumberWithMark();
            if (allVars.contains(childNumber)) {
                allVars.remove(childNumber);
            } else if (allVars.contains(childNumberWithMark)) {
                allVars.remove(childNumberWithMark);
            } else {
                return "\u8282\u70b9\u201c" + childModel.getText4UI() + "\u201d\u5fc5\u987b\u5728\u5176\u7236\u8282\u70b9\u7684\u516c\u5f0f\u4e2d\u51fa\u73b0\u3002";
            }
            String childResult = this.checkCanUse(child);
            if (childResult == null) continue;
            return childResult;
        }
        if (allVars.size() > 0) {
            return "\u8282\u70b9\u201c" + model.getText4UI() + "\u201d\u7684\u5b50\u8282\u70b9\u4e2d\u627e\u4e0d\u5230\u516c\u5f0f\u4e2d\u51fa\u73b0\u7684\u6307\u6807\uff1a" + allVars.toString() + "\u3002";
        }
        return null;
    }

    private void pickAllVar(AbstractExpr expr, Set allVars) {
        if (expr instanceof VarExpr) {
            allVars.add(((VarExpr)expr).getVarName());
        } else if (expr instanceof CompositeExpr) {
            this.pickAllVar(((CompositeExpr)expr).getLeftExpr(), allVars);
            this.pickAllVar(((CompositeExpr)expr).getRightExpr(), allVars);
        }
    }

    public SupplyAppModel getAppointData(String refAppModelId) {
        for (int i = this._lstAppModel.getElementCount() - 1; i >= 0; --i) {
            SupplyAppModel m = (SupplyAppModel)this._lstAppModel.getElement(i);
            if (!StringUtil.equals((String)refAppModelId, (String)m.getName())) continue;
            MetricDimensionNode metricTree = this._supplyer.getMetricTree(refAppModelId);
            SupplyAppModel result = new SupplyAppModel(m.getName(), m.getAlias());
            result.setMetricTreeRoot(metricTree);
            return result;
        }
        return new SupplyAppModel(refAppModelId, null);
    }
}

