/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.general;

import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeModel;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeUtil;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.dialog.general.importscheme.Step1_AccessMethod;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class ImportDataScheme
extends TypicalDialog {
    protected static final Logger log = CommonLogger.getLogger(ImportDataScheme.class);
    private static final long serialVersionUID = 5911716865677841643L;
    private KDPanel panMain;
    private KDLabel labSelect;
    private KDButton btnAdd;
    private KDButton btnEdit;
    private KDButton btnDel;
    private KDList lstMain;
    private KDScrollPane scrPane;
    private IManagementFacade facade = null;
    private String dimId = null;
    private String dimNumber = null;
    private boolean readOnly = false;

    public ImportDataScheme() {
    }

    public ImportDataScheme(Frame owner) {
        super(owner);
    }

    public ImportDataScheme(Dialog owner) {
        super(owner);
    }

    protected void todoInit() {
        this.setTitle("\u6570\u636e\u5bfc\u5165\u65b9\u6848");
        this.setSize(320, 400);
        this.btnOk.setText("\u5bfc\u5165");
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        parent.add(this.getPanMain(), thisCell);
        this.loadSchemeModel();
    }

    private void loadSchemeModel() {
        this.lstMain.removeAllElements();
        try {
            Iterator it = SchemeModel.loadAllScheme(this.facade, this.dimId).iterator();
            while (it.hasNext()) {
                this.lstMain.addElement(it.next());
            }
        }
        catch (BIModelRemoteException e) {
            log.error((Object)("\u83b7\u53d6\u6240\u6709\u5bfc\u5165\u6570\u636e\u6a21\u578b\u51fa\u9519\uff1a" + e));
        }
    }

    private Component getPanMain() {
        if (this.panMain == null) {
            this.panMain = new KDPanel();
            this.setPanMainLayout();
            this.addPanMainComponent();
        }
        return this.panMain;
    }

    private void setPanMainLayout() {
        TableLayout2 tly = new TableLayout2(2, 4);
        tly.setRowsSpacing(TableLayout2.ALL, 5);
        tly.setFixedHeight(0, 21);
        tly.setRatableHeight(1, 100);
        tly.setColsSpacing(TableLayout2.ALL, 5);
        tly.setFixedWidth(new int[]{1, 2, 3}, 21);
        tly.setRatableWidth(0, 100);
        this.panMain.setLayout((LayoutManager)tly);
    }

    private void addPanMainComponent() {
        this.panMain.add(this.getLabSelect(), (Object)TableLayout2.param((int)0, (int)0));
        this.panMain.add(this.getBtnAdd(), (Object)TableLayout2.param((int)0, (int)1));
        this.panMain.add(this.getBtnEdit(), (Object)TableLayout2.param((int)0, (int)2));
        this.panMain.add(this.getBtnDel(), (Object)TableLayout2.param((int)0, (int)3));
        this.panMain.add(this.getScrPane(), (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)3));
    }

    public Component getLabSelect() {
        if (this.labSelect == null) {
            this.labSelect = new KDLabel("\u9009\u62e9\u5bfc\u5165\u6570\u636e\u65b9\u6848");
        }
        return this.labSelect;
    }

    public Component getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new KDButton();
            this.setButttonStatus(this.btnAdd, Resource.ICON_NEW_FILE, "\u65b0\u589e\u6570\u636e\u5bfc\u5165\u65b9\u6848");
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportDataScheme.this.action_Add();
                }
            });
        }
        return this.btnAdd;
    }

    protected void action_Add() {
        SchemeModel model = new SchemeModel();
        this.doEdit(model);
    }

    public Component getBtnEdit() {
        if (this.btnEdit == null) {
            this.btnEdit = new KDButton();
            this.setButttonStatus(this.btnEdit, Resource.ICON_EDIT, "\u7f16\u8f91\u6570\u636e\u5bfc\u5165\u65b9\u6848");
            this.btnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportDataScheme.this.action_Edit();
                }
            });
        }
        return this.btnEdit;
    }

    protected void action_Edit() {
        if (this.checkListSelected()) {
            SchemeModel model = null;
            try {
                model = SchemeModel.load(this.dimNumber, this.getSelectedSchemeId(), this.facade);
            }
            catch (BIModelRemoteException bIModelRemoteException) {
                // empty catch block
            }
            if (model != null) {
                this.doEdit(model);
            }
        }
    }

    private void doEdit(SchemeModel model) {
        model.setDefColumnList(this.getDefColumnList());
        WizardDialog dlg = (WizardDialog)WindowUtil.createWindow(WizardDialog.class, (Component)((Object)this));
        dlg.setModal(true);
        dlg.setTitle("\u6570\u636e\u5bfc\u5165\u65b9\u6848", true);
        dlg.setBigSize(true);
        dlg.setStepsList(this.getWizardSteps(model));
        dlg.show();
        if (dlg.isFinished()) {
            try {
                SchemeModel.save(this.facade, this.dimId, model);
            }
            catch (BIModelRemoteException e) {
                log.error((Object)("\u4fdd\u5b58\u6570\u636e\u5bfc\u5165\u65b9\u6848\u6a21\u578b\u51fa\u9519\uff1a" + e));
            }
            this.loadSchemeModel();
        }
    }

    private List getDefColumnList() {
        List defColumnList = null;
        try {
            defColumnList = SchemeUtil.getDefColumnListFromEAS(this.dimNumber, this.facade);
        }
        catch (BIModelRemoteException bIModelRemoteException) {
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return defColumnList;
    }

    private List getWizardSteps(SchemeModel model) {
        ArrayList<Step1_AccessMethod> steps = new ArrayList<Step1_AccessMethod>();
        Step1_AccessMethod step1 = new Step1_AccessMethod(this.facade, model, (Component)((Object)this));
        steps.add(step1);
        return steps;
    }

    private boolean checkListSelected() {
        if (this.lstMain.getSelectedIndex() < 0) {
            WindowUtil.msgboxInfo((Object)"\u5fc5\u987b\u9009\u62e9\u4e00\u6761\u65b9\u6848\uff01", (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
            return false;
        }
        return true;
    }

    public Component getBtnDel() {
        if (this.btnDel == null) {
            this.btnDel = new KDButton();
            this.setButttonStatus(this.btnDel, Resource.ICON_DELETE, "\u5220\u9664\u6570\u636e\u5bfc\u5165\u65b9\u6848");
            this.btnDel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportDataScheme.this.action_Delete();
                }
            });
        }
        return this.btnDel;
    }

    protected void action_Delete() {
        if (this.checkListSelected()) {
            try {
                if (WindowUtil.msgboxYesNo((Component)this.getOwner(), (Object)("\u5220\u9664\u65b9\u6848\u5c06\u540c\u65f6\u6e05\u7a7a\u672c\u7ef4\u5ea6\u4e0b\u5f15\u7528\u3010" + this.getSelectedSchemeName() + "\u3011\u7684\u89c6\u56fe\u7684\u6700\u540e\u66f4\u65b0\u65b9\u6848\u4fe1\u606f\uff0c\u56e0\u6b64\u53ef\u80fd\u4f1a\u5f71\u54cd\u8c03\u5ea6\u7684\u6b63\u786e\u8fd0\u884c\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u5220\u9664\uff1f\uff01"), (String)"\u63d0\u793a\u4fe1\u606f")) {
                    SchemeModel.delete(this.facade, this.dimId, this.getSelectedSchemeId());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.loadSchemeModel();
        }
    }

    private void setButttonStatus(KDButton button, ImageIcon icon, String text) {
        button.setIcon((Icon)icon);
        button.setToolTipText(text);
        button.setVisible(!this.readOnly);
        button.setLimitedSize(false);
        button.setBorder(BorderFactory.createLineBorder(Color.gray));
        button.setFocusPainted(false);
    }

    public Component getScrPane() {
        if (this.scrPane == null) {
            this.scrPane = new KDScrollPane(this.getLstMain());
        }
        return this.scrPane;
    }

    private Component getLstMain() {
        if (this.lstMain == null) {
            this.lstMain = new KDList();
        }
        return this.lstMain;
    }

    public String getSchemeModel() {
        return null;
    }

    public void setFacade(IManagementFacade facade) {
        this.facade = facade;
    }

    public void setDimNumber(String dimNumber) {
        this.dimNumber = dimNumber;
    }

    public void setDimId(String dimId) {
        this.dimId = dimId;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (readOnly) {
            this.btnOk.setVisible(false);
            this.btnCancel.setText("\u5173\u95ed");
        }
    }

    public void setOpenFromToolBar() {
        this.btnOk.setVisible(false);
        this.btnCancel.setText("\u786e\u5b9a");
    }

    public String getSelectedSchemeId() {
        ComboBoxObject obj = (ComboBoxObject)this.lstMain.getSelectedValue();
        return obj.getCode();
    }

    public String getSelectedSchemeName() {
        ComboBoxObject obj = (ComboBoxObject)this.lstMain.getSelectedValue();
        return obj.getName();
    }

    protected void onOk() {
        if (this.checkListSelected()) {
            super.onOk();
        }
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        ImportDataScheme aTest = new ImportDataScheme();
        aTest.showDialog();
    }
}

