/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.general.importscheme;

import com.kingdee.bos.bi.model.common.mm.general.db.Column;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeModel;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeUtil;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.dialog.general.importscheme.AbstractImportWizardStep;
import com.kingdee.bos.bi.model.ui.dialog.general.importscheme.Step3_Mapping;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.EnumObj;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;

public class Step2_2_DBCenterTable
extends AbstractImportWizardStep {
    protected KDPanel panMain;
    protected KDLabelContainer lctnSelectDBCenter;
    protected KDComboBox cbxSelectDBCenter;
    protected KDLabelContainer lctnSelectDBTable;
    protected KDComboBox cbxSelectDBTable;
    protected AbstractImportWizardStep step3 = null;
    private boolean readOnly = false;
    private static final String PROMPT_TEXT = "\u9009\u62e9\u6570\u636e\u6765\u6e90\u7684\u6570\u636e\u4e2d\u5fc3\u548c\u6570\u636e\u8868\u3002";

    public Step2_2_DBCenterTable(IManagementFacade facade, Component owner) {
        super(facade, owner);
    }

    @Override
    public void beforeIntoThisStep() {
        this.initDBCenterDropdownList();
    }

    private void initDBCenterDropdownList() {
        try {
            if (this.getCbxSelectDBCenter().getItemCount() == 0) {
                this.getCbxSelectDBCenter().addItems((Vector)this.facade.getDBCenterList());
            }
        }
        catch (DBCenterException e) {
            log.error((Object)("\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5217\u8868\u51fa\u9519" + e.getMessage()));
        }
        catch (SQLException e) {
            log.error((Object)("\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5217\u8868\u51fa\u9519" + e.getMessage()));
        }
    }

    @Override
    protected AbstractImportWizardStep getNextStep() {
        if (this.step3 == null) {
            this.step3 = new Step3_Mapping(this.facade, this.getOwner());
        }
        return this.step3;
    }

    @Override
    protected String getPromptText() {
        return PROMPT_TEXT;
    }

    @Override
    public Component getPanMain() {
        if (this.panMain == null) {
            this.panMain = new KDPanel();
            this.setPanMainLayout();
            this.addPanMainComponent();
        }
        return this.panMain;
    }

    private void setPanMainLayout() {
        TableLayout2 tly = new TableLayout2(3, 1);
        tly.setRowsSpacing(TableLayout2.ALL, 5);
        tly.setFixedHeight(TableLayout2.ALL, 21);
        tly.setRatableHeight(2, 100);
        this.panMain.setLayout((LayoutManager)tly);
    }

    private void addPanMainComponent() {
        this.panMain.add(this.getLctnSelectDBCenter(), (Object)TableLayout2.param((int)0, (int)0));
        this.panMain.add(this.getLctnSelectDBTable(), (Object)TableLayout2.param((int)1, (int)0));
    }

    public Component getLctnSelectDBCenter() {
        if (this.lctnSelectDBCenter == null) {
            this.lctnSelectDBCenter = CtrlSwingUtilities.createLabelContainer((JComponent)this.getCbxSelectDBCenter(), (String)"\u9009\u62e9\u6570\u636e\u4e2d\u5fc3", (int)120);
        }
        return this.lctnSelectDBCenter;
    }

    private KDComboBox getCbxSelectDBCenter() {
        if (this.cbxSelectDBCenter == null) {
            this.cbxSelectDBCenter = new KDComboBox();
            this.cbxSelectDBCenter.setEnabled(!this.readOnly);
            this.cbxSelectDBCenter.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        Step2_2_DBCenterTable.this.action_ChangeDBCenter(((EnumObj)e.getItem()).getNumber());
                    }
                }
            });
        }
        return this.cbxSelectDBCenter;
    }

    protected void action_ChangeDBCenter(String dbCenterId) {
        try {
            List tableList = this.facade.getDBCenterTables(dbCenterId);
            this.getCbxSelectDBTable().removeAllItems();
            this.getCbxSelectDBTable().addItems((Vector)tableList);
        }
        catch (SQLException e) {
            log.error((Object)("\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u8868\u51fa\u9519\uff1a" + e.getMessage()));
        }
    }

    public Component getLctnSelectDBTable() {
        if (this.lctnSelectDBTable == null) {
            this.lctnSelectDBTable = CtrlSwingUtilities.createLabelContainer((JComponent)this.getCbxSelectDBTable(), (String)"\u9009\u62e9\u6570\u636e\u5e93\u8868", (int)120);
        }
        return this.lctnSelectDBTable;
    }

    private KDComboBox getCbxSelectDBTable() {
        if (this.cbxSelectDBTable == null) {
            this.cbxSelectDBTable = new KDComboBox();
            this.cbxSelectDBTable.setEnabled(!this.readOnly);
        }
        return this.cbxSelectDBTable;
    }

    @Override
    protected void loadModel() {
        SchemeModel model = (SchemeModel)this.stepsManager.getUserObject();
        String dbCenterId = model.getDbCenterId();
        EnumObj obj = null;
        int n = this.getCbxSelectDBCenter().getItemCount();
        for (int i = 0; i < n; ++i) {
            obj = (EnumObj)this.getCbxSelectDBCenter().getItemAt(i);
            if (!obj.getNumber().equalsIgnoreCase(dbCenterId)) continue;
            this.getCbxSelectDBCenter().setSelectedItem((Object)obj);
            break;
        }
        String dbCenterTableName = model.getDbCenterTable();
        String str = null;
        int n2 = this.getCbxSelectDBTable().getItemCount();
        for (int i = 0; i < n2; ++i) {
            str = (String)this.getCbxSelectDBTable().getItemAt(i);
            if (!str.equalsIgnoreCase(dbCenterTableName)) continue;
            this.getCbxSelectDBTable().setSelectedItem((Object)str);
            break;
        }
    }

    @Override
    protected boolean injectModel() {
        SchemeModel model = (SchemeModel)this.stepsManager.getUserObject();
        String dbCenterId = ((EnumObj)this.getCbxSelectDBCenter().getSelectedItem()).getNumber();
        String dbCenterTableName = (String)this.getCbxSelectDBTable().getSelectedItem();
        List srcColumnList = null;
        try {
            srcColumnList = SchemeUtil.getSrcColumnListFromDBTableName(this.facade, dbCenterId, dbCenterTableName);
        }
        catch (SQLException e) {
            log.error((Object)("\u83b7\u53d6\u6570\u636e\u5e93\u5217\u540d\u51fa\u9519\uff1a" + e.getMessage()));
        }
        if (srcColumnList != null) {
            srcColumnList.add(0, Column.BLANK_COLUMN);
        }
        model.setSrcColumnList(srcColumnList);
        model.setDbCenterId(dbCenterId);
        model.setDbCenterTable(dbCenterTableName);
        return true;
    }

    @Override
    protected boolean checkBeforeInject() {
        if (this.getCbxSelectDBCenter().getSelectedItem() == null) {
            WindowUtil.msgboxInfo((Object)"\u5fc5\u987b\u9009\u62e9\u6570\u636e\u4e2d\u5fc3\uff01", (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
            return false;
        }
        if (this.getCbxSelectDBTable().getSelectedItem() == null) {
            WindowUtil.msgboxInfo((Object)"\u5fc5\u987b\u9009\u62e9\u6570\u636e\u4e2d\u5fc3\uff01", (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
            return false;
        }
        return true;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (readOnly) {
            // empty if block
        }
    }
}

