/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.da.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.BiManagerException;
import com.kingdee.eas.framework.bireport.bimanager.TableTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.basedata.ITableIndex;
import com.kingdee.eas.framework.bireport.bimanager.basedata.ITableManager;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableManagerCollection;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableManagerFactory;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataFactory;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataFileInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.BaseDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.da.app.AbstractBaseDataFileControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;

public class BaseDataFileControllerBean
extends AbstractBaseDataFileControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.bimanager.da.app.BaseDataFileControllerBean");

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BaseDataFileInfo info = (BaseDataFileInfo)model;
        ITableManager iTableManager = TableManagerFactory.getLocalInstance(ctx);
        DecimalFormat df = new DecimalFormat("00000000");
        TableManagerCollection tableManagerCollection = iTableManager.getTableManagerCollection("where model='BaseDataFile'");
        TableManagerInfo tableManagerInfo = null;
        int number = 1;
        if (tableManagerCollection == null || tableManagerCollection.size() <= 0) {
            tableManagerInfo = new TableManagerInfo();
            tableManagerInfo.setModel("BaseDataFile");
            tableManagerInfo.setTableName("T_BI_BaseDataFile_");
            number = 1;
        } else {
            tableManagerInfo = tableManagerCollection.get(0);
            number = tableManagerInfo.getNumber() + 1;
        }
        String tableName = tableManagerInfo.getTableName() + df.format(number);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select * from KSQL_USERTABLES where KSQL_tabName=?", (Object[])new Object[]{tableName});
        try {
            while (rs.next()) {
                tableName = tableManagerInfo.getTableName() + df.format(++number);
                rs = DbUtil.executeQuery((Context)ctx, (String)"select * from KSQL_USERTABLES where KSQL_tabName=?", (Object[])new Object[]{tableName});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        tableManagerInfo.setNumber(number);
        iTableManager.submit(tableManagerInfo);
        BaseDataInfo baseDataInfo = info.getBaseData();
        if (baseDataInfo == null || baseDataInfo.getId() == null) {
            throw new BiManagerException(BiManagerException.E_BASEDATAISNULL);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("baseDataTemplet.id");
        selector.add("baseDataTemplet.masterData.id");
        selector.add("baseDataTemplet.masterData.baseDataTableName");
        baseDataInfo = BaseDataFactory.getLocalInstance(ctx).getBaseDataInfo((IObjectPK)new ObjectUuidPK(baseDataInfo.getId().toString()), selector);
        if (baseDataInfo.getBaseDataTemplet() == null) {
            throw new BiManagerException(BiManagerException.E_BASEDATATEMPLETISNULL);
        }
        if (baseDataInfo.getBaseDataTemplet().getMasterData() == null) {
            throw new BiManagerException(BiManagerException.E_MASTERDATADATAISNULL);
        }
        String masterDataId = baseDataInfo.getBaseDataTemplet().getMasterData().getId().toString();
        ITableIndex iTableIndex = TableIndexFactory.getLocalInstance(ctx);
        String baseDataTableName = iTableIndex.getTableNameById(masterDataId, TableTypeEnum.BaseDataTable);
        if (baseDataTableName == null) {
            throw new BiManagerException(BiManagerException.E_BASEDATATABLEISNULL);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * INTO ").append(tableName).append(" FROM ").append(baseDataTableName);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        info.setTableName(tableName);
        return super._submit(ctx, (IObjectValue)info);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BaseDataFileInfo oldData = this.getBaseDataFileInfo(ctx, pk);
        DbUtil.execute((Context)ctx, (String)("drop table " + oldData.getTableName()));
        super._delete(ctx, pk);
    }
}

