/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.etl.AbstractEtlDispatchManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.ETLSchemeExcuteInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchManagerFactory;
import java.io.Serializable;

public class EtlDispatchManagerInfo
extends AbstractEtlDispatchManagerInfo
implements Serializable {
    public EtlDispatchManagerInfo() {
    }

    protected EtlDispatchManagerInfo(String pkField) {
        super(pkField);
    }

    public static EtlDispatchManagerInfo refreshSchemeData(Context ctx, String billID) throws EASBizException, BOSException {
        if (ctx == null) {
            return EtlDispatchManagerFactory.getRemoteInstance().getEtlDispatchManagerInfo((IObjectPK)new ObjectUuidPK(billID), EtlDispatchManagerInfo.getSelectorItemCollection());
        }
        return EtlDispatchManagerFactory.getLocalInstance(ctx).getEtlDispatchManagerInfo((IObjectPK)new ObjectUuidPK(billID), EtlDispatchManagerInfo.getSelectorItemCollection());
    }

    private static SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("isExecute");
        sic.add("name");
        sic.add("number");
        sic.add("entry.lostStra");
        sic.add("entry.schemeID");
        sic.add("entry.id");
        sic.add("entry.scheme.id");
        sic.add("entry.scheme.name");
        sic.add("entry.scheme.number");
        sic.add("entry.scheme.comDBMapping.entry.dataCenter");
        sic.add("entry.scheme.comDBMapping.entry.company.id");
        sic.add("entry.scheme.comDBMapping.entry.company.name");
        return sic;
    }

    public int getEntrySize() {
        return this.getEntry().size();
    }

    public static EtlDispatchManagerInfo getEtlDispatchManagerInfo(EtlDispatchManagerInfo info, int start, int length) {
        EtlDispatchManagerInfo resultInfo = new EtlDispatchManagerInfo();
        resultInfo.setName(info.getName());
        resultInfo.setNumber(info.getNumber());
        resultInfo.setId(info.getId());
        int index = start;
        int entrySize = info.getEntrySize();
        if (start == 0) {
            resultInfo.setIsFirstExcute(true);
        } else {
            resultInfo.setIsFirstExcute(false);
        }
        resultInfo.setEntryIndex(start);
        while (length > 0) {
            resultInfo.getEntry().add(info.getEntry().get(index));
            ++index;
            --length;
        }
        if (index == entrySize) {
            resultInfo.setIsLastExcute(true);
        } else {
            resultInfo.setIsLastExcute(false);
        }
        return resultInfo;
    }

    public ETLSchemeExcuteInfo getResult() {
        return (ETLSchemeExcuteInfo)this.get("schemeExcuteInfo");
    }

    public void setExcuteInfo(ETLSchemeExcuteInfo result) {
        this.put("schemeExcuteInfo", result);
    }

    public String getDispatchLogID() {
        return this.getExtendedProperty("dispatchLogID");
    }

    public void setDispatchLogID(String dispatchLogID) {
        this.setExtendedProperty("dispatchLogID", dispatchLogID);
    }

    public boolean isLastExcute() {
        String isLastExcute = this.getExtendedProperty("isLastExcute");
        return "true".equalsIgnoreCase(isLastExcute);
    }

    public void setIsLastExcute(boolean isLastExcute) {
        this.setExtendedProperty("isLastExcute", "" + isLastExcute);
    }

    public boolean isFirstExcute() {
        String isLastExcute = this.getExtendedProperty("isFirstExcute");
        return "true".equalsIgnoreCase(isLastExcute);
    }

    public void setIsFirstExcute(boolean isFirstExcute) {
        this.setExtendedProperty("isFirstExcute", "" + isFirstExcute);
    }

    public int getEntryIndex() {
        String entryIndex = this.getExtendedProperty("entryIndex");
        return Integer.parseInt(entryIndex);
    }

    public void setEntryIndex(int entryIndex) {
        this.setExtendedProperty("entryIndex", "" + entryIndex);
    }
}

