/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl;

import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class KettleXmlHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.bimanager.util.kettle.EASXMLHandler");
    public static String NODEDB_NAME = "connection";
    public static String DEFAULTFETCH_DB2 = "EXTRA_OPTION_DB2.defaultFetchSize";
    public static String USEFETHC_DB2 = "EXTRA_OPTION_DB2.useCursorFetch";
    public static String ENCODING_DB2 = "EXTRA_OPTION_DB2.characterEncoding";
    public static String DEFAULTFETCH_ORACLE = "EXTRA_OPTION_ORACLE.defaultFetchSize";
    public static String USEFETHC_ORACLE = "EXTRA_OPTION_ORACLE.useCursorFetch";
    public static String ENCODING_ORACLE = "EXTRA_OPTION_ORACLE.characterEncoding";
    public static String DEFAULTFETCH_MSSQL = "EXTRA_OPTION_MSSQL.defaultFetchSize";
    public static String USEFETHC_MSSQL = "EXTRA_OPTION_MSSQL.useCursorFetch";
    public static String ENCODING_MSSQL = "EXTRA_OPTION_MSSQL.characterEncoding";
    public static String ENCODING = "UTF-8";
    public static String TYPE = "KSQL";
    static final String USER_DEFAULT_DBNODEFORChANGE = "<changeConnections>connectionhasDelete</changeConnections>";

    public static StringBuffer getDBCenterNodes(Iterator iter) throws ParserConfigurationException {
        StringBuffer sb = new StringBuffer();
        if (iter != null) {
            while (iter.hasNext()) {
                DBCenterModel model = (DBCenterModel)iter.next();
                KettleXmlHelper.addDbNode(model, sb);
            }
        }
        return sb;
    }

    public static void appendNode(StringBuffer sb, String nodeName) {
        sb.append("<" + nodeName + ">");
    }

    public static void appendNodeEx(StringBuffer sb, String nodeName) {
        sb.append("</" + nodeName + ">\n");
    }

    public static void addDbNode(DBCenterModel model, StringBuffer sb) {
        KettleXmlHelper.appendNode(sb, NODEDB_NAME);
        sb.append("\n");
        KettleXmlHelper.createElement(sb, "name", model.getDbCenterName());
        KettleXmlHelper.createElement(sb, "server", model.getUrl());
        if (model.getDbType().equals("sqlserver")) {
            KettleXmlHelper.createElement(sb, "type", "MSSQL");
        } else {
            KettleXmlHelper.createElement(sb, "type", model.getDbType());
        }
        KettleXmlHelper.createElement(sb, "access", "Custom");
        KettleXmlHelper.createElement(sb, "database", model.getDbCenterId());
        KettleXmlHelper.createElement(sb, "port", model.getPort());
        KettleXmlHelper.createElement(sb, "username", model.getUserName());
        KettleXmlHelper.createElement(sb, "password", "change_psw");
        KettleXmlHelper.createElement(sb, "servername", null);
        KettleXmlHelper.createElement(sb, "data_tablespace", null);
        KettleXmlHelper.createElement(sb, "index_tablespace", null);
        sb.append("<attributes>");
        sb.append("\n");
        String[] val = KettleXmlHelper.converValue(model.getDbType(), "encoding");
        KettleXmlHelper.createAttributes(sb, val[0], val[1]);
        val = KettleXmlHelper.converValue(model.getDbType(), "defaultFetch");
        KettleXmlHelper.createAttributes(sb, val[0], val[1]);
        val = KettleXmlHelper.converValue(model.getDbType(), "useFetch");
        KettleXmlHelper.createAttributes(sb, val[0], val[1]);
        KettleXmlHelper.createAttributes(sb, "FORCE_IDENTIFIERS_TO_LOWERCASE", "N");
        KettleXmlHelper.createAttributes(sb, "FORCE_IDENTIFIERS_TO_UPPERCASE", "N");
        KettleXmlHelper.createAttributes(sb, "IS_CLUSTERED", "N");
        KettleXmlHelper.createAttributes(sb, "PORT_NUMBER", model.getPort());
        KettleXmlHelper.createAttributes(sb, "QUOTE_ALL_FIELDS", "N");
        KettleXmlHelper.createAttributes(sb, "USE_POOLING", "N");
        if (model.getDbType().equals("sqlserver")) {
            KettleXmlHelper.createAttributes(sb, "MSSQL_DOUBLE_DECIMAL_SEPARATOR", "N");
        }
        sb.append("</attributes>");
        sb.append("\n");
        KettleXmlHelper.appendNodeEx(sb, NODEDB_NAME);
    }

    public static List getDBCentersByXml(String xml) {
        int indexOf;
        LinkedList<String> list = new LinkedList<String>();
        while ((indexOf = xml.indexOf("<connection>")) >= 0) {
            xml = xml.substring(indexOf + 12);
            int endIndex = xml.indexOf("</connection>");
            String dbName = xml.substring(0, endIndex);
            list.add(dbName);
            System.out.println(dbName);
        }
        return list;
    }

    public static boolean hasDBCenter(String xml) throws ETLXMLException {
        return xml.indexOf(USER_DEFAULT_DBNODEFORChANGE) > -1;
    }

    public static String insertDBConnection(List list, String tempDBID, String xml) throws ParserConfigurationException {
        Iterator iter = KettleXmlHelper.getDBCentersByXml(xml).iterator();
        LinkedList<DBCenterModel> dbList = new LinkedList<DBCenterModel>();
        block0: while (iter.hasNext()) {
            DBCenterModel model;
            int i;
            String dbName = iter.next().toString();
            if ("\u6a21\u677f\u6570\u636e\u4e2d\u5fc3".equals(dbName)) {
                for (i = 0; i < list.size(); ++i) {
                    model = (DBCenterModel)list.get(i);
                    if (!model.getDbCenterId().equals(tempDBID)) continue;
                    DBCenterModel centerKettleModel = DBConnectionMap.copyDBCenterModel(model);
                    centerKettleModel.setDbCenterName("\u6a21\u677f\u6570\u636e\u4e2d\u5fc3");
                    dbList.add(centerKettleModel);
                    continue block0;
                }
                continue;
            }
            for (i = 0; i < list.size(); ++i) {
                model = (DBCenterModel)list.get(i);
                if (!model.getDbCenterName().equals(dbName)) continue;
                DBCenterModel temp = DBConnectionMap.copyDBCenterModel(model);
                dbList.add(temp);
                continue block0;
            }
        }
        if (!dbList.isEmpty()) {
            StringBuffer connectionBuffer = KettleXmlHelper.getDBCenterNodes(dbList.iterator());
            return xml.replaceAll(USER_DEFAULT_DBNODEFORChANGE, connectionBuffer.toString());
        }
        return xml;
    }

    public static String insertDBConnectionNotChangetTemp(Iterator iter, List list, String xml) throws ParserConfigurationException {
        LinkedList<DBCenterModel> dbList = new LinkedList<DBCenterModel>();
        block0: while (iter.hasNext()) {
            String dbName = iter.next().toString();
            for (int i = 0; i < list.size(); ++i) {
                DBCenterModel model = (DBCenterModel)list.get(i);
                if (!model.getDbCenterName().equals(dbName)) continue;
                dbList.add(model);
                continue block0;
            }
        }
        if (!dbList.isEmpty()) {
            StringBuffer connectionBuffer = KettleXmlHelper.getDBCenterNodes(dbList.iterator());
            if (xml.indexOf("\u6a21\u677f\u6570\u636e\u4e2d\u5fc3") > 0) {
                return xml.replaceAll(USER_DEFAULT_DBNODEFORChANGE, USER_DEFAULT_DBNODEFORChANGE + connectionBuffer.toString());
            }
            return xml.replaceAll(USER_DEFAULT_DBNODEFORChANGE, connectionBuffer.toString());
        }
        return xml;
    }

    public static List getHasUseDBCenters(List list, String tempDBID, String xml) throws ParserConfigurationException {
        Iterator iter = KettleXmlHelper.getDBCentersByXml(xml).iterator();
        LinkedList<DBCenterModel> dbList = new LinkedList<DBCenterModel>();
        block0: while (iter.hasNext()) {
            DBCenterModel model;
            int i;
            String dbName = iter.next().toString();
            if ("\u6a21\u677f\u6570\u636e\u4e2d\u5fc3".equals(dbName)) {
                for (i = 0; i < list.size(); ++i) {
                    model = (DBCenterModel)list.get(i);
                    if (!model.getDbCenterId().equals(tempDBID)) continue;
                    DBCenterModel centerKettleModel = DBConnectionMap.copyDBCenterModel(model);
                    centerKettleModel.setDbCenterName("\u6a21\u677f\u6570\u636e\u4e2d\u5fc3");
                    centerKettleModel.setPassWord(model.getPassWord());
                    dbList.add(centerKettleModel);
                    continue block0;
                }
                continue;
            }
            for (i = 0; i < list.size(); ++i) {
                model = (DBCenterModel)list.get(i);
                if (!model.getDbCenterName().equals(dbName)) continue;
                dbList.add(model);
                continue block0;
            }
        }
        return dbList;
    }

    public static String[] converValue(String type, String operate) {
        String codeVal = null;
        String attrVal = null;
        if (type.equalsIgnoreCase("sqlserver")) {
            if (operate.equals("encoding")) {
                codeVal = ENCODING_MSSQL;
                attrVal = ENCODING;
            }
            if (operate.equals("defaultFetch")) {
                codeVal = DEFAULTFETCH_MSSQL;
                attrVal = "500";
            }
            if (operate.equals("useFetch")) {
                codeVal = USEFETHC_MSSQL;
                attrVal = "true";
            }
        }
        if (type.equalsIgnoreCase("db2")) {
            if (operate.equals("encoding")) {
                codeVal = ENCODING_DB2;
                attrVal = ENCODING;
            }
            if (operate.equals("defaultFetch")) {
                codeVal = DEFAULTFETCH_DB2;
                attrVal = "500";
            }
            if (operate.equals("useFetch")) {
                codeVal = USEFETHC_DB2;
                attrVal = "true";
            }
        }
        if (type.equalsIgnoreCase("oracle")) {
            if (operate.equals("encoding")) {
                codeVal = ENCODING_ORACLE;
                attrVal = ENCODING;
            }
            if (operate.equals("defaultFetch")) {
                codeVal = DEFAULTFETCH_ORACLE;
                attrVal = "500";
            }
            if (operate.equals("useFetch")) {
                codeVal = USEFETHC_ORACLE;
                attrVal = "true";
            }
        }
        return new String[]{codeVal, attrVal};
    }

    public static void createElement(StringBuffer sb, String nodeName, String nodeValue) {
        KettleXmlHelper.appendNode(sb, nodeName);
        if (nodeValue != null) {
            sb.append(nodeValue);
        }
        KettleXmlHelper.appendNodeEx(sb, nodeName);
    }

    public static void createAttributes(StringBuffer sb, String code, String attribute) {
        KettleXmlHelper.appendNode(sb, "attribute");
        sb.append("\n");
        KettleXmlHelper.createElement(sb, "code", code);
        KettleXmlHelper.createElement(sb, "attribute", attribute);
        KettleXmlHelper.appendNodeEx(sb, "attribute");
    }

    public static void output(Node node) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource();
            source.setNode(node);
            StreamResult result = new StreamResult();
            result.setOutputStream(System.out);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            logger.error((Object)"error", (Throwable)e);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            logger.error((Object)"error", (Throwable)e);
        }
    }

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        return doc;
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
    }
}

