/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB;

import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.IFetchData;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.TransportResultSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class TransportRowSetProxy
implements IFetchData,
Serializable {
    public int rowIndex = -1;
    public static final int CURSOR_BEFOREFIRST = -1;
    public static final int CURSOR_FIRST = 0;
    public static final int CURSOR_LAST = -4;
    public static final int CURSOR_AFTERLAST = -2;
    public static final int CUROSR_CLOSED = -3;
    public int rowCount;
    boolean isFetchComplete;
    public TransportResultSet currentResultSet;
    public ResultSetMetaData metaData;
    public int rowssetIndex = 0;
    public transient Statement statement;
    public transient ResultSet rs;
    public transient TransportResultSet resultSet;
    public String resultID = null;
    private Map key_Index = null;

    public TransportRowSetProxy(ResultSet rowSet, String resultSetID, ResultSetMetaData metaData) throws SQLException {
        this.rs = rowSet;
        this.filldefaultFetchSizeData();
        this.statement = rowSet.getStatement();
        this.metaData = metaData;
        this.rowIndex = -1;
        this.resultID = resultSetID;
    }

    private void filldefaultFetchSizeData() throws SQLException {
        this.currentResultSet = TransportResultSet.parse(this.rs, 5000);
        this.rowCount = this.currentResultSet.getRowCount();
        if (this.rowCount < 4999) {
            this.isFetchComplete = true;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.rowIndex = -2;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.rowIndex = -1;
    }

    @Override
    public boolean first() throws SQLException {
        return this.rowIndex == 0;
    }

    @Override
    public int getRow() throws SQLException {
        return this.rowIndex;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.rowCount == this.rowIndex;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.rowIndex == -1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.rowIndex == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.rowIndex == this.rowCount;
    }

    @Override
    public boolean last() throws SQLException {
        this.rowIndex = this.rowCount;
        return false;
    }

    @Override
    public int nextRow() throws SQLException {
        ++this.rowIndex;
        if (this.isFetchComplete) {
            return this.rowIndex == this.rowssetIndex * 5000 + this.rowCount ? -1 : 1;
        }
        if (this.rowIndex == 0) {
            return 1;
        }
        return this.rowIndex % 5000 == 0 ? 0 : 1;
    }

    @Override
    public void fetchDataRemote(int length) throws SQLException {
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.rowIndex == -1) {
            return false;
        }
        --this.rowIndex;
        return !this.isFirst();
    }

    public TransportResultSet fetchDataLocal(int defaultFetchSize) throws SQLException {
        return TransportResultSet.parse(this.rs, defaultFetchSize);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (row < 0) {
            return false;
        }
        this.rowIndex = row;
        return true;
    }

    public void checkCursor(boolean flag) throws SQLException {
        if (flag) {
            if (this.rowIndex < -1) {
                throw new SQLException();
            }
            if (this.rowIndex > this.rowCount) {
                throw new SQLException();
            }
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            if (o instanceof BigDecimal) {
                return (BigDecimal)o;
            }
            return new BigDecimal(((Number)o).floatValue());
        }
        if (o instanceof String) {
            return new BigDecimal((String)o);
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() == 1;
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return 0;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (byte)1 : 0;
        }
        if (o instanceof String) {
            return Byte.parseByte((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return ((String)o).getBytes();
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0f : 0.0f;
        }
        if (o instanceof String) {
            return Float.parseFloat((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return 0;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return 0L;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return 0;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (short)1 : 0;
        }
        if (o instanceof String) {
            return Short.parseShort((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)obj);
            calendar.set(1, cal.get(1));
            calendar.set(2, cal.get(2));
            calendar.set(5, cal.get(5));
            return new Date(calendar.getTime().getTime());
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)obj);
            calendar.set(11, cal.get(11));
            calendar.set(12, cal.get(12));
            calendar.set(13, cal.get(13));
            return new Time(calendar.getTime().getTime());
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)obj);
            calendar.set(1, cal.get(1));
            calendar.set(2, cal.get(2));
            calendar.set(5, cal.get(5));
            calendar.set(11, cal.get(11));
            calendar.set(12, cal.get(12));
            calendar.set(13, cal.get(13));
            return new Timestamp(calendar.getTime().getTime());
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        throw new SQLException("Value can not be converted to requested type.");
    }

    @Override
    public Object getObject(int i) throws SQLException {
        this.checkCursor(false);
        if (i < 1 || i > this.getMetaData().getColumnCount()) {
            throw new SQLException("Bad column index:" + i);
        }
        return this.currentResultSet.getValue(this.rowIndex % 5000, i - 1);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (this.key_Index == null) {
            this.key_Index = new HashMap();
            ResultSetMetaData meta = this.getMetaData();
            int count = meta.getColumnCount();
            for (int i = 0; i < count; ++i) {
                this.key_Index.put(meta.getColumnName(i + 1), new Integer(i + 1));
            }
        }
        this.checkCursor(false);
        if (!this.key_Index.containsKey(columnName)) {
            throw new SQLException("Not found specified column '" + columnName + "'");
        }
        return (Integer)this.key_Index.get(columnName);
    }

    public ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    public void setCurrentResultSet(TransportResultSet currentResultSet) {
        this.currentResultSet = currentResultSet;
        ++this.rowssetIndex;
        this.isFetchComplete = currentResultSet.getRowCount() < 5000;
        this.rowCount = currentResultSet.getRowCount();
    }

    @Override
    public String getRemoteResultObjID() {
        return this.resultID;
    }

    public void close() throws SQLException {
        this.rs.close();
    }

    @Override
    public ResultSet getResultSet() {
        return this.rs;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.currentResultSet.getRowCount() == 0;
    }
}

