/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.schedule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EASKettle;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlCompanyDBMappingEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchManagerEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlExecuteLogFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlExecuteLogInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlStrategyFacadeFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.KettleXmlHelper;
import com.kingdee.eas.framework.bireport.bimanager.etl.schedule.ETLXMLHandle;
import com.kingdee.eas.framework.bireport.bimanager.etl.schedule.EtlLogUtil;
import com.kingdee.eas.framework.bireport.bimanager.etl.schedule.domain.DBCenterCompanyInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.schedule.domain.TransportToTomcatExeInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.schedule.domain.TransportToTomcatLogInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionMap;
import com.kingdee.eas.framework.bireport.bimanager.util.IDispatchCallBack;
import com.kingdee.eas.framework.bireport.bimanager.util.ScheduleException;
import com.kingdee.eas.framework.bireport.bimanager.util.TnterruptException;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.ClientAgent;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ETLDispatchCallBackAtTomcatImpl
implements IDispatchCallBack {
    private static final String Exception = null;
    private EtlDispatchManagerEntryInfo info = null;
    private String dispatchLogID = "";
    private TransportToTomcatExeInfo excutor = new TransportToTomcatExeInfo();
    private Context ctx;
    private List dbCentersInXML;
    private List logs;

    public ETLDispatchCallBackAtTomcatImpl(Context ctx, EtlDispatchManagerEntryInfo info, int index, String dispatchLogID) {
        int i;
        this.ctx = ctx;
        this.info = info;
        this.excutor.setLostStrategy_ETL(info.getLostStra());
        this.excutor.setDispatchID(dispatchLogID);
        this.excutor.setSchemeName(info.getScheme().getName());
        this.dispatchLogID = dispatchLogID;
        this.excutor.setSchemeID(info.getSchemeID());
        info.refreshSchemeXMLAtApp(ctx);
        int size = info.getEntrySize();
        if (size > 0) {
            for (int i2 = 0; i2 < size; ++i2) {
                DBCenterCompanyInfo dbCompany = new DBCenterCompanyInfo();
                if (this.getCompanyID(i2) == null) continue;
                dbCompany.setCompanyID(this.getCompanyID(i2));
                dbCompany.setCompanyName(this.getCompanyName(i2));
                dbCompany.setDataCenterID(this.getDBID(i2));
                dbCompany.setDataCenterName(this.getDBName(i2));
                this.excutor.addDBCenterCompanyInfo(dbCompany);
            }
        }
        String xml = this.getETLSchemeXML(info.getScheme());
        this.excutor.setXml(xml);
        HashMap<String, String> map = new HashMap<String, String>();
        LinkedList<DBCenterModel> dataCenters = new LinkedList<DBCenterModel>();
        if (this.dbCentersInXML != null && !this.dbCentersInXML.isEmpty()) {
            block5: for (i = 0; i < this.dbCentersInXML.size(); ++i) {
                try {
                    String dbName = this.dbCentersInXML.get(i).toString();
                    if ("\u6a21\u677f\u6570\u636e\u4e2d\u5fc3".equals(dbName)) continue;
                    Iterator iterator = DBConnectionMap.getInstance(ctx).iterator();
                    while (iterator.hasNext()) {
                        DBCenterModel centerModel = (DBCenterModel)iterator.next();
                        if (map.containsKey(centerModel.getDbCenterId()) || !dbName.equalsIgnoreCase(centerModel.getDbCenterName())) continue;
                        map.put(centerModel.getDbCenterId(), centerModel.getDbCenterId());
                        dataCenters.add(centerModel);
                        continue block5;
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        for (i = 0; i < this.excutor.companyDBSize(); ++i) {
            DBCenterCompanyInfo centerCompanyInfo = this.excutor.getDBCenterCompanyInfo(i);
            if (map.containsKey(centerCompanyInfo.getDataCenterID())) continue;
            try {
                DBCenterModel centerModel = DBConnectionMap.getInstance(ctx).get(centerCompanyInfo.getDataCenterID());
                dataCenters.add(centerModel);
                map.put(centerModel.getDbCenterId(), centerModel.getDbCenterId());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.excutor.setDataCenters(dataCenters);
    }

    private String getETLSchemeXML(EtlSchemeManagerInfo schememInfo) {
        byte[] fileByte = schememInfo.getFileWay();
        String transFile = null;
        try {
            transFile = new String(fileByte, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.addException(new TnterruptException("\u65e0\u6cd5\u89e3\u6790ETL\u65b9\u6848!"));
            return null;
        }
        this.dbCentersInXML = KettleXmlHelper.getDBCentersByXml(transFile);
        try {
            transFile = ETLXMLHandle.addDataCenterInXml(this.ctx, transFile, this.dbCentersInXML.iterator());
        }
        catch (Exception e) {
            this.addException(new TnterruptException("\u65e0\u6cd5\u89e3\u6790ETL\u65b9\u6848!"));
            return transFile;
        }
        return transFile;
    }

    @Override
    public String getCompanyName(int index) {
        if (this.info.getScheme().getComDBMapping() == null) {
            return "";
        }
        if (index > this.info.getScheme().getComDBMapping().getEntry().size() - 1) {
            return "";
        }
        EtlCompanyDBMappingEntryInfo entryInfo = this.info.getScheme().getComDBMapping().getEntry().get(index);
        if (entryInfo.getCompany() == null) {
            return "";
        }
        return entryInfo.getCompany().getName();
    }

    public String getCompanyID(int index) {
        return this.info.getScheme().getCompanyID(index);
    }

    public String getDBID(int index) {
        return this.info.getScheme().getDataCenter(index);
    }

    @Override
    public String getDBName(int index) {
        if (this.info.getScheme().getComDBMapping() == null) {
            return "";
        }
        if (index > this.info.getScheme().getComDBMapping().getEntry().size() - 1) {
            return "";
        }
        EtlSchemeManagerInfo managerInfo = this.info.getScheme();
        if (managerInfo.getDataCenter(index) == null) {
            return "";
        }
        try {
            DBCenterModel centerModel = DBConnectionMap.getInstance(this.ctx).get(managerInfo.getDataCenter(index));
            if (centerModel == null) {
                return "\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5931\u8d25\uff1a\u6570\u636e\u4e2d\u5fc3ID=" + managerInfo.getDataCenter(index);
            }
            return centerModel.getDbCenterName();
        }
        catch (Exception e) {
            return "\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5931\u8d25\uff1a\u6570\u636e\u4e2d\u5fc3ID=" + managerInfo.getDataCenter(index);
        }
    }

    @Override
    public void completeEntry() throws BOSException {
        CoreBaseCollection cols = new CoreBaseCollection();
        for (int i = 0; this.logs != null && i < this.logs.size(); ++i) {
            TransportToTomcatLogInfo logInfo = (TransportToTomcatLogInfo)this.logs.get(i);
            EtlExecuteLogInfo addExecuteLog = EtlLogUtil.addExecuteLog(this.info.getSchemeID(), logInfo.getState(), logInfo.getStartTime(), logInfo.getEndTime(), logInfo.getCompanyName(), logInfo.getDataCenter(), this.dispatchLogID, logInfo.getLogContent());
            cols.add((CoreBaseInfo)addExecuteLog);
        }
        try {
            if (cols.size() > 0) {
                EtlExecuteLogFactory.getLocalInstance(this.ctx).addnew(cols);
            }
        }
        catch (EASBizException e) {
            this.addException((Exception)((Object)e));
        }
        String schemeID = this.info.getScheme().getId().toString();
        boolean hasException = this.excutor.getScheduleExp().hasException();
        String str = hasException ? this.excutor.getScheduleExp().getMessage() : "";
        try {
            EtlStrategyFacadeFactory.getLocalInstance(this.ctx).addStrategy(schemeID, this.dispatchLogID, this.excutor.getLogInfo().toString() + str);
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execut() {
        ClientAgent client = null;
        try {
            client = new ClientAgent(0L);
            EASKettle kettle = (EASKettle)client.createRemoteInstance(EASKettle.class);
            String url = client.getURL();
            String configFileName = client.getConfigFileName();
            Map resultTrans = kettle.execute(this.excutor);
            if (resultTrans.containsKey("Exception")) {
                Exception e = (Exception)resultTrans.get("Exception");
                if (e.getMessage() != null && e.getMessage().indexOf("Connection refused: connect") > 0) {
                    String logContent = "kettle \u670d\u52a1\u5668\u672a \u542f\u52a8,\u8bf7\u542f\u52a8kettle\u670d\u52a1\u5668\u3002\n1.\u67e5\u770bkettle\u670d\u52a1\u5668 URL=" + url + " \u662f\u5426\u53ef\u4ee5\u8bbf\u95ee\u3002\n2.\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6b63\u786e\u914d\u7f6e\u3002\u914d\u7f6e\u6587\u4ef6\u8def\u5f84(eas \u670d\u52a1\u5668)\uff1a" + configFileName + "\n3.\u8bf7\u914d\u7f6e\u6b63\u786e\u7684kettle\u670d\u52a1\u5668\u5730\u5740\uff0c\u5e76\u542f\u52a8";
                    this.addException(new TnterruptException(logContent));
                } else if (e.getMessage() != null && e.getMessage().indexOf("java.net.SocketTimeoutException: Read timed out") > 0) {
                    String logContent = "etl\u8c03\u5ea6\u65f6\u95f4\u5927\u4e8e\u7f51\u7edc\u8d85\u65f6\u65f6\u95f4\uff0cetl\u8c03\u5ea6\u5728etl\u670d\u52a1\u5668\u6b63\u5e38\u6267\u884c!\n\u8bf7\u589e\u52a0eas\\server\\profiles\\server1\\config\\biKettleConfig.properties\u6587\u4ef6\u4e2d\u7684requestTimeoutSeconds\u914d\u7f6e\u503c\u3002\n";
                    this.addException(new Exception(logContent));
                } else {
                    this.addException(e);
                }
            } else {
                this.logs = (List)resultTrans.get("result");
                this.excutor.logInfo(resultTrans.get("logInfo").toString());
            }
        }
        catch (Exception e) {
            this.addException(e);
        }
        finally {
            if (client != null) {
                client.client().terminal();
            }
        }
    }

    @Override
    public ScheduleException getException() {
        return this.excutor.getScheduleExp();
    }

    @Override
    public String[] getRecevieMails() {
        return null;
    }

    @Override
    public String getSchemeName() {
        return this.info.getScheme().getName();
    }

    @Override
    public boolean hasException() {
        return this.excutor.getScheduleExp().hasException();
    }

    @Override
    public boolean hasInterruptException() {
        return this.excutor.getScheduleExp().hasTnterruptException();
    }

    @Override
    public void logException(Exception e) {
        throw new RuntimeException();
    }

    @Override
    public void logInfo(String obj) {
        this.excutor.logInfo(obj);
    }

    public StringBuffer getLogInfo() {
        return this.excutor.getLogInfo();
    }

    @Override
    public void addException(Exception e) {
        this.excutor.getScheduleExp().add(e);
    }

    @Override
    public void clearException() {
        throw new RuntimeException();
    }

    @Override
    public void executScheme(int i) throws Exception {
        throw new RuntimeException();
    }

    @Override
    public void executTryCatchScheme(int i) throws Exception {
        throw new RuntimeException();
    }

    @Override
    public int getBatchSize() {
        throw new RuntimeException();
    }
}

