/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.mdm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeFactory;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.BiManagerException;
import com.kingdee.eas.framework.bireport.bimanager.BillStatusEnum;
import com.kingdee.eas.framework.bireport.bimanager.FieldTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.TableTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.basedata.ITableIndex;
import com.kingdee.eas.framework.bireport.bimanager.basedata.ITableManager;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexInfo;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableManagerCollection;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableManagerFactory;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataFactory;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelFactory;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.app.AbstractMasterDataControllerBean;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.app.ConnectionHelper;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MasterDataControllerBean
extends AbstractMasterDataControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.bimanager.mdm.app.MasterDataControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection masterDataSelector = new SelectorItemCollection();
        masterDataSelector.add("*");
        masterDataSelector.add("MasterDataModel.*");
        masterDataSelector.add("BIProjectScheme.*");
        MasterDataInfo info = this.getMasterDataInfo(ctx, pk, masterDataSelector);
        info.setIsUsed(true);
        this.update(ctx, pk, info);
        String masterDataId = info.getId().toString();
        ITableIndex iTableIndex = TableIndexFactory.getLocalInstance(ctx);
        String table = iTableIndex.getTableNameById(masterDataId, TableTypeEnum.MasterDataEasTable);
        if (table != null) {
            return;
        }
        if (info.getBIProjectScheme() == null) {
            throw new BiManagerException(BiManagerException.E_CURPROJECTSCHEMEISNULL);
        }
        String projectSchemeId = info.getBIProjectScheme().getId().toString();
        Connection dwConnection = ConnectionHelper.getConnection(ctx, Constant.DwFactData, projectSchemeId);
        String masterDataEasTable = null;
        String baseDataTable = null;
        String mappingRelationTable = null;
        String masterDataDwTable = null;
        try {
            ITableManager iTableManager = TableManagerFactory.getLocalInstance(ctx);
            DecimalFormat df = new DecimalFormat("00000000");
            TableManagerCollection tableManagerCollection = iTableManager.getTableManagerCollection("where model='MasterData'");
            TableManagerInfo tableManagerInfo = null;
            int number = 1;
            if (tableManagerCollection == null || tableManagerCollection.size() <= 0) {
                tableManagerInfo = new TableManagerInfo();
                tableManagerInfo.setModel("MasterData");
                tableManagerInfo.setTableName("T_BI_MasterData_");
                number = 1;
            } else {
                tableManagerInfo = tableManagerCollection.get(0);
                number = tableManagerInfo.getNumber() + 1;
            }
            masterDataEasTable = tableManagerInfo.getTableName() + df.format(number);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select * from KSQL_USERTABLES where KSQL_tabName=?", (Object[])new Object[]{masterDataEasTable});
            while (rs.next()) {
                masterDataEasTable = tableManagerInfo.getTableName() + df.format(++number);
                rs = DbUtil.executeQuery((Context)ctx, (String)"select * from KSQL_USERTABLES where KSQL_tabName=?", (Object[])new Object[]{masterDataEasTable});
            }
            tableManagerInfo.setNumber(number);
            iTableManager.submit(tableManagerInfo);
            tableManagerCollection = iTableManager.getTableManagerCollection("where model='BaseData'");
            if (tableManagerCollection == null || tableManagerCollection.size() <= 0) {
                tableManagerInfo = new TableManagerInfo();
                tableManagerInfo.setModel("BaseData");
                tableManagerInfo.setTableName("T_BI_BaseData_");
                number = 1;
            } else {
                tableManagerInfo = tableManagerCollection.get(0);
                number = tableManagerInfo.getNumber() + 1;
            }
            baseDataTable = tableManagerInfo.getTableName() + df.format(number);
            rs = DbUtil.executeQuery((Context)ctx, (String)"select * from KSQL_USERTABLES where KSQL_tabName=?", (Object[])new Object[]{baseDataTable});
            while (rs.next()) {
                baseDataTable = tableManagerInfo.getTableName() + df.format(++number);
                rs = DbUtil.executeQuery((Context)ctx, (String)"select * from KSQL_USERTABLES where KSQL_tabName=?", (Object[])new Object[]{baseDataTable});
            }
            tableManagerInfo.setNumber(number);
            iTableManager.submit(tableManagerInfo);
            tableManagerCollection = iTableManager.getTableManagerCollection("where model='MappingRelation'");
            if (tableManagerCollection == null || tableManagerCollection.size() <= 0) {
                tableManagerInfo = new TableManagerInfo();
                tableManagerInfo.setModel("MappingRelation");
                tableManagerInfo.setTableName("T_BI_MappRel_");
                number = 1;
            } else {
                tableManagerInfo = tableManagerCollection.get(0);
                number = tableManagerInfo.getNumber() + 1;
            }
            mappingRelationTable = tableManagerInfo.getTableName() + df.format(number);
            rs = DbUtil.executeQuery((Context)ctx, (String)"select * from KSQL_USERTABLES where KSQL_tabName=?", (Object[])new Object[]{mappingRelationTable});
            while (rs.next()) {
                mappingRelationTable = tableManagerInfo.getTableName() + df.format(++number);
                rs = DbUtil.executeQuery((Context)ctx, (String)"select * from KSQL_USERTABLES where KSQL_tabName=?", (Object[])new Object[]{mappingRelationTable});
            }
            tableManagerInfo.setNumber(number);
            iTableManager.submit(tableManagerInfo);
            tableManagerCollection = iTableManager.getTableManagerCollection("where model='MasterDataDw'");
            if (tableManagerCollection == null || tableManagerCollection.size() <= 0) {
                tableManagerInfo = new TableManagerInfo();
                tableManagerInfo.setModel("MasterDataDw");
                tableManagerInfo.setTableName("T_BI_Dw_Master_");
                number = 1;
            } else {
                tableManagerInfo = tableManagerCollection.get(0);
                number = tableManagerInfo.getNumber() + 1;
            }
            masterDataDwTable = tableManagerInfo.getTableName() + df.format(number);
            RptRowSet rptRs = DBUtil.executeQuery((String)("select * from KSQL_USERTABLES where KSQL_tabName='" + masterDataDwTable + "'"), (Connection)dwConnection);
            while (rptRs.next()) {
                masterDataDwTable = tableManagerInfo.getTableName() + df.format(++number);
                rptRs = DBUtil.executeQuery((String)("select * from KSQL_USERTABLES where KSQL_tabName='" + masterDataDwTable + "'"), (Connection)dwConnection);
            }
            tableManagerInfo.setNumber(number);
            iTableManager.submit(tableManagerInfo);
            MasterDataModelInfo dataModel = info.getMasterDataModel();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("Entry.*");
            dataModel = MasterDataModelFactory.getLocalInstance(ctx).getMasterDataModelInfo((IObjectPK)new ObjectUuidPK(dataModel.getId()), selector);
            MasterDataModelEntryCollection col = dataModel.getEntry();
            if (col == null || col.size() <= 0) {
                throw new BiManagerException(BiManagerException.MODELNOTCOMPLETED);
            }
            boolean hasParent = false;
            MasterDataModelEntryInfo entry = null;
            StringBuffer fieldSb = new StringBuffer();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                entry = col.get(i);
                fieldSb.append("F").append(entry.getAttribute()).append(" ").append(entry.getFieldType().getValue());
                if (FieldTypeEnum.Date.equals((Object)entry.getFieldType())) {
                    fieldSb.append("TIME");
                }
                if (!entry.isIsNull()) {
                    fieldSb.append(" NOT NULL ");
                }
                if (Constant.ID.equals(entry.getAttribute())) {
                    fieldSb.append(" PRIMARY KEY ");
                }
                if (Constant.ParentID.equals(entry.getAttribute())) {
                    hasParent = true;
                }
                fieldSb.append(",");
            }
            fieldSb.replace(fieldSb.length() - 1, fieldSb.length(), "");
            StringBuffer creatTableSql = new StringBuffer();
            creatTableSql.append("Create Table ").append(masterDataEasTable).append(" (").append(fieldSb).append(",Fintid INT");
            if (hasParent) {
                creatTableSql.append(",FintparentID INT");
            }
            creatTableSql.append(");");
            DbUtil.execute((Context)ctx, (String)creatTableSql.toString());
            StringBuffer creatBaseDataTableSql = new StringBuffer();
            String idField = "Fid NVARCHAR(255)";
            int idIndex = fieldSb.indexOf(idField);
            fieldSb.replace(idIndex, idIndex + idField.length(), "Fid INT");
            if (hasParent) {
                String parentField = "FparentID NVARCHAR(255)";
                int parentIndex = fieldSb.indexOf(parentField);
                fieldSb.replace(parentIndex, parentIndex + parentField.length(), "FparentID INT");
            }
            creatBaseDataTableSql.append("Create Table ").append(baseDataTable).append(" (").append(fieldSb).append(",F").append(Constant.BaseDataID).append(" NVARCHAR(255)").append(",F").append(Constant.Company).append(" NVARCHAR(255)").append(",F").append(Constant.ReportSource).append(" INT").append(hasParent ? ",FparentNumber NVARCHAR(255)" : "").append(");");
            DbUtil.execute((Context)ctx, (String)creatBaseDataTableSql.toString());
            StringBuffer creatMappRelTableSql = new StringBuffer();
            creatMappRelTableSql.append("Create Table ").append(mappingRelationTable).append(" (").append("F").append(Constant.ID).append(" NVARCHAR(255) NOT NULL PRIMARY KEY,").append(Constant.Mapping_srcID).append(" INT,").append(Constant.Mapping_srcName).append(" NVARCHAR(255),").append(Constant.Mapping_srcNumber).append(" NVARCHAR(255),").append(Constant.Mapping_weight).append(" NUMERIC(28,10),").append(Constant.Mapping_targetID).append(" INT,").append(Constant.Mapping_targetName).append(" NVARCHAR(255),").append(Constant.Mapping_targetNumber).append(" NVARCHAR(255),").append(Constant.Mapping_MappingRelationID).append(" NVARCHAR(255)").append(")");
            DbUtil.execute((Context)ctx, (String)creatMappRelTableSql.toString());
            StringBuffer createDWTableSql = new StringBuffer();
            createDWTableSql.setLength(0);
            createDWTableSql.append("Create Table ").append(masterDataDwTable).append(" (").append(fieldSb).append(",ForiginID NVARCHAR(255)");
            if (hasParent) {
                createDWTableSql.append(",ForiginParentID NVARCHAR(255)");
            }
            createDWTableSql.append(");");
            DBUtil.execute((String)createDWTableSql.toString(), (Connection)dwConnection);
            BIProjectSchemeInfo bIProjectScheme = BIProjectSchemeFactory.getLocalInstance(ctx).getBIProjectSchemeInfo((IObjectPK)new ObjectUuidPK(projectSchemeId));
            TableIndexInfo tableIndexInfo = new TableIndexInfo();
            tableIndexInfo.setTableName(masterDataEasTable);
            tableIndexInfo.setQuoteID(masterDataId);
            tableIndexInfo.setTableType(TableTypeEnum.MasterDataEasTable);
            tableIndexInfo.setNumber(0);
            iTableIndex.submit(tableIndexInfo);
            tableIndexInfo = new TableIndexInfo();
            tableIndexInfo.setTableName(baseDataTable);
            tableIndexInfo.setQuoteID(masterDataId);
            tableIndexInfo.setTableType(TableTypeEnum.BaseDataTable);
            tableIndexInfo.setNumber(0);
            iTableIndex.submit(tableIndexInfo);
            tableIndexInfo = new TableIndexInfo();
            tableIndexInfo.setTableName(mappingRelationTable);
            tableIndexInfo.setQuoteID(masterDataId);
            tableIndexInfo.setTableType(TableTypeEnum.MappingRelationTable);
            tableIndexInfo.setNumber(0);
            iTableIndex.submit(tableIndexInfo);
            tableIndexInfo = new TableIndexInfo();
            tableIndexInfo.setTableName(masterDataDwTable);
            tableIndexInfo.setQuoteID(masterDataId);
            tableIndexInfo.setDataCenter(bIProjectScheme.getDW());
            tableIndexInfo.setTableType(TableTypeEnum.MasterDataDwTable);
            tableIndexInfo.setNumber(0);
            iTableIndex.submit(tableIndexInfo);
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{e.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)dwConnection);
        }
    }

    public void _update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        super._update(ctx, pk, (IObjectValue)model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String masterDataDwTable;
        String mappingRelationTable;
        String baseDataTable;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("BIProjectScheme.*");
        MasterDataInfo oldData = MasterDataFactory.getLocalInstance(ctx).getMasterDataInfo(pk);
        ITableIndex iTableIndex = TableIndexFactory.getLocalInstance(ctx);
        String masterDataId = oldData.getId().toString();
        String masterDataEasTable = iTableIndex.getTableNameById(masterDataId, TableTypeEnum.MasterDataEasTable);
        if (masterDataEasTable != null) {
            DbUtil.execute((Context)ctx, (String)("drop table " + masterDataEasTable));
        }
        if ((baseDataTable = iTableIndex.getTableNameById(masterDataId, TableTypeEnum.BaseDataTable)) != null) {
            DbUtil.execute((Context)ctx, (String)("drop table " + baseDataTable));
        }
        if ((mappingRelationTable = iTableIndex.getTableNameById(masterDataId, TableTypeEnum.MappingRelationTable)) != null) {
            DbUtil.execute((Context)ctx, (String)("drop table " + mappingRelationTable));
        }
        if ((masterDataDwTable = iTableIndex.getTableNameById(masterDataId, TableTypeEnum.MasterDataDwTable)) != null) {
            String projectSchemeId = oldData.getBIProjectScheme().getId().toString();
            Connection dwConnection = ConnectionHelper.getConnection(ctx, Constant.DwFactData, projectSchemeId);
            if (dwConnection == null) {
                throw new BiManagerException(BiManagerException.CANNOTCONNECTION);
            }
            try {
                DBUtil.execute((String)("drop table " + masterDataDwTable), (Connection)dwConnection);
            }
            catch (SQLException e) {
                throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{"drop table " + masterDataDwTable});
            }
            finally {
                SQLUtils.cleanup((Connection)dwConnection);
            }
        }
        DbUtil.execute((Context)ctx, (String)("delete from T_BI_MNG_TableIndex where FQuoteID='" + masterDataId + "'"));
        super._delete(ctx, pk);
    }

    @Override
    protected void _executeSql(Context ctx, String sql, SqlParams params) throws BOSException, EASBizException {
        try {
            DBUtilx.execute((String)sql, (SqlParams)params, (Context)ctx);
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{sql});
        }
    }

    @Override
    protected boolean _isExists(Context ctx, String sql, SqlParams params) throws BOSException, EASBizException {
        try {
            RptRowSet rs = DBUtilx.executeQuery((String)sql, (SqlParams)params, (Context)ctx);
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{sql});
        }
        return false;
    }

    @Override
    protected void _importData(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("MasterDataModel.*");
        selector.add("MasterDataModel.Entry.*");
        MasterDataInfo info = this.getMasterDataInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        MasterDataModelInfo dataModel = info.getMasterDataModel();
        String targetTable = TableIndexFactory.getLocalInstance(ctx).getTableNameById(id, TableTypeEnum.MasterDataEasTable);
        if (targetTable == null) {
            throw new BiManagerException(BiManagerException.TARGETTABLEISNULL);
        }
        String srcTable = dataModel.getEasTableName();
        if (srcTable == null) {
            throw new BiManagerException(BiManagerException.SRCTABLEISNULL);
        }
        StringBuffer saveTempSql = new StringBuffer();
        String tempTable = "t_bi_mng_masterdata_temp001a";
        saveTempSql.append("select Fid,Fintid,Forder into ").append(tempTable).append(" from ").append(targetTable);
        this.executeSql(ctx, saveTempSql.toString(), null);
        this.executeSql(ctx, "delete from " + targetTable, null);
        StringBuffer targetField = new StringBuffer();
        StringBuffer srcField = new StringBuffer();
        StringBuffer filter = new StringBuffer();
        MasterDataModelEntryCollection col = dataModel.getEntry();
        if (col == null || col.size() <= 0) {
            throw new BiManagerException(BiManagerException.MODELNOTCOMPLETED);
        }
        MasterDataModelEntryInfo entry = null;
        String attribute = null;
        boolean hasParent = false;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            attribute = entry.getAttribute();
            if (Constant.ParentID.equals(attribute)) {
                hasParent = true;
            }
            targetField.append("F").append(attribute).append(",");
            srcField.append(entry.getEasFieldName()).append(",");
            if (dataModel.getCU() != null && Constant.CU.equals(attribute)) {
                CtrlUnitInfo cu = dataModel.getCU();
                if (cu.getLongNumber() == null) {
                    cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(cu.getId()));
                }
                filter.append(" where ").append(entry.getEasFieldName()).append(" in (").append("select fid from T_ORG_CtrlUnit where flongnumber='").append(cu.getLongNumber()).append("' or flongnumber like '").append(cu.getLongNumber()).append("!%')");
            }
            if (dataModel.getCompany() == null || !Constant.Company.equals(attribute)) continue;
            CompanyOrgUnitInfo company = dataModel.getCompany();
            if (company.getLongNumber() == null) {
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
            }
            filter.append(" where ").append(entry.getEasFieldName()).append(" in (").append("select fid from T_ORG_Company where flongnumber='").append(company.getLongNumber()).append("' or flongnumber like '").append(company.getLongNumber()).append("!%')");
        }
        targetField.replace(targetField.length() - 1, targetField.length(), "");
        srcField.replace(srcField.length() - 1, srcField.length(), "");
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(targetTable).append("(").append(targetField).append(") select distinct ").append(srcField).append(" from ").append(srcTable).append(filter).append(" ;");
        this.executeSql(ctx, sql.toString(), null);
        sql.setLength(0);
        sql.append("update ").append(targetTable).append(" as m set fintid=(").append(" select t.fintid from ").append(tempTable).append(" t ").append(" where m.fid=t.fid)");
        this.executeSql(ctx, sql.toString(), null);
        sql.setLength(0);
        sql.append("update ").append(targetTable).append(" as m set forder=(").append(" select t.forder from ").append(tempTable).append(" t ").append(" where m.fid=t.fid)");
        this.executeSql(ctx, sql.toString(), null);
        sql.setLength(0);
        sql.append("select max(fintid) from ").append(targetTable);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int maxNumber = 0;
        try {
            if (rs.next()) {
                maxNumber = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{sql.toString()});
        }
        sql.setLength(0);
        sql.append("select fid from ").append(targetTable).append(" where fintid is null order by fnumber");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        HashMap<String, Integer> idMap = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                String fid = rs.getString(1);
                paramsList.add(new Object[]{new Integer(++maxNumber), new Integer(maxNumber), fid});
                idMap.put(fid, new Integer(maxNumber));
            }
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{sql.toString()});
        }
        sql.setLength(0);
        sql.append("update ").append(targetTable).append(" set fintid=?,forder=? where fid=?");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
        if (hasParent) {
            sql.setLength(0);
            sql.append("update ").append(targetTable).append(" as m set fintparentid=(").append(" select t.fintid from ").append(targetTable).append(" t ").append(" where m.fparentid=t.fid)");
            this.executeSql(ctx, sql.toString(), null);
        }
        this.executeSql(ctx, "drop table " + tempTable, null);
    }

    @Override
    protected void _unAudit(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("MasterDataModel.*");
        selector.add("BIProjectScheme.id");
        MasterDataInfo info = this.getMasterDataInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        if (info.getMasterDataModel() == null) {
            throw new BiManagerException(BiManagerException.E_MASTERDATAMODELISNULL);
        }
        if (info.getBIProjectScheme() == null) {
            throw new BiManagerException(BiManagerException.E_CURPROJECTSCHEMEISNULL);
        }
        MasterDataModelInfo dataModel = info.getMasterDataModel();
        String masterDataId = info.getId().toString();
        ITableIndex iTableIndex = TableIndexFactory.getLocalInstance(ctx);
        String masterDataDwTable = iTableIndex.getTableNameById(masterDataId, TableTypeEnum.MasterDataDwTable);
        if (masterDataDwTable == null) {
            throw new BiManagerException(BiManagerException.E_MASTERDATADWTABLENOTEXIST);
        }
        String projectSchemeId = info.getBIProjectScheme().getId().toString();
        Connection dwConnection = ConnectionHelper.getConnection(ctx, Constant.DwFactData, projectSchemeId);
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(masterDataDwTable);
        try {
            DBUtil.execute((String)sql.toString(), (Connection)dwConnection);
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{sql.toString()});
        }
        finally {
            SQLUtils.cleanup((Connection)dwConnection);
        }
        info.setBillStatus(BillStatusEnum.Submit);
        info.setIsInWarehouse(false);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    @Override
    protected void _audit(Context ctx, String id) throws BOSException, EASBizException {
        String masterDataId;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("MasterDataModel.*");
        selector.add("MasterDataModel.Entry.*");
        selector.add("BIProjectScheme.id");
        MasterDataInfo info = this.getMasterDataInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        if (info.getMasterDataModel() == null) {
            throw new BiManagerException(BiManagerException.E_MASTERDATAMODELISNULL);
        }
        if (info.getBIProjectScheme() == null) {
            throw new BiManagerException(BiManagerException.E_CURPROJECTSCHEMEISNULL);
        }
        MasterDataModelInfo dataModel = info.getMasterDataModel();
        ITableIndex iTableIndex = TableIndexFactory.getLocalInstance(ctx);
        String masterDataDwTable = iTableIndex.getTableNameById(masterDataId = info.getId().toString(), TableTypeEnum.MasterDataDwTable);
        if (masterDataDwTable == null) {
            throw new BiManagerException(BiManagerException.E_MASTERDATADWTABLENOTEXIST);
        }
        String masterDataEasTable = iTableIndex.getTableNameById(masterDataId, TableTypeEnum.MasterDataEasTable);
        if (masterDataEasTable == null) {
            throw new BiManagerException(BiManagerException.E_MASTERDATAEASTABLENOTEXIST);
        }
        MasterDataModelEntryCollection col = dataModel.getEntry();
        if (col == null || col.size() <= 0) {
            throw new BiManagerException(BiManagerException.MODELNOTCOMPLETED);
        }
        String fieldName = null;
        ArrayList<String> fieldList = new ArrayList<String>();
        StringBuffer srcFieldSb = new StringBuffer();
        StringBuffer targetFieldSb = new StringBuffer();
        StringBuffer paramsSb = new StringBuffer();
        boolean hasParent = false;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            MasterDataModelEntryInfo entry = col.get(i);
            String attribute = entry.getAttribute();
            fieldName = "F" + attribute.toUpperCase();
            if ("id".equals(attribute)) {
                srcFieldSb.append(" FINTID as FID");
            } else if ("parentID".equals(attribute)) {
                srcFieldSb.append(" FINTPARENTID as FPARENTID");
                hasParent = true;
            } else {
                srcFieldSb.append(fieldName);
            }
            srcFieldSb.append(",");
            targetFieldSb.append(fieldName).append(",");
            paramsSb.append("?,");
            fieldList.add(fieldName);
        }
        srcFieldSb.replace(srcFieldSb.length() - 1, srcFieldSb.length(), "");
        srcFieldSb.append(", FID as FORIGINID");
        if (hasParent) {
            srcFieldSb.append(", FPARENTID as FORIGINPARENTID");
        }
        paramsSb.replace(paramsSb.length() - 1, paramsSb.length(), "");
        targetFieldSb.replace(targetFieldSb.length() - 1, targetFieldSb.length(), "");
        targetFieldSb.append(", FORIGINID");
        paramsSb.append(",?");
        fieldList.add("FORIGINID");
        if (hasParent) {
            targetFieldSb.append(", FORIGINPARENTID");
            paramsSb.append(",?");
            fieldList.add("FORIGINPARENTID");
        }
        String projectSchemeId = info.getBIProjectScheme().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(srcFieldSb).append(" from ").append(masterDataEasTable);
        RptRowSet rs = null;
        try {
            rs = DBUtil.executeQuery((String)sql.toString(), (Connection)EJBFactory.getConnection((Context)ctx));
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{sql.toString()});
        }
        ArrayList dataList = null;
        String[] columnNames = rs.getColumnNames();
        int columns = columnNames.length;
        while (rs.next()) {
            if (dataList == null) {
                dataList = new ArrayList();
            }
            HashMap<String, Object> objMap = new HashMap<String, Object>();
            for (int i = 0; i < columns; ++i) {
                objMap.put(columnNames[i], rs.getObject(columnNames[i]));
            }
            dataList.add(objMap);
        }
        if (dataList != null && dataList.size() > 0) {
            Connection dwConnection = ConnectionHelper.getConnection(ctx, Constant.DwFactData, projectSchemeId);
            sql.setLength(0);
            sql.append("delete from ").append(masterDataDwTable);
            try {
                DBUtil.execute((String)sql.toString(), (Connection)dwConnection);
            }
            catch (SQLException e) {
                throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{sql.toString()});
            }
            sql.setLength(0);
            sql.append("insert into ").append(masterDataDwTable).append(" (").append(targetFieldSb).append(") ").append(" values (").append(paramsSb).append(") ");
            int MAX_DATA_ROW = 1000;
            PreparedStatement ps = null;
            try {
                ps = dwConnection.prepareStatement(sql.toString());
                boolean flag = false;
                int counts = dataList.size();
                for (int i = 0; i < counts; ++i) {
                    HashMap objMap = (HashMap)dataList.get(i);
                    int paramSize = fieldList.size();
                    for (int j = 0; j < paramSize; ++j) {
                        String field = (String)fieldList.get(j);
                        Object value = objMap.get(field);
                        if (value != null) {
                            ps.setObject(j + 1, value);
                            continue;
                        }
                        ps.setNull(j + 1, 12);
                    }
                    ps.addBatch();
                    if ((i + 1) % 1000 == 0) {
                        ps.executeBatch();
                        flag = true;
                        continue;
                    }
                    flag = false;
                }
                if (!flag) {
                    ps.executeBatch();
                }
            }
            catch (SQLException exc) {
                throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{sql.toString()});
            }
            finally {
                SQLUtils.cleanup((Statement)ps, (Connection)dwConnection);
            }
        }
        info.setBillStatus(BillStatusEnum.Audited);
        info.setIsInWarehouse(true);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    @Override
    protected Map _excelExport(Context ctx, String id) throws BOSException, EASBizException {
        String masterDataEasTable = TableIndexFactory.getLocalInstance(ctx).getTableNameById(id, TableTypeEnum.MasterDataEasTable);
        if (masterDataEasTable == null) {
            throw new BiManagerException(BiManagerException.E_MASTERDATAEASTABLENOTEXIST);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("MasterDataModel.*");
        selector.add("MasterDataModel.Entry.*");
        MasterDataInfo info = this.getMasterDataInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        MasterDataModelInfo dataModel = info.getMasterDataModel();
        MasterDataModelEntryCollection col = dataModel.getEntry();
        if (col == null || col.size() <= 0) {
            throw new BiManagerException(BiManagerException.MODELNOTCOMPLETED);
        }
        MasterDataModelEntryInfo entry = null;
        ArrayList<String> fieldNameList = new ArrayList<String>();
        ArrayList<String> fieldRsList = new ArrayList<String>();
        HashMap<String, FieldTypeEnum> fieldTypeMap = new HashMap<String, FieldTypeEnum>();
        StringBuffer fieldNameSb = new StringBuffer();
        boolean hasParent = false;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String fieldName;
            entry = col.get(i);
            String attribute = entry.getAttribute();
            if ("id".equals(attribute) || "intid".equals(attribute) || "intparentID".equals(attribute)) continue;
            if ("parentID".equals(attribute)) {
                hasParent = true;
                fieldName = "FPARENTNUMBER";
                fieldNameSb.append("B.fnumber as ").append(fieldName).append(",");
                fieldRsList.add(fieldName);
                fieldTypeMap.put(fieldName, FieldTypeEnum.Text);
                fieldNameList.add("\u7236\u7f16\u7801");
                continue;
            }
            fieldName = ("F" + attribute).toUpperCase();
            fieldNameSb.append("A.").append(fieldName).append(" as ").append(fieldName).append(",");
            fieldRsList.add(fieldName);
            fieldTypeMap.put(fieldName, entry.getFieldType());
            fieldNameList.add(entry.getAlias());
        }
        fieldNameSb.replace(fieldNameSb.length() - 1, fieldNameSb.length(), "");
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(fieldNameSb).append(" from ").append(masterDataEasTable).append(" A ");
        if (hasParent) {
            sql.append(" left join ").append(masterDataEasTable).append(" B on A.fparentid=B.fid");
        }
        sql.append(" order by forder");
        ArrayList dataList = new ArrayList();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dataTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            while (rs.next()) {
                HashMap objMap = new HashMap();
                int size2 = fieldRsList.size();
                for (int i = 0; i < size2; ++i) {
                    Date date;
                    String fieldName = (String)fieldRsList.get(i);
                    String value = "";
                    FieldTypeEnum fieldType = (FieldTypeEnum)((Object)fieldTypeMap.get(fieldName));
                    if (FieldTypeEnum.Date.equals((Object)fieldType)) {
                        Timestamp oldValue = rs.getTimestamp(fieldName);
                        if (oldValue != null) {
                            date = new Date(oldValue.getTime());
                            value = dataFormat.format(date);
                        }
                    } else if (FieldTypeEnum.DateTime.equals((Object)fieldType)) {
                        Timestamp oldValue = rs.getTimestamp(fieldName);
                        if (oldValue != null) {
                            date = new Date(oldValue.getTime());
                            value = dataTimeFormat.format(date);
                        }
                    } else if (FieldTypeEnum.Integer.equals((Object)fieldType)) {
                        int oldValue = rs.getInt(fieldName);
                        value = Integer.toString(oldValue);
                    } else {
                        double oldValue;
                        value = FieldTypeEnum.Decimal.equals((Object)fieldType) ? ((oldValue = rs.getDouble(fieldName)) == 0.0 || oldValue == 0.0 ? "0" : Double.toString(oldValue)) : rs.getString(fieldName);
                    }
                    objMap.put(fieldNameList.get(i), value);
                }
                dataList.add(objMap);
            }
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{e.getMessage()});
        }
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        map.put("dataList", dataList);
        map.put("fieldNameList", fieldNameList);
        return map;
    }

    @Override
    protected void _excelImport(Context ctx, String id, Map map) throws BOSException, EASBizException {
        String number;
        String masterDataEasTable = TableIndexFactory.getLocalInstance(ctx).getTableNameById(id, TableTypeEnum.MasterDataEasTable);
        if (masterDataEasTable == null) {
            throw new BiManagerException(BiManagerException.E_MASTERDATAEASTABLENOTEXIST);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("MasterDataModel.*");
        selector.add("MasterDataModel.Entry.*");
        MasterDataInfo info = this.getMasterDataInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        if (info.getMasterDataModel() == null) {
            throw new BiManagerException(BiManagerException.E_MASTERDATAMODELISNULL);
        }
        if (info.getBIProjectScheme() == null) {
            throw new BiManagerException(BiManagerException.E_CURPROJECTSCHEMEISNULL);
        }
        MasterDataModelInfo dataModel = info.getMasterDataModel();
        MasterDataModelEntryCollection col = dataModel.getEntry();
        if (col == null || col.size() <= 0) {
            throw new BiManagerException(BiManagerException.MODELNOTCOMPLETED);
        }
        ArrayList<String> fieldNameList = new ArrayList<String>();
        StringBuffer insertFieldSb = new StringBuffer();
        StringBuffer insertParamSb = new StringBuffer();
        StringBuffer updateFieldSb = new StringBuffer();
        HashMap<String, String> notNullMap = new HashMap<String, String>();
        List srcFieldList = (List)map.get("fieldNameList");
        HashMap<String, FieldTypeEnum> fieldTypeMap = new HashMap<String, FieldTypeEnum>();
        boolean hasParent = false;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            MasterDataModelEntryInfo entry = col.get(i);
            String attribute = entry.getAttribute();
            String fieldName = "F" + attribute.toUpperCase();
            if ("id".equals(attribute) || "intid".equals(attribute) || "intparentID".equals(attribute)) continue;
            if ("parentID".equals(attribute)) {
                hasParent = true;
                continue;
            }
            String alias = entry.getAlias();
            if (!srcFieldList.contains(alias)) {
                throw new BiManagerException(BiManagerException.EXCELLOSECOLUMN, new Object[]{alias, entry.getFieldType().getAlias()});
            }
            insertFieldSb.append(fieldName).append(",");
            insertParamSb.append("?,");
            updateFieldSb.append(fieldName).append("=?,");
            fieldNameList.add(alias);
            fieldTypeMap.put(alias, entry.getFieldType());
            if (entry.isIsNull()) continue;
            notNullMap.put(alias, "");
        }
        insertFieldSb.replace(insertFieldSb.length() - 1, insertFieldSb.length(), "");
        insertParamSb.replace(insertParamSb.length() - 1, insertParamSb.length(), "");
        updateFieldSb.replace(updateFieldSb.length() - 1, updateFieldSb.length(), "");
        String numbers = (String)map.get("numbers");
        StringBuffer sql = new StringBuffer();
        sql.append("select Fnumber from ").append(masterDataEasTable).append(" where Fnumber in(").append(numbers).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> existsNumberMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                String number2 = rs.getString("Fnumber");
                existsNumberMap.put(number2, "");
            }
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{e.getMessage()});
        }
        sql.setLength(0);
        sql.append("select max(fintid) from ").append(masterDataEasTable);
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int maxNumber = 0;
        try {
            if (rs.next()) {
                maxNumber = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{e.getMessage()});
        }
        List dataList = (List)map.get("dataList");
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
        StringBuffer parntNumbers = new StringBuffer();
        ArrayList<Map> hasParentList = new ArrayList<Map>();
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dataTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int columns = fieldNameList.size();
        int size2 = dataList.size();
        for (int i = 0; i < size2; ++i) {
            String parentNumber;
            Map objMap = (Map)dataList.get(i);
            number = (String)objMap.get("\u7f16\u7801");
            Object[] paramObj = new Object[columns + 1];
            for (int j = 0; j < columns; ++j) {
                String fieldName = (String)fieldNameList.get(j);
                String oldValue = (String)objMap.get(fieldName);
                if (notNullMap.containsKey(fieldName) && (oldValue == null || oldValue.trim().length() == 0)) {
                    throw new BiManagerException(BiManagerException.EXCELCANNOTBENOLL, new Object[]{objMap.get("line"), fieldName});
                }
                Object value = null;
                FieldTypeEnum fieldType = (FieldTypeEnum)((Object)fieldTypeMap.get(fieldName));
                try {
                    if (oldValue != null && oldValue.trim().length() != 0) {
                        oldValue = oldValue.trim();
                        value = FieldTypeEnum.Date.equals((Object)fieldType) ? new Timestamp(dataFormat.parse(oldValue).getTime()) : (FieldTypeEnum.DateTime.equals((Object)fieldType) ? new Timestamp(dataTimeFormat.parse(oldValue).getTime() - 28800000L) : (FieldTypeEnum.Integer.equals((Object)fieldType) ? new Integer(oldValue) : (FieldTypeEnum.Decimal.equals((Object)fieldType) ? new BigDecimal(oldValue) : oldValue)));
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new BiManagerException(BiManagerException.EXCELTYPEERROR, new Object[]{objMap.get("line"), fieldName + (oldValue == null ? "" : oldValue), fieldType.getAlias()});
                }
                catch (ParseException e) {
                    throw new BiManagerException(BiManagerException.EXCELTYPEERROR, new Object[]{objMap.get("line"), fieldName + (oldValue == null ? "" : oldValue), fieldType.getAlias()});
                }
                paramObj[j] = value;
            }
            if (existsNumberMap.containsKey(number)) {
                paramObj[columns] = number;
                updateParamList.add(paramObj);
            } else {
                paramObj[columns] = new Integer(++maxNumber);
                insertParamList.add(paramObj);
            }
            if (!hasParent || (parentNumber = (String)objMap.get("\u7236\u7f16\u7801")) == null || parentNumber.trim().length() <= 0) continue;
            parentNumber = parentNumber.trim();
            parntNumbers.append("'").append(parentNumber).append("'").append(",");
            hasParentList.add(objMap);
        }
        boolean deleteOld = (Boolean)map.get("deleteOld");
        if (deleteOld) {
            sql.setLength(0);
            sql.append("delete from ").append(masterDataEasTable).append(" where Fnumber not in(").append(numbers).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if (updateParamList.size() > 0) {
            sql.setLength(0);
            sql.append("update ").append(masterDataEasTable).append(" set ").append(updateFieldSb).append(" where fnumber=?");
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), updateParamList);
        }
        if (insertParamList.size() > 0) {
            sql.setLength(0);
            sql.append("insert ").append(masterDataEasTable).append(" (").append(insertFieldSb).append(",Fintid,Fid").append(") values(").append(insertParamSb).append(",?,newbosid ('12345678')").append(")");
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), insertParamList);
        }
        if (hasParentList.size() > 0) {
            parntNumbers.replace(parntNumbers.length() - 1, parntNumbers.length(), "");
            sql.setLength(0);
            sql.append("select fnumber from ").append(masterDataEasTable).append(" where Fnumber not in(").append(parntNumbers).append(")").append(" and Fnumber in(").append(parntNumbers).append(")");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                StringBuffer errowNumber = null;
                while (rs.next()) {
                    if (errowNumber == null) {
                        errowNumber = new StringBuffer();
                    }
                    errowNumber.append(rs.getString(1)).append(",");
                }
                if (errowNumber != null) {
                    errowNumber.replace(errowNumber.length() - 1, errowNumber.length(), "");
                    throw new BiManagerException(BiManagerException.EXCELNUMBERERROR, new Object[]{errowNumber.toString()});
                }
            }
            catch (SQLException e) {
                throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{e.getMessage()});
            }
            sql.setLength(0);
            sql.append("select fid,fintid,fnumber from ").append(masterDataEasTable).append(" where Fnumber in(").append(parntNumbers).append(")");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashMap<String, Object[]> parentNumberMap = new HashMap<String, Object[]>();
            try {
                while (rs.next()) {
                    Object[] obj = new Object[]{rs.getString("fid"), new Integer(rs.getInt("fintid"))};
                    number = rs.getString("fnumber");
                    parentNumberMap.put(number, obj);
                }
            }
            catch (SQLException e) {
                throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{e.getMessage()});
            }
            ArrayList<Object[]> updateParentList = new ArrayList<Object[]>();
            int size3 = hasParentList.size();
            for (int i = 0; i < size3; ++i) {
                Map objMap = (Map)hasParentList.get(i);
                String parentNumber = (String)objMap.get("\u7236\u7f16\u7801");
                String number3 = (String)objMap.get("\u7f16\u7801");
                Object[] objValue = (Object[])parentNumberMap.get(parentNumber);
                Object[] obj = new Object[]{objValue[0], objValue[1], number3};
                updateParentList.add(obj);
            }
            sql.setLength(0);
            sql.append("update ").append(masterDataEasTable).append(" set fparentID=?,fintparentID=? ").append(" where Fnumber=?");
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), updateParentList);
        }
    }

    @Override
    protected void _insertData(Context ctx, Map map) throws BOSException, EASBizException {
        boolean isDoubleNumber;
        String id = (String)map.get("id");
        String tableName = (String)map.get("tableName");
        String sql = "select forder from " + tableName + " where fid=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id});
        int oldOrder = -1;
        try {
            if (rs.next()) {
                oldOrder = rs.getInt("forder");
            }
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{e.getMessage()});
        }
        if (map.get("deleteOldSql") != null) {
            sql = (String)map.get("deleteOldSql");
            SqlParams params = (SqlParams)map.get("deleteOldParams");
            this.executeSql(ctx, sql, params);
        }
        if (isDoubleNumber = this.isExists(ctx, sql = (String)map.get("checkNumberSql"), null)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{map.get("number")});
        }
        Number order = (Number)map.get("order");
        boolean isDoubleOrder = this.isExists(ctx, "select * from " + tableName + " where forder=" + order + " and fid not in ('" + id + "')", null);
        if (isDoubleOrder) {
            if (oldOrder != -1) {
                if (order.intValue() < oldOrder) {
                    sql = "update " + tableName + " set forder=forder+1 where forder>=" + order + " and forder<" + oldOrder;
                    this.executeSql(ctx, sql, null);
                } else if (order.intValue() > oldOrder) {
                    sql = "update " + tableName + " set forder=forder-1 where forder>" + oldOrder + " and forder<=" + order;
                    this.executeSql(ctx, sql, null);
                }
            }
        } else if (oldOrder != -1 && order != null && order.intValue() > oldOrder) {
            sql = "update " + tableName + " set forder=forder-1 where forder>" + oldOrder + " and forder<=" + order;
            this.executeSql(ctx, sql, null);
        }
        sql = (String)map.get("insertSql");
        SqlParams params = (SqlParams)map.get("insertParams");
        this.executeSql(ctx, sql, params);
        TableIndexInfo tableIndexInfo = (TableIndexInfo)map.get("tableIndexInfo");
        if (tableIndexInfo != null) {
            TableIndexFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(tableIndexInfo.getId()), tableIndexInfo);
        }
    }
}

