/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.mm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.BiManagerException;
import com.kingdee.eas.framework.bireport.bimanager.TableTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.basedata.ITableIndex;
import com.kingdee.eas.framework.bireport.bimanager.basedata.TableIndexFactory;
import com.kingdee.eas.framework.bireport.bimanager.mm.MappingInfo;
import com.kingdee.eas.framework.bireport.bimanager.mm.app.AbstractMappingRelationControllerBean;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class MappingRelationControllerBean
extends AbstractMappingRelationControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.bireport.bimanager.mm.app.MappingRelationControllerBean");

    @Override
    protected String _addMapping(Context ctx, MappingInfo mappingInfo) throws BOSException, EASBizException {
        if (mappingInfo == null) {
            throw new BOSException(Constant.DataIsNull);
        }
        if (mappingInfo.getMappingTableName() == null) {
            throw new BOSException(Constant.MappingTableIsNull);
        }
        if (mappingInfo.getMappingRelationID() == null) {
            throw new BOSException(Constant.MappingRelationIsNull);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(mappingInfo.getMappingTableName()).append("(F").append(Constant.ID).append(",").append(Constant.Mapping_srcID).append(",").append(Constant.Mapping_srcName).append(",").append(Constant.Mapping_srcNumber).append(",").append(Constant.Mapping_weight).append(",").append(Constant.Mapping_targetID).append(",").append(Constant.Mapping_targetName).append(",").append(Constant.Mapping_targetNumber).append(",").append(Constant.Mapping_MappingRelationID).append(") values(?,?,?,?,?,?,?,?,?)");
        Object[] params = new Object[]{mappingInfo.getId(), mappingInfo.getSrcID(), mappingInfo.getSrcName(), mappingInfo.getSrcNumber(), new Double(mappingInfo.getWeight()), mappingInfo.getTargetID(), mappingInfo.getTargetName(), mappingInfo.getTargetNumber(), mappingInfo.getMappingRelationID()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        return mappingInfo.getId();
    }

    @Override
    protected String _modifyMapping(Context ctx, MappingInfo mappingInfo) throws BOSException, EASBizException {
        if (mappingInfo == null) {
            throw new BOSException(Constant.DataIsNull);
        }
        if (mappingInfo.getMappingTableName() == null) {
            throw new BOSException(Constant.MappingTableIsNull);
        }
        if (mappingInfo.getMappingRelationID() == null) {
            throw new BOSException(Constant.MappingRelationIsNull);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(mappingInfo.getMappingTableName()).append(" set ").append(Constant.Mapping_srcID).append("=?").append(",").append(Constant.Mapping_srcName).append("=?").append(",").append(Constant.Mapping_srcNumber).append("=?").append(",").append(Constant.Mapping_weight).append("=?").append(",").append(Constant.Mapping_targetID).append("=?").append(",").append(Constant.Mapping_targetName).append("=?").append(",").append(Constant.Mapping_targetNumber).append("=?").append(",").append(Constant.Mapping_MappingRelationID).append("=? where ").append(Constant.Mapping_srcID).append("=?");
        Object[] params = new Object[]{mappingInfo.getSrcID(), mappingInfo.getSrcName(), mappingInfo.getSrcNumber(), new Double(mappingInfo.getWeight()), mappingInfo.getTargetID(), mappingInfo.getTargetName(), mappingInfo.getTargetNumber(), mappingInfo.getMappingRelationID(), mappingInfo.getSrcID()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        return mappingInfo.getId();
    }

    @Override
    protected boolean _removeMapping(Context ctx, MappingInfo mappingInfo) throws BOSException, EASBizException {
        if (mappingInfo == null) {
            throw new BOSException(Constant.DataIsNull);
        }
        if (mappingInfo.getMappingTableName() == null) {
            throw new BOSException(Constant.MappingTableIsNull);
        }
        if (mappingInfo.getMappingRelationID() == null) {
            throw new BOSException(Constant.MappingRelationIsNull);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(mappingInfo.getMappingTableName()).append(" where ").append(Constant.Mapping_MappingRelationID).append("=?");
        Object[] params = new Object[]{mappingInfo.getMappingRelationID()};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        return true;
    }

    @Override
    protected void _updateMappingRelation(Context ctx, String baseDataId) throws BOSException, EASBizException {
        if (baseDataId == null || baseDataId.length() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select fmasterdataid,fcompanyid from T_BI_MNG_BaseDataAT where fid in( ").append(" select fbasedatatempletid from T_BI_MNG_BaseData where fid=?)         ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{baseDataId});
        try {
            if (rs.next()) {
                String fmasterdataid = rs.getString("fmasterdataid");
                String fcompanyid = rs.getString("fcompanyid");
                if (fmasterdataid != null && fcompanyid != null) {
                    ITableIndex iTableIndex = TableIndexFactory.getLocalInstance(ctx);
                    String mappingRelationTable = iTableIndex.getTableNameById(fmasterdataid, TableTypeEnum.MappingRelationTable);
                    String baseDataTable = iTableIndex.getTableNameById(fmasterdataid, TableTypeEnum.BaseDataTable);
                    if (mappingRelationTable != null && baseDataTable != null) {
                        sql.setLength(0);
                        sql.append(" delete from ").append(mappingRelationTable).append(" where fsrcnumber in(                                       ").append(" select fsrcnumber from ").append(mappingRelationTable).append(" where fmappingrelationid in                     ").append(" (select fid from T_BI_MNG_MappingRelation where fmappingschemeid in(                             ").append(" select fid from T_BI_MNG_MappingScheme where fmasterdataid=?        ").append(" and fcompanyid=?))) and fsrcnumber not in           ").append(" (select fnumber from ").append(baseDataTable).append(" where fbasedataid=?)");
                        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{fmasterdataid, fcompanyid, baseDataId});
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BiManagerException(BiManagerException.E_SQLEXECUTEERROR, new Object[]{e.getMessage()});
        }
    }
}

