/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common;

public class TrafficMask {
    public static final TrafficMask NONE = new TrafficMask(0, "none");
    public static final TrafficMask READ = new TrafficMask(1, "read");
    public static final TrafficMask WRITE = new TrafficMask(4, "write");
    public static final TrafficMask ALL = new TrafficMask(5, "all");
    private final int interestOps;
    private final String name;

    public static TrafficMask getInstance(int interestOps) {
        boolean write;
        boolean read = (interestOps & 1) != 0;
        boolean bl = write = (interestOps & 4) != 0;
        if (read) {
            if (write) {
                return ALL;
            }
            return READ;
        }
        if (write) {
            return WRITE;
        }
        return NONE;
    }

    private TrafficMask(int interestOps, String name) {
        this.interestOps = interestOps;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return (this.interestOps & 1) != 0;
    }

    public boolean isWritable() {
        return (this.interestOps & 4) != 0;
    }

    public int getInterestOps() {
        return this.interestOps;
    }

    public TrafficMask and(TrafficMask mask) {
        return TrafficMask.getInstance(this.interestOps & mask.interestOps);
    }

    public TrafficMask or(TrafficMask mask) {
        return TrafficMask.getInstance(this.interestOps | mask.interestOps);
    }

    public TrafficMask not() {
        return TrafficMask.getInstance(~this.interestOps);
    }

    public TrafficMask xor(TrafficMask mask) {
        return TrafficMask.getInstance(this.interestOps ^ mask.interestOps);
    }

    public String toString() {
        return this.name;
    }
}

