/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.filter;

import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ByteBuffer;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.DefaultIoFilterChainBuilder;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoFilter;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoFilterAdapter;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoFilterChain;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoSession;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.filter.executor.ExecutorFilter;
import java.util.List;

public class ReadThrottleFilterBuilder {
    public static final String COUNTER = ReadThrottleFilterBuilder.class.getName() + ".counter";
    public static final String SUSPENDED_READS = ReadThrottleFilterBuilder.class.getName() + ".suspendedReads";
    private volatile int maximumConnectionBufferSize = 0x100000;

    public void setMaximumConnectionBufferSize(int maximumConnectionBufferSize) {
        this.maximumConnectionBufferSize = maximumConnectionBufferSize;
    }

    public void attach(IoFilterChain chain) {
        String name = this.getThreadPoolFilterEntryName(chain.getAll());
        chain.addBefore(name, this.getClass().getName() + ".add", new Add());
        chain.addAfter(name, this.getClass().getName() + ".release", new Release());
    }

    public void attach(DefaultIoFilterChainBuilder builder) {
        String name = this.getThreadPoolFilterEntryName(builder.getAll());
        builder.addBefore(name, this.getClass().getName() + ".add", new Add());
        builder.addAfter(name, this.getClass().getName() + ".release", new Release());
    }

    private String getThreadPoolFilterEntryName(List entries) {
        for (IoFilterChain.Entry entry : entries) {
            if (!entry.getFilter().getClass().isAssignableFrom(ExecutorFilter.class)) continue;
            return entry.getName();
        }
        throw new IllegalStateException("Chain does not contain a ExecutorFilter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(IoSession session, int size) {
        IoSession ioSession = session;
        synchronized (ioSession) {
            int counter = this.getCounter(session) + size;
            session.setAttribute(COUNTER, new Integer(counter));
            if (counter >= this.maximumConnectionBufferSize && session.getTrafficMask().isReadable()) {
                session.suspendRead();
                session.setAttribute(SUSPENDED_READS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(IoSession session, int size) {
        IoSession ioSession = session;
        synchronized (ioSession) {
            int counter = Math.max(0, this.getCounter(session) - size);
            session.setAttribute(COUNTER, new Integer(counter));
            if (counter < this.maximumConnectionBufferSize && this.isSuspendedReads(session)) {
                session.resumeRead();
                session.removeAttribute(SUSPENDED_READS);
            }
        }
    }

    private boolean isSuspendedReads(IoSession session) {
        Boolean flag = (Boolean)session.getAttribute(SUSPENDED_READS);
        return null != flag && flag != false;
    }

    private int getCounter(IoSession session) {
        Integer i = (Integer)session.getAttribute(COUNTER);
        return null == i ? 0 : i;
    }

    private class Release
    extends IoFilterAdapter {
        private Release() {
        }

        @Override
        public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
            if (message instanceof ByteBuffer) {
                ReadThrottleFilterBuilder.this.release(session, ((ByteBuffer)message).remaining());
            }
            nextFilter.messageReceived(session, message);
        }
    }

    private class Add
    extends IoFilterAdapter {
        private Add() {
        }

        @Override
        public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
            if (message instanceof ByteBuffer) {
                ReadThrottleFilterBuilder.this.add(session, ((ByteBuffer)message).remaining());
            }
            nextFilter.messageReceived(session, message);
        }
    }
}

