/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio;

import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ConnectFuture;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ExceptionMonitor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoConnectorConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoHandler;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoServiceConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.AbstractIoFilterChain;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.BaseIoConnector;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.DefaultConnectFuture;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.SocketIoProcessor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.SocketSessionConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.SocketSessionImpl;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.NamePreservingRunnable;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.NewThreadExecutor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.Queue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Set;

public class SocketConnector
extends BaseIoConnector {
    private static volatile int nextId = 0;
    private final Object lock = new Object();
    private final int id = nextId++;
    private final String threadName = "SocketConnector-" + this.id;
    private SocketConnectorConfig defaultConfig = new SocketConnectorConfig();
    private final Queue connectQueue = new Queue();
    private final SocketIoProcessor[] ioProcessors;
    private final int processorCount;
    private final Executor executor;
    private Selector selector;
    private Worker worker;
    private int processorDistributor = 0;
    private int workerTimeout = 60;

    public SocketConnector() {
        this(1, new NewThreadExecutor());
    }

    public SocketConnector(int processorCount, Executor executor) {
        if (processorCount < 1) {
            throw new IllegalArgumentException("Must have at least one processor");
        }
        this.executor = executor;
        this.processorCount = processorCount;
        this.ioProcessors = new SocketIoProcessor[processorCount];
        for (int i = 0; i < processorCount; ++i) {
            this.ioProcessors[i] = new SocketIoProcessor("SocketConnectorIoProcessor-" + this.id + "." + i, executor);
        }
    }

    public int getWorkerTimeout() {
        return this.workerTimeout;
    }

    public void setWorkerTimeout(int workerTimeout) {
        if (workerTimeout < 0) {
            throw new IllegalArgumentException("Must be >= 0");
        }
        this.workerTimeout = workerTimeout;
    }

    @Override
    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoServiceConfig config) {
        return this.connect(address, null, handler, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoServiceConfig config) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (localAddress != null && !(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + localAddress.getClass());
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        SocketChannel ch = null;
        boolean success = false;
        try {
            int receiveBufferSize;
            ch = SocketChannel.open();
            ch.socket().setReuseAddress(true);
            if (config instanceof SocketConnectorConfig && (receiveBufferSize = ((SocketSessionConfig)config.getSessionConfig()).getReceiveBufferSize()) > 65535) {
                ch.socket().setReceiveBufferSize(receiveBufferSize);
            }
            if (localAddress != null) {
                ch.socket().bind(localAddress);
            }
            ch.configureBlocking(false);
            if (ch.connect(address)) {
                DefaultConnectFuture future = new DefaultConnectFuture();
                this.newSession(ch, handler, config, future);
                success = true;
                DefaultConnectFuture defaultConnectFuture = future;
                return defaultConnectFuture;
            }
            success = true;
        }
        catch (IOException e) {
            ConnectFuture connectFuture = DefaultConnectFuture.newFailedFuture(e);
            return connectFuture;
        }
        finally {
            if (!success && ch != null) {
                try {
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        ConnectionRequest request = new ConnectionRequest(ch, handler, config);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                try {
                    ch.close();
                }
                catch (IOException e2) {
                    ExceptionMonitor.getInstance().exceptionCaught(e2);
                }
                return DefaultConnectFuture.newFailedFuture(e);
            }
            Queue queue = this.connectQueue;
            synchronized (queue) {
                this.connectQueue.push(request);
            }
            this.selector.wakeup();
        }
        return request;
    }

    @Override
    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(SocketConnectorConfig defaultConfig) {
        if (defaultConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Selector getSelector() {
        Object object = this.lock;
        synchronized (object) {
            return this.selector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.selector = Selector.open();
                this.worker = new Worker();
                this.executor.execute((Runnable)new NamePreservingRunnable(this.worker, this.threadName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNew() {
        if (this.connectQueue.isEmpty()) {
            return;
        }
        Selector selector = this.getSelector();
        while (true) {
            ConnectionRequest req;
            Queue queue = this.connectQueue;
            synchronized (queue) {
                req = (ConnectionRequest)this.connectQueue.pop();
            }
            if (req == null) break;
            SocketChannel ch = req.channel;
            try {
                ch.register(selector, 8, req);
            }
            catch (IOException e) {
                req.setException(e);
                try {
                    ch.close();
                }
                catch (IOException e2) {
                    ExceptionMonitor.getInstance().exceptionCaught(e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessions(Set keys) {
        for (SelectionKey key : keys) {
            if (!key.isConnectable()) continue;
            SocketChannel ch = (SocketChannel)key.channel();
            ConnectionRequest entry = (ConnectionRequest)key.attachment();
            boolean success = false;
            try {
                if (ch.finishConnect()) {
                    key.cancel();
                    this.newSession(ch, entry.handler, entry.config, entry);
                }
                success = true;
            }
            catch (Throwable e) {
                entry.setException(e);
            }
            finally {
                if (success) continue;
                key.cancel();
                try {
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        keys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimedOutSessions(Set keys) {
        long currentTime = System.currentTimeMillis();
        for (SelectionKey key : keys) {
            ConnectionRequest entry;
            if (!key.isValid() || currentTime < (entry = (ConnectionRequest)key.attachment()).deadline) continue;
            entry.setException(new ConnectException());
            try {
                key.channel().close();
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
            }
            finally {
                key.cancel();
            }
        }
    }

    private void newSession(SocketChannel ch, IoHandler handler, IoServiceConfig config, ConnectFuture connectFuture) throws IOException {
        SocketSessionImpl session = new SocketSessionImpl(this, this.nextProcessor(), this.getListeners(), config, ch, handler, ch.socket().getRemoteSocketAddress());
        try {
            this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
            config.getThreadModel().buildFilterChain(session.getFilterChain());
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Failed to create a session.").initCause(e);
        }
        session.setAttribute(AbstractIoFilterChain.CONNECT_FUTURE, connectFuture);
        session.getIoProcessor().addNew(session);
    }

    private SocketIoProcessor nextProcessor() {
        if (this.processorDistributor == Integer.MAX_VALUE) {
            this.processorDistributor = Integer.MAX_VALUE % this.processorCount;
        }
        return this.ioProcessors[this.processorDistributor++ % this.processorCount];
    }

    private class ConnectionRequest
    extends DefaultConnectFuture {
        private final SocketChannel channel;
        private final long deadline;
        private final IoHandler handler;
        private final IoServiceConfig config;

        private ConnectionRequest(SocketChannel channel, IoHandler handler, IoServiceConfig config) {
            this.channel = channel;
            long timeout = config instanceof IoConnectorConfig ? ((IoConnectorConfig)config).getConnectTimeoutMillis() : ((IoConnectorConfig)SocketConnector.this.getDefaultConfig()).getConnectTimeoutMillis();
            this.deadline = System.currentTimeMillis() + timeout;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    implements Runnable {
        private long lastActive = System.currentTimeMillis();

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Selector selector = SocketConnector.this.getSelector();
            block12: while (true) {
                try {
                    while (true) {
                        int nKeys = selector.select(1000L);
                        SocketConnector.this.registerNew();
                        if (nKeys > 0) {
                            SocketConnector.this.processSessions(selector.selectedKeys());
                        }
                        SocketConnector.this.processTimedOutSessions(selector.keys());
                        if (selector.keys().isEmpty()) {
                            if (System.currentTimeMillis() - this.lastActive <= (long)SocketConnector.this.workerTimeout * 1000L) continue;
                            Object object = SocketConnector.this.lock;
                            synchronized (object) {
                                if (selector.keys().isEmpty() && SocketConnector.this.connectQueue.isEmpty()) {
                                    SocketConnector.this.worker = null;
                                    try {
                                        selector.close();
                                    }
                                    catch (IOException e) {
                                        ExceptionMonitor.getInstance().exceptionCaught(e);
                                    }
                                    finally {
                                        SocketConnector.this.selector = null;
                                    }
                                    break block12;
                                }
                                continue block12;
                            }
                        }
                        this.lastActive = System.currentTimeMillis();
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

