/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support;

import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ByteBuffer;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ConnectFuture;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ExceptionMonitor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoConnector;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoFilter;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoHandler;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoServiceConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoSession;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoSessionRecycler;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.AbstractIoFilterChain;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.BaseIoConnector;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.DefaultConnectFuture;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.DatagramConnectorConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.DatagramServiceConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support.DatagramService;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.NamePreservingRunnable;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.Queue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;

public class DatagramConnectorDelegate
extends BaseIoConnector
implements DatagramService {
    private static volatile int nextId = 0;
    private final IoConnector wrapper;
    private final Executor executor;
    private final int id = nextId++;
    private Selector selector;
    private DatagramConnectorConfig defaultConfig = new DatagramConnectorConfig();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final Queue flushingSessions = new Queue();
    private final Queue trafficControllingSessions = new Queue();
    private Worker worker;

    public DatagramConnectorDelegate(IoConnector wrapper, Executor executor) {
        this.wrapper = wrapper;
        this.executor = executor;
    }

    @Override
    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoServiceConfig config) {
        return this.connect(address, null, handler, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoServiceConfig config) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (localAddress != null && !(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + localAddress.getClass());
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        DatagramChannel ch = null;
        boolean initialized = false;
        try {
            ch = DatagramChannel.open();
            DatagramSessionConfig cfg = config.getSessionConfig() instanceof DatagramSessionConfig ? (DatagramSessionConfig)config.getSessionConfig() : (DatagramSessionConfig)this.getDefaultConfig().getSessionConfig();
            ch.socket().setReuseAddress(cfg.isReuseAddress());
            ch.socket().setBroadcast(cfg.isBroadcast());
            ch.socket().setReceiveBufferSize(cfg.getReceiveBufferSize());
            ch.socket().setSendBufferSize(cfg.getSendBufferSize());
            if (ch.socket().getTrafficClass() != cfg.getTrafficClass()) {
                ch.socket().setTrafficClass(cfg.getTrafficClass());
            }
            if (localAddress != null) {
                ch.socket().bind(localAddress);
            }
            ch.connect(address);
            ch.configureBlocking(false);
            initialized = true;
        }
        catch (IOException e) {
            ConnectFuture connectFuture = DefaultConnectFuture.newFailedFuture(e);
            return connectFuture;
        }
        finally {
            if (!initialized && ch != null) {
                try {
                    ch.disconnect();
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        RegistrationRequest request = new RegistrationRequest(ch, handler, config);
        DatagramConnectorDelegate datagramConnectorDelegate = this;
        synchronized (datagramConnectorDelegate) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                try {
                    ch.disconnect();
                    ch.close();
                }
                catch (IOException e2) {
                    ExceptionMonitor.getInstance().exceptionCaught(e2);
                }
                return DefaultConnectFuture.newFailedFuture(e);
            }
            Queue queue = this.registerQueue;
            synchronized (queue) {
                this.registerQueue.push(request);
            }
            this.selector.wakeup();
        }
        return request;
    }

    @Override
    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(DatagramConnectorConfig defaultConfig) {
        if (defaultConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = defaultConfig;
    }

    private synchronized Selector getSelector() {
        return this.selector;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.executor.execute((Runnable)new NamePreservingRunnable(this.worker, "DatagramConnector-" + this.id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession(DatagramSessionImpl session) {
        DatagramConnectorDelegate datagramConnectorDelegate = this;
        synchronized (datagramConnectorDelegate) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                return;
            }
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                this.cancelQueue.push(session);
            }
            this.selector.wakeup();
        }
    }

    @Override
    public void flushSession(DatagramSessionImpl session) {
        Selector selector;
        if (this.scheduleFlush(session) && (selector = this.getSelector()) != null) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleFlush(DatagramSessionImpl session) {
        if (session.setScheduledForFlush(true)) {
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                this.flushingSessions.push(session);
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateTrafficMask(DatagramSessionImpl session) {
        this.scheduleTrafficControl(session);
        Selector selector = this.getSelector();
        if (selector != null) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTrafficControl(DatagramSessionImpl session) {
        Queue queue = this.trafficControllingSessions;
        synchronized (queue) {
            this.trafficControllingSessions.push(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateTrafficMask() {
        if (this.trafficControllingSessions.isEmpty()) {
            return;
        }
        while (true) {
            Queue writeRequestQueue;
            DatagramSessionImpl session;
            Queue queue = this.trafficControllingSessions;
            synchronized (queue) {
                session = (DatagramSessionImpl)this.trafficControllingSessions.pop();
            }
            if (session == null) break;
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleTrafficControl(session);
                break;
            }
            if (!key.isValid()) continue;
            int ops = 1;
            Queue queue2 = writeRequestQueue = session.getWriteRequestQueue();
            synchronized (queue2) {
                if (!writeRequestQueue.isEmpty()) {
                    ops |= 4;
                }
            }
            int mask = session.getTrafficMask().getInterestOps();
            key.interestOps(ops & mask);
        }
    }

    private void processReadySessions(Set keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            it.remove();
            DatagramSessionImpl session = (DatagramSessionImpl)key.attachment();
            this.getSessionRecycler(session).recycle(session.getLocalAddress(), session.getRemoteAddress());
            if (key.isReadable() && session.getTrafficMask().isReadable()) {
                this.readSession(session);
            }
            if (!key.isWritable() || !session.getTrafficMask().isWritable()) continue;
            this.scheduleFlush(session);
        }
    }

    private IoSessionRecycler getSessionRecycler(IoSession session) {
        IoServiceConfig config = session.getServiceConfig();
        IoSessionRecycler sessionRecycler = config instanceof DatagramServiceConfig ? ((DatagramServiceConfig)config).getSessionRecycler() : this.defaultConfig.getSessionRecycler();
        return sessionRecycler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSession(DatagramSessionImpl session) {
        ByteBuffer readBuf = ByteBuffer.allocate(session.getReadBufferSize());
        try {
            int readBytes = session.getChannel().read(readBuf.buf());
            if (readBytes > 0) {
                readBuf.flip();
                ByteBuffer newBuf = ByteBuffer.allocate(readBuf.limit());
                newBuf.put(readBuf);
                newBuf.flip();
                session.increaseReadBytes(readBytes);
                session.getFilterChain().fireMessageReceived(session, newBuf);
            }
        }
        catch (IOException e) {
            session.getFilterChain().fireExceptionCaught(session, e);
        }
        finally {
            readBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSessions() {
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while (true) {
            DatagramSessionImpl session;
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                session = (DatagramSessionImpl)this.flushingSessions.pop();
            }
            if (session == null) break;
            session.setScheduledForFlush(false);
            try {
                boolean flushedAll = this.flush(session);
                if (!flushedAll || session.getWriteRequestQueue().isEmpty() || session.isScheduledForFlush()) continue;
                this.scheduleFlush(session);
            }
            catch (IOException e) {
                session.getFilterChain().fireExceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flush(DatagramSessionImpl session) throws IOException {
        SelectionKey key = session.getSelectionKey();
        if (key == null) {
            this.scheduleFlush(session);
            return false;
        }
        if (!key.isValid()) {
            return false;
        }
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        DatagramChannel ch = session.getChannel();
        Queue writeRequestQueue = session.getWriteRequestQueue();
        int writtenBytes = 0;
        int maxWrittenBytes = ((DatagramSessionConfig)session.getConfig()).getSendBufferSize() << 1;
        try {
            while (true) {
                IoFilter.WriteRequest req;
                Queue queue = writeRequestQueue;
                synchronized (queue) {
                    req = (IoFilter.WriteRequest)writeRequestQueue.first();
                }
                if (req == null) {
                    break;
                }
                ByteBuffer buf = (ByteBuffer)req.getMessage();
                if (buf.remaining() == 0) {
                    Queue queue2 = writeRequestQueue;
                    synchronized (queue2) {
                        writeRequestQueue.pop();
                    }
                    buf.reset();
                    if (!buf.hasRemaining()) {
                        session.increaseWrittenMessages();
                    }
                    session.getFilterChain().fireMessageSent(session, req);
                    continue;
                }
                int localWrittenBytes = ch.write(buf.buf());
                if (localWrittenBytes == 0 || (writtenBytes += localWrittenBytes) >= maxWrittenBytes) {
                    key.interestOps(key.interestOps() | 4);
                    boolean bl = false;
                    return bl;
                }
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                Queue queue3 = writeRequestQueue;
                synchronized (queue3) {
                    writeRequestQueue.pop();
                }
                buf.reset();
                if (!buf.hasRemaining()) {
                    session.increaseWrittenMessages();
                }
                session.getFilterChain().fireMessageSent(session, req);
            }
        }
        finally {
            session.increaseWrittenBytes(writtenBytes);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        Selector selector = this.getSelector();
        while (true) {
            RegistrationRequest req;
            Queue queue = this.registerQueue;
            synchronized (queue) {
                req = (RegistrationRequest)this.registerQueue.pop();
            }
            if (req == null) return;
            DatagramSessionImpl session = new DatagramSessionImpl(this.wrapper, this, req.config, req.channel, req.handler, req.channel.socket().getRemoteSocketAddress(), req.channel.socket().getLocalSocketAddress());
            session.setAttribute(AbstractIoFilterChain.CONNECT_FUTURE, req);
            boolean success = false;
            try {
                SelectionKey key = req.channel.register(selector, 1, session);
                session.setSelectionKey(key);
                this.buildFilterChain(req, session);
                this.getSessionRecycler(session).put(session);
                this.getListeners().fireSessionCreated(session);
                success = true;
                continue;
            }
            catch (Throwable t) {
                session.getFilterChain().fireExceptionCaught(session, t);
                continue;
            }
            finally {
                if (success) continue;
                try {
                    req.channel.disconnect();
                    req.channel.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
                continue;
            }
            break;
        }
    }

    private void buildFilterChain(RegistrationRequest req, IoSession session) throws Exception {
        this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
        req.config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
        req.config.getThreadModel().buildFilterChain(session.getFilterChain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        Selector selector = this.getSelector();
        while (true) {
            DatagramSessionImpl session;
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                session = (DatagramSessionImpl)this.cancelQueue.pop();
            }
            if (session == null) break;
            SelectionKey key = session.getSelectionKey();
            DatagramChannel ch = (DatagramChannel)key.channel();
            try {
                ch.disconnect();
                ch.close();
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
            }
            this.getListeners().fireSessionDestroyed(session);
            session.getCloseFuture().setClosed();
            key.cancel();
            selector.wakeup();
        }
    }

    private static class RegistrationRequest
    extends DefaultConnectFuture {
        private final DatagramChannel channel;
        private final IoHandler handler;
        private final IoServiceConfig config;

        private RegistrationRequest(DatagramChannel channel, IoHandler handler, IoServiceConfig config) {
            this.channel = channel;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Selector selector = DatagramConnectorDelegate.this.getSelector();
            while (true) {
                try {
                    do {
                        int nKeys = selector.select();
                        DatagramConnectorDelegate.this.registerNew();
                        DatagramConnectorDelegate.this.doUpdateTrafficMask();
                        if (nKeys > 0) {
                            DatagramConnectorDelegate.this.processReadySessions(selector.selectedKeys());
                        }
                        DatagramConnectorDelegate.this.flushSessions();
                        DatagramConnectorDelegate.this.cancelKeys();
                    } while (!selector.keys().isEmpty());
                    DatagramConnectorDelegate datagramConnectorDelegate = DatagramConnectorDelegate.this;
                    synchronized (datagramConnectorDelegate) {
                        if (selector.keys().isEmpty() && DatagramConnectorDelegate.this.registerQueue.isEmpty() && DatagramConnectorDelegate.this.cancelQueue.isEmpty()) {
                            DatagramConnectorDelegate.this.worker = null;
                            try {
                                selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                DatagramConnectorDelegate.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

