/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.util;

import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.WfKpdlParseException;
import com.kingdee.eas.base.job.QuartzParser;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.framework.bireport.bimanager.GatherFrequencyEnum;
import com.kingdee.eas.framework.client.CoreUI;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class PeriodSetUtil {
    public static final String SCHEDULE_XML_INITIAL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Scheduale xmlns=\"http://www.kingdee.com/2003/K-PDL1.0\" RetryTime=\"0\" Type=\"EVERYDAY\" BeginTime=\"1258446031557\" EndTime=\"1258446031557\" UseCalendar=\"false\" InstructionType=\"0\"></Scheduale>";

    public String getPeriodXml(CoreUI ui, String dispatchXML) throws LinkageError, Exception {
        String prevscheduleXML = dispatchXML;
        if (prevscheduleXML == null || prevscheduleXML.length() < SCHEDULE_XML_INITIAL.length()) {
            prevscheduleXML = SCHEDULE_XML_INITIAL;
        }
        dispatchXML = ProcessSchedulePlan.open((Object)ui, (String)prevscheduleXML);
        return dispatchXML;
    }

    public static String toScheduleTime(String xml) {
        if (xml == null || xml.length() == 0 || xml.equals("null")) {
            return "";
        }
        ScheduleDef scheduleDef = null;
        QuartzParser quartzParser = null;
        String result = null;
        try {
            scheduleDef = KpdlParser.parseSchedule((String)xml);
            quartzParser = new QuartzParser(scheduleDef.getDefine());
            result = quartzParser.parse();
        }
        catch (WfKpdlParseException wfKpdlParseException) {
            // empty catch block
        }
        return result == null ? xml : result;
    }

    public static Date getDateFromPeriod(int year, int period, GatherFrequencyEnum gatherFrequency) {
        GregorianCalendar calendar = new GregorianCalendar(year, 0, 1, 0, 0, 0);
        switch (gatherFrequency.getValue()) {
            case 1: {
                break;
            }
            case 2: {
                ((Calendar)calendar).add(5, period * 7);
                break;
            }
            case 3: {
                calendar.set(2, period - 1);
                break;
            }
            case 4: {
                ((Calendar)calendar).add(2, (period - 1) * 3);
                break;
            }
            case 5: {
                ((Calendar)calendar).add(2, (period - 1) * 6);
                break;
            }
            case 6: {
                break;
            }
        }
        return new Date(calendar.getTimeInMillis());
    }
}

