/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.util.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterManager;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeFactory;
import com.kingdee.eas.framework.bireport.bimanager.BIProjectSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.BiManagerException;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionMap;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionTypeInfo;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionHelper {
    public static Connection getConnection(Context ctx, int type, String projectSchemeId) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            if (type == Constant.OdsFactData) {
                BIProjectSchemeInfo bIProjectScheme = BIProjectSchemeFactory.getLocalInstance(ctx).getBIProjectSchemeInfo((IObjectPK)new ObjectUuidPK(projectSchemeId));
                conn = DBCenterManager.getConnection((Context)ctx, (String)bIProjectScheme.getODS());
            } else if (type == Constant.DwFactData) {
                BIProjectSchemeInfo bIProjectScheme = BIProjectSchemeFactory.getLocalInstance(ctx).getBIProjectSchemeInfo((IObjectPK)new ObjectUuidPK(projectSchemeId));
                conn = DBCenterManager.getConnection((Context)ctx, (String)bIProjectScheme.getDW());
            } else {
                conn = EJBFactory.getConnection((Context)ctx);
            }
        }
        catch (DBCenterException e2) {
            throw new BiManagerException(BiManagerException.CANNOTCONNECTION);
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.CANNOTCONNECTION);
        }
        return conn;
    }

    public static DBConnectionTypeInfo getDBConnectionInfo(Context ctx, int type, String projectSchemeId) throws BOSException, EASBizException {
        DBConnectionTypeInfo connInfo = new DBConnectionTypeInfo();
        try {
            BIProjectSchemeInfo bIProjectScheme;
            String dbID = null;
            if (type == Constant.OdsFactData) {
                bIProjectScheme = BIProjectSchemeFactory.getLocalInstance(ctx).getBIProjectSchemeInfo((IObjectPK)new ObjectUuidPK(projectSchemeId));
                connInfo.conn = DBCenterManager.getConnection((Context)ctx, (String)bIProjectScheme.getODS());
                dbID = bIProjectScheme.getODS();
            } else if (type == Constant.DwFactData) {
                bIProjectScheme = BIProjectSchemeFactory.getLocalInstance(ctx).getBIProjectSchemeInfo((IObjectPK)new ObjectUuidPK(projectSchemeId));
                connInfo.conn = DBCenterManager.getConnection((Context)ctx, (String)bIProjectScheme.getDW());
                dbID = bIProjectScheme.getDW();
            } else {
                connInfo.conn = EJBFactory.getConnection((Context)ctx);
                dbID = ctx.getAIS();
                String driverName = connInfo.conn.getMetaData().getDriverName();
                if (driverName.toLowerCase().indexOf("ms sql") > 0 || driverName.toLowerCase().indexOf("sqlserver") > 0) {
                    connInfo.type = "sqlserver";
                }
                return connInfo;
            }
            DBCenterModel centerModel = DBConnectionMap.getInstance(ctx).get(dbID);
            connInfo.type = centerModel.getDbType();
        }
        catch (DBCenterException e2) {
            throw new BiManagerException(BiManagerException.CANNOTCONNECTION);
        }
        catch (SQLException e) {
            throw new BiManagerException(BiManagerException.CANNOTCONNECTION);
        }
        catch (Exception e) {
            throw new BiManagerException(BiManagerException.CANNOTCONNECTION);
        }
        return connInfo;
    }

    public static DBConnectionTypeInfo getDWConnection(Context ctx, String projectSchemeId) throws BOSException, EASBizException {
        return ConnectionHelper.getDBConnectionInfo(ctx, Constant.DwFactData, projectSchemeId);
    }

    public static DBConnectionTypeInfo getODSConnection(Context ctx, String projectSchemeId) throws BOSException, EASBizException {
        return ConnectionHelper.getDBConnectionInfo(ctx, Constant.OdsFactData, projectSchemeId);
    }

    public static DBConnectionTypeInfo getEASConnection(Context ctx) throws BOSException, EASBizException {
        return ConnectionHelper.getDBConnectionInfo(ctx, 1111, null);
    }
}

