/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.util.fileupload;

import com.kingdee.eas.framework.bireport.bimanager.util.CleanStreamUtils;
import com.kingdee.eas.framework.bireport.bimanager.util.fileupload.ThresholdingOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private ByteArrayOutputStream memoryOutputStream;
    private FileOutputStream diskOutputStream;
    private OutputStream currentOutputStream;
    private File outputFile;

    public DeferredFileOutputStream(int threshold, File outputFile) {
        super(threshold);
        this.outputFile = outputFile;
        this.memoryOutputStream = new ByteArrayOutputStream(threshold);
        this.currentOutputStream = this.memoryOutputStream;
    }

    @Override
    protected OutputStream getStream() throws IOException {
        return this.currentOutputStream;
    }

    @Override
    protected void thresholdReached() throws IOException {
        FileOutputStream fos = null;
        try {
            byte[] data = this.memoryOutputStream.toByteArray();
            fos = new FileOutputStream(this.outputFile);
            fos.write(data);
            this.diskOutputStream = fos;
            this.currentOutputStream = fos;
            this.memoryOutputStream = null;
        }
        catch (Throwable throwable) {
            CleanStreamUtils.close(fos);
            throw throwable;
        }
        CleanStreamUtils.close(fos);
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.outputFile;
    }
}

