/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.util.tree;

import com.kingdee.bos.ctrl.kdf.table.render.RenderObject;
import com.kingdee.bos.ctrl.kdf.util.render.IExtBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.framework.bireport.bimanager.util.tree.NumberExpandInfo;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;

public class TreeBaseRender
implements IExtBasicRender {
    private int TABSIZE = 8;
    private int ICONSIZE = 10;
    private int margin = 2;
    protected SimpleTextRender simpleRender = new SimpleTextRender();
    protected HashMap idToPos = new HashMap();

    protected void drawExpanded(Graphics g, int x, int y) {
        g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
        int lineSize = this.ICONSIZE - 2 * this.margin;
        g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
    }

    protected void drawCollapsed(Graphics g, int x, int y) {
        g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
        int lineSize = this.ICONSIZE - 2 * this.margin;
        g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
    }

    protected void drawLeaf(Graphics g, int x, int y) {
    }

    public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
        String acctId = numberExpandInfo.getId();
        Rectangle rec = (Rectangle)this.idToPos.get(acctId);
        if (rec != null) {
            return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
        }
        return false;
    }

    public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
        if (obj instanceof NumberExpandInfo) {
            NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
            int ident = numberExpandInfo.getLevel() * this.TABSIZE;
            Rectangle rect = clip.getBounds();
            int x = rect.x + ident;
            int y = rect.y + (rect.height - this.ICONSIZE) / 2;
            Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
            this.idToPos.put(numberExpandInfo.getId(), iconRect);
            this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - ident - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
            this.paintIcon(graphics, numberExpandInfo, iconRect);
        } else if (obj != null) {
            this.simpleRender.draw(graphics, clip, obj.toString(), style);
        }
    }

    private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
        if (numberExpandInfo.isLeaf()) {
            this.drawLeaf(graphics, iconRect.x, iconRect.y);
        } else if (numberExpandInfo.isExpandStatus()) {
            this.drawExpanded(graphics, iconRect.x, iconRect.y);
        } else if (!numberExpandInfo.isExpandStatus()) {
            this.drawCollapsed(graphics, iconRect.x, iconRect.y);
        }
    }

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle, Object extObject) {
        Object obj;
        RenderObject ro = (RenderObject)extObject;
        if (ro != null && ro.getCell() != null && (obj = ro.getCell().getValue()) != null) {
            this.draw(graphics, clip, obj, cellStyle);
        }
    }

    public boolean isClip() {
        return false;
    }

    public boolean isFillBackground() {
        return false;
    }

    public boolean isDrawBorder() {
        return false;
    }
}

