/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.web.jxl;

import com.kingdee.eas.framework.bireport.bimanager.util.CleanStreamUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;

public abstract class UpExcelParseByPOIUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readExcel(String pathName, int sheetId) throws Exception {
        LinkedHashMap map = new LinkedHashMap();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(pathName);
            HSSFWorkbook book = new HSSFWorkbook((InputStream)fis);
            HSSFSheet sheet = book.getSheetAt(sheetId);
            HSSFFormulaEvaluator evaluator = new HSSFFormulaEvaluator(book);
            HashMap innerMap = null;
            int rows = sheet.getLastRowNum() + 1;
            HSSFRow firstRow = sheet.getRow(1);
            int columnNumber = 0;
            LinkedList<Object> list = new LinkedList<Object>();
            for (int j = 0; j < firstRow.getLastCellNum(); ++j) {
                HSSFCell fieldName = firstRow.getCell(j);
                Object cellValue = UpExcelParseByPOIUtil.getCellValue(fieldName, evaluator);
                if (cellValue == null || cellValue.toString().trim().length() == 0) continue;
                list.add(cellValue);
                ++columnNumber;
            }
            for (int i = 2; i < rows; ++i) {
                HSSFCell cell;
                int j;
                innerMap = new HashMap();
                boolean valid = false;
                int line = 2;
                HSSFRow row = sheet.getRow(i);
                for (j = 0; j < columnNumber; ++j) {
                    cell = row.getCell(j);
                    Object obj = UpExcelParseByPOIUtil.getCellValue(cell, evaluator);
                    if (obj == null || obj.toString().trim().length() <= 0) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    ++line;
                    continue;
                }
                for (j = 0; j < columnNumber; ++j) {
                    cell = row.getCell(j);
                    Object value = UpExcelParseByPOIUtil.getCellValue(cell, evaluator);
                    System.out.println(value);
                    innerMap.put(list.get(j), value);
                }
                map.put(new Integer(i - line), innerMap);
            }
        }
        catch (Throwable throwable) {
            CleanStreamUtils.close(fis);
            throw throwable;
        }
        CleanStreamUtils.close(fis);
        return map;
    }

    public static void main(String[] args) {
        try {
            UpExcelParseByPOIUtil.readExcel("d:\\dd.xls", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Object getCellValue(HSSFCell cell, HSSFFormulaEvaluator evaluator) {
        Object result = null;
        switch (cell.getCellType()) {
            case BOOLEAN: {
                result = cell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    double d = cell.getNumericCellValue();
                    result = HSSFDateUtil.getJavaDate((double)d);
                    break;
                }
                result = new Double(cell.getNumericCellValue());
                break;
            }
            case FORMULA: {
                try {
                    result = new Double(cell.getNumericCellValue());
                }
                catch (Exception e) {
                    result = cell.getStringCellValue();
                }
                break;
            }
            case STRING: {
                result = cell.getStringCellValue();
                break;
            }
        }
        return result;
    }

    private static Object str2Double(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        try {
            String ch = str.replaceAll(",", "");
            return new Double(ch);
        }
        catch (Exception e) {
            return str;
        }
    }
}

