/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionTypeInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.app.ConnectionHelper;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.domain.WSPageData;
import com.kingdee.eas.framework.bireport.bimanager.ws.util.TableStructFactory;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class DBTableStructHelper {
    public static String getDbTypeString(WSPageData pageData, String columnName) {
        String type = pageData.getType(columnName);
        return DBTableStructHelper.getDbColumnType(type);
    }

    public static String getDbColumnType(String type) {
        if ("int".equalsIgnoreCase(type) || "short".equalsIgnoreCase(type) || "boolean".equalsIgnoreCase(type)) {
            return "  int ";
        }
        if ("string".equalsIgnoreCase(type) || "base64Binary".equalsIgnoreCase(type)) {
            return " nvarchar(255)";
        }
        if ("decimal".equalsIgnoreCase(type) || "double".equalsIgnoreCase(type) || "float".equalsIgnoreCase(type)) {
            return " NUMERIC(28,10)";
        }
        if ("date".equalsIgnoreCase(type) || "time".equalsIgnoreCase(type) || "dateTime".equalsIgnoreCase(type) || "TimeStamp".equalsIgnoreCase(type)) {
            return " DateTime";
        }
        return null;
    }

    public static void createTable(String tableName, WSPageData pageData, List sqls) throws SQLException, EASBizException, BOSException {
        String[] types = pageData.getType();
        String[] columnNames = pageData.getColumnNames();
        StringBuffer createSQL = new StringBuffer();
        createSQL.append("drop table ");
        createSQL.append(tableName);
        createSQL.append(";\n");
        sqls.add(createSQL.toString());
        createSQL = new StringBuffer();
        createSQL.append("create table ");
        createSQL.append(tableName);
        createSQL.append("(");
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                createSQL.append(", ");
            }
            createSQL.append(columnNames[i]);
            createSQL.append("  ");
            createSQL.append(DBTableStructHelper.getDbColumnType(types[i]));
        }
        createSQL.append(", FUrgeLoadTime DateTime, FUrgeCompanyID varchar(44) ,FwsfactDataID varchar(44) ");
        createSQL.append(");");
        System.out.println(createSQL.toString());
        sqls.add(createSQL.toString());
    }

    public static List alterTableSql(WSPageData pageData, String tableName, Map key_type) throws Exception {
        LinkedList<String> sqls = new LinkedList<String>();
        if (key_type.size() == 1 && key_type.containsKey("FTEMP_ID")) {
            DBTableStructHelper.createTable(tableName, pageData, sqls);
            return sqls;
        }
        List fieldNotInOdsTable = DBTableStructHelper.isSameType(pageData, tableName, key_type, sqls);
        if (fieldNotInOdsTable.size() == 0) {
            return sqls;
        }
        Iterator iter = fieldNotInOdsTable.iterator();
        StringBuffer sp = new StringBuffer();
        while (iter.hasNext()) {
            String columnKey = iter.next().toString();
            String type = DBTableStructHelper.getDbTypeString(pageData, columnKey);
            sp.append("alter table " + tableName + " add " + columnKey + "  " + type + " ;");
            sp.append("\n");
        }
        sqls.add(sp.toString());
        return sqls;
    }

    public static boolean isContainKey(Map map, String column) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            if (!key.equalsIgnoreCase(column)) continue;
            return true;
        }
        return false;
    }

    public static List isSameType(WSPageData pageData, String tableName, Map key_type, List sqls) throws Exception {
        int i;
        String[] pageColumns = pageData.getColumnNames();
        LinkedList<String> notExsitFields = new LinkedList<String>();
        LinkedList<String> notSameType = new LinkedList<String>();
        for (i = 0; i < pageColumns.length; ++i) {
            if (DBTableStructHelper.isContainKey(key_type, pageColumns[i])) {
                Object type = key_type.get(pageColumns[i].toUpperCase());
                String pageType = pageData.getType()[i];
                if ("DateTime".equalsIgnoreCase(type.toString())) {
                    if ("date".equalsIgnoreCase(pageType) || "time".equalsIgnoreCase(pageType) || "dateTime".equalsIgnoreCase(pageType) || "TimeStamp".equalsIgnoreCase(pageType)) continue;
                    notSameType.add(pageColumns[i]);
                    continue;
                }
                if ("STRING".equalsIgnoreCase(type.toString())) {
                    if ("string".equalsIgnoreCase(pageType) || "base64Binary".equalsIgnoreCase(pageType)) continue;
                    notSameType.add(pageColumns[i]);
                    continue;
                }
                if ("INTEGER".equalsIgnoreCase(type.toString())) {
                    if ("int".equalsIgnoreCase(pageType) || "short".equalsIgnoreCase(pageType) || "boolean".equalsIgnoreCase(pageType)) continue;
                    notSameType.add(pageColumns[i]);
                    continue;
                }
                if ("BigDecimal".equalsIgnoreCase(type.toString())) {
                    if ("decimal".equalsIgnoreCase(pageType) || "double".equalsIgnoreCase(pageType) || "float".equalsIgnoreCase(pageType)) continue;
                    notSameType.add(pageColumns[i]);
                    continue;
                }
                notSameType.add(pageColumns[i]);
                continue;
            }
            notExsitFields.add(pageColumns[i]);
        }
        for (i = 0; i < notSameType.size(); ++i) {
        }
        DBTableStructHelper.alterTableByTypeNotSame(notSameType, tableName, pageData, sqls);
        return notExsitFields;
    }

    private static void alterTableByTypeNotSame(List notSameTypes, String tableName, WSPageData pageData, List sqls) throws Exception {
        if (notSameTypes.size() == 0) {
            return;
        }
        for (int i = 0; i < notSameTypes.size(); ++i) {
            String fieldName = notSameTypes.get(i).toString();
            String alterTable = "alter  table " + tableName + " dorp column " + fieldName + " ;alter  table " + tableName + " add " + fieldName + DBTableStructHelper.getDbTypeString(pageData, fieldName) + ";";
            sqls.add(alterTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getTableColumnKey_Type(Context ctx, String schemeID, String tableName) throws Exception, EASBizException, BOSException {
        String sql = "select * from KSQL_USERCOLUMNS where KSQL_TABNAME ='" + tableName + "'";
        DBConnectionTypeInfo typeInfo = null;
        typeInfo = schemeID != null ? ConnectionHelper.getEASConnection(ctx) : ConnectionHelper.getODSConnection(ctx, schemeID);
        try {
            RptRowSet rowSet = DBUtil.executeQuery((String)sql, (Connection)typeInfo.conn);
            String type = typeInfo.type;
            Map map = TableStructFactory.getITableStruct(type).tanslate(rowSet);
            return map;
        }
        finally {
            if (typeInfo.conn != null) {
                typeInfo.conn.close();
            }
        }
    }

    public static Map getTableColumnKey_Type(DBConnectionTypeInfo info, String tableName) throws Exception, EASBizException, BOSException {
        String sql = "select * from KSQL_USERCOLUMNS where KSQL_TABNAME ='" + tableName + "'";
        RptRowSet rowSet = DBUtil.executeQuery((String)sql, (Connection)info.conn);
        String type = info.type;
        return TableStructFactory.getITableStruct(type).tanslate(rowSet);
    }

    public static String getDBType(Connection conn) throws SQLException {
        String driverName = conn.getMetaData().getDriverName();
        String type = "sqlserver";
        if (driverName.toLowerCase().indexOf("oracle") > 1) {
            type = "oracle";
        }
        return type;
    }
}

