/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.calc.express;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.eas.common.calc.CalcResource;
import com.kingdee.eas.common.calc.ICalculateListener;
import com.kingdee.eas.common.calc.IllegalExpressException;
import com.kingdee.eas.common.calc.express.ExpressAnalyzer;
import com.kingdee.eas.common.calc.express.IExpressTraceListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;

public class ExpressDialog
extends JDialog
implements ActionListener,
KeyListener,
IExpressTraceListener {
    private static final int MAX_HISTORY = 100;
    private LinkedList expressList = new LinkedList();
    private int historyExpressIndex = 0;
    private KDTextArea jtInput;
    private KDTextArea jtOutput;
    private KDButton btnCalc;
    private KDButton btnClear;
    private KDButton btnHelp;
    private KDButton btnOK;
    private KDButton btnCancel;
    private KDButton btnPre;
    private KDButton btnNext;
    private KDCheckBox ckDebug = new KDCheckBox(CalcResource.getRes("show_calc_process"));
    private ExpressAnalyzer ce;
    private EventListenerList listenerList = new EventListenerList();

    public ExpressDialog(Dialog parent) {
        super(parent, true);
        this.setResizable(true);
        this.jtInput = new KDTextArea(4, 100);
        this.jtOutput = new KDTextArea();
        this.btnCalc = new KDButton(CalcResource.getRes("calculate"));
        this.btnClear = new KDButton(CalcResource.getRes("clear"));
        this.btnHelp = new KDButton(CalcResource.getRes("help"));
        this.btnOK = new KDButton(CalcResource.getRes("OK"));
        this.btnCancel = new KDButton(CalcResource.getRes("cancel"));
        this.btnPre = new KDButton(CalcResource.getRes("pre_step"));
        this.btnNext = new KDButton(CalcResource.getRes("next_step"));
        this.setFontBold((JComponent)this.jtInput);
        this.jtOutput.setForeground(Color.BLUE);
        this.ce = new ExpressAnalyzer();
        this.ce.addCalculateExpressListener(this);
        this.jbInit();
    }

    private void setFontBold(JComponent jc) {
        Font f = new Font(jc.getFont().getFontName(), 1, jc.getFont().getSize() + 8);
        jc.setFont(f);
    }

    private KDPanel createBorderPanel() {
        KDPanel p = new KDPanel();
        p.setPreferredSize(new Dimension(7, 7));
        return p;
    }

    private void jbInit() {
        Dimension dd = this.getToolkit().getScreenSize();
        int w = 450;
        int h = 350;
        Color background = new Color(217, 217, 208);
        this.setBounds((dd.width - w) / 2, (dd.height - h) / 2, w, h);
        this.setTitle(CalcResource.getRes("calc_express"));
        this.getContentPane().setBackground(background);
        this.getContentPane().setLayout(new BorderLayout());
        KDSplitPane jsp = new KDSplitPane();
        jsp.setOrientation(0);
        this.getContentPane().add((Component)jsp, "Center");
        KDPanel topPanel = new KDPanel((LayoutManager)new BorderLayout());
        topPanel.setBackground(background);
        topPanel.add((Component)this.createBorderPanel(), (Object)"North");
        topPanel.add((Component)this.createBorderPanel(), (Object)"West");
        topPanel.add((Component)new KDScrollPane((Component)this.jtInput), (Object)"Center");
        topPanel.add((Component)this.createBorderPanel(), (Object)"East");
        KDPanel funPanel = new KDPanel();
        topPanel.add((Component)funPanel, (Object)"South");
        funPanel.add((Component)this.ckDebug);
        funPanel.add((Component)this.btnCalc);
        funPanel.add((Component)this.btnClear);
        funPanel.add((Component)this.btnPre);
        funPanel.add((Component)this.btnNext);
        KDPanel buttomPanel = new KDPanel((LayoutManager)new BorderLayout());
        buttomPanel.setBackground(background);
        buttomPanel.add((Component)new KDScrollPane((Component)this.jtOutput), (Object)"Center");
        KDPanel returnFunPanel = new KDPanel();
        returnFunPanel.add((Component)this.btnOK);
        returnFunPanel.add((Component)this.btnCancel);
        returnFunPanel.add((Component)this.btnHelp);
        buttomPanel.add((Component)returnFunPanel, (Object)"South");
        buttomPanel.add((Component)this.createBorderPanel(), (Object)"West");
        buttomPanel.add((Component)this.createBorderPanel(), (Object)"East");
        jsp.add((Component)topPanel, (Object)"top");
        jsp.add((Component)buttomPanel, (Object)"bottom");
        jsp.setDividerLocation(200);
        this.jtOutput.setEditable(false);
        this.jtOutput.setAutoscrolls(true);
        this.jtInput.setAutoscrolls(true);
        this.jtInput.addKeyListener((KeyListener)this);
        this.btnCalc.addKeyListener((KeyListener)this);
        this.btnCalc.addActionListener((ActionListener)this);
        this.btnOK.addActionListener((ActionListener)this);
        this.btnCancel.addActionListener((ActionListener)this);
        this.btnClear.addActionListener((ActionListener)this);
        this.btnHelp.addActionListener((ActionListener)this);
        this.btnPre.addActionListener((ActionListener)this);
        this.btnNext.addActionListener((ActionListener)this);
        this.btnPre.setEnabled(false);
        this.btnNext.setEnabled(false);
    }

    private void calculateExpress() {
        String express = this.jtInput.getText();
        this.jtInput.requestFocus();
        if (express.trim().length() == 0) {
            return;
        }
        this.jtOutput.setText("");
        double result = 0.0;
        try {
            result = this.ce.calculate(express);
            this.jtOutput.append(CalcResource.getRes("returnvalue_colon") + new BigDecimal(result).toString());
        }
        catch (IllegalExpressException ex) {
            this.jtOutput.append(ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.logExpress(result);
    }

    private void clear() {
        this.jtInput.setText("");
        this.jtInput.requestFocus();
    }

    private void help() {
        this.jtOutput.setText(ExpressAnalyzer.getUsage());
        this.jtOutput.setCaretPosition(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.btnCalc) {
            this.calculateExpress();
        } else if (obj == this.btnCancel) {
            this.dispose();
        } else if (obj == this.btnHelp) {
            this.help();
        } else if (obj == this.btnClear) {
            this.clear();
        } else if (obj == this.btnOK) {
            this.returnValue();
        } else if (obj == this.btnPre) {
            this.recallExpress(true);
        } else if (obj == this.btnNext) {
            this.recallExpress(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '=') {
            this.calculateExpress();
            e.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && (e.isControlDown() || e.isShiftDown() || e.isAltDown())) {
            this.calculateExpress();
        } else if (e.getKeyCode() == 112) {
            this.help();
        } else if (e.getKeyCode() == 32 && e.getSource() == this.btnCalc) {
            this.calculateExpress();
        } else if (e.isAltDown()) {
            if (e.getKeyCode() == 38) {
                this.recallExpress(true);
            } else if (e.getKeyCode() == 40) {
                this.recallExpress(false);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void debug(Object msg) {
        if (this.ckDebug.isSelected()) {
            this.jtOutput.append(String.valueOf(msg));
        }
    }

    @Override
    public void warn(Object msg) {
        this.jtOutput.append(String.valueOf(msg));
    }

    private void logExpress(double value) {
        this.historyExpressIndex = 0;
        StringBuffer express = new StringBuffer(this.jtInput.getText());
        while (express.charAt(express.length() - 1) == '\n') {
            express.deleteCharAt(express.length() - 1);
        }
        ExpressStatus es = new ExpressStatus();
        es.isDebug = this.ckDebug.isSelected();
        es.express = express.toString();
        es.msg = this.jtOutput.getText();
        es.value = value;
        this.expressList.remove(es);
        this.expressList.addFirst(es);
        while (this.expressList.size() > 100) {
            this.expressList.removeLast();
        }
        this.btnPre.setEnabled(true);
        this.btnNext.setEnabled(false);
    }

    private void recallExpress(boolean down) {
        int size = this.expressList.size();
        if (size != 0) {
            this.btnPre.setEnabled(true);
            this.btnNext.setEnabled(true);
            this.historyExpressIndex = down ? ++this.historyExpressIndex : --this.historyExpressIndex;
            if (this.historyExpressIndex < 0) {
                this.historyExpressIndex = -1;
                this.btnNext.setEnabled(false);
            } else if (this.historyExpressIndex >= size) {
                this.historyExpressIndex = size - 1;
                this.btnPre.setEnabled(false);
            }
            if (this.historyExpressIndex == -1) {
                this.clear();
            } else {
                ExpressStatus es = (ExpressStatus)this.expressList.get(this.historyExpressIndex);
                this.jtInput.setText(es.express);
                this.jtOutput.setText(es.msg);
                this.ckDebug.setSelected(es.isDebug);
                this.jtInput.setCaretPosition(0);
                this.jtOutput.setCaretPosition(0);
                this.jtInput.selectAll();
            }
        }
    }

    public void addCalculatorListener(ICalculateListener l) {
        this.listenerList.add(ICalculateListener.class, l);
    }

    public void removeCalculatorListener(ICalculateListener l) {
        this.listenerList.remove(ICalculateListener.class, l);
    }

    private void fireValueReturn() {
        Object[] listeners = this.listenerList.getListenerList();
        String value = "0";
        if (this.expressList.size() > this.historyExpressIndex && this.historyExpressIndex >= 0) {
            ExpressStatus es = (ExpressStatus)this.expressList.get(this.historyExpressIndex);
            value = String.valueOf(es.value);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ICalculateListener.class) continue;
            ((ICalculateListener)listeners[i + 1]).calculated(value);
        }
    }

    private void returnValue() {
        this.fireValueReturn();
        this.dispose();
    }

    class ExpressStatus {
        String express;
        double value = 0.0;
        String msg;
        boolean isDebug;

        ExpressStatus() {
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExpressStatus) {
                return this.express.equals(((ExpressStatus)obj).express);
            }
            return false;
        }
    }
}

