/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.calc;

import com.kingdee.eas.common.calc.CalcResource;
import com.kingdee.eas.common.calc.CalculatorPanel;
import com.kingdee.eas.common.calc.ICalculatorActionListener;
import com.kingdee.eas.common.calc.IllegalExpressException;
import com.kingdee.eas.common.calc.express.ExpressAnalyzer;
import com.kingdee.eas.common.client.SysContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class CalculatorDialog
extends Dialog
implements ICalculatorActionListener {
    public static final int DEFALULT_DECIMAL_DIGITS = 2;
    protected List calcActionListenerList = new ArrayList();
    private CalculatorPanel cp = null;
    private boolean validate;

    public CalculatorDialog(Container parent) {
        this(parent, true);
    }

    public CalculatorDialog(Container parent, boolean modal) {
        super(CalculatorDialog.searchFrame(parent), modal);
        CalcResource.setLocale(SysContext.getSysContext().getLocale());
        this.setTitle(CalcResource.getRes("kingdee_calc"));
        this.addComponentListener(null);
        this.enableEvents(64L);
        this.cp = new CalculatorPanel(this, this);
        Dimension dd = this.getToolkit().getScreenSize();
        this.setLayout(new BorderLayout());
        int w = 298;
        int h = 228;
        this.setBounds((dd.width - 298) / 2, (dd.height - 228) / 2, 298, 228);
        this.add((Component)((Object)this.cp), "Center");
        this.setResizable(false);
        this.setModal(true);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        } else {
            super.processWindowEvent(e);
        }
    }

    public void addCalculatorActionListener(ICalculatorActionListener l) {
        this.calcActionListenerList.add(l);
    }

    public boolean removeCalculatorActionListener(ICalculatorActionListener l) {
        return this.calcActionListenerList.remove(l);
    }

    public void reset() {
        this.cp.sendCommand("C");
    }

    public void setInitValue(BigDecimal value) {
        this.reset();
        if (value != null) {
            char[] chs = value.toString().toCharArray();
            for (int i = 0; i < chs.length; ++i) {
                this.cp.sendCommand(String.valueOf(chs[i]));
            }
        }
    }

    public void inputAsNew() {
        this.cp.sendCommand("INPUTASNEW");
    }

    public BigDecimal showDialog() {
        return this.showDialog(2, false);
    }

    public BigDecimal showDialog(int precision, boolean enableChange) {
        this.validate = true;
        this.cp.setPrecision(precision, enableChange);
        this.setVisible(true);
        return this.getReturnValue();
    }

    public void showUnModalDialog(int precision, boolean enableChange) {
        this.validate = true;
        this.cp.setPrecision(precision, enableChange);
        this.setVisible(true);
    }

    public BigDecimal getReturnValue() {
        if (this.validate) {
            return new BigDecimal(this.cp.getExpressValue());
        }
        return null;
    }

    @Override
    public void ok() {
        this.validate = true;
        int n = this.calcActionListenerList.size();
        for (int i = 0; i < n; ++i) {
            ((ICalculatorActionListener)this.calcActionListenerList.get(i)).ok();
        }
        this.close();
    }

    @Override
    public void cancel() {
        this.validate = false;
        int n = this.calcActionListenerList.size();
        for (int i = 0; i < n; ++i) {
            ((ICalculatorActionListener)this.calcActionListenerList.get(i)).cancel();
        }
        this.close();
    }

    private void close() {
        this.dispose();
    }

    private static Frame searchFrame(Container parent) {
        while (parent != null && !(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        return (Frame)parent;
    }

    public static double calculate(String express) throws IllegalExpressException {
        return new ExpressAnalyzer().calculate(express);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final JFrame f = new JFrame();
        CalculatorDialog dlg = new CalculatorDialog((Container)f);
        dlg.addCalculatorActionListener(new ICalculatorActionListener(){

            @Override
            public void ok() {
                f.dispose();
            }

            @Override
            public void cancel() {
                f.dispose();
            }
        });
        dlg.show();
    }
}

