/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipTaskFactory;
import com.kingdee.eas.csinterface.agent.EipTaskInfo;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.agent.IEipTask;
import com.kingdee.eas.csinterface.agent.TaskStatus;
import com.kingdee.eas.csinterface.agent.app.AbstractTaskManagerControllerBean;
import com.kingdee.eas.csinterface.agent.base.ResultInfo;
import com.kingdee.eas.csinterface.agent.task.EipTaskManager;
import com.kingdee.eas.csinterface.agent.task.TaskAction;
import com.kingdee.eas.csinterface.agent.task.TaskReportHandler;
import com.kingdee.eas.csinterface.agent.task.TaskType;
import com.kingdee.eas.csinterface.schedule.ScheduleInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class TaskManagerControllerBean
extends AbstractTaskManagerControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.agent.app.TaskManagerControllerBean");

    @Override
    protected void _orderTask(Context ctx, String taskID, TaskType taskType, TaskAction taskAction, String param, String taskDes, EipUserInfo executor, ScheduleInfo scheduleInfo) throws BOSException, EASBizException {
        IEipTask eipTask = EipTaskFactory.getLocalInstance(ctx);
        EipTaskInfo eipTaskInfo = null;
        try {
            eipTaskInfo = eipTask.getEipTaskInfo("where number = '" + taskID + "'");
        }
        catch (Exception exception) {
            // empty catch block
        }
        long now = new Date().getTime();
        Timestamp nowTimestamp = new Timestamp(now);
        boolean isNewTask = false;
        if (eipTaskInfo == null) {
            eipTaskInfo = new EipTaskInfo();
            eipTaskInfo.setNumber(taskID);
            isNewTask = true;
        } else {
            eipTaskInfo.setReceiveCount(0);
            eipTaskInfo.setReturnResultTime(null);
            eipTaskInfo.setResult(null);
        }
        if (!StringUtils.isEmpty((String)taskDes) && taskDes.length() > 255) {
            taskDes = taskDes.substring(0, 254) + "\u2026";
        }
        eipTaskInfo.setStatus(TaskStatus.assigned);
        eipTaskInfo.setDescription(taskDes);
        eipTaskInfo.setOrderTime(nowTimestamp);
        eipTaskInfo.setName(taskType.typeName + " - " + taskAction.actionName);
        eipTaskInfo.setType(taskType.type);
        eipTaskInfo.setAction(taskAction.action);
        eipTaskInfo.setParams(param);
        eipTaskInfo.setExecutor(executor);
        eipTaskInfo.setSchedule(scheduleInfo);
        if (isNewTask) {
            eipTask.addnew((CoreBaseInfo)eipTaskInfo);
        } else {
            eipTask.update(CommonUtil.convert2PK(eipTaskInfo.getId().toString()), (CoreBaseInfo)eipTaskInfo);
        }
    }

    @Override
    protected IObjectCollection _receiveTask(Context ctx, String userID) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("executor", (Object)(StringUtils.isEmpty((String)userID) ? ctx.getCaller().toString() : userID)));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"assigned"));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)TaskType.BASEDATASYN, CompareType.NOTEQUALS));
        viewInfo.getSelector().add("number");
        viewInfo.getSelector().add("type");
        viewInfo.getSelector().add("action");
        viewInfo.getSelector().add("params");
        viewInfo.getSelector().add("lastUpdateTime");
        viewInfo.getSelector().add("depend");
        viewInfo.getSelector().add("orderTime");
        try {
            viewInfo.setSorter(new SorterItemCollection("orderTime asc"));
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        IEipTask eipTask = EipTaskFactory.getLocalInstance(ctx);
        CoreBaseCollection taskCollection = eipTask.getCollection(viewInfo);
        if (taskCollection.size() > 0) {
            for (int i = 0; i < taskCollection.size(); ++i) {
                EipTaskInfo eipTaskInfo = (EipTaskInfo)taskCollection.getObject(i);
                eipTaskInfo.setReceiveCount(eipTaskInfo.getReceiveCount() + 1);
                eipTaskInfo.setLastReceiveTime(new Timestamp(new Date().getTime()));
                eipTask.update(CommonUtil.convert2PK(eipTaskInfo.getId().toString()), (CoreBaseInfo)eipTaskInfo);
            }
        }
        return taskCollection;
    }

    @Override
    protected ResultInfo _reportTask(Context ctx, String taskID, long taskVersion, String status, String result) throws BOSException, EASBizException {
        EipTaskInfo taskInfo = (EipTaskInfo)EipTaskFactory.getLocalInstance(ctx).getDataBaseInfo("where number='" + taskID + "'");
        if (taskInfo == null) {
            return ResultInfo.STATUS_TASK_NOT_EXIST;
        }
        if (taskVersion < taskInfo.getOrderTime().getTime()) {
            return ResultInfo.STATUS_TASK_EXPIRED;
        }
        TaskStatus taskStatus = TaskStatus.getEnum(status);
        if (taskStatus == null) {
            return new ResultInfo(ResultInfo.STATUS_ERROR.getStatus(), "'" + status + "' can't be convert to TaskStatus!");
        }
        TaskReportHandler.handleReport(ctx, taskInfo, taskVersion, taskStatus, result);
        taskInfo.setStatus(taskStatus);
        taskInfo.setResult(result);
        taskInfo.setReturnResultTime(new Timestamp(new Date().getTime()));
        EipTaskFactory.getLocalInstance(ctx).update(CommonUtil.convert2PK(taskInfo.getId().toString()), (CoreBaseInfo)taskInfo);
        return ResultInfo.STATUS_SUCCESS;
    }

    @Override
    protected EipTaskInfo _getTask(Context ctx, String type, String action, String objectId) throws BOSException, EASBizException {
        String taskId = EipTaskManager.generateTaskID(type, action, objectId);
        return (EipTaskInfo)EipTaskFactory.getLocalInstance(ctx).getValue("where number = '" + taskId + "'");
    }

    @Override
    protected IObjectCollection _receiveBaseDataTask(Context ctx, String userId, TaskType taskType) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("executor", (Object)(StringUtils.isEmpty((String)userId) ? ctx.getCaller().toString() : userId)));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"assigned"));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)taskType.type));
        viewInfo.getSelector().add("number");
        viewInfo.getSelector().add("type");
        viewInfo.getSelector().add("action");
        viewInfo.getSelector().add("params");
        viewInfo.getSelector().add("lastUpdateTime");
        viewInfo.getSelector().add("depend");
        viewInfo.getSelector().add("orderTime");
        try {
            viewInfo.setSorter(new SorterItemCollection("orderTime asc"));
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        IEipTask eipTask = EipTaskFactory.getLocalInstance(ctx);
        CoreBaseCollection taskCollection = eipTask.getCollection(viewInfo);
        if (taskCollection.size() > 0) {
            for (int i = 0; i < taskCollection.size(); ++i) {
                EipTaskInfo eipTaskInfo = (EipTaskInfo)taskCollection.getObject(i);
                eipTaskInfo.setReceiveCount(eipTaskInfo.getReceiveCount() + 1);
                eipTaskInfo.setLastReceiveTime(new Timestamp(new Date().getTime()));
                eipTask.update(CommonUtil.convert2PK(eipTaskInfo.getId().toString()), (CoreBaseInfo)eipTaskInfo);
            }
        }
        return taskCollection;
    }
}

