/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.base.util;

import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicBitSet {
    private final AtomicIntegerArray array;

    public AtomicBitSet(int length) {
        int intLength = (length + 31) / 32;
        this.array = new AtomicIntegerArray(intLength);
    }

    public void set(long n) {
        int num2;
        int num;
        int bit = 1 << (int)n;
        int idx = (int)(n >>> 5);
        while ((num = this.array.get(idx)) != (num2 = num | bit) && !this.array.compareAndSet(idx, num, num2)) {
        }
    }

    public boolean get(long n) {
        int bit = 1 << (int)n;
        int idx = (int)(n >>> 5);
        int num = this.array.get(idx);
        return (num & bit) != 0;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.array.length(); ++i) {
            if (this.array.get(i) <= 0) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        AtomicBitSet bs = new AtomicBitSet(1);
        System.out.println(bs.isEmpty());
        bs.set(0L);
        bs.set(1L);
        bs.set(5L);
        bs.set(5L);
        System.out.println(bs.isEmpty());
        for (int i = 0; i < 32; ++i) {
            System.out.println(i + ":" + bs.get(i));
        }
    }
}

