/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.base.util;

import com.kingdee.bos.util.md5;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5 {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private MessageDigest md;

    public MD5() {
        try {
            this.md = MessageDigest.getInstance(System.getProperty("MD5.algorithm", "MD5"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public final void update(byte[] input) {
        this.md.update(input);
    }

    public final String getDigestResult() {
        return MD5.bytesToHex(this.md.digest());
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            int t = bytes[i];
            if (t < 0) {
                t += 256;
            }
            sb.append(hexDigits[t >>> 4]);
            sb.append(hexDigits[t % 16]);
        }
        return sb.toString();
    }

    public static String code(String input) throws Exception {
        return MD5.code(input.getBytes("utf-8"));
    }

    public static String code(byte[] bytes) throws Exception {
        return MD5.code(bytes, 32);
    }

    public static String code(byte[] bytes, int bit) throws Exception {
        MessageDigest md = MessageDigest.getInstance(System.getProperty("MD5.algorithm", "MD5"));
        if (bit == 16) {
            return MD5.bytesToHex(md.digest(bytes)).substring(8, 24);
        }
        return MD5.bytesToHex(md.digest(bytes));
    }

    public static void main(String[] args) throws Exception {
        System.out.println(MD5.code("123456789"));
        md5 m = new md5("");
        m.processString();
        System.out.println(m.getStringDigest());
    }
}

