/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.process.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.DataRow;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.process.DataFilter;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.SQLType;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTypeMapInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapEntryCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapEntryFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapEntryInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.ScriptUtil;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class BaseDataSynConvertFilter
implements DataFilter {
    private static final Logger logger = Logger.getLogger(BaseDataSynConvertFilter.class);
    private Context ctx;
    private StructuredDataModel dataModel;
    private Map<String, Map<Object, Object>> transCache = new HashMap<String, Map<Object, Object>>();

    public BaseDataSynConvertFilter(Context ctx, StructuredDataModel dataModel) {
        this.ctx = ctx;
        this.dataModel = dataModel;
    }

    @Override
    public void doFilter(List<DataRow> data) throws Exception {
        if (data == null || data.isEmpty()) {
            return;
        }
        Object[] headBaseDataTypes = this.dataModel.getPriorityTables()[0].baseDataTypes;
        Object[] entryBaseDataTypes = this.dataModel.getPriorityTables()[1].baseDataTypes;
        ColumnModel[] models = (ColumnModel[])ArrayUtils.addAll((Object[])headBaseDataTypes, (Object[])entryBaseDataTypes);
        this.doFilterWithColumnModel(models, data);
        ColumnModel[] all = (ColumnModel[])ArrayUtils.addAll((Object[])this.dataModel.getPriorityTables()[1].columns, (Object[])this.dataModel.getPriorityTables()[2].columns);
        this.applyDefaultValue(all, data);
        this.applyTransRule(all, data);
    }

    private void doFilterWithColumnModel(ColumnModel[] models, List<DataRow> data) throws BOSException {
        if (models == null || models.length <= 0) {
            return;
        }
        Map<String, Map<String, String>> valueMapCache = this.initDataMapByModel(models, data);
        for (ColumnModel model : models) {
            String columnName = model.name;
            Map<String, String> valueMap = valueMapCache.get(columnName);
            for (DataRow row : data) {
                Map fileds = row.getValues();
                Object oldValue = fileds.get(columnName);
                String newValue = valueMap.get(oldValue);
                if (newValue == null) continue;
                fileds.put(columnName, newValue);
            }
        }
    }

    private Map<String, Map<String, String>> initDataMapByModel(ColumnModel[] columnModel, List<DataRow> data) throws BOSException {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (columnModel == null || columnModel.length <= 0) {
            return result;
        }
        if (data == null || data.isEmpty()) {
            return result;
        }
        for (ColumnModel model : columnModel) {
            String columnName = model.name;
            BaseDataSynTypeMapInfo info = (BaseDataSynTypeMapInfo)model.baseDataType;
            Set<String> srcIds = this.getSrcValueSetByColumn(columnName, data);
            Map<String, String> map = this.getSrcIDToDestIdMapCache(srcIds, info);
            result.put(columnName, map);
        }
        return result;
    }

    private Set<String> getSrcValueSetByColumn(String columnName, List<DataRow> data) {
        HashSet<String> result = new HashSet<String>();
        for (DataRow row : data) {
            Map values = row.getValues();
            if (values == null) continue;
            Object value = values.get(columnName);
            result.add((String)value);
        }
        return result;
    }

    public ICoreBase getCoreBaseInstance(Context ctx, BaseDataSynTypeMapInfo baseDataSynTypeMap) throws BOSException {
        BaseDataInfo baseData = baseDataSynTypeMap.getSrcBaseData();
        if (null == baseData) {
            String errerMsg = "\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6620\u5c04 [id=" + baseDataSynTypeMap.getId() + ",number=" + baseDataSynTypeMap.getNumber() + ",name=" + baseDataSynTypeMap.getName() + "]\u672a\u914d\u7f6e\u201c\u57fa\u7840\u8d44\u6599\u201d";
            logger.error((Object)errerMsg);
            throw new BOSException(errerMsg);
        }
        String queryName = baseData.getQueryName();
        if (StringUtils.isEmpty((String)queryName)) {
            String errerMsg = "Query [" + queryName + "]\u4e0d\u5b58\u5728";
            System.out.println(errerMsg);
            throw new BOSException(errerMsg);
        }
        ICoreBase instance = CommonUtil.getCoreBaseInstanceByQueryName(ctx, queryName);
        return instance;
    }

    private Map<String, String> getSrcIDToDestIdMapCache(Set<String> srcIds, BaseDataSynTypeMapInfo info) throws BOSException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (srcIds == null || srcIds.isEmpty() || info == null) {
            return resultMap;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        ev.setFilter(filterInfo);
        FilterItemCollection items = filterInfo.getFilterItems();
        items.add(new FilterItemInfo("baseDataType.id", (Object)info.getId().toString(), CompareType.EQUALS));
        BaseDataSynValueMapCollection mapInfoColl = BaseDataSynValueMapFactory.getLocalInstance(this.ctx).getBaseDataSynValueMapCollection(ev);
        if (mapInfoColl.isEmpty()) {
            logger.error((Object)("\u83b7\u53d6\u57fa\u7840\u8d44\u6599\u503c\u5f02\u5e38\uff0c\u8868\uff1aT_SYN_BaseDataSynValueMap ,baseDataType.id=" + info.getId().toString()));
        }
        BaseDataSynValueMapInfo mapInfoTmp = mapInfoColl.get(0);
        items.clear();
        items.add(new FilterItemInfo("srcID", srcIds, CompareType.INCLUDE));
        items.add(new FilterItemInfo("parent.id", (Object)mapInfoTmp.getId().toString(), CompareType.EQUALS));
        BaseDataSynValueMapEntryCollection coll = BaseDataSynValueMapEntryFactory.getLocalInstance(this.ctx).getBaseDataSynValueMapEntryCollection(ev);
        for (int i = 0; i < coll.size(); ++i) {
            BaseDataSynValueMapEntryInfo mapInfo = coll.get(i);
            resultMap.put(mapInfo.getSrcID(), mapInfo.getDestID());
        }
        return resultMap;
    }

    private void applyDefaultValue(ColumnModel[] allColumn, List<DataRow> data) {
        if (allColumn == null || allColumn.length <= 0) {
            return;
        }
        String colName = null;
        String destName = null;
        for (ColumnModel model : allColumn) {
            colName = model.name;
            destName = model.destName;
            if (StringUtils.equalsIgnoreCase((String)colName, (String)destName) || !"FID".equalsIgnoreCase(colName)) continue;
            for (DataRow row : data) {
                Map values = row.getValues();
                if (values == null) continue;
                values.put(destName, values.get(colName));
            }
        }
        for (ColumnModel model : allColumn) {
            String columnName = model.name;
            if (model.defaultValue == null) continue;
            String realName = columnName;
            if (StringUtils.isEmpty((String)realName)) {
                realName = model.destName;
            }
            Object o = model.defaultValue;
            if (SQLType.DATETIME.equals(model.destSqlType) || SQLType.TIMESTAMP.equals(model.destSqlType)) {
                SimpleDateFormat sdf = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy", Locale.US);
                Date date = null;
                try {
                    date = sdf.parse(model.defaultValue.toString());
                    o = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss.SSS");
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            for (DataRow row : data) {
                Map values = row.getValues();
                if (values == null) continue;
                values.put(realName, o);
            }
        }
    }

    private void applyTransRule(ColumnModel[] allColumn, List<DataRow> data) {
        if (allColumn == null || allColumn.length <= 0) {
            return;
        }
        for (ColumnModel model : allColumn) {
            String columnName = model.name;
            if (model.transRule == null) continue;
            String realName = columnName;
            if (StringUtils.isEmpty((String)realName)) {
                realName = model.destName;
            }
            for (DataRow row : data) {
                Map values = row.getValues();
                if (values == null) continue;
                Object o = this.transValue(realName, values.get(realName), model.transRule);
                if (SQLType.DATETIME.equals(model.destSqlType) || SQLType.TIMESTAMP.equals(model.destSqlType)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy", Locale.US);
                    Date date = null;
                    try {
                        date = sdf.parse(model.defaultValue.toString());
                        o = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss.SSS");
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                values.put(realName, o);
            }
        }
    }

    private Object transValue(String columnName, Object oldVal, String rule) {
        Map<Object, Object> cache;
        if (StringUtils.isEmpty((String)rule)) {
            return oldVal;
        }
        rule = rule.trim();
        boolean isIdentical = false;
        if (rule.startsWith("[") && rule.endsWith("]")) {
            isIdentical = true;
            rule = rule.substring(1, rule.length() - 1);
        }
        if (isIdentical && (cache = this.transCache.get(columnName)) != null && cache.containsKey(oldVal)) {
            return cache.get(oldVal);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ctx", this.ctx);
        map.put("old", oldVal);
        Object newVal = ScriptUtil.evalExpr((String)rule, map);
        if (isIdentical) {
            Map<Object, Object> cache2;
            if (this.transCache.containsKey(columnName)) {
                // empty if block
            }
            if ((cache2 = this.transCache.get(columnName)) == null) {
                cache2 = new HashMap<Object, Object>();
                this.transCache.put(columnName, cache2);
            }
            cache2.put(oldVal, newVal);
        }
        return newVal;
    }
}

