/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.csinterface.agent.service.work.basedata.provider.db.DBTransformUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class BaseDataBatchUpdateHelper {
    private static ThreadLocal<BaseDataBatchUpdateHelper> threadUpdateHelpers = new ThreadLocal();
    private String updateSQL;
    private List<String> columns;
    private String userInfoId;
    private Timestamp currentTime;
    private static final String headReservedFields = "FID, FControlUnitID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime";
    private static final int headReservedFieldsLen = 6;
    private static final String entryReservedFields = "FID, FSeq";
    private static final int entryReservedFieldsLen = 2;
    private String transmitSerialNumber;
    private int transmitChunkedNumber;
    private static final String insertChunkedTransmit = "insert into T_EIP_ChunkedTransmit(FTransmitSerialNumber, FTransmitChunkedNumber, FUserID, FCreateTime, FLastUpdateTime) values(?,?,?,?,?)";
    private static final String undateChunkedTransmit = "update T_EIP_ChunkedTransmit set FTransmitChunkedNumber=?, FLastUpdateTime=? where FTransmitSerialNumber=?";

    private BaseDataBatchUpdateHelper() {
    }

    public String getUpdateSql() {
        return this.updateSQL;
    }

    public void setParameters(List<String> columns, PreparedStatement preparedStratement, Map<String, Object> dataMap, Map<String, String> colTyleMap) throws SQLException, BOSException, Exception {
        String columnName = "";
        String colType = "";
        int index = 1;
        for (int i = 0; i < columns.size(); ++i) {
            columnName = columns.get(i);
            if (StringUtils.equalsIgnoreCase((String)columnName, (String)"fid")) continue;
            Object obj = dataMap.get(columnName);
            colType = colTyleMap.get(columnName.toUpperCase()).toUpperCase();
            DBTransformUtil.transform(preparedStratement, index++, obj, colType);
        }
        Object fid = dataMap.get("FID");
        if (fid == null) {
            fid = dataMap.get("fid");
        }
        preparedStratement.setObject(columns.size(), fid);
    }

    public void setParameters(String[] columns, PreparedStatement stmt, JSONArray data, JSONObject colType, String mainPK) {
        String columnName = "";
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            columnName = columns[i];
            Object obj = i + 1 != length ? data.get(i + 1) : data.get(0);
            try {
                String sscolType = colType.get((Object)columnName.toUpperCase()).toString().toUpperCase();
                DBTransformUtil.transform(stmt, i + 1, obj, sscolType);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                StringBuffer errorInfo = new StringBuffer();
                String columnStr = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.arrayToString(columns, ",");
                String objStr = data.toString();
                String coTypeStr = colType.toString();
                errorInfo.append(" \u5217\u540d\uff1a").append(columnStr).append(" \u6570\u636e\u503c\uff1a").append(objStr).append(" \u6570\u636e\u7c7b\u578b\u5bf9\u7167\u5173\u7cfb\uff1a").append(coTypeStr).append(" \u8f6c\u6362\u51fa\u9519\u7684\u5217\uff1a").append(columns[i]);
                Logger.error((Throwable)e, (String)errorInfo.toString());
                throw new RuntimeException("\u8fdb\u884c\u6570\u636e\u8f6c\u6362\u65f6\u51fa\u9519\uff1a" + e.getMessage() + " " + errorInfo.toString());
            }
        }
    }

    public static final BaseDataBatchUpdateHelper getInstance() {
        return threadUpdateHelpers.get();
    }

    private static Timestamp getTime() {
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static void setCurrentTransmitChunkedNumber(int transmitChunkedNumber) {
        BaseDataBatchUpdateHelper.threadUpdateHelpers.get().transmitChunkedNumber = transmitChunkedNumber;
    }

    public void updateTransmitChunked(Connection con) throws SQLException {
        if (!StringUtils.isEmpty((String)this.transmitSerialNumber)) {
            PreparedStatement undateChunkedTransmitStatement = con.prepareStatement(undateChunkedTransmit);
            try {
                undateChunkedTransmitStatement.setInt(1, this.transmitChunkedNumber);
                undateChunkedTransmitStatement.setDate(2, new Date(System.currentTimeMillis()));
                undateChunkedTransmitStatement.setString(3, this.transmitSerialNumber);
                undateChunkedTransmitStatement.executeUpdate();
            }
            finally {
                SQLUtils.cleanup((Statement)undateChunkedTransmitStatement);
            }
        }
    }

    public static final void prepare(String tableName, List<String> colNameList, String transmitSerialNumber) throws BOSException, SQLException {
        BaseDataBatchUpdateHelper updateHelper = new BaseDataBatchUpdateHelper();
        updateHelper.currentTime = BaseDataBatchUpdateHelper.getTime();
        updateHelper.columns = new ArrayList<String>();
        updateHelper.updateSQL = BaseDataBatchUpdateHelper.generateUpdateSql(updateHelper.columns, tableName, colNameList);
        threadUpdateHelpers.set(updateHelper);
    }

    public static final void prepare() {
        BaseDataBatchUpdateHelper updateHelper = new BaseDataBatchUpdateHelper();
        threadUpdateHelpers.set(updateHelper);
    }

    public static String generateUpdateSql(List<String> columns, String tableName, List<String> colNameList) {
        StringBuilder sqlBuffer = new StringBuilder();
        StringBuffer setBuffer = new StringBuffer();
        sqlBuffer.append("update ").append(tableName).append(" set ");
        for (int i = 0; i < colNameList.size(); ++i) {
            String colName = colNameList.get(i);
            if (StringUtils.equalsIgnoreCase((String)colName, (String)"FID")) continue;
            columns.add(colName);
            if (setBuffer.length() > 0) {
                setBuffer.append(" , ");
            }
            setBuffer.append(colName + " =? ");
        }
        setBuffer.append(" where FID = ? ");
        return sqlBuffer.append(setBuffer).toString();
    }
}

