/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.service.work.basedata.snapshot;

import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.csinterface.agent.service.base.util.MD5;
import com.kingdee.eas.csinterface.agent.service.base.util.PacketsUtil;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import org.apache.log4j.Logger;

public class ChangefulBillData {
    static final Logger logger = Logger.getLogger(ChangefulBillData.class);
    public static final String FIELD_PK = "pk";
    public static final String FIELD_HEADPK_IN_VIEW = "viewheadpk";
    public static final String FIELD_AS_HASHCODE = "pktablehashcode";
    public static final String FIELD_HASHCODE = "hashCode";
    public static final String FIELD_CHANGETIME = "changeTime";
    public static final String FIELD_CREATETIME = "createTime";
    public static final String FIELD_MAIN_HEADPK = "mainPK";
    private Object headpkOfPkTable;
    private Object headpkOfView;
    private String oldHashCode;
    private String newHashCode;
    private String[] sortedChangefulFields;
    private ByteArrayOutputStream changefulFieldBytes;
    private boolean initSnapshot;
    private boolean isOracle;
    private String oldChangeTime = "";
    private String newChangeTime = "";

    public ChangefulBillData(String[] sortedChangefulFields, boolean initSnapshot, boolean isOracle) {
        this.sortedChangefulFields = sortedChangefulFields;
        this.changefulFieldBytes = new ByteArrayOutputStream();
        this.initSnapshot = initSnapshot;
        this.isOracle = isOracle;
    }

    public static final String[] getSortedChangefulFields(StructuredDataModel dataModel) {
        StructuredDataModel.TableModel[] tableModels = dataModel.getTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        ArrayList<String> changefulFields = new ArrayList<String>();
        String tmpName = "";
        for (int i = 0; i < header.columns.length; ++i) {
            if (!header.columns[i].isChangeSyn || changefulFields.contains(tmpName = header.columns[i].name.toLowerCase())) continue;
            changefulFields.add(tmpName);
        }
        Object[] sortedChangefulFields = changefulFields.toArray(new String[0]);
        Arrays.sort((Object[])sortedChangefulFields);
        return sortedChangefulFields;
    }

    public static final String[] getSortedChangefulFields4BaseData(StructuredDataModel dataModel) {
        StructuredDataModel.TableModel[] tableModels = dataModel.getTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        ArrayList<String> changefulFields = new ArrayList<String>();
        String tmpName = "";
        for (int i = 0; i < header.columns.length; ++i) {
            if (!header.columns[i].isPkTime || StringUtils.isEmpty((String)header.columns[i].destName) || changefulFields.contains(tmpName = header.columns[i].name.toLowerCase())) continue;
            changefulFields.add(tmpName);
        }
        Object[] sortedChangefulFields = changefulFields.toArray(new String[0]);
        Arrays.sort((Object[])sortedChangefulFields);
        return sortedChangefulFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHashCodeColumnIfNeed(Connection connection, String pkTable) throws SQLException {
        boolean existHashCodeColumn = SQLUtil.existsColumn(connection, pkTable, FIELD_HASHCODE);
        if (!existHashCodeColumn) {
            ResultSet rs = null;
            Statement stm = null;
            try {
                stm = connection.createStatement();
                stm.executeUpdate("ALTER TABLE " + pkTable + " ADD " + FIELD_HASHCODE + " varchar(64)");
            }
            finally {
                SQLUtil.cleanup(rs, stm);
            }
        }
    }

    public void recordChangeTime(ResultSet rs) throws SQLException {
        Timestamp timestamp;
        Object object;
        String timeField = "flastupdatetime";
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.newChangeTime = this.isOracle ? ((object = rs.getObject(timeField)) != null ? fmt.format(object) : null) : ((timestamp = rs.getTimestamp(timeField)) != null ? fmt.format(timestamp) : null);
    }

    public void recordChangeTime(ResultSet rs, String tableName, boolean isMainTable) throws SQLException {
        try {
            this.recordChangeTime(rs);
        }
        catch (SQLException e) {
            throw new SQLException(isMainTable ? "\u4e3b\u8868\uff1a" : "\u4ece\u8868\uff1a" + tableName + "\uff0c\u7f3a\u5c11\u6700\u540e\u66f4\u65b0\u65f6\u95f4\u5b57\u6bb5flastupdatetime\u3002");
        }
    }

    public void appendFieldBytes(ResultSet rs) throws SQLException {
        boolean isOracle;
        if (!this.initSnapshot) {
            if (this.headpkOfView == null) {
                this.headpkOfView = rs.getObject(FIELD_HEADPK_IN_VIEW);
                if (this.headpkOfView == null) {
                    return;
                }
            }
            this.oldHashCode = rs.getString(FIELD_AS_HASHCODE);
        }
        if (isOracle = this.isOracle) {
            Object obj = null;
            String str = "";
            ResultSetMetaData metaData = null;
            for (int i = 0; i < this.sortedChangefulFields.length; ++i) {
                byte[] fieldBytes;
                int rsRow;
                metaData = rs.getMetaData();
                String dataType = metaData.getColumnTypeName(rsRow = rs.findColumn(this.sortedChangefulFields[i]));
                if (dataType.equalsIgnoreCase("NCLOB") || dataType.equalsIgnoreCase("CLOB")) {
                    obj = rs.getObject(this.sortedChangefulFields[i]);
                    if (obj != null) {
                        CLOB c = (CLOB)obj;
                        str = c.getSubString(1L, (int)c.length());
                    }
                    fieldBytes = str.getBytes();
                } else if (dataType.equalsIgnoreCase("BLOB")) {
                    obj = rs.getObject(this.sortedChangefulFields[i]);
                    if (obj != null) {
                        BLOB b = (BLOB)obj;
                        str = new String(b.getBytes(1L, (int)b.length()));
                    }
                    fieldBytes = str.getBytes();
                } else {
                    fieldBytes = rs.getBytes(this.sortedChangefulFields[i]);
                }
                try {
                    if (fieldBytes == null) {
                        PacketsUtil.writeInt(this.changefulFieldBytes, 0);
                        continue;
                    }
                    PacketsUtil.writeInt(this.changefulFieldBytes, fieldBytes.length);
                    this.changefulFieldBytes.write(fieldBytes);
                    continue;
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        } else {
            Object fieldObject = null;
            try {
                ObjectOutputStream rowOutputStream = new ObjectOutputStream(this.changefulFieldBytes);
                for (int i = 0; i < this.sortedChangefulFields.length; ++i) {
                    fieldObject = rs.getObject(this.sortedChangefulFields[i]);
                    if (fieldObject == null) {
                        rowOutputStream.writeInt(0);
                        continue;
                    }
                    rowOutputStream.writeObject(fieldObject);
                }
                rowOutputStream.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void appendFieldBytes4MainTable(ResultSet rs) throws SQLException {
    }

    public void snapshot() {
        byte[] bytes = this.changefulFieldBytes.toByteArray();
        if (bytes != null && bytes.length > 0) {
            try {
                this.newHashCode = MD5.code(bytes);
                this.changefulFieldBytes.reset();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public void snapshot4MainTable() {
        byte[] bytes = this.changefulFieldBytes.toByteArray();
        if (bytes != null && bytes.length > 0) {
            try {
                this.newHashCode = MD5.code(bytes);
                this.changefulFieldBytes.reset();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        this.newChangeTime = this.newChangeTime;
    }

    public boolean isNewHash() {
        return this.headpkOfView != null && this.oldHashCode == null;
    }

    public boolean isUpdate() {
        return !this.isNewHash() && this.newHashCode != null && !this.newHashCode.equals(this.oldHashCode);
    }

    public boolean isDelete() {
        return this.headpkOfView == null;
    }

    public Object getHeadpkOfPkTable() {
        return this.headpkOfPkTable;
    }

    public Object getHeadpkOfView() {
        return this.headpkOfView;
    }

    public String getOldHashCode() {
        return this.oldHashCode;
    }

    public String getNewHashCode() {
        return this.newHashCode;
    }

    public String getOldChangeTime() {
        return this.oldChangeTime;
    }

    public String getNewChangeTime() {
        return this.newChangeTime;
    }
}

