/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet.processor;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.csinterface.agent.base.ResultInfo;
import com.kingdee.eas.csinterface.agent.servlet.RequestProcessor;
import com.kingdee.eas.csinterface.billmapping.BillMappingCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingHelper;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.DataProcessType;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class MidBillServlet
extends RequestProcessor {
    @Override
    public String getTargetURI() {
        return "/midbill";
    }

    @Override
    public String process(Map<String, String> params, String reqBody) throws Exception {
        return null;
    }

    public String query(Map<String, String> params, String reqBody) throws Exception {
        EntityViewInfo viewInfo = this.baseFilter();
        BillMappingCollection billMappingCol = BillMappingFactory.getLocalInstance(this.ctx).getBillMappingCollection(viewInfo);
        LinkedList billBaseInfoList = new LinkedList();
        Iterator itr = billMappingCol.iterator();
        while (itr.hasNext()) {
            BillMappingInfo billMappingInfo = (BillMappingInfo)itr.next();
            HashMap<String, String> billBaseInfoJSON = new HashMap<String, String>();
            billBaseInfoJSON.put("id", billMappingInfo.getId().toString());
            billBaseInfoJSON.put("number", billMappingInfo.getNumber());
            billBaseInfoJSON.put("name", billMappingInfo.getBillMappingName());
            billBaseInfoJSON.put("srcViewName", billMappingInfo.getSrcViewName());
            billBaseInfoJSON.put("pkTableName", "\u672a\u751f\u6210\u589e\u91cf\u8868".equals(billMappingInfo.getPkTableName()) ? BillMappingHelper.calc2PkTableName(billMappingInfo.getId().toString()) : billMappingInfo.getPkTableName());
            billBaseInfoList.add(billBaseInfoJSON);
        }
        ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
        resultInfo.setData(billBaseInfoList);
        return new JSONObject(resultInfo).toString();
    }

    private EntityViewInfo baseFilter() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("agentUser.id", (Object)this.ctx.get((Object)"agentId").toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("published", (Object)true, CompareType.EQUALS));
        return viewInfo;
    }

    public String define(Map<String, String> params, String reqBody) throws Exception {
        String number = params.get("number");
        if (StringUtils.isEmpty((String)number)) {
            throw new Exception("\u53c2\u6570'" + number + "'\u4e3a\u7a7a!");
        }
        number = number.replace("'", "''");
        EntityViewInfo viewInfo = this.baseFilter();
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        BillMappingCollection mappingCol = BillMappingFactory.getLocalInstance(this.ctx).getBillMappingCollection(viewInfo);
        if (mappingCol == null || mappingCol.size() == 0) {
            ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_OBJECT_NOT_FOUND.clone();
            resultInfo.setStatusMsg("\u627e\u4e0d\u5230number=[" + number + "]\u5bf9\u5e94\u7684\u5355\u636e\u6620\u5c04 \u6216 \u8be5\u5355\u636e\u5c1a\u672a\u53d1\u5e03.");
            return new JSONObject(resultInfo).toString();
        }
        BillMappingInfo mappingInfo = mappingCol.get(0);
        HashMap<String, Object> mappingJson = new HashMap<String, Object>();
        mappingJson.put("srcWhere", mappingInfo.getSrcWhere() == null ? "" : mappingInfo.getSrcWhere());
        mappingJson.put("srcViewName", mappingInfo.getSrcViewName());
        mappingJson.put("number", mappingInfo.getNumber());
        mappingJson.put("pkTableName", "\u672a\u751f\u6210\u589e\u91cf\u8868".equals(mappingInfo.getPkTableName()) ? BillMappingHelper.calc2PkTableName(mappingInfo.getId().toString()) : mappingInfo.getPkTableName());
        mappingJson.put("billAlias", mappingInfo.getBillMappingName());
        mappingJson.put("version", mappingInfo.getLastUpdateTime().getTime());
        mappingJson.put("needResetSnapshot", mappingInfo.isNeedResetSnapshot());
        mappingJson.put("notCheckBaseData", mappingInfo.isNotCheckBaseData());
        DataProcessType dataProcessType = mappingInfo.getDataProcessType();
        mappingJson.put("dataProcessType", dataProcessType == null ? null : dataProcessType.getValue());
        BillMappingEntryCollection mappingEntryCol = mappingInfo.getEntrys();
        ArrayList entryList = new ArrayList();
        Iterator itr = mappingEntryCol.iterator();
        while (itr.hasNext()) {
            BillMappingEntryInfo mappingEntry = (BillMappingEntryInfo)itr.next();
            if (mappingEntry.isDropped()) continue;
            HashMap<String, String> entryJson = new HashMap<String, String>();
            entryJson.put("fieldType", mappingEntry.isHead() ? "header" : "entry");
            entryJson.put("srcFieldName", mappingEntry.getSrcFieldName());
            entryJson.put("srcFieldDataType", mappingEntry.getSrcFieldDataType());
            entryJson.put("srcFieldAlias", mappingEntry.getSrcFieldAlias());
            entryJson.put("srcFieldDataPrecision", String.valueOf(mappingEntry.getSrcFieldDataPrecision()));
            entryJson.put("srcFieldDataScale", String.valueOf(mappingEntry.getSrcFieldDataScale()));
            entryJson.put("srcFieldDataLength", String.valueOf(mappingEntry.getSrcFieldDataLength()));
            entryJson.put("midFieldName", mappingEntry.getMidFieldName());
            entryJson.put("midFieldDataType", mappingEntry.getMidFieldDataType());
            entryJson.put("midFieldAlias", mappingEntry.getMidFieldAlias());
            entryJson.put("midFieldDataPrecision", String.valueOf(mappingEntry.getMidFieldDataPrecision()));
            entryJson.put("midFieldDataScale", String.valueOf(mappingEntry.getMidFieldDataScale()));
            entryJson.put("midFieldDataLength", String.valueOf(mappingEntry.getMidFieldDataLength()));
            entryJson.put("changeful", String.valueOf(mappingEntry.isChangeful()));
            entryList.add(entryJson);
        }
        mappingJson.put("entrys", entryList);
        ResultInfo resultInfo = (ResultInfo)ResultInfo.STATUS_SUCCESS.clone();
        resultInfo.setData(mappingJson);
        return new JSONObject(resultInfo).toString();
    }
}

