/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.servlet.processor;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.bos.webservice.WSConfig;
import com.kingdee.eas.csinterface.agent.service.base.util.AES;
import com.kingdee.eas.csinterface.agent.servlet.RequestProcessor;
import com.kingdee.eas.csinterface.base.cache.SessionUtil;
import com.kingdee.eas.csinterface.webservice.app.constant.WSConstant;
import com.kingdee.eas.csinterface.webservice.app.util.ReturnDataService;
import com.kingdee.eas.csinterface.webservice.framework.Return;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WebAPILoginServlet
extends RequestProcessor {
    private static final Logger logger = Logger.getLogger(WebAPILoginServlet.class);
    public static boolean ALL_HASH_UPDATE = false;

    @Override
    public String getTargetURI() {
        return "/webAPI/login";
    }

    public static String getSessionId(String token) {
        if (!StringUtils.isEmpty((CharSequence)token)) {
            try {
                token = token.replaceAll(" ", "+");
                token = token.replaceAll("%2B", "+");
                token = token.replaceAll("%2F", "/");
                return AES.decryptToString(token, WSConstant.getEntryKey(null));
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public static String getToken(String sessionId) {
        String token = null;
        try {
            token = AES.encryptToString(sessionId, WSConstant.getEntryKey(null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return token;
    }

    @Override
    public String process(Map<String, String> params, String reqContent) throws Exception {
        String userName = null;
        String password = null;
        String dcName = null;
        String language = null;
        String slnName = "eas";
        String userAuthPattern = null;
        JSONObject requestParam = JSONObject.parseObject((String)reqContent);
        if (requestParam == null) {
            userName = params.get("user");
            password = params.get("password");
            dcName = params.get("dcName");
            language = params.get("language");
            userAuthPattern = params.get("auth");
        } else {
            userName = requestParam.getString("user");
            password = requestParam.getString("password");
            dcName = requestParam.getString("dcName");
            language = requestParam.getString("language");
            userAuthPattern = requestParam.getString("auth");
        }
        String token = SessionUtil.getTokenId(userName, password, dcName, language, slnName, userAuthPattern);
        String result = ReturnDataService.format(Return.valueOf("", token, 0));
        return result;
    }

    public static String loginError() {
        return ReturnDataService.format(Return.valueOf("\u767b\u9646\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u767b\u9646", "", 1001));
    }

    public static String reLogin() {
        return ReturnDataService.format(Return.valueOf(1000, "\u8bf7\u91cd\u65b0\u767b\u9646", null));
    }

    private ILoginModule getLoginModule(String url) throws BOSException {
        if (WSConfig.getRomoteLocate() == null || WSConfig.getRomoteLocate().equals("true")) {
            return LoginModuleFactory.getRemoteInstance((String)url);
        }
        return LoginModuleFactory.getLocalInstance(null);
    }

    private String encodePassword(String userName, String password) throws BOSException {
        String encodedPassword = "";
        try {
            encodedPassword = CryptoTean.encrypt((String)userName, (String)password);
        }
        catch (CryptException e) {
            logger.error((Object)e);
        }
        if (com.kingdee.util.StringUtils.isEmpty((String)encodedPassword)) {
            throw new BOSException("\u52a0\u5bc6\u5bc6\u7801\u5931\u8d25\uff01\u5bc6\u7801\u4e0d\u80fd\u8bbe\u5b9a\u4e3a\u7a7a\u5b57\u7b26\u4e32\u3002");
        }
        return encodedPassword;
    }
}

