/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.agent.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.EipTaskInfo;
import com.kingdee.eas.csinterface.agent.TaskStatus;
import com.kingdee.eas.csinterface.agent.task.TaskAction;
import com.kingdee.eas.csinterface.agent.task.TaskType;
import com.kingdee.eas.csinterface.util.ClassUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class TaskReportHandler {
    private static Logger logger = Logger.getLogger(TaskReportHandler.class);
    private static List<TaskReportHandler> handlers;

    private static void initHanlders() {
        List<Class> classList;
        handlers = new ArrayList<TaskReportHandler>();
        try {
            classList = ClassUtil.findPackageClasses("com.kingdee.eas.csinterface.agent.task.handler");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Class cl : classList) {
            if (!TaskReportHandler.class.isAssignableFrom(cl)) continue;
            TaskReportHandler handler = (TaskReportHandler)ClassUtil.getNewInstance(cl);
            if (handler == null) {
                logger.error((Object)(cl.getName() + " newInstance fail!"));
                continue;
            }
            if (handler.getType() == null) {
                logger.error((Object)("type of '" + handler.getClass().getName() + "' is null! "));
                continue;
            }
            if (handler.getAction() == null) {
                logger.error((Object)("action of '" + handler.getClass().getName() + "' is null! "));
                continue;
            }
            handlers.add(handler);
        }
    }

    public static void handleReport(Context ctx, EipTaskInfo taskInfo, long taskVersion, TaskStatus taskStatus, String result) throws EASBizException, BOSException {
        String type = taskInfo.getType();
        String action = taskInfo.getAction();
        for (TaskReportHandler handler : handlers) {
            if (!handler.getType().type.equals(type) || !handler.getAction().action.equals(action)) continue;
            handler.handle(ctx, taskInfo, taskVersion, taskStatus, result);
        }
    }

    public abstract void handle(Context var1, EipTaskInfo var2, long var3, TaskStatus var5, String var6) throws BOSException, EASBizException;

    public abstract TaskType getType();

    public abstract TaskAction getAction();

    static {
        TaskReportHandler.initHanlders();
    }
}

