/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.app;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseUsageInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvAgent;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.app.IORMRPCEIPLicenseService;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ORMRPCEIPServiceService
extends ORMObject
implements IORMRPCEIPLicenseService {
    private static Logger logger = Logger.getLogger(ORMRPCEIPServiceService.class);
    public static final String BOS_NAME = "EIP";
    private static int TOTAL_EIP_LICENSE = -2;
    private static final String LICENSE_NOT_ENOUGH = "\u96c6\u6210\u5e73\u53f0\u6a21\u5757\u5f53\u524d\u8bb8\u53ef\u6570\u5df2\u7528\u5b8c\uff0c\u8be6\u89c1\u670d\u52a1\u7aef\u4e3b\u5b9e\u4f8bapusic\u65e5\u5fd7\u3002";
    private static Long expireTime = System.currentTimeMillis() - 0x6DDD00L;
    private static Map<String, Set<String>> ALL_AIS_LICENSE_MAP = new HashMap<String, Set<String>>();
    private static Set<String> aixLicenseSet = new HashSet<String>();

    public static Map<String, Set<String>> getAllLicenseInfo() {
        return ALL_AIS_LICENSE_MAP;
    }

    @Override
    public void _checkLicenseEnough(Context ctx) throws BOSException {
        int totalUsed = this.getHasUsedLicenseCount(ctx);
        if (TOTAL_EIP_LICENSE < totalUsed) {
            this.throwException(totalUsed);
        }
    }

    @Override
    public void _canAddLicenseOnceMore(Context ctx) throws BOSException {
        int totalUsed = this.getHasUsedLicenseCount(ctx);
        if (TOTAL_EIP_LICENSE <= totalUsed) {
            this.throwException(totalUsed);
        }
    }

    private void throwException(int totalUsed) throws BOSException {
        StringBuilder builder = new StringBuilder();
        builder.append(LICENSE_NOT_ENOUGH).append("License\u4e2d\u96c6\u6210\u8bb8\u53ef\u6570:").append(TOTAL_EIP_LICENSE < 0 ? 0 : TOTAL_EIP_LICENSE).append(",\u5df2\u4f7f\u7528:").append(totalUsed).append(".\u5360\u7528\u660e\u7ec6\uff1a");
        int i = 0;
        for (String ais : ALL_AIS_LICENSE_MAP.keySet()) {
            ORMRPCEIPServiceService.clearBlankLicense(ais);
            if (i != 0) {
                builder.append(";");
            }
            builder.append("\u6570\u636e\u4e2d\u5fc3\u7f16\u7801(").append(ais).append("),\u5360\u7528\u4e2a\u6570\uff1a").append(ALL_AIS_LICENSE_MAP.get(ais).size()).append(",\u5360\u7528\u5217\u8868\u4e3a\uff1a").append(com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converSet2String(ALL_AIS_LICENSE_MAP.get(ais), ",", ""));
            ++i;
        }
        logger.error((Object)builder.toString());
        throw new BOSException(LICENSE_NOT_ENOUGH);
    }

    public static void clearBlankLicense(String ais) {
        Set<String> setInfo = ALL_AIS_LICENSE_MAP.get(ais);
        logger.error((Object)("\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u300a" + ais + "\u300b\u4e0b\uff0c\u5360\u7528\u8bb8\u53ef\u6570\uff1a" + setInfo.size()));
        Iterator<String> itre = setInfo.iterator();
        while (itre.hasNext()) {
            String dbInfo = itre.next();
            logger.error((Object)("\u6570\u636e\u4e2d\u5fc3\uff1a" + dbInfo));
            if (!StringUtils.isEmpty((String)dbInfo)) continue;
            logger.error((Object)"\u51fa\u73b0\u4e3a\u7a7a\u5360\u7528\uff0c\u5df2\u5220\u9664\u5904\u7406\uff01");
            itre.remove();
        }
    }

    @Override
    public synchronized void _addLicense(Context ctx) throws BOSException {
        String AIS = ctx.getAIS();
        String licenseFlag = this.getLicenseFlag(ctx);
        if (!ALL_AIS_LICENSE_MAP.containsKey(AIS)) {
            this.initAISLicenseCouont(ctx);
            HashSet<String> licenseSet = new HashSet<String>();
            licenseSet.add(licenseFlag);
            ALL_AIS_LICENSE_MAP.put(AIS, licenseSet);
        } else {
            ALL_AIS_LICENSE_MAP.get(AIS).add(licenseFlag);
        }
    }

    @Override
    public synchronized Map<String, String> _getLicenseDetail(Context ctx) throws BOSException {
        HashMap<String, String> licenseDetail = new HashMap<String, String>();
        try {
            licenseDetail.put("TOTAL_EIP_LICENSE", String.valueOf(ORMRPCEIPServiceService.getEIPLicenseCountStatic()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.initAISLicenseCouont(ctx);
        licenseDetail.put("ALL_AIS_LICENSE_MAP", JSONUtils.convertObjectToJson((Context)ctx, ALL_AIS_LICENSE_MAP));
        return licenseDetail;
    }

    @Override
    public synchronized void _releaseLicense(Context ctx) throws BOSException {
        String AIS = ctx.getAIS();
        String licenseFlag = this.getLicenseFlag(ctx);
        if (ALL_AIS_LICENSE_MAP.containsKey(AIS)) {
            ALL_AIS_LICENSE_MAP.get(AIS).remove(licenseFlag);
        }
    }

    private String getLicenseFlag(Context ctx) {
        Object licenseObj = ctx.get((Object)"EIPLICENSEOBJECT");
        StringBuilder licenseBf = new StringBuilder(50);
        if (licenseObj instanceof ConnectionInfo) {
            ConnectionInfo cninfo = (ConnectionInfo)licenseObj;
            licenseBf.append(cninfo.getIP()).append(":").append(cninfo.getPort()).append(":").append(cninfo.getInstance());
        } else {
            EipUserInfo eipInfo = (EipUserInfo)licenseObj;
            licenseBf.append(eipInfo.getDBIP()).append(":").append(eipInfo.getDBPort()).append(":").append(eipInfo.getDbName());
        }
        return licenseBf.toString();
    }

    private int getHasUsedLicenseCount(Context ctx) throws BOSException {
        int totalCount = 0;
        String AIS = ctx.getAIS();
        this.initAISLicenseCouont(ctx);
        if (TOTAL_EIP_LICENSE == -2) {
            try {
                ORMRPCEIPServiceService.getEIPLicenseCountStatic();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (!ALL_AIS_LICENSE_MAP.containsKey(AIS)) {
            this.initAISLicenseCouont(ctx);
        }
        for (String ais : ALL_AIS_LICENSE_MAP.keySet()) {
            totalCount += ALL_AIS_LICENSE_MAP.get(ais).size();
        }
        return totalCount;
    }

    private synchronized void initAISLicenseCouont(Context ctx) throws BOSException {
        if (ALL_AIS_LICENSE_MAP.containsKey(ctx.getAIS())) {
            return;
        }
        Connection conn = null;
        try {
            aixLicenseSet = new HashSet<String>();
            conn = EJBFactory.getConnection((Context)ctx);
            this.getAgentCount(conn);
            this.getConnectionCount(conn);
            ALL_AIS_LICENSE_MAP.put(ctx.getAIS(), aixLicenseSet);
        }
        catch (Exception e) {
            try {
                throw new BOSException("EIP Module is destroy, please conneection administrator.", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
    }

    private void getAgentCount(Connection conn) throws BOSException {
        ResultSet rs = null;
        PreparedStatement ps = null;
        String sql = "select FDBIP, FDBPORT, FDBNAME from t_eip_eipUser";
        try {
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            StringBuilder bf = null;
            while (rs.next()) {
                bf = new StringBuilder(50);
                String ip = rs.getString("FDBIP");
                if (StringUtils.isEmpty((String)ip)) continue;
                String port = rs.getString("FDBPORT");
                String dbName = rs.getString("FDBNAME");
                bf.append(ip).append(":").append(port).append(":").append(dbName).toString();
                aixLicenseSet.add(bf.toString());
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
    }

    private void getConnectionCount(Connection conn) throws BOSException {
        ResultSet rs = null;
        PreparedStatement ps = null;
        String sql = "select FIP, FPORT, FINSTANCE from t_syn_connection";
        try {
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            StringBuilder bf = null;
            while (rs.next()) {
                bf = new StringBuilder(50);
                String ip = rs.getString("FIP");
                if (StringUtils.isEmpty((String)ip)) continue;
                String port = rs.getString("FPORT");
                String dbName = rs.getString("FINSTANCE");
                bf.append(ip).append(":").append(port).append(":").append(dbName);
                aixLicenseSet.add(bf.toString());
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
    }

    private static synchronized int getEIPLicenseCountStatic() throws Exception {
        int count = -1;
        if (TOTAL_EIP_LICENSE == -2) {
            ILicenseSrvAgent agent = LicenseSrvAgent.getLocalInstance();
            LicenseUsageInfo[] usageInfos = agent.getLicenseUsageInfo(BOS_NAME);
            if (usageInfos != null && usageInfos.length > 0) {
                count = usageInfos[0].getMaxLicenseNum();
            } else {
                logger.error((Object)"\u8bb8\u53ef\u6587\u4ef6\u4e2d\u672a\u5305\u542b\u6a21\u5757[EIP]\u7684\u8bb8\u53ef\u6570\u8bf4\u660e\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c-1\u3002");
            }
            if (count < 0) {
                throw new BOSException("\u8bb8\u53ef\u6587\u4ef6\u4e2d\u672a\u5305\u542b\u96c6\u6210\u5e73\u53f0\u6a21\u5757[EIP]\u7684\u8bb8\u53ef\u6570\u3002");
            }
            TOTAL_EIP_LICENSE = count;
        }
        return TOTAL_EIP_LICENSE;
    }

    @Override
    public String getLicenseInfo(Context ctx, boolean isRefresh) throws BOSException {
        HashMap<String, Object> mapInfo = new HashMap<String, Object>();
        if (isRefresh) {
            long time = System.currentTimeMillis() - expireTime;
            if (time < 3600000L) {
                mapInfo.put("expireTime", time);
                return JSON.toJSONString(mapInfo);
            }
            ALL_AIS_LICENSE_MAP.remove(ctx.getAIS());
            expireTime = System.currentTimeMillis();
        }
        this.initAISLicenseCouont(ctx);
        if (TOTAL_EIP_LICENSE < 0) {
            mapInfo.put("licenseCount", 0);
        } else {
            mapInfo.put("licenseCount", TOTAL_EIP_LICENSE);
        }
        mapInfo.put("licenseInfo", ALL_AIS_LICENSE_MAP);
        return JSON.toJSONString(mapInfo);
    }

    static {
        try {
            boolean hasError = false;
            Class<?> clazzIORM = Class.forName("com.kingdee.eas.csinterface.app.IORMRPCEIPLicenseService");
            URL iorm = clazzIORM.getResource("IORMRPCEIPLicenseService.class");
            if (iorm != null && iorm.getPath() != null && iorm.getPath().indexOf("sp\\") > -1) {
                logger.error((Object)"EIP License Error!");
                hasError = true;
            }
            if (!hasError) {
                ORMRPCEIPServiceService.getEIPLicenseCountStatic();
            } else {
                TOTAL_EIP_LICENSE = -3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

