/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureCollection;
import com.kingdee.eas.csinterface.basedatasyn.TableStructureInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.AbstractTableStructureControllerBean;
import com.kingdee.eas.csinterface.eipserviceplugin.execute.IERPExecute;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.util.ColumnInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.DataTypeConverter;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLFacadeFactory;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.csinterface.webservice.BaseDataSynWebServiceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceURLInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.user.EASBaseDataSynUserHandler;
import com.kingdee.eas.csinterface.webservice.app.handler.user.IERPUserHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class TableStructureControllerBean
extends AbstractTableStructureControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.basedatasyn.app.TableStructureControllerBean");

    @Override
    protected List _getColumnsByInfo(Context ctx, String tableName, Object info) throws BOSException {
        ArrayList<ColumnInfo> result = new ArrayList<ColumnInfo>();
        DBType dbTypeEnum = null;
        String ip = null;
        int port = -1;
        String instance = null;
        String username = null;
        String password = null;
        if (info instanceof ConnectionInfo) {
            dbTypeEnum = ((ConnectionInfo)info).getDBType();
            ip = ((ConnectionInfo)info).getIP();
            port = ((ConnectionInfo)info).getPort();
            instance = ((ConnectionInfo)info).getInstance();
            username = ((ConnectionInfo)info).getUsername();
            password = ((ConnectionInfo)info).getPassword();
        } else if (info instanceof EipUserInfo) {
            ip = ((EipUserInfo)info).getDBIP();
            port = Integer.valueOf(((EipUserInfo)info).getDBPort());
            instance = ((EipUserInfo)info).getDbName();
        } else if (info instanceof BaseDataSynWebServiceInfo) {
            ip = ((BaseDataSynWebServiceInfo)info).getWebAddress();
            port = ((BaseDataSynWebServiceInfo)info).getPort();
            instance = ((BaseDataSynWebServiceInfo)info).getDataCenter();
            username = ((BaseDataSynWebServiceInfo)info).getUserName();
            password = ((BaseDataSynWebServiceInfo)info).getPassword();
        } else {
            if (info instanceof WSServiceInfo) {
                WSServiceInfo serviceInfo;
                WSServiceURLInfo treeInfo;
                String treeId = "";
                if (((WSServiceInfo)info).getTree() != null && ((WSServiceInfo)info).getTree().getId() != null) {
                    treeId = ((WSServiceInfo)info).getTree().getId().toString();
                }
                if ((treeInfo = (serviceInfo = IERPExecute.getWSServiceInfo(ctx, ((WSServiceInfo)info).getId().toString(), "")).getTree()).getNumber().toUpperCase().indexOf("IERP") > -1) {
                    try {
                        String instanceId = treeInfo.getId().toString();
                        String upperTableName = tableName.toUpperCase();
                        EntityViewInfo ev = new EntityViewInfo();
                        FilterInfo filterInfo = new FilterInfo();
                        ev.setFilter(filterInfo);
                        filterInfo.getFilterItems().add(new FilterItemInfo("instance", (Object)instanceId, CompareType.EQUALS));
                        filterInfo.getFilterItems().add(new FilterItemInfo("tableName", (Object)upperTableName, CompareType.EQUALS));
                        TableStructureCollection coll = this.getTableStructureCollection(ctx, ev);
                        if (!coll.isEmpty()) {
                            TableStructureInfo tableInfo = coll.get(0);
                            JSONArray jsonArray = JSONArray.fromObject((Object)tableInfo.getColumnModel());
                            for (Object object : jsonArray) {
                                JSONObject jsonObject = (JSONObject)object;
                                ColumnInfo columnInfo = (ColumnInfo)JSONObject.toBean((JSONObject)jsonObject, ColumnInfo.class);
                                result.add(columnInfo);
                            }
                            return result;
                        }
                        List<ColumnInfo> queryList = IERPUserHandler.getTableFields(ctx, (WSServiceInfo)info, upperTableName);
                        boolean isExists = this.exists(ctx, "where instance = '" + instanceId + "' and tableName = '" + upperTableName + "'");
                        if (!isExists) {
                            TableStructureInfo tableStructureInfo = new TableStructureInfo();
                            tableStructureInfo.setIP(treeInfo.getServiceURL());
                            tableStructureInfo.setPort(treeInfo.getPort());
                            tableStructureInfo.setInstance(treeInfo.getId().toString());
                            tableStructureInfo.setTableName(upperTableName);
                            JSONArray array = JSONArray.fromObject(queryList);
                            tableStructureInfo.setColumnModel(array.toString());
                            this.addnew(ctx, tableStructureInfo);
                        }
                        return queryList;
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                throw new BOSException("\u4e0d\u652f\u6301\u7684\u975e\u82cd\u7a79\u7684\u8fdc\u7a0b\u670d\u52a1");
            }
            throw new BOSException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        ev.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("IP", (Object)ip, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("port", (Object)port, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("instance", (Object)instance, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("tableName", (Object)tableName, CompareType.EQUALS));
        TableStructureCollection coll = this.getTableStructureCollection(ctx, ev);
        if (!coll.isEmpty()) {
            TableStructureInfo tableInfo = coll.get(0);
            JSONArray jsonArray = JSONArray.fromObject((Object)tableInfo.getColumnModel());
            for (Object object : jsonArray) {
                JSONObject jsonObject = (JSONObject)object;
                ColumnInfo columnInfo = (ColumnInfo)JSONObject.toBean((JSONObject)jsonObject, ColumnInfo.class);
                result.add(columnInfo);
            }
            return result;
        }
        if (info instanceof EipUserInfo) {
            return result;
        }
        try {
            List<ColumnInfo> queryList = null;
            queryList = info instanceof ConnectionInfo ? this.getColumnsByConnectDirect(ctx, tableName, dbTypeEnum, ip, port, instance, username, password) : this.getColumnsByBaseDataSynWebService(ctx, tableName, (BaseDataSynWebServiceInfo)info);
            result.addAll(queryList);
            TableStructureInfo tableStructureInfo = new TableStructureInfo();
            tableStructureInfo.setIP(ip);
            tableStructureInfo.setPort(port);
            tableStructureInfo.setInstance(instance);
            tableStructureInfo.setTableName(tableName);
            JSONArray array = JSONArray.fromObject(queryList);
            tableStructureInfo.setColumnModel(array.toString());
            this.addnew(ctx, tableStructureInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private List<ColumnInfo> getColumnsByConnectDirect(Context ctx, String tableName, DBType dbTypeEnum, String ip, int port, String instance, String username, String password) throws Exception {
        ArrayList<ColumnInfo> result = new ArrayList<ColumnInfo>();
        DataTypeConverter converter = DataTypeConverter.getConverter(dbTypeEnum);
        String ksql = converter.getColumnDefinedSql(tableName);
        DataBaseType dbType = DataBaseType.getInstance(dbTypeEnum.getName());
        if (DataBaseType.MySql.equals((Object)dbType)) {
            return KSQLUtil.getMySqlSchema(dbType, ip, port, instance, username, password, tableName);
        }
        IRowSet rowset = null;
        try {
            rowset = KSQLFacadeFactory.getLocalInstance(ctx).getTargetRowset(dbType, ip, port, instance, username, password, ksql);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            String str = "[EIP]\u67e5\u8be2\u6570\u636e\u5e93\u8868\u7ed3\u6784\u5f02\u5e38\uff01[\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + (Object)((Object)dbType) + ";ip\u5730\u5740\uff1a" + ip + ":\u7aef\u53e3\u53f7\uff1a" + port + ";\u6570\u636e\u5e93\u540d\u79f0:" + instance + "]";
            logger.error((Object)str);
            throw new Exception(str, ex);
        }
        if (0 == rowset.size()) {
            String detal = "sql\uff1a" + ksql + "\r\n\u6570\u636e\u5e93\u7c7b\u578b" + dbType.getName();
            logger.error((Object)(tableName + "\u4e0d\u5b58\u5728" + detal));
        }
        while (rowset.next()) {
            ColumnInfo colInfo = new ColumnInfo();
            String colName = rowset.getString("COLUMN_NAME");
            String type = rowset.getString("DATA_TYPE");
            String defaultLength = rowset.getString("DEFAULT_LENGTH");
            String dataLength = null;
            try {
                dataLength = rowset.getString("DATA_LENGTH");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            String precision = rowset.getString("DATA_PRECISION");
            String scale = rowset.getString("DATA_SCALE");
            String nullable = rowset.getString("NULLABLE");
            colInfo.setCOLUMN_NAME(colName);
            colInfo.setDATA_TYPE(type.toUpperCase());
            colInfo.setDEFAULT_LENGTH(defaultLength);
            colInfo.setDATA_LENGTH(dataLength);
            colInfo.setDATA_PRECISION(precision);
            colInfo.setDATA_SCALE(scale);
            colInfo.setNULLABLE(nullable);
            result.add(colInfo);
        }
        return result;
    }

    @Override
    protected void _updateColumnsByInfo(Context ctx, String id, Object info) throws BOSException {
        DBType dbTypeEnum = null;
        String ip = null;
        int port = -1;
        String instance = null;
        String username = null;
        String password = null;
        try {
            TableStructureInfo tableStructure = this.getTableStructureInfo(ctx, "where id='" + id + "'");
            List<ColumnInfo> queryList = null;
            if (info instanceof ConnectionInfo) {
                dbTypeEnum = ((ConnectionInfo)info).getDBType();
                ip = ((ConnectionInfo)info).getIP();
                port = ((ConnectionInfo)info).getPort();
                instance = ((ConnectionInfo)info).getInstance();
                username = ((ConnectionInfo)info).getUsername();
                password = ((ConnectionInfo)info).getPassword();
                queryList = this.getColumnsByConnectDirect(ctx, tableStructure.getTableName(), dbTypeEnum, ip, port, instance, username, password);
            } else if (info instanceof WSServiceInfo) {
                queryList = IERPUserHandler.getTableFields(ctx, (WSServiceInfo)info, tableStructure.getTableName().toUpperCase());
            } else {
                throw new BOSException("\u76ee\u524d\u4ec5\u652f\u6301\u6570\u636e\u5e93\u8fde\u63a5\u548c\u8fdc\u7a0b\u670d\u52a1\u4e24\u79cd\u7c7b\u578b");
            }
            JSONArray array = JSONArray.fromObject(queryList);
            tableStructure.setColumnModel(array.toString());
            this.update(ctx, CommonUtil.convert2PK(id), tableStructure);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private List<ColumnInfo> getColumnsByBaseDataSynWebService(Context ctx, String tableName, BaseDataSynWebServiceInfo info) throws Exception {
        JSONArray array;
        ArrayList<ColumnInfo> result = new ArrayList<ColumnInfo>();
        try {
            String returnValue = EASBaseDataSynUserHandler.sendDataToEASForDataStructure(ctx, tableName, "5", info);
            array = JSONArray.fromObject((Object)returnValue);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            String str = "[EIP]\u67e5\u8be2\u6570\u636e\u5e93\u8868\u7ed3\u6784\u5f02\u5e38\uff01[\u8868\u540d\uff1a" + tableName + ";\u8fdc\u7a0b\u670d\u52a1id\uff1a" + info.toString() + "]";
            throw new Exception(str, ex);
        }
        if (0 == array.size()) {
            String detal = "BaseDataSynWebServiceInfo\uff1a" + info.getId().toString();
            logger.error((Object)(tableName + "\u4e0d\u5b58\u5728" + detal));
            return result;
        }
        for (int i = 0; i < array.size(); ++i) {
            ColumnInfo colInfo = new ColumnInfo();
            JSONObject obj = array.getJSONObject(i);
            colInfo.setCOLUMN_NAME(obj.getString("COLUMN_NAME"));
            colInfo.setDATA_TYPE(obj.getString("DATA_TYPE"));
            colInfo.setDEFAULT_LENGTH(obj.getString("DEFAULT_LENGTH"));
            colInfo.setDATA_LENGTH(obj.getString("DATA_LENGTH"));
            colInfo.setDATA_PRECISION(obj.getString("DATA_PRECISION"));
            colInfo.setDATA_SCALE(obj.getString("DATA_SCALE"));
            colInfo.setNULLABLE(obj.getString("NULLABLE"));
            result.add(colInfo);
        }
        return result;
    }
}

