/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.newsync.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.ColumnModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHelper;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSpecialSQLCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSpecialSQLFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSpecialSQLInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTypeMapInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapFactory;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.cache.BaseDataSynCacheHelper;
import com.kingdee.eas.csinterface.basedatasyn.app.newsync.cache.BaseDataSynCacheInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataResourceholder;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynUtil;
import com.kingdee.eas.csinterface.basedatasyn.app.util.KeyTableUtil;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class GetExecuteIDHelper {
    private static Logger logger = Logger.getLogger(GetExecuteIDHelper.class);

    public static String getQuerySQLForFId(Context ctx, String filterString, BaseDataSynTableInfo tableInfo, List<String> mainPKList, String connId) throws Exception {
        String specialSQL;
        String mainTableField;
        String relateSQL = tableInfo.getRelateSQL();
        String tableName = tableInfo.getTableName();
        String pkTable = tableInfo.getPkTableName().replaceAll("\"", "");
        String tableFilter = tableInfo.getSrcWhere();
        boolean isMainTable = tableInfo.isMainTable();
        String pks = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(mainPKList, ",", "'");
        BaseDataSynCacheHelper.getCurrent();
        StructuredDataModel dataModel = BaseDataSynCacheInfo.getTableModel(tableName);
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        StructuredDataModel.TableModel entry = tableModels[1];
        StringBuilder sqlBuf = new StringBuilder();
        sqlBuf.append("select ");
        String entryPkName = null;
        String AS_NAME = "t1.";
        String ALIAS_NAME = "t1";
        for (int i = 0; i < entry.columns.length; ++i) {
            if (StringUtils.isEmpty((String)entry.columns[i].name) || !entry.columns[i].isPk) continue;
            entryPkName = entry.columns[i].name;
            sqlBuf.append(AS_NAME).append(entryPkName);
            break;
        }
        if (!(StringUtils.isEmpty((String)relateSQL) || StringUtils.isEmpty((String)(mainTableField = relateSQL.substring(relateSQL.lastIndexOf("and") + 3, relateSQL.lastIndexOf("in(")))) || StringUtils.endsWithIgnoreCase((String)relateSQL, (String)mainTableField))) {
            sqlBuf.append(" , ").append(mainTableField).append(" ").append("mainPK");
        }
        sqlBuf.append(" from ").append(tableName).append(" " + ALIAS_NAME);
        if (!StringUtils.isEmpty((String)relateSQL) && (relateSQL = relateSQL.replace(tableName + ".", AS_NAME)) != null) {
            relateSQL = relateSQL.replace("${fid}", pks);
            sqlBuf.append(relateSQL);
        }
        sqlBuf.append(" where ");
        if (isMainTable && !StringUtils.isEmpty((String)pks)) {
            sqlBuf.append(" " + ALIAS_NAME + ".fid in (" + pks + ") and ");
        }
        ColumnModel pkColumn = null;
        for (int i = 0; i < entry.columns.length; ++i) {
            if (!entry.columns[i].isPk) continue;
            pkColumn = entry.columns[i];
            break;
        }
        if (pkColumn == null) {
            throw new NullPointerException();
        }
        if (pkColumn.baseDataType != null) {
            BaseDataSynTypeMapInfo info = (BaseDataSynTypeMapInfo)pkColumn.baseDataType;
            IObjectPK[] typeIds = BaseDataSynValueMapFactory.getLocalInstance(ctx).getPKList("where baseDataType.id ='" + info.getId().toString() + "'");
            StringBuilder valueMapIds = new StringBuilder();
            for (int i = 0; i < typeIds.length; ++i) {
                if (i > 0) {
                    valueMapIds.append(",");
                }
                valueMapIds.append("'").append(typeIds[i].toString()).append("'");
            }
            StringBuilder noExistSql = new StringBuilder();
            noExistSql.append(" not exists (").append(" select 1 from T_SYN_BaseDataSynValueMapEntry where " + ALIAS_NAME + "." + pkColumn.name + "=T_SYN_BaseDataSynValueMapEntry.FSrcID").append(" and T_SYN_BaseDataSynValueMapEntry.FParentId in (" + valueMapIds).append("))").append(" and ");
            sqlBuf.append(noExistSql.toString());
        }
        sqlBuf.append("  not exists(select 1 from ").append(pkTable).append(" p").append(" where " + AS_NAME).append(entryPkName).append(" = p.").append("headpk AND p.agentId = '" + connId + "'").append(")");
        if (isMainTable) {
            String cTableName = BaseDataSynHelper.calc2ExistTableName(tableName);
            if (!BaseDataSynUtil.existCTable.containsKey(tableName)) {
                Boolean flag = false;
                try {
                    flag = KeyTableUtil.existKeyTable(ctx, cTableName);
                }
                catch (Exception e) {
                    String message = "\u5224\u65adC\u8868\u662f\u5426\u5b58\u5728\u5f02\u5e38\uff0c\u8868\u540d\uff1a" + cTableName;
                    throw new BOSException(message, (Throwable)e);
                }
                BaseDataSynUtil.existCTable.put(tableName, flag);
            }
            if (BaseDataSynUtil.existCTable.get(tableName).booleanValue()) {
                sqlBuf.append(" and not exists(select 1 from ").append(cTableName).append(" c").append(" where " + AS_NAME).append(entryPkName).append(" = c.").append("headpk AND c.agentId = '" + connId + "'").append(")");
            }
            BaseDataResourceholder.put(ctx);
            BaseDataResourceholder.putBaseDataSynTableInfo(tableInfo);
        }
        if (isMainTable) {
            sqlBuf.append(" and not exists(select 1 from ").append(" T_EIP_BaseDataSynPreCheckLog ").append(" l ").append(" where " + AS_NAME).append(entryPkName).append(" = l.").append("fsrcValue").append(")");
        }
        if (!StringUtils.isEmpty((String)tableFilter)) {
            if (StringUtils.startsWithIgnoreCase((String)tableFilter, (String)"where")) {
                tableFilter = StringUtils.replaceIgnoreCase((String)tableFilter, (String)"where", (String)"");
                tableFilter = tableFilter.replace(tableName + ".", AS_NAME);
            }
            if (tableFilter.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(tableFilter);
            } else {
                sqlBuf.append(" and ").append(tableFilter);
            }
        }
        if (isMainTable && !StringUtils.isEmpty((String)(specialSQL = GetExecuteIDHelper.getPlanSpecialSQL(ctx, tableInfo, connId)))) {
            if (StringUtils.startsWithIgnoreCase((String)specialSQL, (String)"where")) {
                specialSQL = StringUtils.replaceIgnoreCase((String)specialSQL, (String)"where", (String)"");
            }
            if (specialSQL.matches("(?im)^and.*")) {
                sqlBuf.append(" ").append(specialSQL);
            } else {
                sqlBuf.append(" and ").append(specialSQL);
            }
        }
        if (!StringUtils.isEmpty((String)filterString)) {
            if (!(filterString = filterString.trim()).matches("(?im)^and.*")) {
                sqlBuf.append(" and ");
            }
            sqlBuf.append(filterString);
        }
        return sqlBuf.toString();
    }

    private static String getPlanSpecialSQL(Context ctx, BaseDataSynTableInfo tableInfo, String connId) throws Exception {
        String planId = tableInfo.getParent().getId().toString();
        String sql = BaseDataSynCacheHelper.getCurrent().getPlanSpecilaSQL(planId);
        if (sql != null) {
            return sql;
        }
        EntityViewInfo view = new EntityViewInfo();
        try {
            Iterator it;
            BaseDataSynSpecialSQLCollection coll;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)planId, CompareType.EQUALS));
            if (!StringUtils.isEmpty((String)((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getExtendedProperty("wsserviceId"))) {
                filter.getFilterItems().add(new FilterItemInfo("wsservice.id", (Object)connId, CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("connnection.id", (Object)connId, CompareType.EQUALS));
            }
            filter.setMaskString("#0 and #1");
            view.setFilter(filter);
            if (ctx == null) {
                ctx = BaseDataResourceholder.getContext();
            }
            if ((coll = BaseDataSynSpecialSQLFactory.getLocalInstance(ctx).getBaseDataSynSpecialSQLCollection(view)).size() > 0 && (it = coll.iterator()).hasNext()) {
                BaseDataSynSpecialSQLInfo specialSQL = (BaseDataSynSpecialSQLInfo)it.next();
                sql = specialSQL.getSql();
            }
        }
        catch (Exception e) {
            logger.error((Object)("EIP:do specialSQL fail![baseDataSynId:" + tableInfo.getParent().getId().toString() + ""));
            throw e;
        }
        BaseDataSynCacheHelper.getCurrent().setPlanSpecilaSQLMap(planId, sql);
        return sql;
    }
}

