/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.BaseDataSaver;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynExecuteFacadeFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.ThreadBaseDataPlanSyn;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataResourceholder;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynUtil;
import com.kingdee.eas.csinterface.basedatasyn.app.util.EIPConfiguration;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataExector;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataFunUtil;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataPage;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataSyn;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataSynParam;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadBaseDataUtil;
import com.kingdee.eas.csinterface.basedatasyn.app.util.ThreadSortedTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.basedatadel.BaseDataDelSynByJDBCImpl;
import com.kingdee.eas.csinterface.basedatasyn.app.util.basedatadel.BaseDataDelSynByWebServiceImpl;
import com.kingdee.eas.csinterface.basedatasyn.app.util.basedatadel.IBaseDataDelSynExecute;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.schedule.app.service.ScheduleTaskAction;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class BaseDataDownExecutor {
    Logger logger = Logger.getLogger(BaseDataDownExecutor.class);
    private Context ctx = null;
    public static final int PAGESIZE = 300;
    private static List<IBaseDataDelSynExecute> BASEDATA_DEL_STRATEGYS = new ArrayList<IBaseDataDelSynExecute>();

    public BaseDataDownExecutor() {
    }

    public BaseDataDownExecutor(Context context) {
        this.ctx = context;
    }

    public String execBaseDataDown(BaseDataSynHeadInfo baseDataSynInfo, List<String> mainPKList) throws Exception {
        int i;
        String reuslt = null;
        String connectionId = MonitorManager.getCurrent().getExtendedProperty("connId");
        String agentId4http = MonitorManager.getCurrent().getExtendedProperty("agentId4http");
        List<BaseDataSynTableInfo> sortedTableColl = BaseDataSynUtil.getSortedTablesDesc(baseDataSynInfo);
        int tmpPageSize = 300;
        if (sortedTableColl.size() == 1) {
            tmpPageSize = 1000;
        }
        BaseDataDownMonitorLogInfo baseDataDownLog = (BaseDataDownMonitorLogInfo)MonitorManager.getCurrent();
        int totalLength = mainPKList.size();
        int totalPageSize = (totalLength - 1) / tmpPageSize + 1;
        int fromIndex = 0;
        int toIndex = 0;
        if (!com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.isEmpty(connectionId)) {
            for (i = 0; i < totalPageSize; ++i) {
                fromIndex = i * tmpPageSize;
                toIndex = (i + 1) * tmpPageSize > totalLength ? totalLength : (i + 1) * tmpPageSize;
                this.executeDownPage(baseDataSynInfo, mainPKList.subList(fromIndex, toIndex), connectionId);
                ScheduleTaskAction.removeMapByBaseDataSyn(baseDataDownLog);
            }
        }
        if (!com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.isEmpty(agentId4http)) {
            for (i = 0; i < totalPageSize; ++i) {
                fromIndex = i * tmpPageSize;
                toIndex = (i + 1) * tmpPageSize > totalLength ? totalLength : (i + 1) * tmpPageSize;
                this.executeDownPage(baseDataSynInfo, mainPKList.subList(fromIndex, toIndex), agentId4http);
            }
        }
        return reuslt;
    }

    public String execBaseDataUpdate(BaseDataSynHeadInfo baseDataSyninfo, List<String> mainPKList) throws Exception {
        String reuslt = null;
        String connectionId = MonitorManager.getCurrent().getExtendedProperty("connId");
        List<BaseDataSynTableInfo> sortedTableColl = BaseDataSynUtil.getSortedTablesDesc(baseDataSyninfo);
        int tmpPageSize = 300;
        if (sortedTableColl.size() == 1) {
            tmpPageSize = 1000;
        }
        BaseDataDownMonitorLogInfo baseDataDownLog = (BaseDataDownMonitorLogInfo)MonitorManager.getCurrent();
        int totalLength = mainPKList.size();
        int totalPageSize = (totalLength - 1) / tmpPageSize + 1;
        int fromIndex = 0;
        int toIndex = 0;
        for (int i = 0; i < totalPageSize; ++i) {
            fromIndex = i * tmpPageSize;
            toIndex = (i + 1) * tmpPageSize > totalLength ? totalLength : (i + 1) * tmpPageSize;
            this.executeUpdatePage(baseDataSyninfo, mainPKList.subList(fromIndex, toIndex), connectionId);
            ScheduleTaskAction.removeMapByBaseDataSyn(baseDataDownLog);
        }
        return reuslt;
    }

    private void executeDownPage(BaseDataSynHeadInfo baseDataSyninfo, List<String> mainPKList, String connId) throws Exception {
        String monitorLogId = MonitorManager.getCurrentBaseDataDown().getId().toString();
        this.getMainTableChangeTime(baseDataSyninfo, mainPKList);
        List<BaseDataSynTableInfo> sortedTableColl = BaseDataSynUtil.getSortedTablesDesc(baseDataSyninfo);
        for (BaseDataSynTableInfo tableInfo : sortedTableColl) {
            BaseDataSynExecuteFacadeFactory.getLocalInstance(this.ctx).execPlanPatch(connId, mainPKList, baseDataSyninfo, tableInfo, monitorLogId, "add");
        }
    }

    private void getMainTableChangeTime(BaseDataSynHeadInfo headInfo, List<String> mainPKList) throws Exception {
        String changeTimeName = "flastupdatetime";
        BaseDataSynTableInfo mainTable = BaseDataSynUtil.getMainTableInfo(this.ctx, headInfo);
        String tableName = mainTable.getTableName();
        BaseDataSynColumnCollection columnColl = headInfo.getColumnEntrys();
        Iterator ite = columnColl.iterator();
        BaseDataSynColumnInfo column = null;
        while (ite.hasNext()) {
            column = (BaseDataSynColumnInfo)ite.next();
            if (!StringUtils.endsWithIgnoreCase((String)column.getTableName(), (String)tableName) || !column.isPkTime()) continue;
            changeTimeName = column.getColName();
            break;
        }
        String mainPKBuffer = com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(mainPKList, ",", "'");
        String sql = "select fid, " + changeTimeName + " changetime from " + tableName + " where fid in (" + mainPKBuffer + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        String fid = null;
        String changeTime = null;
        Timestamp time = null;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        HashMap<String, String> timeMap = new HashMap<String, String>(300);
        while (rowSet.next()) {
            fid = rowSet.getString("fid");
            time = rowSet.getTimestamp("changetime");
            changeTime = time == null ? null : fmt.format(rowSet.getTimestamp("changetime"));
            timeMap.put(fid, changeTime);
        }
        MonitorManager.getCurrentBaseDataDown().getMainId_ChangeTime_map().putAll(timeMap);
    }

    private void executeUpdatePage(BaseDataSynHeadInfo baseDataSyninfo, List<String> mainPKList, String connId) throws Exception {
        String monitorLogId = MonitorManager.getCurrentBaseDataDown().getId().toString();
        this.getMainTableChangeTime(baseDataSyninfo, mainPKList);
        List<BaseDataSynTableInfo> sortedTableColl = BaseDataSynUtil.getSortedTablesDesc(baseDataSyninfo);
        String tableName = null;
        for (BaseDataSynTableInfo tableInfo : sortedTableColl) {
            tableName = tableInfo.getTableName();
            if (!EIPConfiguration.Instance().needUpdateTable(tableName)) continue;
            BaseDataSynExecuteFacadeFactory.getLocalInstance(this.ctx).execPlanPatch(connId, mainPKList, baseDataSyninfo, tableInfo, monitorLogId, "update");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execBaseDataDelete(BaseDataSynHeadInfo baseDataSyninfo, String extendSQL) throws Exception {
        String reuslt = null;
        String agentId = "";
        BaseDataSaver saver = null;
        String connectionId = MonitorManager.getCurrent().getExtendedProperty("connId");
        ConnectionInfo connection = null;
        String extWebServiceId = MonitorManager.getCurrent().getExtendedProperty("webserviceId");
        if (!com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.isEmpty(connectionId)) {
            agentId = connectionId;
            connection = ConnectionFactory.getLocalInstance(this.ctx).getConnectionInfo(CommonUtil.convert2PK(connectionId));
        } else if (!com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.isEmpty(extWebServiceId)) {
            agentId = extWebServiceId;
        }
        saver = new BaseDataSaver(connection);
        MonitorManager.getCurrent().setExtendedProperty("currThreadBaseDataSynHeadNum", baseDataSyninfo.getNumber());
        List<BaseDataSynTableInfo> sortedTableColl = BaseDataSynUtil.getSortedTablesDesc(baseDataSyninfo);
        ArrayList<String> deleteIdList = new ArrayList();
        long deleteDestTime = 0L;
        long deletePkTableTime = 0L;
        long recordLogTime = 0L;
        try {
            if (null != saver && null != connection) {
                saver.open();
                saver.open(this.ctx);
            }
            BaseDataSynTableInfo mainTable = BaseDataSynUtil.getMainTableInfo(this.ctx, baseDataSyninfo.getNumber());
            boolean hasMainNext = true;
            boolean isFirst = true;
            while (hasMainNext) {
                List<String> mainIdList = BaseDataSynUtil.getDeleteIdByTable(this.ctx, mainTable, agentId, null, extendSQL, isFirst);
                isFirst = false;
                if (mainIdList.size() <= BaseDataSynUtil.MAXCOUNT) {
                    if (mainIdList.size() == 0) {
                        return reuslt;
                    }
                    hasMainNext = false;
                }
                for (BaseDataSynTableInfo tableInfo : sortedTableColl) {
                    try {
                        boolean hasNext = true;
                        while (hasNext) {
                            deleteIdList = BaseDataSynUtil.getDeleteIdByTable(this.ctx, tableInfo, agentId, mainIdList, null);
                            for (IBaseDataDelSynExecute baseDataSynDel : BASEDATA_DEL_STRATEGYS) {
                                if (!baseDataSynDel.baseDataDelSynType(MonitorManager.getCurrent())) continue;
                                hasNext = baseDataSynDel.baseDataDelSynExecute(this.ctx, deleteIdList, tableInfo, saver);
                                deleteDestTime += MonitorManager.getCurrent().getExtendedProperty("preDeleteDestTime") == null ? 0L : (long)Integer.parseInt(MonitorManager.getCurrent().getExtendedProperty("preDeleteDestTime"));
                                deletePkTableTime += MonitorManager.getCurrent().getExtendedProperty("preDeletePkTableTime") == null ? 0L : (long)Integer.parseInt(MonitorManager.getCurrent().getExtendedProperty("preDeletePkTableTime"));
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.error((Object)(e + "\u6267\u884c\u57fa\u7840\u8d44\u6599\u540c\u6b65\u5220\u9664\u5931\u8d25\uff0c\u65b9\u6848\u7f16\u7801\uff1a" + baseDataSyninfo.getNumber()));
                        throw new Exception(e);
                    }
                }
                continue;
                return reuslt;
            }
        }
        finally {
            if (null != saver) {
                saver.close();
            }
            StringBuffer recordInfo = new StringBuffer();
            recordInfo.append("\u5220\u9664\u76ee\u6807\u6570\u636e\u8017\u65f6\uff1a" + deleteDestTime + "ms \r");
            recordInfo.append("\u5220\u9664\u589e\u91cf\u8868\u8017\u65f6\uff1a" + deletePkTableTime + "ms \r");
            recordInfo.append("\u8bb0\u5f55\u5b50\u65e5\u5fd7\u8017\u65f6\uff1a" + recordLogTime + "ms \r");
            ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo(recordInfo.toString());
        }
    }

    public void executePage(BaseDataSynHeadInfo baseDataSyninfo, List<String> mainPKList, String connId, ThreadBaseDataExector executor, boolean isFirst, String execType, boolean isOpenMutliTable) throws Exception {
        BaseDataDownMonitorLogInfo monitorLog = executor.getMonitorLogInfo();
        String monitorLogId = monitorLog.getId().toString();
        ThreadSortedTableInfo sortedTableInfo = executor.getSortedTableInfo();
        this.getMainTableChangeTime(baseDataSyninfo, mainPKList);
        List<BaseDataSynTableInfo> sortedTableColl = sortedTableInfo.getSortedTableColl();
        BaseDataSynTableInfo mainTableInfo = sortedTableColl.get(sortedTableInfo.getFromTalbeSize());
        ThreadBaseDataUtil threaUtil = new ThreadBaseDataUtil(sortedTableInfo.getFromTalbeSize());
        String tableName = "";
        execType = execType.toLowerCase();
        boolean isSingleTable = false;
        if (sortedTableColl.size() == 1) {
            isSingleTable = true;
        }
        for (BaseDataSynTableInfo tableInfo : sortedTableColl) {
            if (isOpenMutliTable) {
                ThreadBaseDataSyn threadSyn = new ThreadBaseDataSyn(this.ctx, connId, mainPKList, baseDataSyninfo, tableInfo, monitorLogId, execType, monitorLog.getMainId_ChangeTime_map());
                threadSyn.setExecutor(executor);
                threadSyn.setMainTableInfo(mainTableInfo);
                threadSyn.setThreaUtil(threaUtil);
                if (isSingleTable) {
                    threadSyn.runMainTableSyn(true);
                    continue;
                }
                if (tableInfo.isMainTable()) continue;
                tableName = tableInfo.getTableName();
                if ("update".equalsIgnoreCase(execType) && !EIPConfiguration.Instance().needUpdateTable(tableName)) continue;
                ThreadBaseDataSynParam.tableExec.submit(threadSyn);
                continue;
            }
            BaseDataSynExecuteFacadeFactory.getLocalInstance(this.ctx).execPlanPatch(connId, mainPKList, baseDataSyninfo, tableInfo, monitorLogId, execType);
        }
    }

    public String execBaseDataByType(BaseDataSynHeadInfo baseDataSynInfo, List<String> mainPKList, BaseDataSynTableInfo mainTableInfo, String extendSQL, BaseDataDownMonitorLogInfo baseDataDownLog, boolean isFirst, ThreadBaseDataExector multiThreadExcutor) throws Exception {
        int tmpPageSize = 300;
        int totalLength = 0;
        String connectionId = "";
        ThreadBaseDataFunUtil threadUtil = null;
        String execType = baseDataDownLog.getExecType();
        if (isFirst) {
            threadUtil = new ThreadBaseDataFunUtil();
            connectionId = MonitorManager.getCurrent().getExtendedProperty("connId");
            List<BaseDataSynTableInfo> sortedTableColl = BaseDataSynUtil.getSortedTablesDesc(baseDataSynInfo);
            int fromTalbeSize = sortedTableColl.size() - 1;
            ThreadSortedTableInfo sortedTableInfo = new ThreadSortedTableInfo(sortedTableColl, fromTalbeSize);
            if (sortedTableColl.size() == 1) {
                tmpPageSize = 1000;
            }
            totalLength = mainPKList.size();
            BaseDataDownMonitorLogInfo monitorLogInfo = (BaseDataDownMonitorLogInfo)MonitorManager.getCurrent();
            multiThreadExcutor = new ThreadBaseDataExector(this, mainPKList, tmpPageSize, totalLength, threadUtil, monitorLogInfo);
            multiThreadExcutor.setCtx(this.ctx);
            multiThreadExcutor.setSortedTableInfo(sortedTableInfo);
            multiThreadExcutor.setBaseDataDownInfo(new ThreadBaseDataInfo(baseDataSynInfo, mainTableInfo, extendSQL, baseDataDownLog, isFirst));
        } else {
            threadUtil = multiThreadExcutor.getThreadUtil();
            BaseDataResourceholder.put(this.ctx);
            if (threadUtil.isShutDown || this.avoidDeadLoop(baseDataSynInfo, mainTableInfo, extendSQL, isFirst, multiThreadExcutor, execType)) {
                this.logger.error((Object)("\u5f53\u524d\u6709\u5df2\u6709\u6279\u6b21\u6267\u884c\u9519\u8bef\uff0c\u4e0d\u518d\u5411\u4e0b\u6267\u884c\uff0c\u76f8\u5173\u4fe1\u606f-\u300b\u57fa\u7840\u8d44\u6599\u65b9\u6848\u4e3a\uff1a" + baseDataSynInfo.getId().toString()));
                MonitorManager.exitByMulti(this.ctx, baseDataSynInfo);
                return "back";
            }
            if ("ADD".equalsIgnoreCase(execType)) {
                mainPKList = BaseDataSynUtil.getMainPKListForAdd(this.ctx, baseDataSynInfo, mainTableInfo, extendSQL, isFirst);
            } else if ("Update".equalsIgnoreCase(execType)) {
                mainPKList = BaseDataSynUtil.getMainPKListForUpdate(this.ctx, baseDataSynInfo, mainTableInfo, extendSQL, isFirst);
            }
            totalLength = mainPKList.size();
            if (totalLength == 0) {
                this.logger.error((Object)"\u5f53\u524d\u65b9\u6848\u7684\u6570\u636e\u5df2\u540c\u6b65\u5b8c\u6210\uff0c\u8d70\u56de\u8c03\u81f3\u65b9\u6848\u751f\u6210\u5bf9\u5e94\u65e5\u5fd7");
                ThreadBaseDataPlanSyn planSyn = baseDataSynInfo.getBaseDataPlanSyn();
                if (planSyn.updateMultiThreadStatus(baseDataSynInfo)) {
                    MonitorManager.exitByMulti(this.ctx, baseDataSynInfo);
                    return "back";
                }
            }
            tmpPageSize = multiThreadExcutor.pageSize;
            connectionId = multiThreadExcutor.getBaseDataDownInfo().getConnectionId();
        }
        int totalPageSize = (totalLength - 1) / tmpPageSize + 1;
        int toPageCount = totalPageSize <= ThreadBaseDataSynParam.pageProtocol ? totalPageSize : ThreadBaseDataSynParam.pageProtocol;
        int pageCounter = 0;
        int toIndex = 0;
        AtomicInteger atomInt = multiThreadExcutor.getAtomInt();
        if (atomInt.get() > ThreadBaseDataSynParam.pageProtocol) {
            atomInt.set(-1);
        }
        for (int j = 0; j < toPageCount; ++j) {
            pageCounter = atomInt.addAndGet(1);
            this.logger.error((Object)("\u5f53\u524d\u7684\u5206\u9875\u6279\u6b21\u4e3a\uff1a" + pageCounter));
            toIndex = (pageCounter + 1) * tmpPageSize > totalLength ? totalLength : (pageCounter + 1) * tmpPageSize;
            ThreadBaseDataSynParam.pageExec.submit(new ThreadBaseDataPage(baseDataSynInfo, mainPKList.subList(pageCounter * tmpPageSize, toIndex), connectionId, multiThreadExcutor, isFirst, execType));
        }
        return "runBackCall";
    }

    private boolean avoidDeadLoop(BaseDataSynHeadInfo baseDataSynInfo, BaseDataSynTableInfo mainTableInfo, String extendSQL, boolean isFirst, ThreadBaseDataExector multiThreadExcutor, String execType) {
        int parentPage = multiThreadExcutor.getParentPage().addAndGet(1);
        boolean avoidDeadLoop = multiThreadExcutor.getAvoidDeadLoop();
        if (parentPage > ThreadBaseDataSynParam.parentTotalPage * 2 / 3 && !avoidDeadLoop) {
            this.logger.info((Object)"\u5f53\u524d\u5df2\u5904\u7406\u65b9\u6848\u4e3b\u8868mainpk_20W,\u8fdb\u5165\u591a\u7ebf\u7a0b\u9632\u6b7b\u5faa\u73af\u903b\u8f91\u63a7\u5236");
            int eipCount = BaseDataSynUtil.caclMainPkCount(this.ctx, baseDataSynInfo, mainTableInfo, extendSQL, isFirst, execType);
            multiThreadExcutor.parentTotalPage = eipCount == -1 ? ThreadBaseDataSynParam.parentTotalPage : (eipCount - 1) / BaseDataSynUtil.MAXCOUNT + 1;
            multiThreadExcutor.setAvoidDeadLoop(true);
        }
        if (avoidDeadLoop && parentPage >= multiThreadExcutor.parentTotalPage) {
            this.logger.error((Object)("\u8fdb\u5165\u9632\u6b7b\u5faa\u73af\u673a\u5236\u7684\u9000\u51fa,\u5f53\u524d\u5df2\u6267\u884c\u603b\u9875\u6570\uff1a" + parentPage + "\u5355\u6279\u603b\u5206\u9875\u7684\u6570\u91cf\u4e3a\uff1a" + BaseDataSynUtil.MAXCOUNT));
            MonitorManager.exit(this.ctx);
            return true;
        }
        return false;
    }

    static {
        BASEDATA_DEL_STRATEGYS.add(new BaseDataDelSynByJDBCImpl());
        BASEDATA_DEL_STRATEGYS.add(new BaseDataDelSynByWebServiceImpl());
    }
}

