/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.work.basedata.model.StructuredDataModel;
import com.kingdee.eas.csinterface.agent.service.work.basedata.snapshot.ChangefulBillData;
import com.kingdee.eas.csinterface.agent.service.work.basedata.thread.BaseDataRunner;
import com.kingdee.eas.csinterface.agent.service.work.basedata.util.DataModelUtil;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynColumnInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynHeadInfo;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynPublisherFacadeFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynSubPlanCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableCollection;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableFactory;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynHead;
import com.kingdee.eas.csinterface.basedatasyn.IBaseDataSynTable;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynCheckUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.json.JSONObject;
import com.kingdee.eas.csinterface.monitor.MonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class BaseDataSynUtil {
    private static Logger logger = Logger.getLogger(BaseDataSynUtil.class);
    public static Map<String, String> INTERFACE_PLAN_LOG = new ConcurrentHashMap<String, String>();
    public static final String CONN_KEY = "Conn";
    public static final List<String> actionTypes = Arrays.asList("ADD", "UPDATE", "DELETE", "ADD_UPDATE");
    public static final Integer MAXCOUNT = 40000;
    public static Map<String, Boolean> existCTable = new HashMap<String, Boolean>(100);
    public static ThreadLocal<Boolean> localHasWhere = new ThreadLocal();

    public static boolean checkPlanHasPublish(Context ctx, String planNumber) throws BOSException, EASBizException {
        boolean result = false;
        BaseDataSynHeadInfo headInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo("where number='" + planNumber + "'");
        if (headInfo == null) {
            throw new BOSException("\u65b9\u6848\u7f16\u7801\uff08" + planNumber + "\uff09\u4e0d\u5b58\u5728\uff0c\u53d1\u5e03\u6821\u9a8c\u5931\u8d25");
        }
        result = BaseDataSynUtil.checkPlanHasPublish(ctx, headInfo);
        return result;
    }

    public static boolean checkPlanHasPublish(Context ctx, BaseDataSynHeadInfo headInfo) throws BOSException, EASBizException {
        boolean result = false;
        boolean isMultiPlan = headInfo.isMultiPlan();
        if (isMultiPlan) {
            BaseDataSynSubPlanCollection subPlans = headInfo.getPlans();
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < subPlans.size(); ++i) {
                idSet.add(subPlans.get(i).getSubPlanId());
            }
            String[] idArray = idSet.toArray(new String[0]);
            IBaseDataSynHead instance = BaseDataSynHeadFactory.getLocalInstance(ctx);
            Map map = instance.convertId2CoreBaseInfo(idArray);
            for (CoreBaseInfo baseInfo : map.values()) {
                BaseDataSynHeadInfo subPlan = (BaseDataSynHeadInfo)baseInfo;
                result = BaseDataSynUtil.checkPlanAllTablePublished(ctx, subPlan);
                if (result) continue;
                return false;
            }
        } else {
            result = BaseDataSynUtil.checkPlanAllTablePublished(ctx, headInfo);
        }
        return result;
    }

    public static List<String> getMainPKListForAdd(Context ctx, String planNumber, String extendSQL, boolean isFirst) throws BOSException, EASBizException, Exception {
        return BaseDataSynUtil.getMainTableIDListForAdd(ctx, planNumber, extendSQL, isFirst);
    }

    public static List<String> getMainPKList(Context ctx, String planNumber) throws BOSException, EASBizException, Exception {
        return BaseDataSynUtil.getMainTableIDListForAdd(ctx, planNumber, null);
    }

    public static List<String> getMainPKListForUpdate(Context ctx, String planNumber, String extendSQL, boolean isFirst) throws BOSException, EASBizException, Exception {
        return BaseDataSynUtil.getUpdateIDListForJDBC(ctx, planNumber, extendSQL, isFirst);
    }

    public static List<String> getMainPKListForDelete(Context ctx, String planNumber) throws BOSException, EASBizException, Exception {
        return BaseDataSynUtil.getMainTableIDListForDelete(ctx, planNumber, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getDeleteIdByTable(Context ctx, BaseDataSynTableInfo tableInfo, String connectionId, List<String> mainIdList, String extendSQL) throws BOSException, EASBizException, Exception {
        if (tableInfo.isMainTable() && mainIdList != null) {
            return mainIdList;
        }
        ArrayList<String> deleteIDList = new ArrayList<String>();
        String pkTableName = tableInfo.getPkTableName();
        String tableName = tableInfo.getTableName();
        StructuredDataModel dataModel = DataModelUtil.convert(tableInfo, ctx, true);
        StructuredDataModel.TableModel[] tableModels = dataModel.getPriorityTables();
        StructuredDataModel.TableModel header = tableModels[0];
        StructuredDataModel.TableModel entry = tableModels[1];
        String pkField = "FID";
        for (int i = 0; i < entry.columns.length; ++i) {
            String columnName = entry.columns[i].name;
            if (!entry.columns[i].isPk) continue;
            pkField = columnName;
            break;
        }
        String getdeleteIDSQL = "select top " + MAXCOUNT + " p.headpk from " + pkTableName.replace("\"", "") + " p where not exists(select 1 from " + tableName + " t1 where p.headpk = t1." + pkField + ") and p.agentId='" + connectionId + "'";
        if (tableInfo.isMainTable()) {
            String srcWhere = tableInfo.getSrcWhere();
            if (!StringUtils.isEmpty((String)srcWhere)) {
                if (StringUtils.startsWithIgnoreCase((String)srcWhere, (String)"where")) {
                    srcWhere = StringUtils.replaceIgnoreCase((String)srcWhere, (String)"where", (String)"");
                }
                getdeleteIDSQL = "select top " + MAXCOUNT + " p.headpk from (select t1.fid from " + tableName + " t1 where 1=1 and " + srcWhere + " ) as t1  right join " + pkTableName + " p on t1.fid = p.headpk where p.headpk in (select p.headpk from " + pkTableName + " as p where p.agentId='" + connectionId + "' and not exists (select 1 from " + tableName + " where fid= p.headpk)) and p.agentId='" + connectionId + "'";
            } else {
                getdeleteIDSQL = "select top " + MAXCOUNT + " p.headpk from (select t1.fid from " + tableName + " t1 where 1=1 ) as t1  right join " + pkTableName + " p on t1.fid = p.headpk where p.headpk in (select p.headpk from " + pkTableName + " as p where p.agentId='" + connectionId + "' and not exists (select 1 from " + tableName + " where fid= p.headpk)) and p.agentId='" + connectionId + "'";
            }
            if (!StringUtils.isEmpty((String)extendSQL)) {
                getdeleteIDSQL = extendSQL.trim().toUpperCase(Locale.ENGLISH).endsWith("AND") ? getdeleteIDSQL + " " + extendSQL : getdeleteIDSQL + " and  " + extendSQL;
            }
        } else {
            getdeleteIDSQL = "select top " + MAXCOUNT + " p.headpk from (select t1.fid from " + tableName + " t1 where 1=1) as t1  right join " + pkTableName + " p on t1.fid = p.headpk where p.headpk in (select p.headpk from " + pkTableName + " as p where p.agentId='" + connectionId + "' and not exists (select 1 from " + tableName + " where fid= p.headpk)) and p.agentId='" + connectionId + "' ";
            if (mainIdList != null && !mainIdList.isEmpty()) {
                getdeleteIDSQL = getdeleteIDSQL + " and p.mainpk in (" + com.kingdee.eas.csinterface.agent.service.base.util.StringUtils.converList2String(mainIdList, ",", "'") + ")";
            }
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        long beginTime = System.currentTimeMillis();
        try {
            conn = DBUtils.getConnection(ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(getdeleteIDSQL);
            rs.setFetchSize(10000);
            while (rs.next()) {
                String headpk = rs.getString("headpk");
                deleteIDList.add(headpk);
            }
            if (deleteIDList.isEmpty()) {
                tableInfo.setExtendedProperty("getdeleteIDSQL", getdeleteIDSQL);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
            long endTime = System.currentTimeMillis();
            StringBuffer recordBuffer = new StringBuffer();
            recordBuffer.append("\u5220\u9664\u6267\u884c\u7684KSQL\uff1a" + getdeleteIDSQL + "\r");
            recordBuffer.append("\u6267\u884c\u60c5\u51b5\uff1a\u603b\u884c\u6570\uff1a" + deleteIDList.size() + "\uff0c\u8017\u65f6\uff1a" + (endTime - beginTime) + "ms \r");
            ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo(recordBuffer.toString());
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        long endTime = System.currentTimeMillis();
        StringBuffer recordBuffer = new StringBuffer();
        recordBuffer.append("\u5220\u9664\u6267\u884c\u7684KSQL\uff1a" + getdeleteIDSQL + "\r");
        recordBuffer.append("\u6267\u884c\u60c5\u51b5\uff1a\u603b\u884c\u6570\uff1a" + deleteIDList.size() + "\uff0c\u8017\u65f6\uff1a" + (endTime - beginTime) + "ms \r");
        ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo(recordBuffer.toString());
        return deleteIDList;
    }

    public static List<String> getDeleteIdByTable(Context ctx, BaseDataSynTableInfo tableInfo, String connectionId, List<String> mainIdList, String extendSQL, boolean isFirst) throws BOSException, EASBizException, Exception {
        List<String> delList = BaseDataSynUtil.getDeleteIdByTable(ctx, tableInfo, connectionId, mainIdList, extendSQL);
        if (null != delList && delList.size() == 0 && isFirst) {
            String deleteIDSQL = tableInfo.getExtendedProperty("getdeleteIDSQL");
            MonitorLogInfo current = MonitorManager.getCurrent();
            String warnMsg = current.getExtendedProperty("warnMsg");
            if (warnMsg == null) {
                com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
                jsonObject.put(tableInfo.getTableName(), (Object)("\n-----------------------\n\u8b66\u544a\u4fe1\u606f\uff1a \u6ca1\u6709\u627e\u5230\u9700\u8981\u5220\u9664\u540c\u6b65\u7684\u6570\u636e\uff0c\u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a\n" + deleteIDSQL));
                current.setExtendedProperty("warnMsg", JSON.toJSONString((Object)jsonObject));
            } else {
                com.alibaba.fastjson.JSONObject parseObject = JSON.parseObject((String)warnMsg);
                parseObject.put(tableInfo.getTableName(), (Object)("\n-----------------------\n\u8b66\u544a\u4fe1\u606f\uff1a \u6ca1\u6709\u627e\u5230\u9700\u8981\u5220\u9664\u540c\u6b65\u7684\u6570\u636e\uff0c\u67e5\u8be2\u6761\u4ef6\u4e3a\uff1a\n" + deleteIDSQL));
                current.setExtendedProperty("warnMsg", JSON.toJSONString((Object)parseObject));
            }
        }
        return delList;
    }

    public static List<String> getMainPKListForDelete(Context ctx, String planNumber, String extendSQL) throws BOSException, EASBizException, Exception {
        return BaseDataSynUtil.getMainTableIDListForDelete(ctx, planNumber, extendSQL);
    }

    public static void getMainPKList(Context ctx, String planNumber, String scheduleId) throws BOSException, EASBizException {
        BaseDataSynHeadInfo headInfo = BaseDataSynUtil.getHeadInfo(ctx, planNumber);
    }

    public static void getMainPKList(Context ctx, String planNumber, String mainSQL, List<String> mainPKList) throws BOSException, EASBizException {
    }

    public static void getMainPKList(Context ctx, String planNumber, String scheduleId, String mainSQL, List<String> mainPKList) throws BOSException, EASBizException, Exception {
        EIPLicenseCheckUtil.checkLicenseEnough(ctx);
        BaseDataSynHeadInfo headInfo = BaseDataSynUtil.getHeadInfo(ctx, planNumber);
        BaseDataSynTableInfo mianTable = BaseDataSynUtil.getMainTableInfo(ctx, planNumber);
    }

    public static List<BaseDataSynTableInfo> getSortedTables(BaseDataSynHeadInfo headInfo) throws Exception {
        BaseDataSynTableCollection tableCols = headInfo.getTableEntrys();
        ArrayList<BaseDataSynTableInfo> tmpList = new ArrayList<BaseDataSynTableInfo>();
        for (int i = 0; i < tableCols.size(); ++i) {
            BaseDataSynTableInfo tableInfo = tableCols.get(i);
            tmpList.add(tableInfo);
        }
        Collections.sort(tmpList, new Comparator<BaseDataSynTableInfo>(){

            @Override
            public int compare(BaseDataSynTableInfo o1, BaseDataSynTableInfo o2) {
                return o1.getLevel() - o2.getLevel();
            }
        });
        return tmpList;
    }

    public static List<BaseDataSynTableInfo> getSortedTablesDesc(BaseDataSynHeadInfo headInfo) throws Exception {
        BaseDataSynTableCollection tableCols = headInfo.getTableEntrys();
        ArrayList<BaseDataSynTableInfo> tmpList = new ArrayList<BaseDataSynTableInfo>();
        for (int i = 0; i < tableCols.size(); ++i) {
            BaseDataSynTableInfo tableInfo = tableCols.get(i);
            tmpList.add(tableInfo);
        }
        Collections.sort(tmpList, new Comparator<BaseDataSynTableInfo>(){

            @Override
            public int compare(BaseDataSynTableInfo o1, BaseDataSynTableInfo o2) {
                return o2.getLevel() - o1.getLevel();
            }
        });
        return tmpList;
    }

    public static BaseDataSynHeadInfo getHeadInfo(Context ctx, String number) throws BOSException, EASBizException {
        BaseDataSynHeadInfo headInfo = BaseDataSynHeadFactory.getLocalInstance(ctx).getBaseDataSynHeadInfo("where number = '" + number + "'");
        return headInfo;
    }

    public static void checkPlanValid(Context ctx, String planNumber) throws BOSException, EASBizException {
        BaseDataSynHeadInfo headInfo = BaseDataSynUtil.getHeadInfo(ctx, planNumber);
        if (headInfo == null) {
            throw new BOSException("\u540c\u6b65\u65b9\u6848\uff08" + planNumber + "\uff09\u4e0d\u5b58\u5728");
        }
        ConnectionInfo connection = headInfo.getConn();
        if (connection == null) {
            throw new BOSException("\u540c\u6b65\u65b9\u6848\u914d\u7f6e\u7684\u8fde\u63a5\u4e0d\u5b58\u5728");
        }
        if (!headInfo.isPublished()) {
            BaseDataSynPublisherFacadeFactory.getLocalInstance(ctx).publish(headInfo.getId().toString());
        }
    }

    private static List<String> getMainTableIDListForAddNew(Context ctx, String planNumber, String extendSQL) throws BOSException, EASBizException, Exception {
        ArrayList<String> pkList = new ArrayList<String>();
        BaseDataSynHeadInfo headInfo = BaseDataSynUtil.getHeadInfo(ctx, planNumber);
        String connId = MonitorManager.getCurrent().getExtendedProperty("connId");
        BaseDataSynTableInfo tableInfo = BaseDataSynUtil.getMainTableInfo(ctx, headInfo);
        BaseDataRunner.deleteInvalidRecord(ctx, tableInfo.getPkTableName(), connId);
        String specialSQL = tableInfo.getSrcWhere();
        specialSQL = BaseDataSynUtil.expendExtendSQL(specialSQL, extendSQL);
        BaseDataRunner baseDataRunner = null;
        baseDataRunner = new BaseDataRunner(tableInfo, ctx, 1, MAXCOUNT, true, "", specialSQL, tableInfo.getRelateSQL(), true, connId);
        String ksql = baseDataRunner.initQuerySqlAddID(tableInfo.getTableName(), connId);
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        Statement prepareStmt = null;
        try {
            String s = "";
            conn = DBUtils.getConnection(ctx);
            s = DBUtils.isPostgresSQL(conn) ? ksql : (!(conn instanceof KDConnection) ? TransUtil.Translate((String)ksql, (int)DBUtils.getDBType(conn)) : ksql);
            try {
                ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo("\u4e3b\u8868\u65b0\u589eSQL:" + s + "\r");
            }
            catch (Exception exception) {
                // empty catch block
            }
            stmt = conn.createStatement();
            resultSet = DBUtil.isOracle((Connection)conn) ? stmt.executeQuery(ksql) : stmt.executeQuery(s);
            while (resultSet.next()) {
                String fid = resultSet.getString("FID");
                pkList.add(fid);
            }
        }
        catch (Exception sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(prepareStmt);
                SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(prepareStmt);
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return pkList;
    }

    private static List<String> getMainTableIDListForAdd(Context ctx, String planNumber, String extendSQL) throws BOSException, EASBizException, Exception {
        return BaseDataSynUtil.getMainTableIDListForAdd(ctx, planNumber, extendSQL, false);
    }

    private static List<String> getMainTableIDListForAdd(Context ctx, String planNumber, String extendSQL, boolean isFirst) throws BOSException, EASBizException, Exception {
        BaseDataSynHeadInfo headInfo = BaseDataSynUtil.getHeadInfo(ctx, planNumber);
        BaseDataSynTableInfo tableInfo = BaseDataSynUtil.getMainTableInfo(ctx, headInfo);
        return BaseDataSynUtil.getSubMainIDsForAdd(ctx, headInfo, extendSQL, isFirst, tableInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getSubMainIDsForAdd(Context ctx, BaseDataSynHeadInfo headInfo, String extendSQL, boolean isFirst, BaseDataSynTableInfo tableInfo) throws Exception {
        ArrayList<String> pkList = new ArrayList<String>();
        String connId = MonitorManager.getCurrent().getExtendedProperty("connId");
        String specialSQL = tableInfo.getSrcWhere();
        boolean hasWhere = true;
        if (StringUtils.isEmpty((String)specialSQL) && StringUtils.isEmpty((String)extendSQL) && BaseDataRunner.isClearAllInvalidRecord(tableInfo.getPkTableName())) {
            BaseDataRunner.deleteInvalidRecord(ctx, tableInfo.getPkTableName(), connId);
            hasWhere = false;
        }
        localHasWhere.set(hasWhere);
        specialSQL = BaseDataSynUtil.expendExtendSQL(specialSQL, extendSQL);
        String tableName = tableInfo.getTableName();
        BaseDataRunner baseDataRunner = new BaseDataRunner(tableInfo, ctx, 1, MAXCOUNT, true, "", specialSQL, tableInfo.getRelateSQL(), true, connId);
        String ksql = baseDataRunner.initQuerySqlAddID(tableName, connId);
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        String s = "";
        String beforeSQLDefine = tableInfo.getBeforeSQL();
        if (!StringUtils.isEmpty((String)beforeSQLDefine)) {
            BaseDataSynUtil.addBeforeSQLCheck(ctx, pkList, connId, tableInfo, ksql, beforeSQLDefine);
        } else {
            try {
                conn = DBUtils.getConnection(ctx);
                s = DBUtils.isPostgresSQL(conn) ? ksql : (!(conn instanceof KDConnection) ? TransUtil.Translate((String)ksql, (int)DBUtils.getDBType(conn)) : ksql);
                try {
                    ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo("\u4e3b\u8868\u65b0\u589eSQL:" + s + "\r");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stmt = conn.createStatement();
                resultSet = DBUtil.isOracle((Connection)conn) ? stmt.executeQuery(ksql) : stmt.executeQuery(s);
                while (resultSet.next()) {
                    String fid = resultSet.getString("FID");
                    if (StringUtils.isEmpty((String)fid)) continue;
                    pkList.add(fid);
                }
            }
            catch (Exception sqle) {
                try {
                    throw sqle;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        }
        HashSet<String> h = new HashSet<String>();
        h.addAll(pkList);
        pkList.clear();
        pkList.addAll(h);
        if (pkList.size() != 0) return pkList;
        if (!isFirst) return pkList;
        MonitorLogInfo current = MonitorManager.getCurrent();
        String warnMsg = current.getExtendedProperty("warnMsg");
        if (warnMsg == null) {
            com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
            jsonObject.put(headInfo.getNumber(), (Object)("\n-----------------------\n\u8b66\u544a\u4fe1\u606f\uff1a \u6ca1\u6709\u627e\u5230\u9700\u8981\u65b0\u589e\u540c\u6b65\u7684\u6570\u636e" + ("".equals(s) ? s : " , \u67e5\u8be2\u6761\u4ef6\u4e3a : \n" + s)));
            current.setExtendedProperty("warnMsg", JSON.toJSONString((Object)jsonObject));
            return pkList;
        }
        com.alibaba.fastjson.JSONObject parseObject = JSON.parseObject((String)warnMsg);
        parseObject.put(headInfo.getNumber(), (Object)("\n-----------------------\n\u8b66\u544a\u4fe1\u606f\uff1a \u6ca1\u6709\u627e\u5230\u9700\u8981\u65b0\u589e\u540c\u6b65\u7684\u6570\u636e" + ("".equals(s) ? s : " , \u67e5\u8be2\u6761\u4ef6\u4e3a : \n" + s)));
        current.setExtendedProperty("warnMsg", JSON.toJSONString((Object)parseObject));
        return pkList;
    }

    public static void addBeforeSQLCheck(Context ctx, List<String> pkList, String connId, BaseDataSynTableInfo tableInfo, String ksql, String beforeSQLDefine) throws Exception {
        if (StringUtils.isEmpty((String)beforeSQLDefine)) {
            return;
        }
        if (beforeSQLDefine.indexOf("selfSQL") > -1) {
            BaseDataSynCheckUtil.addBeforeSQLCheckIfNeed(ctx, tableInfo, ksql, pkList, connId, beforeSQLDefine);
        } else {
            BaseDataSynCheckUtil.addBeforeSQLCheckNew(ctx, tableInfo, ksql, pkList, connId, beforeSQLDefine);
        }
    }

    @Deprecated
    private static void addBeforeSQLCheckIfNeed(Context ctx, BaseDataSynTableInfo tableInfo, String ksql, List<String> pkList, String connId, String beforeSQLDefine) throws Exception {
        StringBuffer hasExistValueBuffer = new StringBuffer();
        String[] eachSQLCode = beforeSQLDefine.split(" ");
        hasExistValueBuffer.append("\u6821\u9a8c\u7684SQL\uff1a" + beforeSQLDefine + "\n");
        LinkedHashMap<String, String> valueSQLCode = new LinkedHashMap<String, String>();
        StringBuffer checkFiled = new StringBuffer();
        for (String sqlCode : eachSQLCode) {
            if (sqlCode.indexOf("${") != 0) continue;
            String temp = sqlCode.substring(2, sqlCode.indexOf("}"));
            String sqlTemp = sqlCode.substring(0, sqlCode.indexOf("}") + 1);
            valueSQLCode.put(temp, sqlTemp);
            if (checkFiled.length() > 0) {
                checkFiled.append(",");
            }
            checkFiled.append(temp);
        }
        hasExistValueBuffer.append("\u6821\u9a8c\u7684\u5b57\u6bb5\uff1a" + checkFiled.toString() + "\n");
        StringBuffer checkSQLBuffer = new StringBuffer();
        String beforeStr = beforeSQLDefine.substring(0, beforeSQLDefine.indexOf("["));
        String roopStr = beforeSQLDefine.substring(beforeSQLDefine.indexOf("[") + 1, beforeSQLDefine.indexOf("]"));
        String afterStr = beforeSQLDefine.substring(beforeSQLDefine.indexOf("]") + 1, beforeSQLDefine.length());
        checkSQLBuffer.append(beforeStr);
        String newRoopStr = roopStr;
        ArrayList checkAddList = new ArrayList();
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        HashMap<String, Object> execMap = null;
        HashMap<String, String> fidMap = new HashMap<String, String>();
        String s = "";
        conn = DBUtils.getConnection(ctx);
        s = !(conn instanceof KDConnection) ? TransUtil.Translate((String)ksql, (int)DBUtils.getDBType(conn)) : ksql;
        stmt = conn.createStatement();
        resultSet = DBUtil.isOracle((Connection)conn) ? stmt.executeQuery(ksql) : stmt.executeQuery(s);
        while (resultSet.next()) {
            String fid = resultSet.getString("FID");
            pkList.add(fid);
            StringBuffer value = new StringBuffer();
            execMap = new HashMap<String, Object>();
            boolean isFirst = false;
            for (String key : valueSQLCode.keySet()) {
                execMap.put(key, resultSet.getObject(key));
                if (isFirst) {
                    value.append("_");
                }
                isFirst = true;
                value.append(resultSet.getObject(key));
            }
            checkAddList.add(execMap);
            fidMap.put(fid, value.toString());
        }
        ArrayList<String> batchSQLList = new ArrayList<String>();
        StringBuffer eachShouldCheckBuffer = new StringBuffer();
        int execMapIndex = 1;
        StringBuffer tmpRoopStrBuffer = new StringBuffer();
        for (int i = 0; i < checkAddList.size(); ++i) {
            if (execMapIndex == 1) {
                eachShouldCheckBuffer = new StringBuffer();
                eachShouldCheckBuffer.append(beforeStr);
                eachShouldCheckBuffer.append(" (");
            }
            if (execMapIndex > 1) {
                eachShouldCheckBuffer.append(" or ");
            }
            ++execMapIndex;
            Map map = (Map)checkAddList.get(i);
            String finalRoopStr = roopStr;
            eachShouldCheckBuffer.append("(");
            for (String key : valueSQLCode.keySet()) {
                finalRoopStr = finalRoopStr.replace((CharSequence)valueSQLCode.get(key), "'" + String.valueOf(map.get(key)) + "'");
            }
            eachShouldCheckBuffer.append(" " + finalRoopStr + " ");
            eachShouldCheckBuffer.append(")");
            if (execMapIndex % 100 != 0) continue;
            tmpRoopStrBuffer.append(eachShouldCheckBuffer);
            tmpRoopStrBuffer.append(") ");
            tmpRoopStrBuffer.append(afterStr);
            batchSQLList.add(tmpRoopStrBuffer.toString());
            tmpRoopStrBuffer = new StringBuffer();
            execMapIndex = 1;
        }
        System.out.println("------ \u51c6\u5907\u6267\u884c\u6821\u9a8c\u7684SQL ----" + eachShouldCheckBuffer.toString());
        logger.error((Object)"ssss");
        if (eachShouldCheckBuffer.length() > 0) {
            eachShouldCheckBuffer.append(") ");
            eachShouldCheckBuffer.append(afterStr);
            batchSQLList.add(eachShouldCheckBuffer.toString());
        }
        ConnectionInfo connInfo = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(connId));
        DataBaseType dbType = DataBaseType.getInstance(connInfo.getDBType().getName());
        Connection connection = null;
        Statement statement = null;
        try {
            connection = KSQLUtil.getKSQLConnection(dbType, connInfo.getIP(), connInfo.getPort(), connInfo.getInstance(), connInfo.getUsername(), connInfo.getPassword());
            statement = connection.createStatement();
            hasExistValueBuffer.append("\u6570\u636e\u5bf9\u7167\u5173\u7cfb\uff1a\u6e90\u6807\u5fd7\u503c\uff0c\u76ee\u6807\u6807\u5fd7\u503c\uff0c\u5177\u4f53\u7684\u503c\u7ec4\u5408\n");
            for (int i = 0; i < batchSQLList.size(); ++i) {
                ResultSet rs = null;
                try {
                    rs = statement.executeQuery((String)batchSQLList.get(i));
                    while (rs.next()) {
                        String code = rs.getString("code");
                        String value = rs.getString("value");
                        for (String key : fidMap.keySet()) {
                            if (!((String)fidMap.get(key)).equals(value) || key.equals(code)) continue;
                            pkList.remove(key);
                            hasExistValueBuffer.append(key).append(" , " + code).append(" , ").append(value).append("\r\n");
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, statement, connection);
                MonitorManager.getCurrentBaseDataDown().setExtendedProperty("extContext", hasExistValueBuffer.toString());
                logger.error((Object)("---EIP\u57fa\u7840\u8d44\u6599\u540c\u6b65\u68c0\u67e5\u5230\u6570\u636e\u4e00\u81f4\u65f6\u7684LOG----" + hasExistValueBuffer.toString() + "------------"));
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)statement, (Connection)connection);
        MonitorManager.getCurrentBaseDataDown().setExtendedProperty("extContext", hasExistValueBuffer.toString());
        logger.error((Object)("---EIP\u57fa\u7840\u8d44\u6599\u540c\u6b65\u68c0\u67e5\u5230\u6570\u636e\u4e00\u81f4\u65f6\u7684LOG----" + hasExistValueBuffer.toString() + "------------"));
    }

    private static List<String> getUpdateIDListForJDBC(Context ctx, String planNumber, String extendSQL, boolean isFirst) throws BOSException, EASBizException, Exception {
        BaseDataSynHeadInfo headInfo = BaseDataSynUtil.getHeadInfo(ctx, planNumber);
        BaseDataSynTableInfo tableInfo = BaseDataSynUtil.getMainTableInfo(ctx, headInfo);
        return BaseDataSynUtil.getSubUpdateIDsForJDBC(ctx, headInfo, extendSQL, isFirst, tableInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getSubUpdateIDsForJDBC(Context ctx, BaseDataSynHeadInfo headInfo, String extendSQL, boolean isFirst, BaseDataSynTableInfo tableInfo) throws Exception, SQLException {
        String connId = MonitorManager.getCurrent().getExtendedProperty("connId");
        String agent4http = MonitorManager.getCurrent().getExtendedProperty("agentId4http");
        boolean isMainTable = tableInfo.isMainTable();
        String tableName = tableInfo.getTableName();
        String specialSQL = tableInfo.getSrcWhere();
        specialSQL = BaseDataSynUtil.expendExtendSQL(specialSQL, extendSQL);
        BaseDataRunner baseDataRunner = null;
        StructuredDataModel dataModel = null;
        String ksql = "";
        if (!StringUtils.isEmpty((String)connId)) {
            baseDataRunner = new BaseDataRunner(tableInfo, ctx, 1, MAXCOUNT, true, "", specialSQL, tableInfo.getRelateSQL(), true, connId);
            dataModel = baseDataRunner.dataModel;
            ksql = baseDataRunner.initQuerySql4ChangeJDBC(tableName, connId, isMainTable, false, "");
        } else if (!StringUtils.isEmpty((String)agent4http)) {
            baseDataRunner = new BaseDataRunner(tableInfo, ctx, 1, MAXCOUNT, true, "", specialSQL, tableInfo.getRelateSQL(), true, agent4http);
            dataModel = baseDataRunner.dataModel;
            ksql = baseDataRunner.initQuerySql4ChangeJDBC(tableName, agent4http, isMainTable, false, "");
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        JSONObject hashCodeObj = new JSONObject();
        ArrayList<String> mainUpdateIdList = new ArrayList<String>();
        String s = ksql;
        try {
            conn = DBUtils.getConnection(ctx);
            stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery(ksql);
            }
            catch (Exception e) {
                logger.error((Object)("\u6267\u884csql\u5931\u8d25\uff1a" + ksql));
                throw e;
            }
            try {
                ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).getRecordBaseDataLog().recordTableExecInfo("\u4e3b\u8868\u66f4\u65b0SQL:" + s + "\r");
            }
            catch (Exception e) {
                // empty catch block
            }
            StringBuffer addIds = new StringBuffer();
            StringBuffer updateIds = new StringBuffer();
            StringBuffer deleteIds = new StringBuffer();
            StringBuffer columns = new StringBuffer();
            StringBuffer changeColumns = new StringBuffer();
            String pkField = "";
            if (baseDataRunner == null) {
                throw new NullPointerException();
            }
            StructuredDataModel.TableModel[] tableModels = baseDataRunner.dataModel.getPriorityTables();
            StructuredDataModel.TableModel header = tableModels[0];
            StructuredDataModel.TableModel entry = tableModels[1];
            StringBuilder sqlBuf = new StringBuilder();
            for (int i = 0; i < entry.columns.length; ++i) {
                String columnName = entry.columns[i].name;
                if (entry.columns[i].isPk) {
                    pkField = columnName;
                }
                columns.append(columnName + ",");
                if (!entry.columns[i].isChangeSyn) continue;
                changeColumns.append(columnName + ",");
            }
            String[] sortedChangefulFields = null;
            sortedChangefulFields = isMainTable ? ChangefulBillData.getSortedChangefulFields4BaseData(dataModel) : ChangefulBillData.getSortedChangefulFields(dataModel);
            String changeTime = "";
            if (isMainTable) {
                BaseDataSynColumnInfo info = BaseDataSynColumnFactory.getLocalInstance(ctx).getBaseDataSynColumnInfo(" where parent = '" + tableInfo.getParent().getId().toString() + "' and pkTime = 1 and tableName='" + tableName + "'");
                changeTime = info.getColName();
            }
            changeColumns.append("fid,");
            ChangefulBillData changefulBillData = new ChangefulBillData(sortedChangefulFields, true, DBUtil.isOracle((Connection)conn));
            while (rs.next()) {
                if (isMainTable) {
                    String headpk = rs.getString("headPk");
                    String fid = rs.getString("fid");
                    changefulBillData.appendFieldBytes4MainTable(rs);
                    changefulBillData.snapshot4MainTable();
                    String newChangeTime = changefulBillData.getNewChangeTime();
                    if (StringUtils.isEmpty((String)headpk) || StringUtils.isEmpty((String)fid) || rs.getString("changeTime") == null && rs.getString(changeTime) == null || StringUtils.isEmpty((String)headpk)) continue;
                    mainUpdateIdList.add(headpk);
                    hashCodeObj.put(headpk, newChangeTime);
                    continue;
                }
                String headPK = rs.getString("headpk");
                String oldhashCode = rs.getString("hashCode");
                String pkValue = rs.getString(pkField);
                changefulBillData.appendFieldBytes(rs);
                changefulBillData.snapshot();
                String newHashCode = changefulBillData.getNewHashCode();
                if (StringUtils.isEmpty((String)headPK)) {
                    addIds.append("'" + pkValue + "',");
                    hashCodeObj.put(pkValue, newHashCode);
                    continue;
                }
                if (StringUtils.isEmpty((String)pkValue) || StringUtils.equals((String)oldhashCode, (String)newHashCode)) continue;
                updateIds.append("'" + headPK + "',");
                hashCodeObj.put(pkValue, newHashCode);
            }
            if (!isMainTable) {
                String deleteSQL = "select p.headpk from " + tableInfo.getPkTableName().replace("\"", "") + " p where not exists(select 1 from " + tableName + " t1 where p.headpk = t1." + pkField + ") and p.agentId='" + connId + "'";
                conn = DBUtils.getConnection(ctx);
                stmt = conn.createStatement();
                rs = stmt.executeQuery(deleteSQL);
                while (rs.next()) {
                    String headpk = rs.getString("headpk");
                    deleteIds.append("'" + headpk + "',");
                }
            }
            if (isMainTable && updateIds.length() > 0) {
                updateIds.deleteCharAt(updateIds.lastIndexOf(","));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        }
        catch (SQLException sqle) {
            throw sqle;
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
        }
        if (mainUpdateIdList.size() != 0) return mainUpdateIdList;
        if (!isFirst) return mainUpdateIdList;
        MonitorLogInfo current = MonitorManager.getCurrent();
        String warnMsg = current.getExtendedProperty("warnMsg");
        if (warnMsg == null) {
            com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
            jsonObject.put(headInfo.getNumber(), (Object)("\n-----------------------\n\u8b66\u544a\u4fe1\u606f\uff1a \u6ca1\u6709\u627e\u5230\u9700\u8981\u66f4\u65b0\u540c\u6b65\u7684\u6570\u636e , \u67e5\u8be2\u6761\u4ef6\u4e3a : \n" + s));
            current.setExtendedProperty("warnMsg", JSON.toJSONString((Object)jsonObject));
            return mainUpdateIdList;
        }
        com.alibaba.fastjson.JSONObject parseObject = JSON.parseObject((String)warnMsg);
        parseObject.put(headInfo.getNumber(), (Object)("\n-----------------------\n\u8b66\u544a\u4fe1\u606f\uff1a \u6ca1\u6709\u627e\u5230\u9700\u8981\u66f4\u65b0\u540c\u6b65\u7684\u6570\u636e , \u67e5\u8be2\u6761\u4ef6\u4e3a : \n" + s));
        current.setExtendedProperty("warnMsg", JSON.toJSONString((Object)parseObject));
        return mainUpdateIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static List<String> getMainTableIDListForDelete(Context ctx, String planNumber, String extendSQL) throws BOSException, EASBizException, Exception {
        ArrayList<String> pkList = new ArrayList<String>();
        BaseDataSynHeadInfo headInfo = BaseDataSynUtil.getHeadInfo(ctx, planNumber);
        String connId = MonitorManager.getCurrent().getExtendedProperty("connId");
        ConnectionInfo connection = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo(CommonUtil.convert2PK(connId));
        BaseDataSynTableInfo tableInfo = BaseDataSynUtil.getMainTableInfo(ctx, headInfo);
        BaseDataRunner.deleteInvalidRecord(ctx, tableInfo.getPkTableName(), connection.getId().toString());
        String specialSQL = tableInfo.getSrcWhere();
        if (extendSQL != null) {
            specialSQL = specialSQL + " and " + extendSQL;
        }
        BaseDataRunner baseDataRunner = null;
        baseDataRunner = new BaseDataRunner(tableInfo, ctx, 1, Integer.MAX_VALUE, true, "", specialSQL, tableInfo.getRelateSQL(), true, "");
        String ksql = baseDataRunner.initQuerySqlAdd(tableInfo.getTableName(), connection.getId().toString());
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            String s = "";
            conn = DBUtils.getConnection(ctx);
            s = !(conn instanceof KDConnection) ? TransUtil.Translate((String)ksql, (int)DBUtils.getDBType(conn)) : ksql;
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(s);
            while (resultSet.next()) {
                pkList.add(resultSet.getString("FID"));
            }
        }
        catch (SqlTranslateException sqlTranslateException) {
            SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
            {
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet, stmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return pkList;
    }

    private static List<String> getMainTableDataList(Context ctx, String planNumber) throws BOSException, EASBizException, Exception {
        return null;
    }

    public static BaseDataSynTableInfo getMainTableInfo(Context ctx, String planNumber) throws BOSException, EASBizException {
        BaseDataSynTableInfo tableInfo = null;
        IBaseDataSynTable instacne = BaseDataSynTableFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)planNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("mainTable", (Object)true, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        BaseDataSynTableCollection entryColl = instacne.getBaseDataSynTableCollection(view);
        if (entryColl.size() > 0) {
            tableInfo = entryColl.get(0);
        }
        return tableInfo;
    }

    public static BaseDataSynTableInfo getMainTableInfo(Context ctx, BaseDataSynHeadInfo headInfo) throws BOSException, EASBizException {
        BaseDataSynTableInfo tableInfo = null;
        IBaseDataSynTable instacne = BaseDataSynTableFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)headInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("mainTable", (Object)true, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        BaseDataSynTableCollection entryColl = instacne.getBaseDataSynTableCollection(view);
        if (entryColl.size() > 0) {
            tableInfo = entryColl.get(0);
        }
        return tableInfo;
    }

    public static String expendExtendSQL(String specialSQL, String extendSQL) {
        if (specialSQL == null) {
            specialSQL = " 1 = 1  ";
        }
        if (StringUtils.isEmpty((String)extendSQL)) {
            return specialSQL;
        }
        if (extendSQL != null) {
            if (StringUtils.startsWithIgnoreCase((String)extendSQL, (String)"where")) {
                extendSQL = StringUtils.replaceIgnoreCase((String)extendSQL, (String)"where", (String)"");
            }
            specialSQL = extendSQL.matches("(?im)^and.*") ? specialSQL + extendSQL : specialSQL + " and " + extendSQL;
        }
        return specialSQL;
    }

    public static int getBaseDataSynActionType(String actionType) {
        int type = 0;
        if (actionTypes.get(0).equalsIgnoreCase(actionType)) {
            type = 400;
        } else if (actionTypes.get(1).equalsIgnoreCase(actionType)) {
            type = 500;
        } else if (actionTypes.get(2).equalsIgnoreCase(actionType)) {
            type = 800;
        } else if (actionTypes.get(3).equalsIgnoreCase(actionType)) {
            type = 700;
        }
        return type;
    }

    public static boolean checkPlanAllTablePublished(Context ctx, BaseDataSynHeadInfo headInfo) throws BOSException, EASBizException {
        if (headInfo != null) {
            BaseDataSynTableCollection tableColl = headInfo.getTableEntrys();
            Iterator tableIte = tableColl.iterator();
            BaseDataSynTableInfo tableInfo = null;
            while (tableIte.hasNext()) {
                tableInfo = (BaseDataSynTableInfo)tableIte.next();
                if (!StringUtils.isEmpty((String)tableInfo.getPkTableName())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkPlanHasInit(Context ctx, BaseDataSynHeadInfo headInfo, String extendSQL, String agentId) throws BOSException, EASBizException, Exception {
        boolean result = false;
        BaseDataSynTableInfo tableInfo = BaseDataSynUtil.getMainTableInfo(ctx, headInfo);
        BaseDataRunner.deleteInvalidRecord(ctx, tableInfo.getPkTableName(), agentId);
        extendSQL = BaseDataSynUtil.expendExtendSQL(extendSQL, "");
        String ksql = "select count(*) count from " + tableInfo.getPkTableName() + " where agentid = '" + agentId + "' " + extendSQL;
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            conn = DBUtils.getConnection(ctx);
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(ksql);
            while (resultSet.next()) {
                long count = resultSet.getLong("count");
                if (count <= 0L) continue;
                result = true;
            }
        }
        catch (Exception sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(resultSet, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet, (Statement)stmt, (Connection)conn);
        return result;
    }

    public static List<String> getMainPKListForAdd(Context ctx, BaseDataSynHeadInfo headInfo, BaseDataSynTableInfo mainableInfo, String extendSQL, boolean isFirst) throws BOSException, EASBizException, Exception {
        return BaseDataSynUtil.getSubMainIDsForAdd(ctx, headInfo, extendSQL, isFirst, mainableInfo);
    }

    public static List<String> getMainPKListForUpdate(Context ctx, BaseDataSynHeadInfo headInfo, BaseDataSynTableInfo tableInfo, String extendSQL, boolean isFirst) throws BOSException, EASBizException, Exception {
        return BaseDataSynUtil.getSubUpdateIDsForJDBC(ctx, headInfo, extendSQL, isFirst, tableInfo);
    }

    public static int caclMainPkCount(Context ctx, BaseDataSynHeadInfo baseDataSynInfo, BaseDataSynTableInfo mainTableInfo, String extendSQL, boolean isFirst, String execType) {
        String specialSQL = mainTableInfo.getSrcWhere();
        specialSQL = BaseDataSynUtil.expendExtendSQL(specialSQL, extendSQL);
        String connId = MonitorManager.getCurrent().getExtendedProperty("connId");
        String tableName = mainTableInfo.getTableName();
        String ksql = "";
        try {
            BaseDataRunner baseDataRunner = new BaseDataRunner(mainTableInfo, ctx, 1, -1, true, "", specialSQL, mainTableInfo.getRelateSQL(), true, connId);
            if ("add".equalsIgnoreCase(execType)) {
                ksql = baseDataRunner.initQuerySqlAddID(tableName, connId);
            } else if ("update".equalsIgnoreCase(execType)) {
                boolean isMainTable = mainTableInfo.isMainTable();
                ksql = baseDataRunner.initQuerySql4ChangeJDBC(tableName, connId, isMainTable, false, "");
            }
            RowSet rowSet = SQLUtils.getJdbcRowSet((Connection)DBUtils.getConnection(ctx), (String)ksql);
            if (rowSet.next()) {
                return rowSet.getInt(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return -1;
    }
}

