/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.app.util.basedatadel;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.csinterface.agent.service.work.basedata.saver.db.BaseDataSaver;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynTableInfo;
import com.kingdee.eas.csinterface.basedatasyn.app.util.BaseDataSynUtil;
import com.kingdee.eas.csinterface.basedatasyn.app.util.basedatadel.IBaseDataDelSynExecute;
import com.kingdee.eas.csinterface.monitor.MonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.SubMonitorLogFactory;
import com.kingdee.eas.csinterface.monitor.app.BaseDataDownMonitorLogInfo;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BaseDataDelSynByJDBCImpl
implements IBaseDataDelSynExecute {
    MonitorLogInfo curThreadMonitorInfo;

    @Override
    public boolean baseDataDelSynType(MonitorLogInfo curThreadMonitorInfo) {
        this.curThreadMonitorInfo = curThreadMonitorInfo;
        return curThreadMonitorInfo == null ? false : !StringUtils.isEmpty(curThreadMonitorInfo.getExtendedProperty("connId"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean baseDataDelSynExecute(Context ctx, List<String> candidateDelIds, BaseDataSynTableInfo tableInfo, BaseDataSaver saver) throws Exception {
        boolean hasNext = true;
        if (candidateDelIds.size() <= BaseDataSynUtil.MAXCOUNT && candidateDelIds.size() == 0) {
            hasNext = false;
            return hasNext;
        }
        String connectionId = this.curThreadMonitorInfo.getExtendedProperty("connId");
        String tempIds = "";
        ArrayList<String> tempIdList = new ArrayList();
        int perDeleteSize = 2000;
        long deletePkTableTime = 0L;
        long deleteDestTime = 0L;
        long deleteDestEnd = 0L;
        long deletePkTableEnd = 0L;
        int pageSize = (candidateDelIds.size() - 1) / perDeleteSize + 1;
        int begin = 0;
        int end = 0;
        HashSet<String> dillIds = new HashSet<String>();
        try {
            for (int i = 0; i < pageSize; ++i) {
                long beginTime = System.currentTimeMillis();
                begin = perDeleteSize * i;
                end = (i + 1) * perDeleteSize > candidateDelIds.size() ? candidateDelIds.size() : (i + 1) * perDeleteSize;
                tempIdList = candidateDelIds.subList(begin, end);
                dillIds.addAll(tempIdList);
                tempIds = StringUtils.converList2String(tempIdList, ",", "'");
                boolean isSucc = false;
                isSucc = saver.deleteDestDBData(tableInfo, tempIdList);
                deleteDestEnd = System.currentTimeMillis();
                deleteDestTime += deleteDestEnd - beginTime;
                saver.deletePKTableRecords(ctx, tableInfo, tempIds, connectionId);
                deletePkTableEnd = System.currentTimeMillis();
                deletePkTableTime += deletePkTableEnd - deleteDestEnd;
                saver.setSuccessNumber(dillIds);
                if (!isSucc) continue;
                saver.getDestJDBCConn().commit();
            }
        }
        catch (Exception e) {
            saver.setFailureNumber(dillIds);
            ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).setExtendedProperty("errorMsg", ThrowableHelper.toString(e));
            Logger.error((Throwable)e);
        }
        finally {
            ((BaseDataDownMonitorLogInfo)MonitorManager.getCurrent()).addChangeCount(dillIds.size());
            SubMonitorLogFactory.getLocalInstance(ctx).addLogWithoutTrans(saver, tableInfo.getTableName(), "del", tableInfo.isMainTable(), this.curThreadMonitorInfo.getExtendedProperty("currThreadBaseDataSynHeadNum"));
            this.curThreadMonitorInfo.setExtendedProperty("preDeleteDestTime", String.valueOf(deleteDestTime));
            this.curThreadMonitorInfo.setExtendedProperty("preDeletePkTableTime", String.valueOf(deletePkTableTime));
        }
        return false;
    }
}

