/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.basedatasyn.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.csinterface.basedatasyn.BaseDataSynValueMapInfo;
import com.kingdee.eas.csinterface.converter.core.Converter;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.util.CustColor;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class BaseDataSynValueMapExcelConverter
implements Converter {
    @Override
    public boolean canConvert(Class type) {
        return BaseDataSynValueMapInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        try {
            BaseDataSynValueMapInfo baseDataMapingInfo = (BaseDataSynValueMapInfo)source;
            WritableWorkbook writableWorkbook = (WritableWorkbook)context.get("WritableWorkbook");
            WritableSheet writableSheet = writableWorkbook.getSheet(0);
            this.marshalEntry(context, baseDataMapingInfo, writableSheet);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ICoreBase getCoreBaseInstance(Context ctx, String id) throws BOSException {
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)id, (boolean)true);
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        return coreBase;
    }

    private void marshalEntry(MarshallingContext context, BaseDataSynValueMapInfo baseDataMapingInfo, WritableSheet writableSheet) throws Exception {
        KDTable kdtEntrys = (KDTable)context.get("kdtEntrys");
        ObjectValueRender destIDRender = (ObjectValueRender)kdtEntrys.getColumn("srcID").getRenderer();
        int rowCount = kdtEntrys.getRowCount();
        int baseRowIndex = 1;
        WritableCellFormat cellFormat = this.getCellFormat();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = kdtEntrys.getRow(i);
            String srcID = destIDRender.getText(row.getCell("srcID").getValue());
            String srcDisplay = this.getRowCellValue(row, "srcDisplay");
            String destID = this.getRowCellValue(row, "destID");
            String destDisplay = (String)row.getCell("destDisplay").getValue();
            int lineIndex = baseRowIndex + i;
            writableSheet.addCell((WritableCell)new Label(0, lineIndex, destID, (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(1, lineIndex, destDisplay, (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(2, lineIndex, srcID, (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(3, lineIndex, srcDisplay, (CellFormat)cellFormat));
        }
    }

    private WritableCellFormat getCellFormat() throws Exception {
        WritableCellFormat cellFormat = new WritableCellFormat(NumberFormats.TEXT);
        cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
        cellFormat.setBackground((Colour)CustColor.CustColor_Yellow);
        return cellFormat;
    }

    private String getRowCellValue(IRow row, String key) {
        Object value = row.getCell(key).getValue();
        if (null == value) {
            return "";
        }
        if (value instanceof DataBaseInfo) {
            return ((DataBaseInfo)value).getNumber();
        }
        return value.toString();
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        return null;
    }
}

