/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.billmapping.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.csinterface.billmapping.app.util.ThreadUtil;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.LRULinkedHashMap;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.util.EipSQLUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TempTableUtil {
    public static LRULinkedHashMap<String, String> tempTabMap = new LRULinkedHashMap(10);
    private static Logger logger = Logger.getLogger(TempTableUtil.class);
    public static final String RE_CREATE_TAB = "reCreateTab";

    private TempTableUtil() {
    }

    public static void createTempTableIfNotExist(Map param) throws DIPException {
        block12: {
            String pkTableName = (String)param.get("pkTableName");
            String tempTableName = (String)param.get("tempTableName");
            Statement sta = null;
            try {
                Connection connction = (Connection)param.get("srcCon");
                DBType dbType = (DBType)((Object)param.get("DBTYPE"));
                String srcConName = (String)param.get("srcConName");
                String srcViewName = (String)param.get("srcViewName");
                boolean flag = TempTableUtil.checkExistTable(tempTableName, connction, dbType, srcConName);
                if (!flag) {
                    String createSql = "";
                    if (dbType == DBType.SQLServer) {
                        String rule = TempTableUtil.checkSortRule(connction, srcViewName);
                        createSql = "create table " + tempTableName + "(headpk VARCHAR(50) collate " + rule + " primary key,BATCHNO INT DEFAULT 0 NOT NULL)";
                    } else {
                        createSql = "create table " + tempTableName + " (headpk VARCHAR(50) primary key, BATCHNO INT DEFAULT 0 NOT NULL)";
                    }
                    sta = connction.createStatement();
                    try {
                        sta.executeUpdate(createSql);
                        tempTabMap.putMap(pkTableName, tempTableName);
                        break block12;
                    }
                    catch (Exception e) {
                        if (param.get(RE_CREATE_TAB) == null || param.get(RE_CREATE_TAB).toString().trim().length() == 0) {
                            tempTableName = TempTableUtil.filterStr(pkTableName);
                            tempTableName = tempTableName.substring(0, 20) + "_TEMP";
                            if (dbType == DBType.PostgreSQL) {
                                tempTableName = tempTableName.toLowerCase();
                            }
                            param.put("tempTableName", tempTableName);
                            param.put(RE_CREATE_TAB, 1);
                            TempTableUtil.createTempTableIfNotExist(param);
                            break block12;
                        }
                        throw new BOSException("\u4e34\u65f6\u8868\u521b\u5efa\u5931\u8d25\uff1a", (Throwable)e);
                    }
                }
                TempTableUtil.addTempTableColumn(param);
            }
            catch (Exception e) {
                throw new DIPException("\u6253\u5f00\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25:" + e.getMessage(), e);
            }
            finally {
                SQLUtils.cleanup(sta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkSortRule(Connection connction, String srcViewName) {
        Statement sta = null;
        ResultSet rs = null;
        String rule = "DATABASE_DEFAULT";
        String ruleSql = "select c.collation_name from sys.columns c join sys.objects o on c.object_id = o.object_id  where o.name = '" + srcViewName + "' and c.name = 'HEADPK'";
        try {
            sta = connction.createStatement();
            rs = sta.executeQuery(ruleSql);
            while (rs.next()) {
                String tempRule = rs.getString("collation_name");
                if (StringUtil.isEmpty((String)tempRule)) continue;
                rule = tempRule;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)ThreadUtil.logCallStatck(e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)sta);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sta);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sta);
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkExistTable(String tempTableName, Connection connction, DBType dbType, String srcConName) {
        Statement statement;
        ResultSet rowSet;
        block5: {
            boolean bl;
            String ksql = "select * from KSQL_USERTABLES where KSQL_TABNAME ='" + tempTableName + "'";
            rowSet = null;
            statement = null;
            if (dbType == DBType.MySql) {
                ksql = "SELECT table_name FROM `INFORMATION_SCHEMA`.`TABLES` WHERE table_name ='" + tempTableName + "' AND TABLE_SCHEMA='" + srcConName + "'";
            }
            try {
                statement = connction.createStatement();
                rowSet = statement.executeQuery(ksql);
                if (!rowSet.next()) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rowSet, (Statement)statement);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rowSet, (Statement)statement);
            }
            SQLUtils.cleanup((ResultSet)rowSet, (Statement)statement);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rowSet, (Statement)statement);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertHeadpkToTempTable(List<Object> listPks, Map param) {
        PreparedStatement writeHeadpkPreSta = null;
        Connection connction = null;
        try {
            connction = (Connection)param.get("srcCon");
            String tempTableName = (String)param.get("tempTableName");
            String sql = "insert into " + tempTableName + "(headpk) values (?)";
            writeHeadpkPreSta = connction.prepareStatement(sql);
            connction.setAutoCommit(false);
            int size = 1000;
            int batch = (listPks.size() - 1) / size + 1;
            List<Object> subList = new ArrayList();
            for (int i = 0; i < batch; ++i) {
                subList = i < batch - 1 ? listPks.subList(i * size, (i + 1) * size) : listPks.subList(i * size, listPks.size());
                for (int j = 0; j < subList.size(); ++j) {
                    writeHeadpkPreSta.setObject(1, ((String)subList.get(j)).replace("'", ""));
                    writeHeadpkPreSta.addBatch();
                }
                writeHeadpkPreSta.executeBatch();
                connction.commit();
            }
            connction.setAutoCommit(true);
            SQLUtils.cleanup((Statement)writeHeadpkPreSta);
        }
        catch (Exception e) {
            logger.error((Object)("\u53cd\u5199\u4e34\u65f6\u8868\u5931\u8d25:" + e.getMessage()));
        }
        finally {
            SQLUtils.cleanup(writeHeadpkPreSta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteHeadpkFromTempTable(Map param) {
        Connection connction = (Connection)param.get("srcCon");
        Statement sta = null;
        String tempTableName = (String)param.get("tempTableName");
        if (tempTableName != null) {
            String sql = "truncate  table " + tempTableName;
            try {
                sta = connction.createStatement();
                sta.executeUpdate(sql);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                SQLUtils.cleanup((Statement)sta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTempTable(String tempTableName, Connection connction) {
        Statement sta = null;
        String sql = "drop table " + tempTableName;
        try {
            connction.setAutoCommit(false);
            sta = connction.createStatement();
            sta.executeUpdate(sql);
            connction.commit();
        }
        catch (Exception e) {
            try {
                logger.error((Object)ThreadUtil.logCallStatck(e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sta);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)sta);
        }
        SQLUtils.cleanup((Statement)sta);
    }

    public static String getTempTableName(DBType dbType, String pkTableName) {
        String tempName = TempTableUtil.filterStr(pkTableName);
        tempName = tempName + "_TEMP";
        if (dbType == DBType.PostgreSQL) {
            tempName = tempName.toLowerCase();
        }
        return tempName;
    }

    public static String filterStr(String fromStr) {
        String toStr = fromStr.replace("\"", "");
        return toStr.replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "");
    }

    public static void deleteTempPageData(Map param) throws Exception {
        PreparedStatement prepareState = null;
        Connection connction = null;
        int pageSize = (Integer)param.get("pageSize");
        try {
            connction = (Connection)param.get("srcCon");
            String tempTableName = (String)param.get("tempTableName");
            String sql = "delete from " + tempTableName + " where headpk in (select top " + pageSize + " headpk from " + tempTableName + "  order by headpk) ";
            prepareState = connction.prepareStatement(sql);
            prepareState.execute(sql);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("deletePageData  \u5220\u9664\u5206\u9875\u6570\u636e\u5931\u8d25" + e));
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(prepareState);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)prepareState);
    }

    public static void updateBatchNo(Map param) throws Exception {
        PreparedStatement prepareState = null;
        Connection connction = null;
        int pageSize = (Integer)param.get("pageSize");
        int batchNo = (Integer)param.get("i");
        DBType dbType = (DBType)((Object)param.get("DBTYPE"));
        StringBuilder upSql = new StringBuilder();
        try {
            connction = (Connection)param.get("srcCon");
            String tempTableName = (String)param.get("tempTableName");
            upSql.append("update " + tempTableName + " set batchNo = " + batchNo + " where headpk in (");
            if (dbType == DBType.MySql) {
                upSql.append("select tt.headpk from (select headpk from " + tempTableName + " where batchNo = 0  order by batchNo limit 0," + pageSize + ") tt )");
            } else {
                upSql.append("select top " + pageSize + " headpk from " + tempTableName + " where batchNo = 0)");
            }
            prepareState = connction.prepareStatement(upSql.toString());
            prepareState.executeUpdate();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("updateBatchNo  \u66f4\u65b0\u5206\u9875\u6570\u636e\u72b6\u6001\u5931\u8d25" + e));
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(prepareState);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)prepareState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTempTableColumn(Map param) throws Exception {
        Connection connection = (Connection)param.get("srcCon");
        String pkTable = (String)param.get("tempTableName");
        DBType dbType = (DBType)((Object)param.get("DBTYPE"));
        boolean existHashCodeColumn = EipSQLUtil.existsColumn(connection, pkTable, "batchNo");
        if (!existHashCodeColumn) {
            ResultSet rs = null;
            Statement stm = null;
            try {
                stm = connection.createStatement();
                if (dbType == DBType.MySql) {
                    stm.executeUpdate("ALTER TABLE " + pkTable + " ADD COLUMN BATCHNO INT");
                } else {
                    if (dbType == DBType.PostgreSQL) {
                        pkTable = pkTable.toLowerCase();
                    }
                    stm.executeUpdate("ALTER TABLE " + pkTable + " ADD BATCHNO INT");
                }
            }
            finally {
                SQLUtils.cleanup(rs, (Statement)stm);
            }
        }
        tempTabMap.putMap((String)param.get("pkTableName"), pkTable);
    }

    public static boolean isExistTempTable(String pkTableName) {
        return !StringUtils.isEmpty((String)tempTabMap.getTempTable(pkTableName));
    }
}

