/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.extract;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.biz.DataSourceEntryCollection;
import com.kingdee.eas.csinterface.biz.DataSourceEntryInfo;
import com.kingdee.eas.csinterface.biz.DataSourceFactory;
import com.kingdee.eas.csinterface.biz.DataSourceInfo;
import com.kingdee.eas.csinterface.biz.IDataSource;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.app.DataSourceType;
import com.kingdee.eas.csinterface.biz.context.EIPContext;
import com.kingdee.eas.csinterface.biz.exception.EIPException;
import com.kingdee.eas.csinterface.biz.extract.APIExtract;
import com.kingdee.eas.csinterface.biz.extract.DataBaseExtract;
import com.kingdee.eas.csinterface.biz.extract.IDataExtract;
import com.kingdee.eas.csinterface.biz.log.MonitorLogManager;
import java.util.HashMap;

public class DataExtractFactory {
    public static DataExtractFactory _instance = new DataExtractFactory();

    private DataExtractFactory() {
    }

    public static DataExtractFactory getInstance() {
        return _instance;
    }

    public IDataExtract getExtract() throws BOSException, EASBizException {
        DataSourceInfo dataSourceInfo = this.initDataSource();
        MonitorLogManager.enterDataSource(dataSourceInfo);
        DataSourceType dsType = dataSourceInfo.getDsType();
        if (DataSourceType.JDBC.equals((Object)dsType)) {
            DataBaseExtract dataBaseExtract = new DataBaseExtract();
            dataBaseExtract.copyContext();
            return dataBaseExtract;
        }
        if (DataSourceType.INTERFACE.equals((Object)dsType)) {
            APIExtract apiExtract = new APIExtract();
            return apiExtract;
        }
        throw new EIPException("\u6570\u636e\u6e90\u4e3a\u7a7a\u6216\u8005\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b");
    }

    private DataSourceInfo initDataSource() throws BOSException, EASBizException {
        EIPContext eipContext = EIPContext.getInstance();
        Context ctx = eipContext.getContext();
        ProjectInfo projectInfo = (ProjectInfo)eipContext.get("projectInfo");
        IDataSource dataSource = DataSourceFactory.getLocalInstance(ctx);
        String dataSourceId = projectInfo.getSrcObj().getId().toString();
        DataSourceInfo dataSourceInfo = dataSource.getDataSourceInfo("SELECT id,name,number,isPublish,dsType,pkTableName,mainView,allViewName,entrys.id,entrys.name,entrys.alias,entrys.type,entrys.isKey,entrys.isHead,entrys.isCheck,entrys.isChangeTime,connection.id,connection.IP,connection.Port,connection.DBType,connection.instance,connection.username,connection.password,connection.edition,connection.originType,api.customClass where id = '" + dataSourceId + "'");
        eipContext.put("dataSourceInfo", dataSourceInfo);
        eipContext.put("connectionInfo", dataSourceInfo.getConnection());
        eipContext.put("apiInfo", dataSourceInfo.getApi());
        this.parseDataSource(eipContext, dataSourceInfo);
        return dataSourceInfo;
    }

    private void parseDataSource(EIPContext eipContext, DataSourceInfo dataSourceInfo) {
        HashMap<String, String> result = new HashMap<String, String>();
        DataSourceEntryCollection entrys = dataSourceInfo.getEntrys();
        String headPK = null;
        StringBuilder entryPK = new StringBuilder();
        String changeTimeField = null;
        StringBuilder headFields = new StringBuilder();
        StringBuilder entryFields = new StringBuilder();
        StringBuilder checkFields = new StringBuilder();
        for (int i = 0; i < entrys.size(); ++i) {
            DataSourceEntryInfo entry = entrys.get(i);
            String entryName = entry.getName();
            if (entry.isIsKey()) {
                if (entry.isIsHead()) {
                    headPK = entryName;
                } else {
                    entryPK.append(entryName).append(",");
                }
            }
            if (entry.isIsChangeTime()) {
                changeTimeField = entryName;
            }
            if (entry.isIsCheck()) {
                checkFields.append(entryName).append(",");
            }
            if (entry.isIsHead()) {
                headFields.append(entryName).append(",");
                continue;
            }
            entryFields.append(entryName).append(",");
        }
        if (headPK == null) {
            throw new EIPException("\u7f3a\u5c11\u4e3b\u8868\u6620\u5c04\u5b57\u6bb5");
        }
        result.put("headpk", headPK);
        if (entryPK.length() > 0) {
            result.put("entrypk", entryPK.substring(0, entryPK.length() - 1));
        }
        if (changeTimeField != null) {
            result.put("changeTimeField", changeTimeField);
        }
        if (checkFields.length() > 0) {
            result.put("checkFields", checkFields.substring(0, checkFields.length() - 1));
        }
        if (headFields.length() > 0) {
            result.put("headFields", headFields.substring(0, headFields.length() - 1));
        }
        if (entryFields.length() > 0) {
            result.put("entryFields", entryFields.substring(0, entryFields.length() - 1));
        }
        eipContext.put("dataSourceResult", result);
    }
}

