/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.plan;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.biz.DataSourceEntryCollection;
import com.kingdee.eas.csinterface.biz.DataSourceFactory;
import com.kingdee.eas.csinterface.biz.DataSourceInfo;
import com.kingdee.eas.csinterface.biz.IDataSource;
import com.kingdee.eas.csinterface.biz.IMapping;
import com.kingdee.eas.csinterface.biz.IMappingResult;
import com.kingdee.eas.csinterface.biz.IProject;
import com.kingdee.eas.csinterface.biz.MappingEntryCollection;
import com.kingdee.eas.csinterface.biz.MappingFactory;
import com.kingdee.eas.csinterface.biz.MappingInfo;
import com.kingdee.eas.csinterface.biz.MappingResultFactory;
import com.kingdee.eas.csinterface.biz.MappingResultInfo;
import com.kingdee.eas.csinterface.biz.ProjectEntryCollection;
import com.kingdee.eas.csinterface.biz.ProjectEntryInfo;
import com.kingdee.eas.csinterface.biz.ProjectFactory;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.ISrcDBView;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewFactory;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewInfo;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class PlanManager {
    private static final Logger logger = Logger.getLogger(PlanManager.class);
    private static Map<String, Set<String>> planFiles = new HashMap<String, Set<String>>();
    private static final PlanManager instance = new PlanManager();
    private static final ThreadLocal<String> logs = new ThreadLocal();

    private PlanManager() {
        this.getPlanFile();
    }

    public static PlanManager getInstance() {
        return instance;
    }

    public String initPlan(Context ctx, String connid) throws DIPException {
        String result = null;
        try {
            ConnectionInfo info = ConnectionFactory.getLocalInstance(ctx).getConnectionInfo((IObjectPK)new ObjectStringPK(connid));
            String editon = info.getEdition();
            String type = "";
            if ("0".equals(editon)) {
                type = "EAS";
            } else if ("1".equals(editon)) {
                type = "K3Wise";
            } else {
                throw new DIPException("\u6682\u4e0d\u652f\u6301\u7684\u6e90\u7cfb\u7edf\u7c7b\u578b");
            }
            Set<String> files = planFiles.get(type.toLowerCase());
            if (files != null) {
                this.initPlanFile(ctx, info, files);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u3010\u521d\u59cb\u5316\u5931\u8d25\u3011", (Throwable)e);
            throw new DIPException("\u521d\u59cb\u5316\u5931\u8d25", e);
        }
        finally {
            result = logs.get();
            logs.set(null);
        }
        if (result == null) {
            return "\u672a\u627e\u5230\u53ef\u4ee5\u521d\u59cb\u5316\u7684\u65b9\u6848";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPlanFile() {
        String jarPath = PlanManager.class.getResource("").getPath();
        if (jarPath.startsWith("file:")) {
            jarPath = jarPath.substring(5);
        }
        if (jarPath.indexOf("!/") > -1) {
            jarPath = jarPath.substring(0, jarPath.indexOf("!/"));
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String jarName = jarEntry.getName();
                if (!jarName.startsWith("com/kingdee/eas/csinterface/biz/plan") || !jarName.endsWith(".plan")) continue;
                String[] planNames = this.getPlanNames(jarName);
                String type = planNames[0].toLowerCase();
                Set<String> files = planFiles.get(type);
                if (files == null) {
                    files = new HashSet<String>();
                    planFiles.put(type, files);
                }
                files.add(jarName);
            }
        }
        catch (IOException e) {
            logger.error((Object)"\u3010EIP\u3011\u83b7\u53d6jar\u5305\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    private String[] getPlanNames(String planName) {
        planName = planName.substring(planName.lastIndexOf(47) + 1);
        return planName.split("_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPlanFile(Context ctx, ConnectionInfo info, Set<String> files) throws IOException, BOSException, EASBizException, SQLException {
        for (String file : files) {
            String[] planNames = this.getPlanNames(file);
            InputStream is = null;
            InputStreamReader isr = null;
            BufferedReader reader = null;
            try {
                is = PlanManager.class.getResourceAsStream("/" + file);
                isr = new InputStreamReader(is, "UTF-8");
                reader = new BufferedReader(isr);
                this.enterLog("\u65b9\u6848\u540d\uff1a\u3010" + planNames[1] + "\u3011;'");
                String tempString = null;
                StringBuilder planString = new StringBuilder();
                while ((tempString = reader.readLine()) != null) {
                    planString.append(tempString);
                }
                JSONObject obj = JSONObject.parseObject((String)planString.toString());
                this.loadPlans(ctx, obj, info);
                this.enterLog("\n");
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("\u3010EIP\u3011\u65b9\u6848`" + file + "`\u52a0\u8f7d\u5931\u8d25"), (Throwable)e);
                    this.enterLog("\u52a0\u8f7d\u5931\u8d25");
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{reader, isr, is});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{reader, isr, is});
                continue;
            }
            CloseUtil.close((Closeable[])new Closeable[]{reader, isr, is});
        }
    }

    private void loadPlans(Context ctx, JSONObject obj, ConnectionInfo info) throws BOSException, EASBizException, SQLException {
        int i;
        SrcDBViewInfo viewInfo = (SrcDBViewInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)obj.getString("view"), SrcDBViewInfo.class);
        this.loadSrcDbView(ctx, viewInfo, info);
        DataSourceInfo dataSourceInfo = (DataSourceInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)obj.getString("datasource"), DataSourceInfo.class);
        this.loadDataSource(ctx, dataSourceInfo, info);
        HashMap<String, MappingInfo> map = new HashMap<String, MappingInfo>();
        JSONArray jsonArray = obj.getJSONArray("mapping");
        if (jsonArray != null) {
            for (i = 0; i < jsonArray.size(); ++i) {
                MappingInfo mappingInfo = (MappingInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonArray.getString(i), MappingInfo.class);
                String oldId = mappingInfo.getId().toString();
                this.loadMapping(ctx, mappingInfo, info);
                map.put(oldId, mappingInfo);
            }
        }
        if ((jsonArray = obj.getJSONArray("mappingResult")) != null) {
            for (i = 0; i < jsonArray.size(); ++i) {
                MappingResultInfo mappingResultInfo = (MappingResultInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonArray.getString(i), MappingResultInfo.class);
                this.loadMappingResult(ctx, mappingResultInfo, (MappingInfo)map.get(mappingResultInfo.getMapping().getId().toString()), info);
            }
        }
        ProjectInfo projectInfo = (ProjectInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)obj.getString("project"), ProjectInfo.class);
        projectInfo.setSrcObj(dataSourceInfo);
        this.loadProject(ctx, projectInfo, info, map);
    }

    private void loadSrcDbView(Context ctx, SrcDBViewInfo viewInfo, ConnectionInfo info) throws EASBizException, BOSException, SQLException {
        ISrcDBView srcDBView = SrcDBViewFactory.getLocalInstance(ctx);
        String number = info.getNumber();
        String viewInfoNum = this.getNewNumber(viewInfo.getNumber(), number);
        String oldId = this.hasInit(ctx, "T_SYN_SrcDBView", viewInfoNum);
        if (StringUtils.isEmpty((String)oldId)) {
            viewInfo.setConnection(info);
            viewInfo.setName(this.getNewNumber(viewInfo.getName(), number));
            viewInfo.setNumber(viewInfoNum);
            viewInfo.setId(BOSUuid.create((String)"D141266C"));
            srcDBView.save((CoreBaseInfo)viewInfo);
            this.enterLog("\u3010\u6e90\u7cfb\u7edf\u89c6\u56fe\u3011" + viewInfoNum + "\u521b\u5efa\u6210\u529f" + ";");
        } else {
            this.enterLog("\u3010\u6e90\u7cfb\u7edf\u89c6\u56fe\u3011" + viewInfoNum + "\u5df2\u5b58\u5728" + ";");
        }
    }

    private void loadDataSource(Context ctx, DataSourceInfo dataSourceInfo, ConnectionInfo info) throws EASBizException, BOSException, SQLException {
        IDataSource dataSource = DataSourceFactory.getLocalInstance(ctx);
        String number = info.getNumber();
        String dataSourceInfoNum = this.getNewNumber(dataSourceInfo.getNumber(), number);
        String oldId = this.hasInit(ctx, "T_EIP_BIZ_DataSource", dataSourceInfoNum);
        if (StringUtils.isEmpty((String)oldId)) {
            dataSourceInfo.setConnection(info);
            dataSourceInfo.setNumber(dataSourceInfoNum);
            dataSourceInfo.setName(this.getNewNumber(dataSourceInfo.getName(), number));
            dataSourceInfo.setId(BOSUuid.create((String)"D98F7077"));
            DataSourceEntryCollection entrys = dataSourceInfo.getEntrys();
            for (int i = 0; i < entrys.size(); ++i) {
                entrys.get(i).setId(BOSUuid.create((String)"B5A75A3B"));
            }
            dataSource.save((CoreBaseInfo)dataSourceInfo);
            this.enterLog("\u3010\u6570\u636e\u6e90\u3011" + dataSourceInfoNum + "\u521b\u5efa\u6210\u529f" + ";");
        } else {
            dataSourceInfo.setId(BOSUuid.read((String)oldId));
            this.enterLog("\u3010\u6570\u636e\u6e90\u3011" + dataSourceInfoNum + "\u5df2\u5b58\u5728" + ";");
        }
    }

    private void loadMapping(Context ctx, MappingInfo mappingInfo, ConnectionInfo info) throws EASBizException, BOSException, SQLException {
        IMapping mapping = MappingFactory.getLocalInstance(ctx);
        String number = info.getNumber();
        String mappingInfoNum = this.getNewNumber(mappingInfo.getNumber(), number);
        String oldId = this.hasInit(ctx, "T_EIP_BIZ_Mapping", mappingInfoNum);
        if (StringUtils.isEmpty((String)oldId)) {
            mappingInfo.setConn(info);
            mappingInfo.setNumber(mappingInfoNum);
            mappingInfo.setName(this.getNewNumber(mappingInfo.getName(), number));
            mappingInfo.setId(BOSUuid.create((String)"2C71CDFC"));
            MappingEntryCollection entrys = mappingInfo.getEntrys();
            for (int i = 0; i < entrys.size(); ++i) {
                entrys.get(i).setId(BOSUuid.create((String)"75ABA7D6"));
            }
            mapping.save((CoreBaseInfo)mappingInfo);
            this.enterLog("\u3010\u6620\u5c04\u5173\u7cfb\u3011" + mappingInfoNum + "\u521b\u5efa\u6210\u529f" + ";");
        } else {
            mappingInfo.setId(BOSUuid.read((String)oldId));
            this.enterLog("\u3010\u6620\u5c04\u5173\u7cfb\u3011" + mappingInfoNum + "\u5df2\u5b58\u5728" + ";");
        }
    }

    private void loadMappingResult(Context ctx, MappingResultInfo mappingResultInfo, MappingInfo mappingInfo, ConnectionInfo info) throws EASBizException, BOSException, SQLException {
        IMappingResult mappingResult = MappingResultFactory.getLocalInstance(ctx);
        String number = info.getNumber();
        String mappingResultInfoNum = this.getNewNumber(mappingResultInfo.getNumber(), number);
        String oldId = this.hasInit(ctx, "T_EIP_BIZ_MappingResult", mappingResultInfoNum);
        if (StringUtils.isEmpty((String)oldId)) {
            mappingResultInfo.setMapping(mappingInfo);
            mappingResultInfo.setNumber(mappingResultInfoNum);
            mappingResultInfo.setId(BOSUuid.create((String)"55791539"));
            mappingResultInfo.getEntrys().clear();
            mappingResult.save((CoreBaseInfo)mappingResultInfo);
            this.enterLog("\u3010\u6620\u5c04\u7ed3\u679c\u3011" + mappingResultInfoNum + "\u521b\u5efa\u6210\u529f" + ";");
        } else {
            mappingInfo.setId(BOSUuid.read((String)oldId));
            this.enterLog("\u3010\u6620\u5c04\u7ed3\u679c\u3011" + mappingResultInfoNum + "\u5df2\u5b58\u5728" + ";");
        }
    }

    private void loadProject(Context ctx, ProjectInfo projectInfo, ConnectionInfo info, Map<String, MappingInfo> map) throws EASBizException, BOSException, SQLException {
        IProject project = ProjectFactory.getLocalInstance(ctx);
        String number = info.getNumber();
        String projectInfoNum = this.getNewNumber(projectInfo.getNumber(), number);
        String oldId = this.hasInit(ctx, "T_EIP_BIZ_Project", projectInfoNum);
        if (StringUtils.isEmpty((String)oldId)) {
            projectInfo.setNumber(projectInfoNum);
            projectInfo.setName(this.getNewNumber(projectInfo.getName(), number));
            projectInfo.setId(BOSUuid.create((String)"E8160047"));
            ProjectEntryCollection entrys = projectInfo.getEntrys();
            for (int i = 0; i < entrys.size(); ++i) {
                ProjectEntryInfo entry = entrys.get(i);
                entry.setId(BOSUuid.create((String)"32D22C6B"));
                if (entry.getMappingTrans() == null) continue;
                entry.setMappingTrans(map.get(entry.getMappingTrans().getId().toString()));
            }
            project.save((CoreBaseInfo)projectInfo);
            this.enterLog("\u3010\u6570\u636e\u96c6\u6210\u65b9\u6848\u3011" + projectInfoNum + "\u521b\u5efa\u6210\u529f" + ";");
        } else {
            this.enterLog("\u3010\u6570\u636e\u96c6\u6210\u65b9\u6848\u3011" + projectInfoNum + "\u5df2\u5b58\u5728" + ";");
        }
    }

    private String getNewNumber(String oldNum, String newPrefix) {
        oldNum = oldNum.substring(oldNum.indexOf(95));
        return newPrefix + oldNum;
    }

    private String hasInit(Context ctx, String tableName, String number) throws BOSException, SQLException {
        String fid = null;
        String sql = "SELECT FID FROM " + tableName + " WHERE FNUMBER = '" + number + "'";
        Connection connection = DBUtils.getConnection(ctx);
        IRowSet rowSet = KSQLUtil.executeQuery(connection, sql);
        while (rowSet.next()) {
            fid = rowSet.getString(1);
        }
        return fid;
    }

    private void enterLog(String log) {
        if (logs.get() == null) {
            logs.set(log);
        } else {
            logs.set(logs.get() + log);
        }
    }
}

