/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.biz.transform;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.csinterface.biz.ProjectEntryCollection;
import com.kingdee.eas.csinterface.biz.ProjectEntryInfo;
import com.kingdee.eas.csinterface.biz.ProjectInfo;
import com.kingdee.eas.csinterface.biz.data.TableData;
import com.kingdee.eas.csinterface.biz.transform.ColumnTransformHandler;
import com.kingdee.eas.csinterface.biz.transform.IDataTransformHandler;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class RowTransformHandler
implements IDataTransformHandler {
    private IDataTransformHandler[] handlers = new IDataTransformHandler[]{new ColumnTransformHandler()};

    @Override
    public void handle(Map<String, Object> ctx) {
        ProjectInfo projectInfo = (ProjectInfo)ctx.get("project");
        TableData tableData = (TableData)ctx.get("srcData");
        ProjectEntryCollection coll = projectInfo.getEntrys();
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            ProjectEntryInfo col = coll.get(i);
            if (StringUtils.isEmpty((String)col.getSrcField())) continue;
            String targetField = col.getTargetField();
            if (!StringUtils.isEmpty((String)col.getParentField())) {
                targetField = col.getParentField() + "." + targetField;
            }
            mapping.put(targetField, col.getSrcField());
        }
        ctx.put("mapping", mapping);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = null;
        while (tableData.next()) {
            for (IDataTransformHandler handler : this.handlers) {
                handler.handle(ctx);
            }
            jsonObject = (JSONObject)ctx.get("rowData");
            jsonArray.add((Object)jsonObject);
        }
        ctx.put("destData", jsonArray);
    }
}

