/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.bizbill.metadata.editor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.db.DBUpdateInfo;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.IServerMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.EntityTableEditor;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.ListUIEditor;
import com.kingdee.eas.csinterface.bizbill.metadata.editor.QueryEditor;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.info.FieldInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.SqlBuilder;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class FieldEditorUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.billmapping.app.DynamicsMidBillPublisherFacadeControllerBean");

    public static void addFields(Context ctx, Connection cn, String name, List fieldInfos) throws Exception {
        FieldEditorUtil.addFields0(ctx, cn, name, fieldInfos);
    }

    private static void addFields0(Context ctx, Connection cn, String name, List fieldInfos) throws Exception {
        if (fieldInfos == null || fieldInfos.size() == 0) {
            return;
        }
        if (!MetadataUtils.checkBillName(name)) {
            throw new DIPException("\u975e\u6cd5\u7684\u5355\u636e\u540d\u79f0'" + name + "'");
        }
        DIPMetadata dm = new DIPMetadata(name);
        EntityObjectInfo entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
        EntityObjectInfo entrysEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
        ArrayList dropField = new ArrayList();
        FieldEditorUtil.checkField(fieldInfos, entityInfo, entrysEntityInfo, dropField);
        if (dropField.size() > 0) {
            FieldEditorUtil.deleteFields(ctx, cn, name, dropField);
            entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
            entrysEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
        }
        entityInfo.setTrueClone(true);
        entrysEntityInfo.setTrueClone(true);
        DataTableInfo tableInfo = entityInfo.getTable();
        DataTableInfo entrysTableInfo = entrysEntityInfo.getTable();
        QueryInfo queryInfo = UictUtils.loadQuery((IMetaDataPK)new MetaDataPK(dm.getQueryPK()));
        UIObjectInfo listUIInfo = UictUtils.loadUI((IMetaDataPK)new MetaDataPK(dm.getListUIPK()));
        EntityTableEditor entityTableEditor = new EntityTableEditor(entityInfo, tableInfo);
        EntityTableEditor entrysEntityTableEditor = new EntityTableEditor(entrysEntityInfo, entrysTableInfo);
        QueryEditor queryEditor = new QueryEditor(queryInfo, entityInfo, entrysEntityInfo);
        ListUIEditor listUIEditor = new ListUIEditor(listUIInfo, queryInfo);
        ArrayList<FieldInfo> headFields = new ArrayList<FieldInfo>();
        ArrayList<FieldInfo> entryFields = new ArrayList<FieldInfo>();
        for (int i = 0; i < fieldInfos.size(); ++i) {
            boolean isBaseDataType;
            FieldInfo fieldInfo = (FieldInfo)fieldInfos.get(i);
            if ("entrys".equals(fieldInfo.getNamePrefix())) {
                entryFields.add(fieldInfo);
            } else {
                headFields.add(fieldInfo);
            }
            if (fieldInfo.getName().indexOf(46) != -1) {
                entrysEntityTableEditor.add(fieldInfo);
            } else {
                entityTableEditor.add(fieldInfo);
            }
            String displayName = fieldInfo.getBaseDataDisplayName();
            boolean bl = isBaseDataType = !StringUtils.isEmpty((String)fieldInfo.getBaseDataType());
            if (isBaseDataType) {
                fieldInfo.setBaseDataDisplayName("number");
                queryEditor.add(fieldInfo);
                listUIEditor.addNumber(fieldInfo);
            }
            fieldInfo.setBaseDataDisplayName(displayName);
            queryEditor.add(fieldInfo);
            listUIEditor.add(fieldInfo);
        }
        listUIInfo = listUIEditor.getListUIObject();
        ArrayList<RelationshipInfo> relationInfos = new ArrayList<RelationshipInfo>();
        if (entityTableEditor.getRelationInfos() != null && entityTableEditor.getRelationInfos().size() > 0) {
            relationInfos.addAll(entityTableEditor.getRelationInfos());
        }
        if (entrysEntityTableEditor.getRelationInfos() != null && entrysEntityTableEditor.getRelationInfos().size() > 0) {
            relationInfos.addAll(entrysEntityTableEditor.getRelationInfos());
        }
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[6 + (relationInfos.size() > 0 ? relationInfos.size() : 0)];
        mds[0] = entrysTableInfo;
        mds[1] = entrysEntityInfo;
        mds[2] = tableInfo;
        mds[3] = entityInfo;
        mds[4] = queryInfo;
        mds[5] = listUIInfo;
        queryInfo.setTrueClone(true);
        if (relationInfos.size() > 0) {
            int i = 6;
            for (int j = 0; j < relationInfos.size(); ++j) {
                if (relationInfos.get(j) != null) {
                    mds[i] = (AbstractMetaDataValue)relationInfos.get(j);
                }
                ++i;
            }
        }
        MetadataStoreFactory.getServerMetadataStore((Context)ctx).saveMetadata(mds, MetadataUtils.PROJECT.getId(), null);
        FieldEditorUtil.addDBColumns(cn, entityInfo, headFields);
        FieldEditorUtil.addDBColumns(cn, entrysEntityInfo, entryFields);
    }

    public static void deleteFields(Context ctx, Connection cn, String name, List fieldInfos) throws Exception {
        FieldEditorUtil.deleteFields0(ctx, cn, name, fieldInfos);
    }

    private static void deleteFields0(Context ctx, Connection cn, String name, List fieldInfos) throws Exception {
        int i;
        if (fieldInfos == null || fieldInfos.size() == 0) {
            return;
        }
        if (!name.matches("[A-Z][A-Za-z0-9_]*")) {
            throw new DIPException("\u975e\u6cd5\u7684\u5355\u636e\u540d\u79f0'" + name + "'");
        }
        DIPMetadata dm = new DIPMetadata(name);
        EntityObjectInfo entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
        EntityObjectInfo entrysEntityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getEntryEntityPK()));
        entityInfo.setTrueClone(true);
        entrysEntityInfo.setTrueClone(true);
        fieldInfos = FieldEditorUtil.filterField4Delete(fieldInfos, entityInfo, entrysEntityInfo);
        DataTableInfo tableInfo = entityInfo.getTable();
        DataTableInfo entrysTableInfo = entrysEntityInfo.getTable();
        QueryInfo queryInfo = UictUtils.loadQuery((IMetaDataPK)new MetaDataPK(dm.getQueryPK()));
        UIObjectInfo listUIInfo = UictUtils.loadUI((IMetaDataPK)new MetaDataPK(dm.getListUIPK()));
        EntityTableEditor entityTableEditor = new EntityTableEditor(entityInfo, tableInfo);
        EntityTableEditor entrysEntityTableEditor = new EntityTableEditor(entrysEntityInfo, entrysTableInfo);
        QueryEditor queryEditor = new QueryEditor(queryInfo, entityInfo, entrysEntityInfo);
        ListUIEditor listUIEditor = new ListUIEditor(listUIInfo, queryInfo);
        for (int i2 = 0; i2 < fieldInfos.size(); ++i2) {
            FieldInfo fieldInfo = (FieldInfo)fieldInfos.get(i2);
            listUIEditor.delete(fieldInfo);
            queryEditor.delete(fieldInfo);
            if (fieldInfo.getName().indexOf(46) != -1) {
                entrysEntityTableEditor.delete(fieldInfo);
                continue;
            }
            entityTableEditor.delete(fieldInfo);
        }
        listUIInfo = listUIEditor.getListUIObject();
        AbstractMetaDataValue[] mds = new AbstractMetaDataValue[]{entrysTableInfo, entrysEntityInfo, tableInfo, entityInfo, queryInfo, listUIInfo};
        queryInfo.setTrueClone(true);
        List<String> toDelHeaderList = entityTableEditor.getToDelRelationList();
        List<String> toDelEntryList = entrysEntityTableEditor.getToDelRelationList();
        IServerMetadataStore metadataStore = MetadataStoreFactory.getServerMetadataStore((Context)ctx);
        metadataStore.saveMetadata(mds, MetadataUtils.PROJECT.getId(), null);
        if (toDelHeaderList != null && toDelHeaderList.size() > 0) {
            MetaDataPK2[] toDelHeaderPKs = new MetaDataPK2[toDelHeaderList.size()];
            for (i = 0; i < toDelHeaderList.size(); ++i) {
                toDelHeaderPKs[i] = new MetaDataPK2(toDelHeaderList.get(i) + "!" + MetaDataTypeList.RELATIONSHIP);
            }
            metadataStore.deleteMetadata(toDelHeaderPKs, MetadataUtils.PROJECT.getId());
        }
        if (toDelEntryList != null && toDelEntryList.size() > 0) {
            MetaDataPK2[] toDelEntryPKs = new MetaDataPK2[toDelEntryList.size()];
            for (i = 0; i < toDelEntryList.size(); ++i) {
                toDelEntryPKs[i] = new MetaDataPK2(toDelEntryList.get(i) + "!" + MetaDataTypeList.RELATIONSHIP);
            }
            metadataStore.deleteMetadata(toDelEntryPKs, MetadataUtils.PROJECT.getId());
        }
    }

    private static void checkField(List fieldInfos, EntityObjectInfo entityInfo, EntityObjectInfo entrysEntityInfo, List dropField) throws DIPException {
        HashSet<FieldInfo> exists = new HashSet<FieldInfo>();
        for (int i = 0; i < fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = (FieldInfo)fieldInfos.get(i);
            if (exists.contains(fieldInfo)) {
                throw new DIPException("\u6dfb\u52a0\u7684\u5b57\u6bb5\u5217\u8868\u4e2d\uff0c\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u4e24\u4e2a\u5b57\u6bb5'" + fieldInfo.getName() + "(" + fieldInfo.getAlias() + ")'");
            }
            String fname = fieldInfo.getName();
            int index = fname.indexOf(46);
            if (index != -1) {
                String prefix = fname.substring(0, index);
                String realFName = fname.substring(index + 1);
                if (!"entrys".equals(prefix)) {
                    throw new DIPException("\u6682\u65f6\u4e0d\u652f\u6301\u7684\u5206\u5f55'" + realFName + "'");
                }
                if (!realFName.matches("[A-Za-z][A-Za-z0-9_]*")) {
                    throw new DIPException("\u975e\u6cd5\u7684\u5b57\u6bb5\u540d\u79f0'" + realFName + "'");
                }
                if (entrysEntityInfo.getPropertyByName(realFName) != null) {
                    dropField.add(fieldInfo);
                    logger.error((Object)("\u68c0\u6d4b\u5230\u5206\u5f55\u5b9e\u4f53\u5143\u6570\u636e\u4e2d\u5df2\u5b58\u5728\u5b57\u6bb5'" + realFName + "'"));
                }
            } else {
                if (!fname.matches("[A-Za-z][A-Za-z0-9_]*")) {
                    throw new DIPException("\u975e\u6cd5\u7684\u5b57\u6bb5\u540d\u79f0'" + fname + "'");
                }
                if (entityInfo.getPropertyByName(fname) != null) {
                    dropField.add(fieldInfo);
                    logger.error((Object)("\u68c0\u6d4b\u5230\u8868\u5934\u5b9e\u4f53\u5143\u6570\u636e\u4e2d\u5df2\u5b58\u5728\u5b57\u6bb5'" + fname + "'"));
                }
            }
            exists.add(fieldInfo);
        }
    }

    private static List filterField4Delete(List fieldInfos, EntityObjectInfo entityInfo, EntityObjectInfo entrysEntityInfo) throws DIPException {
        ArrayList<FieldInfo> newFieldInfos = new ArrayList<FieldInfo>();
        for (int i = 0; i < fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = (FieldInfo)fieldInfos.get(i);
            String fname = fieldInfo.getName();
            int index = fname.indexOf(46);
            if (index != -1) {
                String realFName = fname.substring(index + 1);
                PropertyInfo propertyInfo = entrysEntityInfo.getPropertyByName(realFName);
                if (propertyInfo == null || !propertyInfo.isConfigured()) continue;
                newFieldInfos.add(fieldInfo);
                continue;
            }
            PropertyInfo propertyInfo = entityInfo.getPropertyByName(fname);
            if (propertyInfo == null || !propertyInfo.isConfigured()) continue;
            newFieldInfos.add(fieldInfo);
        }
        return newFieldInfos;
    }

    private static void addDBColumns(Connection cn, EntityObjectInfo entityInfo, List fieldInfos) throws BOSException {
        PropertyCollection col = entityInfo.getProperties();
        for (int i = 0; i < fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = (FieldInfo)fieldInfos.get(i);
            PropertyInfo pInfo = entityInfo.getPropertyByName(fieldInfo.getRealName());
            if (pInfo == null || !pInfo.isConfigured()) continue;
            List sqlObjs = FieldEditorUtil.addSQL4DynCol(entityInfo.getTable(), pInfo.getMappingField());
            if (sqlObjs != null && sqlObjs.size() > 0) {
                for (int j = 0; j < sqlObjs.size(); ++j) {
                    DBUtils.excuteSql(cn, ((DBUpdateInfo)sqlObjs.get(j)).getSql().getValue());
                }
            }
            if ("headpk".equalsIgnoreCase(pInfo.getName())) {
                DBUtils.excuteSql(cn, SqlBuilder.buildUniqueIndexSql(entityInfo, pInfo));
                PropertyInfo pFivoucheredInfo = entityInfo.getPropertyByName("Fivouchered");
                PropertyInfo pMidBillStatusInfo = entityInfo.getPropertyByName("midBillStatus");
                DBUtils.excuteSql(cn, SqlBuilder.buildCombineIndexSql(entityInfo, pFivoucheredInfo, pMidBillStatusInfo));
            }
            if (!"entrypk".equalsIgnoreCase(pInfo.getName())) continue;
            PropertyInfo pEntrySatatusInfo = entityInfo.getPropertyByName("entryStatus");
            PropertyInfo pAssignmentNumberInfo = entityInfo.getPropertyByName("assignmentNumber");
            PropertyInfo pParentInfo = entityInfo.getPropertyByName("parent");
            DBUtils.excuteSql(cn, SqlBuilder.buildCombineIndexSql(entityInfo, pEntrySatatusInfo, pAssignmentNumberInfo));
            DBUtils.excuteSql(cn, SqlBuilder.buildIndexSql(entityInfo, pParentInfo));
        }
    }

    public static List addSQL4DynCol(DataTableInfo table, ColumnInfo column) {
        if (column == null) {
            return null;
        }
        LinkedList<DBUpdateInfo> sqlObjs = new LinkedList<DBUpdateInfo>();
        if (!column.isMultilingual()) {
            DBUpdateInfo info = new DBUpdateInfo(11, table.getName(), column.getName(), SqlBuilder.buildColumnSql((AbstractTableInfo)table, column), 0);
            sqlObjs.add(info);
        } else {
            for (int i = 1; i <= 3; ++i) {
                DBUpdateInfo info = new DBUpdateInfo(11, table.getName(), column.getName() + "_l" + i, SqlBuilder.buildColumnSqlInMultiLanguage((AbstractTableInfo)table, column, i), 0);
                sqlObjs.add(info);
            }
        }
        return sqlObjs;
    }
}

