/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.bizbill.metadata.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.DynamicMetadataFactory;
import com.kingdee.bos.config.IDynamicMetadata;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitHelper;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.SuffixCollection;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.DBUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetaDataGetter;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataUtils;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.SqlBuilder;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.TemplateHelper;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class MetadataTemplateCopyUtil {
    private static final Logger logger = Logger.getLogger(MetadataTemplateCopyUtil.class);
    private static SuffixCollection suffixs;

    private static synchronized void initSuffixs(Context ctx) {
        if (suffixs == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            SolutionInfo solution = loader.getSolution();
            suffixs = solution.getSuffixes();
        }
    }

    public static BizUnitInfo copy(Context ctx, String name, String alias) throws Exception {
        String editUI;
        BizUnitInfo temp;
        JoinQueryInfo query;
        if (!name.matches("[A-Z][A-Za-z0-9_]*")) {
            throw new DIPException("\u975e\u6cd5\u7684\u5355\u636e\u540d\u79f0'" + name + "'");
        }
        MetadataTemplateCopyUtil.initSuffixs(ctx);
        MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).clear(MetaDataTypeList.UIOBJECT);
        XMLAccessEngine.getXMLLoader((Context)ctx).clearCacheByType(MetaDataTypeList.UIOBJECT);
        BizUnitInfo template = TemplateHelper.getBizUnit("com.kingdee.eas.csinterface.DynamicBillTemplate");
        BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(ctx);
        bizUnitCtrl.loadAll(template, true, false);
        EntityObjectInfo entity = template.getEntity();
        if (entity != null) {
            entity.setExtendedProperty("commonControllerName", "com.kingdee.eas.csinterface.app.DynamicBillTemplate");
            entity.setTrueClone(true);
        }
        if ((entity = template.getRelatedEntity()) != null) {
            entity.setTrueClone(true);
        }
        if ((query = template.getQuery()) != null) {
            query.setTrueClone(true);
        }
        BizUnitInfo bizUnit = temp = bizUnitCtrl.clone(template, suffixs, "com.kingdee.eas.csinterface.custom", name, 0);
        temp.setAlias(alias);
        temp.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        temp.setPackage("com.kingdee.eas.csinterface.custom");
        if (temp.getEditUI() != null && !StringUtils.isEmpty((String)template.getEditUIPK())) {
            temp.getEditUI().setTemplateUIClass(template.getEditUIPK());
        }
        if (temp.getListUI() != null && !StringUtils.isEmpty((String)template.getListUIPK())) {
            temp.getListUI().setTemplateUIClass(template.getListUIPK());
            if (temp.getEditUI() != null && !StringUtils.isEmpty((String)template.getEditUIPK())) {
                temp.getListUI().setTemplateEditUIClass(template.getEditUIPK());
                temp.getListUI().setDynEditUIClass(temp.getEditUI().getRealFullName());
            }
        }
        if (temp.getRelatedTreeUI() != null && !StringUtils.isEmpty((String)template.getRelatedEditUIPK())) {
            temp.getRelatedTreeUI().setTemplateUIClass(template.getRelatedEditUIPK());
        }
        if ((query = temp.getQuery()) != null) {
            query.setExtendedProperty("f7WindowTitle", alias);
            query.setExtendedProperty("F7WindowTitle", alias);
        }
        if ((entity = temp.getEntity()) != null) {
            editUI = entity.getExtendedProperty("editUI");
            if (!StringUtils.isEmpty((String)editUI)) {
                entity.setExtendedProperty("editUI", editUI + "$$" + template.getEditUIPK());
            }
            String listUI = entity.getExtendedProperty("listUI");
            if (!StringUtils.isEmpty((String)editUI)) {
                entity.setExtendedProperty("listUI", listUI + "$$" + template.getListUIPK());
            }
        }
        if ((entity = temp.getRelatedEntity()) != null && !StringUtils.isEmpty((String)(editUI = entity.getExtendedProperty("editUI")))) {
            entity.setExtendedProperty("editUI", editUI + "$$" + template.getRelatedTreeUI());
        }
        AbstractMetaDataValue[] mds = new MetaDataGetter(temp).getMetaData();
        for (int i = 0; i < mds.length; ++i) {
            AbstractMetaDataValue md = mds[i];
            md.setDynamic(true);
        }
        if (MetadataTemplateCopyUtil.existsInDynamicmetas(ctx, mds, MetadataUtils.PROJECT)) {
            throw new DIPException("\u521b\u5efa\u5931\u8d25\uff0c\u8be5\u5355\u636e\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        UictUtils.saveMetadata(mds, MetadataUtils.PROJECT, ctx);
        MetadataTemplateCopyUtil.generateTable(ctx, (DataTableInfo)mds[0], (DataTableInfo)mds[2]);
        MetadataTemplateCopyUtil.clearCache(ctx, mds, template);
        MetadataUtils.clearServerMetadataCache();
        return bizUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateTable(Context ctx, DataTableInfo tableInfo, DataTableInfo entryTableInfo) throws BOSException {
        Connection cn = null;
        try {
            cn = DBUtils.getConnection(ctx);
            String tableSql = SqlBuilder.buildTableSql(tableInfo);
            String entryTableSql = SqlBuilder.buildTableSql(entryTableInfo);
            DBUtils.excuteSql(cn, tableSql);
            DBUtils.excuteSql(cn, entryTableSql);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateTable(Context ctx, DataTableInfo tableInfo) throws BOSException {
        Connection cn = null;
        try {
            cn = DBUtils.getConnection(ctx);
            String tableSql = SqlBuilder.buildTableSql(tableInfo);
            DBUtils.excuteSql(cn, tableSql);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(Context ctx, String name) throws Exception {
        DIPMetadata customeMetadata = new DIPMetadata(name);
        EntityObjectInfo headerEntity = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(customeMetadata.getHeaderEntityPK()));
        EntityObjectInfo entryEntity = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(customeMetadata.getEntryEntityPK()));
        HashSet<String> relations = new HashSet<String>();
        MetadataTemplateCopyUtil.readRelationsFromEntity(headerEntity, relations);
        MetadataTemplateCopyUtil.readRelationsFromEntity(entryEntity, relations);
        MetaDataPK2[] toDelPKs = new MetaDataPK2[11 + relations.size()];
        toDelPKs[0] = new MetaDataPK2(customeMetadata.getBizUnitPK() + "!" + MetaDataTypeList.BIZUNIT);
        toDelPKs[1] = new MetaDataPK2(customeMetadata.getHeaderEntityPK() + "!" + MetaDataTypeList.ENTITY);
        toDelPKs[2] = new MetaDataPK2(customeMetadata.getHeaderTablePK() + "!" + MetaDataTypeList.DATATABLE);
        toDelPKs[3] = new MetaDataPK2(customeMetadata.getEntryEntityPK() + "!" + MetaDataTypeList.ENTITY);
        toDelPKs[4] = new MetaDataPK2(customeMetadata.getEntryTablePK() + "!" + MetaDataTypeList.DATATABLE);
        toDelPKs[5] = new MetaDataPK2(customeMetadata.getQueryPK() + "!" + MetaDataTypeList.JOINQUERY);
        toDelPKs[6] = new MetaDataPK2(customeMetadata.getListUIPK() + "!" + MetaDataTypeList.UIOBJECT);
        toDelPKs[7] = new MetaDataPK2(customeMetadata.getListUIFunctionPK() + "!" + MetaDataTypeList.FUNCTION);
        toDelPKs[8] = new MetaDataPK2(customeMetadata.getEditUIPK() + "!" + MetaDataTypeList.UIOBJECT);
        toDelPKs[9] = new MetaDataPK2(customeMetadata.getEditUIFunctionPK() + "!" + MetaDataTypeList.FUNCTION);
        toDelPKs[10] = new MetaDataPK2(customeMetadata.getRuleSetPK() + "!" + MetaDataTypeList.BIZRULESET);
        int i = 0;
        for (String rpk : relations) {
            toDelPKs[11 + i] = new MetaDataPK2(rpk + "!" + MetaDataTypeList.RELATIONSHIP);
            ++i;
        }
        MetadataStoreFactory.getServerMetadataStore((Context)ctx).deleteMetadata(toDelPKs, MetadataUtils.PROJECT.getId());
        Connection cn = null;
        String headerTable = DIPMetadata.getShortName(customeMetadata.getHeaderTablePK());
        String entryTable = DIPMetadata.getShortName(customeMetadata.getEntryTablePK());
        String dropHeaderTable = "drop table " + headerTable;
        String dropEntryTable = "drop table " + entryTable;
        try {
            cn = DBUtils.getConnection(ctx);
            if (DBUtils.isTableExists(cn, headerTable)) {
                try {
                    DBUtils.excuteSql(cn, dropHeaderTable);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (DBUtils.isTableExists(cn, entryTable)) {
                try {
                    DBUtils.excuteSql(cn, dropEntryTable);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        MetadataUtils.clearServerMetadataCache();
    }

    public static void readRelationsFromEntity(EntityObjectInfo headerEntity, HashSet<String> relations) {
        PropertyCollection pcs = headerEntity.getProperties();
        if (pcs != null) {
            for (int i = 0; i < pcs.size(); ++i) {
                PropertyInfo pInfo = pcs.get(i);
                if (!(pInfo instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo lpInfo = (LinkPropertyInfo)pInfo;
                relations.add(lpInfo.getRelationship().getRealFullName());
            }
        }
    }

    public static boolean existsInDynamicmetas(Context ctx, AbstractMetaDataValue[] md, Project project) {
        if (md == null || md.length < 1) {
            return false;
        }
        String sql = "where ";
        if (project != null) {
            sql = sql + "projectid = '" + project.getId() + "' and ";
        }
        sql = sql + "metadatapk in (";
        int n = md.length;
        for (int i = 0; i < n; ++i) {
            sql = i == 0 ? sql + "'" + md[i].getRealFullName() + "'" : sql + ",'" + md[i].getRealFullName() + "'";
        }
        sql = sql + ")";
        try {
            IDynamicMetadata idynamic = DynamicMetadataFactory.getLocalInstance((Context)ctx);
            if (idynamic.exists(sql)) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return false;
    }

    public static void clearCache(Context ctx, AbstractMetaDataValue[] mds, BizUnitInfo template) {
        AbstractMetaDataValue md2 = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        for (int i = 0; i < mds.length; ++i) {
            md2 = mds[i];
            if (md2 instanceof UIObjectInfo) continue;
            logger.info((Object)(" clear md cache --- > [" + md2.getBOSType() + "]" + md2.getFullName()));
            if (md2 == null || StringUtils.isEmpty((String)md2.getFullName())) continue;
            loader.clear(md2.getBOSType(), (IMetaDataPK)new MetaDataPK(md2.getFullName()));
        }
        List tmds = BizUnitHelper.getRelatedMetadatas((BizUnitInfo)template);
        for (AbstractMetaDataValue md2 : tmds) {
            if (md2 == null || StringUtils.isEmpty((String)md2.getFullName())) continue;
            loader.clear(md2.getBOSType(), (IMetaDataPK)new MetaDataPK(md2.getFullName()));
        }
    }
}

