/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.business.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingHelper;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingType;
import com.kingdee.eas.csinterface.billmapping.DataProcessType;
import com.kingdee.eas.csinterface.billmapping.DynamicsMidBillPublisherFacadeFactory;
import com.kingdee.eas.csinterface.billmapping.IBillMapping;
import com.kingdee.eas.csinterface.billmapping.IDynamicsMidBillPublisherFacade;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.business.BizWizardFactory;
import com.kingdee.eas.csinterface.business.NetType;
import com.kingdee.eas.csinterface.business.app.AbstractImportPresetPlanControllerBean;
import com.kingdee.eas.csinterface.planmanager.IPlanManagerBaseDataTypMappingEntry;
import com.kingdee.eas.csinterface.planmanager.PlanManagerBaseDataTypMappingEntryCollection;
import com.kingdee.eas.csinterface.planmanager.PlanManagerBaseDataTypMappingEntryFactory;
import com.kingdee.eas.csinterface.planmanager.PlanManagerBaseDataTypMappingEntryInfo;
import com.kingdee.eas.csinterface.planmanager.PlanManagerInfo;
import com.kingdee.eas.csinterface.syncdatabase.ApplicationScopeType;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryCollection;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.AssistAccountTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.syncdatabase.IAssistAccountType;
import com.kingdee.eas.csinterface.syncdatabase.IBaseDataType;
import com.kingdee.eas.csinterface.syncdatabase.ISrcDBView;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewFactory;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ImportUtil;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.utils.ViewSQLSimpleParser;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ImportPresetPlanControllerBean
extends AbstractImportPresetPlanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.business.app.ImportPresetPlanControllerBean");
    protected BOTRuleSegmentInfo ruleSeg;
    public static Locale zh_en = LocaleUtils.locale_en_US;
    public static Locale zh_cn = LocaleUtils.locale_zh_CN;
    public static Locale zh_hk = LocaleUtils.locale_zh_TW;
    private Map idMap = new HashMap();
    private Map assistAccountTypeFIDMap = new HashMap();
    private Map preValueMap = new HashMap();

    @Override
    protected Object _savePresetPlan(Context ctx, Object planManagerInfo, Object presetValue) throws BOSException, EASBizException {
        BillMappingInfo billMappingInfo;
        this.idMap.clear();
        this.preValueMap.clear();
        this.preValueMap = (Map)presetValue;
        PlanManagerInfo info = (PlanManagerInfo)planManagerInfo;
        if (info == null) {
            return this.idMap;
        }
        this.preValueMap.put("planName", info.getName());
        this.saveSrcDBViewInfo(ctx, info);
        this.saveBaseDataTypeInfos(ctx, info);
        this.saveAssistAccountInfo(ctx, info);
        Object billType = this.preValueMap.get("mappingType");
        BillMappingType mappingType = null;
        if (billType != null) {
            mappingType = (BillMappingType)((Object)billType);
        }
        if ((billMappingInfo = this.saveBillMappingInfo(ctx, info, mappingType)) == null) {
            return this.idMap;
        }
        boolean shouldPublish = (Boolean)this.preValueMap.get("publish");
        if (shouldPublish) {
            this.publishBillMapping(ctx, billMappingInfo);
        }
        DIPMetadata dm = new DIPMetadata(billMappingInfo.getNumber());
        EntityObjectInfo entityInfo = UictUtils.loadEntity((IMetaDataPK)new MetaDataPK(dm.getHeaderEntityPK()));
        BOTMappingInfo botpInfo = info.getBotprule();
        if (null != entityInfo.getType()) {
            String bosType = entityInfo.getType().toString();
            System.err.println(bosType);
            if (botpInfo != null) {
                botpInfo.setSrcEntityName(bosType);
            }
        }
        this.saveBOTMappingInfo(ctx, info);
        return this.idMap;
    }

    private void saveSrcDBViewInfo(Context ctx, PlanManagerInfo planManagerInfo) throws BOSException, EASBizException {
        SrcDBViewInfo info = planManagerInfo.getCreatesourceviewsql();
        if (null != info) {
            try {
                ISrcDBView instance = SrcDBViewFactory.getLocalInstance(ctx);
                String currentNumber = info.getNumber();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                String targetNumber = ImportUtil.getTargetValue((ICoreBase)instance, view, currentNumber);
                info.setNumber((String)this.preValueMap.get("number"));
                info.setName((String)this.preValueMap.get("name"));
                NetType netType = (NetType)((Object)this.preValueMap.get("netType"));
                DataSourceType dsType = DataSourceType.getEnum(netType.getName());
                info.setDsType(dsType);
                if (DataSourceType.jdbc.equals((Object)dsType)) {
                    info.setConnection((ConnectionInfo)this.preValueMap.get("dbConn"));
                } else {
                    info.setAgentUser((EipUserInfo)this.preValueMap.get("dbConn"));
                }
                String srcViewSql = info.getCreateViewSql();
                srcViewSql = ImportPresetPlanControllerBean.replaceViewNameNew(info.getNumber(), srcViewSql, this.preValueMap);
                info.setMainView((String)this.preValueMap.get("mainView"));
                info.setCreateViewSql(srcViewSql);
                Object scope = this.preValueMap.get("applicationScope");
                if (scope != null) {
                    info.setApplicationScope((ApplicationScopeType)((Object)scope));
                }
                IObjectPK objectUuidPK = instance.addnew((CoreBaseInfo)info);
                this.idMap.put("srcDBViewId", (BOSUuid)objectUuidPK.getKeyValue("id"));
                planManagerInfo.setCreatesourceviewsql(info);
            }
            catch (Exception e) {
                throw new BOSException("\u5f15\u5165\u65b9\u6848\u7684\u3010\u6e90\u7cfb\u7edf\u89c6\u56fe\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    private void saveBaseDataTypeInfos(Context ctx, PlanManagerInfo planManagerInfo) throws BOSException, EASBizException {
        PlanManagerBaseDataTypMappingEntryCollection collection = planManagerInfo.getBaseDataTypMappingEntry();
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> mapIdSet = new HashSet<String>();
        if (null != collection && collection.size() > 0) {
            try {
                int length = collection.size();
                Map viewNameMap = (Map)this.preValueMap.get("viewNameMap");
                IBaseDataType instance = BaseDataTypeFactory.getLocalInstance(ctx);
                IPlanManagerBaseDataTypMappingEntry entryInstance = PlanManagerBaseDataTypMappingEntryFactory.getLocalInstance(ctx);
                for (int i = 0; i < length; ++i) {
                    Object scope;
                    BaseDataTypeInfo info;
                    PlanManagerBaseDataTypMappingEntryInfo item = collection.get(i);
                    if (null == item || null == (info = item.getBaseDataTypeF7())) continue;
                    String currentNumber = info.getNumber();
                    EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                    String targetNumber = ImportUtil.getTargetValue((ICoreBase)instance, view, currentNumber);
                    info.setNumber(targetNumber);
                    String currentName = info.getName();
                    EntityViewInfo viewName = ImportUtil.getEntityViewInfo4Equal("name", currentName);
                    String targetName = ImportUtil.getTargetValue((ICoreBase)instance, viewName, currentName);
                    info.setName(targetName);
                    NetType netType = (NetType)((Object)this.preValueMap.get("netType"));
                    DataSourceType dsType = DataSourceType.getEnum(netType.getName());
                    if (DataSourceType.jdbc.equals((Object)dsType)) {
                        info.setDsType(dsType);
                        info.setConn((ConnectionInfo)this.preValueMap.get("dbConn"));
                    } else {
                        info.setDsType(DataSourceType.file);
                    }
                    String desfOrgField = info.getDestOrgField();
                    if (StringUtils.isEmpty((String)desfOrgField) || StringUtils.endsWithIgnoreCase((String)desfOrgField, (String)"null")) {
                        info.setDestOrgField("");
                    }
                    String srcTable = info.getSrcTable();
                    if (!StringUtils.isEmpty((String)(srcTable = (String)viewNameMap.get(srcTable)))) {
                        info.setSrcTable(srcTable);
                    }
                    if ((scope = this.preValueMap.get("applicationScope")) != null) {
                        info.setApplicationScope((ApplicationScopeType)((Object)scope));
                    }
                    IObjectPK objectUuidPK = instance.addnew(info);
                    BOSUuid newBOSUuid = (BOSUuid)objectUuidPK.getKeyValue("id");
                    info.setId(newBOSUuid);
                    idSet.add(newBOSUuid.toString());
                    this.idMap.put("baseDataTypeId", newBOSUuid);
                    String oldFID = (String)info.get("baseDataTypeFID_TO_BE_REFERENCED");
                    if (null != oldFID) {
                        this.idMap.put(oldFID, newBOSUuid.toString());
                    }
                    logger.info((Object)("baseDateTypeMap(" + i + "):[" + oldFID + "] -> [" + newBOSUuid.toString() + "]"));
                    BaseDataMapingInfo mappingInfo = new BaseDataMapingInfo();
                    mappingInfo.setBaseDataType(info);
                    mappingInfo.setNumber(info.getNumber());
                    mappingInfo.setApplicationScope((ApplicationScopeType)((Object)scope));
                    try {
                        BaseDataInfo baseData = info.getDestBaseData();
                        IObjectPK pk = CommonUtil.convert2PK(baseData.getId().toString());
                        baseData = BaseDataFactory.getLocalInstance(ctx).getBaseDataInfo(pk);
                        String queryName = baseData.getQueryName();
                        OrgType orgType = CommonUtil.getOrgTypeByQueryName(queryName);
                        String ouId = null;
                        if (OrgType.Company == orgType) {
                            ouId = this.preValueMap.get("ou").toString();
                        } else if (OrgType.ControlUnit == orgType) {
                            ouId = this.preValueMap.get("cu").toString();
                        }
                        mappingInfo.setOrgUnit(ouId);
                    }
                    catch (Exception e) {
                        logger.info((Object)("\u81ea\u52a8\u521b\u5efa\u503c\u6620\u5c04\u65f6\uff0c\u8bbe\u7f6e\u7ec4\u7ec7\u51fa\u9519\uff0c\u7c7b\u578b\u6620\u5c04\u7f16\u7801\uff1a" + info.getNumber()));
                    }
                    IObjectPK pk = BaseDataMapingFactory.getLocalInstance(ctx).save((CoreBaseInfo)mappingInfo);
                    mapIdSet.add(pk.toString());
                    logger.info((Object)("baseDateMappingId(" + i + "):[" + pk.toString() + "]"));
                }
                this.idMap.put("baseDataTypeIds", idSet);
                this.idMap.put("basedataMappingIds", mapIdSet);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException("\u5f15\u5165\u65b9\u6848\u7684\u3010\u57fa\u7840\u6570\u636e\u7c7b\u578b\u6620\u5c04\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    private BillMappingInfo saveBillMappingInfo(Context ctx, PlanManagerInfo planManagerInfo, BillMappingType mappingType) throws BOSException, EASBizException {
        BillMappingInfo info = planManagerInfo.getBizbillmapping();
        if (null != info) {
            try {
                IBillMapping instance = BillMappingFactory.getLocalInstance(ctx);
                String currentNumber = info.getNumber();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                String targetNumber = ImportUtil.getTargetValue((ICoreBase)instance, view, currentNumber, false);
                targetNumber = (String)this.preValueMap.get("number");
                info.setNumber((String)this.preValueMap.get("number"));
                info.setPkTableName("");
                String midBillTable = BillMappingHelper.calc2MidBillTableName(targetNumber);
                info.setMidBillTable(midBillTable);
                String midBillEntryTable = BillMappingHelper.calc2MidBillEntryTableName(targetNumber);
                info.setMidBillEntryTable(midBillEntryTable);
                String billMappingName = info.getBillMappingName();
                this.preValueMap.put("planName", billMappingName);
                EntityViewInfo nameView = ImportUtil.getEntityViewInfo4Equal("billMappingName", billMappingName);
                String targetBillMappingName = ImportUtil.getTargetValue((ICoreBase)instance, nameView, billMappingName, false);
                targetBillMappingName = (String)this.preValueMap.get("name");
                info.setBillMappingName(targetBillMappingName);
                NetType netType = (NetType)((Object)this.preValueMap.get("netType"));
                DataSourceType dsType = DataSourceType.getEnum(netType.getName());
                info.setDsType(dsType);
                if (NetType.jdbc.equals((Object)netType)) {
                    info.setSrcDBConn((ConnectionInfo)this.preValueMap.get("dbConn"));
                } else {
                    info.setAgentUser((EipUserInfo)this.preValueMap.get("dbConn"));
                }
                String midBillEntityMetaAlias = BillMappingHelper.calc2MidBillEntityMetaAlias(targetBillMappingName);
                midBillEntityMetaAlias = targetBillMappingName;
                info.setMidBillEntityMetaAlias(midBillEntityMetaAlias);
                String preType = info.getDataProcessType() == null ? "allNotProcess" : info.getDataProcessType().getName();
                info.setDataProcessType(DataProcessType.getEnum(preType));
                IBaseDataType IBaseDataTypeInstance = BaseDataTypeFactory.getLocalInstance(ctx);
                BillMappingEntryCollection entryCollection = info.getEntrys();
                for (int i = 0; i < entryCollection.size(); ++i) {
                    BillMappingEntryInfo entryInfo = entryCollection.get(i);
                    this.replaceBaseDataType(IBaseDataTypeInstance, entryInfo);
                }
                info.setSrcViewName((String)this.preValueMap.get("mainView"));
                info.setIntegrateCashFlow(info.isIntegrateCashFlow());
                if (mappingType != null) {
                    info.setMappingType(mappingType);
                }
                IAssistAccountType IAssistAccountTypeInstance = AssistAccountTypeFactory.getLocalInstance(ctx);
                this.replaceAssistAccountType(IAssistAccountTypeInstance, info);
                IObjectPK objectUuidPK = instance.addnew(info);
                info.setId((BOSUuid)objectUuidPK.getKeyValue("id"));
                this.idMap.put("billMappingId", (BOSUuid)objectUuidPK.getKeyValue("id"));
                BOTMappingInfo botpInfo = planManagerInfo.getBotprule();
                if (botpInfo != null) {
                    botpInfo.setSrcEntityFullName("com.kingdee.eas.csinterface.custom.app." + targetNumber);
                    botpInfo.setSrcEntityAlias(info.getMidBillEntityMetaAlias());
                }
            }
            catch (Exception e) {
                throw new BOSException("\u5f15\u5165\u65b9\u6848\u7684\u3010\u4e1a\u52a1\u5355\u636e\u6620\u5c04\u89c4\u5219\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
        return info;
    }

    private void replaceBaseDataType(IBaseDataType instance, BillMappingEntryInfo entryInfo) throws EASBizException, BOSException {
        String oldFID = (String)entryInfo.get("baseDataTypeFID_TO_BE_REPLACED");
        if (null != oldFID) {
            String newFID = (String)this.idMap.get(oldFID);
            if (null == newFID) {
                logger.error((Object)("\u672a\u80fd\u627e\u5230\u57fa\u7840\u8d44\u6599FID[" + oldFID + "]\u5728\u76ee\u6807\u7cfb\u7edf\u4e2d\u5bf9\u5e94\u7684\u65b0\u7684FID\u3002"));
                return;
            }
            BaseDataTypeInfo item = instance.getBaseDataTypeInfo((IObjectPK)new ObjectUuidPK(newFID));
            entryInfo.setBaseDataType(item);
        }
    }

    private void publishBillMapping(Context ctx, BillMappingInfo billMappingInfo) throws BOSException, EASBizException {
        if (null == billMappingInfo) {
            return;
        }
        String id = billMappingInfo.getId().toString();
        IDynamicsMidBillPublisherFacade facade = DynamicsMidBillPublisherFacadeFactory.getLocalInstance(ctx);
        try {
            facade.publish(id);
        }
        catch (Exception e) {
            logger.error((Object)ThrowableHelper.toString(e));
            throw new BOSException((Throwable)e);
        }
    }

    private void saveBOTMappingInfo(Context ctx, PlanManagerInfo planManagerInfo) throws BOSException, EASBizException {
        BOTMappingInfo info = planManagerInfo.getBotprule();
        if (null != info) {
            try {
                IBOTMapping instance = BOTMappingFactory.getLocalInstance((Context)ctx);
                String currentName = info.getName();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("name", currentName);
                String targetName = ImportUtil.getTargetValue((ICoreBase)instance, view, currentName);
                targetName = (String)this.preValueMap.get("name");
                info.setName(targetName);
                String currentAliasName = info.getAlias();
                EntityViewInfo aliasView = ImportUtil.getEntityViewInfo4Equal("alias", currentAliasName);
                String targetAliasName = ImportUtil.getTargetValue((ICoreBase)instance, aliasView, currentAliasName);
                targetAliasName = (String)this.preValueMap.get("name");
                info.setAlias(targetAliasName);
                info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                info.getRevRule();
                info.getDelRevRule();
                info.getExtRule();
                BOTRuleCollection rules = info.getRules();
                if (rules.size() > 0) {
                    BOTRuleSegmentCollection segmentCollection = rules.get(0).getRuleSegments();
                    int segmentSize = segmentCollection.size();
                    BOTRuleSegmentInfo segment = null;
                    String tmpAlias = "";
                    String tmpExpre = "";
                    for (int i = 0; i < segmentSize; ++i) {
                        segment = segmentCollection.get(i);
                        if (segment == null) continue;
                        tmpAlias = segment.getAlias();
                        if (tmpAlias != null) {
                            segment.setAlias(this.replaceBOTRuleName(tmpAlias));
                            segment.setAlias(this.replaceBOTRuleName(tmpAlias), zh_cn);
                        }
                        if (StringUtils.endsWithIgnoreCase((String)segment.getDestPropertyName(), (String)"company")) {
                            try {
                                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.preValueMap.get("company");
                                if (company != null) {
                                    String id = company.getId().toString();
                                    String type = company.getBOSType().toString();
                                    if (company.containsKey("name")) {
                                        segment.setAlias(company.get("name").toString());
                                    }
                                    String expression = MessageFormat.format("return com.kingdee.eas.base.botp.BotpHelper.getObjectByIdWithBosType(__bosContext, \"{0}\", \"{1}\");", id, type);
                                    segment.setExpression(expression);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if ((tmpExpre = segment.getExpression()) == null) continue;
                        segment.setExpression(this.replaceBOTRuleName(tmpExpre));
                    }
                }
                IObjectPK objectUuidPK = instance.addnew((CoreBaseInfo)info);
                instance.enableMapping((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                info.setId((BOSUuid)objectUuidPK.getKeyValue("id"));
                this.idMap.put("botpRuleId", info.getId());
            }
            catch (Exception e) {
                throw new BOSException("\u5f15\u5165\u65b9\u6848\u7684\u3010BOTP\u89c4\u5219\u3011\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    public static String replaceViewName(Map<String, String> viewNameMap, String sql) {
        if (StringUtils.isEmpty((String)sql)) {
            return "";
        }
        for (String viewName : viewNameMap.keySet()) {
            if (sql.indexOf(viewName) <= -1) continue;
            sql = sql.replace(viewName, viewNameMap.get(viewName));
        }
        return sql;
    }

    public static String replaceViewNameNew(String number, String sql, Map preValueMap) {
        if (StringUtils.isEmpty((String)sql)) {
            return "";
        }
        ViewSQLSimpleParser simpleParser = new ViewSQLSimpleParser(sql);
        ArrayList<ViewSQLSimpleParser.ViewParseResult> parseResults = simpleParser.getParseResult();
        ArrayList<String> ksqls = new ArrayList<String>();
        ArrayList<String> viewNames = new ArrayList<String>();
        String mainViewName = null;
        int index = 0;
        for (ViewSQLSimpleParser.ViewParseResult parseResult : parseResults) {
            ++index;
            if (!parseResult.isCreateViewSql()) {
                return "";
            }
            if (parseResult.hasHeadpk) {
                mainViewName = parseResult.viewName;
            }
            viewNames.add(parseResult.viewName);
            ksqls.add("/*dialect*/" + parseResult.viewSql);
        }
        int seq = 1;
        for (String viewName : viewNames) {
            if (sql.indexOf(viewName) <= -1) continue;
            sql = sql.replace(viewName, "V_" + number + "_" + seq++);
        }
        simpleParser = new ViewSQLSimpleParser(sql);
        parseResults = simpleParser.getParseResult();
        for (ViewSQLSimpleParser.ViewParseResult parseResult : parseResults) {
            if (!parseResult.hasHeadpk) continue;
            mainViewName = parseResult.viewName;
            break;
        }
        preValueMap.put("mainView", mainViewName);
        return sql;
    }

    public String replaceBOTRuleName(String obj) {
        if (StringUtils.isEmpty((String)obj)) {
            return "";
        }
        String oldValue = String.valueOf(this.preValueMap.get("planName"));
        String newValue = String.valueOf(this.preValueMap.get("name"));
        obj = obj.replace(oldValue, newValue);
        return obj;
    }

    @Override
    protected Map _saveExistPlan(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        IBillMapping billInstance = BillMappingFactory.getLocalInstance(ctx);
        String billId = param.get("billMappingId").toString();
        BillMappingInfo billInfo = billInstance.getBillMappingInfo(CommonUtil.convert2PK(billId));
        int existSize = BizWizardFactory.getLocalInstance(ctx).getPKList("where billMapId = '" + billId + "'").length;
        if (existSize > 0) {
            throw new BOSException("\u5355\u636e\u5df2\u7ecf\u88ab\u5411\u5bfc\u5f15\u7528\uff0c\u4e0d\u80fd\u518d\u6b21\u521b\u5efa\u5411\u5bfc\u3002");
        }
        result.put("netType", billInfo.getDsType().getName());
        DataSourceType dsType = billInfo.getDsType();
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            if (billInfo.getSrcDBConn() == null) {
                throw new BOSException("\u5355\u636e\u4f7f\u7528\u7684\u6e90\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6b63\u5e38\u5bfc\u5165\u3002");
            }
            result.put("dbConnId", billInfo.getSrcDBConn().getId().toString());
        } else {
            if (billInfo.getAgentUser() == null) {
                throw new BOSException("\u5355\u636e\u4f7f\u7528\u7684\u5ba2\u6237\u7aef\u4ee3\u7406\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6b63\u5e38\u5bfc\u5165\u3002");
            }
            result.put("dbConnId", billInfo.getAgentUser().getId().toString());
        }
        String srcDBViewId = billInstance.getSrcDbView(billId);
        result.put("srcDBViewId", srcDBViewId);
        List botpIds = billInstance.getBOTPList(billId, true);
        result.put("botpRuleId", botpIds.size() > 0 ? (String)botpIds.get(0) : "1");
        return result;
    }

    private void saveAssistAccountInfo(Context ctx, PlanManagerInfo planManagerInfo) {
        BillMappingInfo info = planManagerInfo.getBizbillmapping();
        if (info == null) {
            return;
        }
        AssistAccountTypeInfo aaTypeInfo = info.getAssistAccountType();
        if (null != aaTypeInfo) {
            try {
                Object scope;
                IAssistAccountType instance = AssistAccountTypeFactory.getLocalInstance(ctx);
                String currentNumber = aaTypeInfo.getNumber();
                EntityViewInfo view = ImportUtil.getEntityViewInfo4Equal("number", currentNumber);
                String targetNumber = ImportUtil.getTargetValue((ICoreBase)instance, view, currentNumber, false);
                aaTypeInfo.setNumber(targetNumber);
                IBaseDataType IBaseDataTypeInstance = BaseDataTypeFactory.getLocalInstance(ctx);
                AssistAccountTypeEntryCollection entryCollection = aaTypeInfo.getEntrys();
                for (int i = 0; i < entryCollection.size(); ++i) {
                    AssistAccountTypeEntryInfo entryInfo = entryCollection.get(i);
                    this.replaceBaseDataType(IBaseDataTypeInstance, entryInfo);
                }
                NetType netType = (NetType)((Object)this.preValueMap.get("netType"));
                if (NetType.jdbc.equals((Object)netType)) {
                    aaTypeInfo.setConn((ConnectionInfo)this.preValueMap.get("dbConn"));
                }
                if ((scope = this.preValueMap.get("applicationScope")) != null) {
                    aaTypeInfo.setApplicationScope((ApplicationScopeType)((Object)scope));
                }
                IObjectPK newBOSUuid = instance.addnew(aaTypeInfo);
                String oldFID = (String)aaTypeInfo.get("assistAccountTypeFID_TO_BE_REPLACED");
                if (null != oldFID) {
                    this.assistAccountTypeFIDMap.put(oldFID, newBOSUuid.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void replaceBaseDataType(IBaseDataType instance, AssistAccountTypeEntryInfo entryInfo) throws EASBizException, BOSException {
        String oldFID = (String)entryInfo.get("baseDataTypeFID_TO_BE_REPLACED");
        if (null != oldFID) {
            String newFID = (String)this.idMap.get(oldFID);
            if (null == newFID) {
                logger.error((Object)("\u672a\u80fd\u627e\u5230\u57fa\u7840\u8d44\u6599FID[" + oldFID + "]\u5728\u76ee\u6807\u7cfb\u7edf\u4e2d\u5bf9\u5e94\u7684\u65b0\u7684FID\u3002"));
                return;
            }
            BaseDataTypeInfo item = instance.getBaseDataTypeInfo((IObjectPK)new ObjectUuidPK(newFID));
            entryInfo.setBaseDataType(item);
        }
    }

    private void replaceAssistAccountType(IAssistAccountType instance, BillMappingInfo info) throws EASBizException, BOSException {
        String oldFID = (String)info.get("assistAccountTypeFID_TO_BE_REPLACED");
        if (null != oldFID) {
            String newFID = (String)this.assistAccountTypeFIDMap.get(oldFID);
            if (null == newFID) {
                logger.error((Object)("\u672a\u80fd\u627e\u5230\u57fa\u7840\u8d44\u6599FID[" + oldFID + "]\u5728\u76ee\u6807\u7cfb\u7edf\u4e2d\u5bf9\u5e94\u7684\u65b0\u7684FID\u3002"));
                return;
            }
            AssistAccountTypeInfo item = instance.getAssistAccountTypeInfo((IObjectPK)new ObjectUuidPK(newFID));
            info.setAssistAccountType(item);
        }
    }
}

