/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.cloud;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.csinterface.util.EncodingUtils;
import com.kingdee.eas.csinterface.util.IOUtils;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class Web20AppClient {
    private static final String WEB20_BASE_URL = "http://web20.kingdee.com";
    private static final Logger logger = CoreUIObject.getLogger(Web20AppClient.class);

    public static String urlEncodedUTF8(String data) throws Exception {
        return URLEncoder.encode(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createResource(String resourceid, String category, String name, String desc) throws Exception {
        byte[] byArray;
        String uri = "/app/rest/resource/new/" + resourceid + "/" + category + "/" + name + "/" + desc;
        DataOutputStream dataOutputStream = null;
        InputStream inputStream = null;
        ByteArrayOutputStream baoutputStream = null;
        try {
            URL url = new URL(WEB20_BASE_URL + uri);
            logger.info((Object)("URL:" + url.toExternalForm()));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestMethod("POST");
            con.setRequestProperty("Connection", "Keep-Alive");
            con.setRequestProperty("Charset", "UTF-8");
            con.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
            dataOutputStream = new DataOutputStream(con.getOutputStream());
            dataOutputStream.flush();
            inputStream = con.getInputStream();
            baoutputStream = new ByteArrayOutputStream();
            IOUtils.copy(inputStream, baoutputStream);
            byArray = baoutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeInputStreamQuietly(inputStream);
            IOUtils.closeOutputStreamQuietly(dataOutputStream);
            IOUtils.closeOutputStreamQuietly(baoutputStream);
            throw throwable;
        }
        IOUtils.closeInputStreamQuietly(inputStream);
        IOUtils.closeOutputStreamQuietly(dataOutputStream);
        IOUtils.closeOutputStreamQuietly(baoutputStream);
        return byArray;
    }

    public static byte[] queryCategory(String categoryId) throws Exception {
        String uri = "/app/rest/type/category/" + categoryId;
        return Web20AppClient.getDataAsByte(uri);
    }

    public static byte[] queryAllResourceAndFile(String categoryId) throws Exception {
        String uri = "/app/rest/type/category/" + categoryId + "/all";
        return Web20AppClient.getDataAsByte(uri);
    }

    public static byte[] queryResourceFile(String resourceid, String version) throws Exception {
        String uri = "/app/rest/resource/" + resourceid + "/" + version;
        return Web20AppClient.getDataAsByte(uri);
    }

    public static byte[] downloadFile(String resourceId, String version, String fileName) throws Exception {
        String custNo = Web20AppClient.getCustomerNumber();
        String uri = "/app/rest/resource/dnload/" + resourceId + "/" + version + "/" + fileName + "/" + custNo;
        return Web20AppClient.getDataAsByte(uri);
    }

    public static String getCustomerNumber() {
        String cNum = "custno_unknown";
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            String serialNum = baseInfo.getSerialNum();
            if (!StringUtils.isEmpty((String)serialNum)) {
                cNum = serialNum;
            }
        }
        catch (LicenseException e) {
            logger.error((Object)("[custNO]getLicenseException:" + (Object)((Object)e)));
        }
        return cNum;
    }

    public static byte[] downloadFileFromURI(String uri) throws Exception {
        return Web20AppClient.getDataAsByte(uri);
    }

    public static byte[] downloadFile(String resourceId) throws Exception {
        String uri = "/app/rest/resource/dnload/" + resourceId;
        return Web20AppClient.getDataAsByte(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] uploadFileByte(String resourceId, String version, String fileName, String filedesc, byte[] fileData) throws Exception {
        byte[] byArray;
        String uri = "/app/rest/resource/upload/" + resourceId + "/" + version;
        String newLine = "\r\n";
        String twoHyphens = "--";
        String boundary = "*****";
        DataOutputStream dataOutputStream = null;
        InputStream inputStream = null;
        ByteArrayOutputStream baoutputStream = null;
        try {
            URL url = new URL(WEB20_BASE_URL + uri);
            logger.info((Object)("URL:" + url.toExternalForm()));
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestMethod("POST");
            con.setRequestProperty("Connection", "Keep-Alive");
            con.setRequestProperty("Charset", "UTF-8");
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            dataOutputStream = new DataOutputStream(con.getOutputStream());
            dataOutputStream.writeBytes(newLine);
            dataOutputStream.writeBytes(twoHyphens + boundary + newLine);
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"" + newLine);
            dataOutputStream.writeBytes("Content-Type: application/octet-stream" + newLine);
            dataOutputStream.writeBytes(newLine);
            dataOutputStream.write(fileData, 0, fileData.length);
            dataOutputStream.writeBytes(newLine);
            dataOutputStream.writeBytes(twoHyphens + boundary + newLine);
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"filedesc\"" + newLine);
            dataOutputStream.writeBytes(newLine);
            dataOutputStream.writeBytes(filedesc);
            dataOutputStream.writeBytes(newLine);
            dataOutputStream.writeBytes(twoHyphens + boundary + twoHyphens + newLine);
            dataOutputStream.writeBytes(newLine);
            dataOutputStream.flush();
            inputStream = con.getInputStream();
            baoutputStream = new ByteArrayOutputStream();
            IOUtils.copy(inputStream, baoutputStream);
            byArray = baoutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeInputStreamQuietly(inputStream);
            IOUtils.closeOutputStreamQuietly(dataOutputStream);
            IOUtils.closeOutputStreamQuietly(baoutputStream);
            throw throwable;
        }
        IOUtils.closeInputStreamQuietly(inputStream);
        IOUtils.closeOutputStreamQuietly(dataOutputStream);
        IOUtils.closeOutputStreamQuietly(baoutputStream);
        return byArray;
    }

    public static byte[] uploadFile(String resourceId, String version, String fileName, String filedesc, String fileContent) throws Exception {
        byte[] fileByte = EncodingUtils.str2BytesUTF8(fileContent);
        return Web20AppClient.uploadFileByte(resourceId, version, fileName, filedesc, fileByte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getDataAsByte(String uri) throws Exception {
        byte[] byArray;
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            byte[] bytes;
            URL url = new URL(WEB20_BASE_URL + uri);
            logger.info((Object)("URL:" + url.toExternalForm()));
            URLConnection urlConn = url.openConnection();
            inputStream = urlConn.getInputStream();
            outputStream = new ByteArrayOutputStream();
            IOUtils.copy(inputStream, outputStream);
            byArray = bytes = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeInputStreamQuietly(inputStream);
            IOUtils.closeOutputStreamQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeInputStreamQuietly(inputStream);
        IOUtils.closeOutputStreamQuietly(outputStream);
        return byArray;
    }
}

