/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.model;

import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.DataColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StructuredDataModel
implements Serializable {
    private static final long serialVersionUID = 2357973549216849724L;
    private boolean isCompleted;
    private TableModel[] tables;
    private TableModel hostTable;
    private TableModel[] priorityTables;
    private List priorityTablesRelation;
    public static final int DATASOURCE_DB = 1;
    public static final int DATASOURCE_FILE = 2;
    private int datasourceType;
    private String modelName;
    private String modelAlias;
    private Map modelProperties;
    private String pkField;

    public StructuredDataModel(String modelName, String modelAlias, Map modelProperties, String pkField) {
        this.pkField = pkField;
        this.modelName = modelName;
        this.modelAlias = modelAlias;
        this.modelProperties = modelProperties == null ? new HashMap() : modelProperties;
    }

    public StructuredDataModel(String modelName, String modelAlias, TableModel[] tables, String pkField) {
        this(modelName, modelAlias, new HashMap(), pkField);
        this.tables = tables;
    }

    public StructuredDataModel(String modelName, String modelAlias, Map modelProperties, TableModel[] tables, String pkField) {
        this(modelName, modelAlias, modelProperties, pkField);
        this.tables = tables;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelAlias() {
        return this.modelAlias;
    }

    public int getDatasourceType() {
        return this.datasourceType;
    }

    public Object getProperty(String name) {
        return this.modelProperties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.modelProperties.put(name, value);
    }

    public String getPkField() {
        return this.pkField;
    }

    public void setPkField(String pkField) {
        this.pkField = pkField;
    }

    public synchronized void addTable(TableModel table) throws DIPException {
        this.checkReady();
        if (this.tables == null) {
            this.tables = new TableModel[1];
        } else {
            TableModel[] _tables = new TableModel[this.tables.length + 1];
            System.arraycopy(this.tables, 0, _tables, 0, this.tables.length);
            this.tables = _tables;
        }
        this.tables[this.tables.length - 1] = table;
    }

    public synchronized void addTableRelation(TableModel table1, TableModel table2, int relation) throws DIPException {
        this.checkReady();
        table1.addRelation(table2, relation);
        switch (relation) {
            case 2: {
                table2.addRelation(table1, 1);
                break;
            }
            case 1: {
                table2.addRelation(table1, 2);
                break;
            }
        }
    }

    private void checkReady() throws DIPException {
        if (this.isCompleted) {
            throw new DIPException("forbidden modify the completed DataModel");
        }
    }

    public synchronized boolean isCompleted() {
        return this.isCompleted;
    }

    public TableModel[] getPriorityTables() {
        return this.priorityTables;
    }

    public List getPriorityTablesRelation() {
        return this.priorityTablesRelation;
    }

    public synchronized void setCompleted() throws DIPException {
        if (this.tables == null || this.tables.length == 0) {
            throw new DIPException("\u6570\u636e\u6a21\u578b\u4e0d\u5b58\u5728\u8868\u6a21\u578b");
        }
        this.checkReady();
        HashSet<TableModel> existTables = new HashSet<TableModel>();
        for (int i = 0; i < this.tables.length; ++i) {
            if (existTables.contains(this.tables[i])) {
                throw new DIPException("\u6a21\u578b\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u8868\u540d'" + this.tables[i].name + "'");
            }
            existTables.add(this.tables[i]);
            this.checkTableModel(this.tables[i]);
            Map relations = this.tables[i].getTableRelations();
            if (relations == null || relations.size() == 0) {
                this.hostTable = this.tables[i];
                continue;
            }
            if (this.hostTable != null) continue;
            Set keySet = relations.keySet();
            boolean hasManyToOne = false;
            for (TableModel tableModel : keySet) {
                int relation = (Integer)relations.get(tableModel);
                if (2 != relation) continue;
                hasManyToOne = true;
                break;
            }
            if (hasManyToOne) continue;
            this.hostTable = this.tables[i];
        }
        if (this.hostTable == null) {
            throw new DIPException("\u6570\u636e\u6e90\u6620\u5c04\u5173\u7cfb\u4e0d\u6b63\u786e!");
        }
        ArrayList traversalPath = new ArrayList(this.tables.length);
        ArrayList priorityPath = new ArrayList(this.tables.length);
        this.processTableRelation(this.hostTable, traversalPath, priorityPath);
        if (priorityPath.size() != this.tables.length) {
            throw new DIPException("\u6570\u636e\u6e90\u6570\u636e\u8868\u5173\u8054\u5173\u7cfb\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u6620\u5c04\u5173\u7cfb!");
        }
        this.priorityTables = priorityPath.toArray(new TableModel[0]);
        this.priorityTablesRelation = this.prepareTableRelation(this.priorityTables);
        this.isCompleted = true;
    }

    private List prepareTableRelation(TableModel[] tableModels) {
        ArrayList<int[]> priorityTablesRelation = new ArrayList<int[]>();
        for (int i = 0; i < tableModels.length; ++i) {
            Map relations = tableModels[i].getTableRelations();
            if (relations == null) {
                return priorityTablesRelation;
            }
            Set entrySet = relations.entrySet();
            block1: for (Map.Entry entry : entrySet) {
                TableModel tableModel = (TableModel)entry.getKey();
                int relation = (Integer)entry.getValue();
                if (relation != 1) continue;
                for (int j = 0; j < tableModels.length; ++j) {
                    if (!tableModels[j].name.equals(tableModel.name)) continue;
                    int[] tablesRelation = new int[]{i, j, relation};
                    priorityTablesRelation.add(tablesRelation);
                    continue block1;
                }
            }
        }
        return priorityTablesRelation;
    }

    private void checkTableModel(TableModel tableModel) throws DIPException {
        ColumnModel[] columns = tableModel.columns;
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].isPk) continue;
            return;
        }
        throw new DIPException("\u8868\u6a21\u578b'" + tableModel.name + "'\u7f3a\u5c11\u4e3b\u952e");
    }

    private void processTableRelation(TableModel tableModel, List traversalPath, List priorityPath) {
        Map tRelations;
        if (traversalPath.size() == 0) {
            traversalPath.add(tableModel);
            priorityPath.add(tableModel);
        }
        if ((tRelations = tableModel.getTableRelations()) == null || tRelations.size() == 0) {
            return;
        }
        Set tEntrySet = tRelations.entrySet();
        for (Map.Entry tEntry : tEntrySet) {
            TableModel tTableModel = (TableModel)tEntry.getKey();
            if (traversalPath.contains(tTableModel)) continue;
            Map relations = tTableModel.getTableRelations();
            Set pEntrySet = relations.entrySet();
            for (Map.Entry entry : pEntrySet) {
                TableModel pTableModel = (TableModel)entry.getKey();
                int pRelation = (Integer)entry.getValue();
                if (pRelation != 2) continue;
                int index = priorityPath.indexOf(tTableModel);
                if (index != -1) {
                    if (priorityPath.contains(pTableModel)) continue;
                    priorityPath.add(index, pTableModel);
                    continue;
                }
                if (priorityPath.contains(pTableModel)) continue;
                priorityPath.add(pTableModel);
            }
            if (!priorityPath.contains(tTableModel)) {
                priorityPath.add(tTableModel);
            }
            traversalPath.add(tTableModel);
            if (tTableModel.getTableRelations() == null) continue;
            this.processTableRelation(tTableModel, traversalPath, priorityPath);
        }
    }

    public String toString() {
        return this.modelName + "(" + this.modelAlias + ")";
    }

    public int hashCode() {
        return this.modelName.hashCode();
    }

    public static void main(String[] args) throws DIPException {
        ColumnModel cm;
        ColumnModel[] cms = new ColumnModel[1];
        boolean isPrimaryKey = true;
        cms[0] = cm = new ColumnModel("id", "id", isPrimaryKey, null, false);
        TableModel[] tms = new TableModel[5];
        TableModel A = new TableModel("A", cms, "A", "A1");
        TableModel B = new TableModel("B", cms, "A", "A1");
        TableModel C = new TableModel("C", cms, "A", "A1");
        TableModel D = new TableModel("D", cms, "A", "A1");
        TableModel E = new TableModel("E", cms, "A", "A1");
        tms[0] = B;
        tms[1] = A;
        tms[2] = C;
        tms[3] = D;
        tms[4] = E;
        StructuredDataModel model = new StructuredDataModel("name", "\u540d\u79f0", tms, "no");
        model.addTableRelation(B, C, 1);
        model.addTableRelation(A, D, 1);
        model.addTableRelation(A, B, 1);
        model.addTableRelation(B, E, 1);
        model.setCompleted();
        TableModel[] ptms = model.getPriorityTables();
        for (int i = 0; i < ptms.length; ++i) {
            System.out.println(ptms[i]);
        }
        List list = model.getPriorityTablesRelation();
        for (int i = 0; i < list.size(); ++i) {
            int[] a = (int[])list.get(i);
            System.out.print(a[0]);
            System.out.print(a[1]);
            System.out.print(a[2]);
            System.out.println();
        }
    }

    public static class ColumnModel
    extends DataColumn {
        private static final long serialVersionUID = 6868134209562838835L;
        public String srcName;
        public final String srcAlias;
        public final String destName;
        public final String destAlias;
        public final boolean isPk;
        public final boolean isChangeful;
        public final SQLType sqlType;
        public final Object baseDataType;
        public final boolean isChangeSyn;
        public String defaultValue;

        public ColumnModel(String name, String alias, String destName, String destAlias, SQLType sqlType, boolean isPrimaryKey, Object baseDataType, boolean isChangeful) {
            super(name, alias);
            this.srcName = name;
            this.srcAlias = alias;
            this.destName = destName;
            this.destAlias = destAlias;
            this.isPk = isPrimaryKey;
            this.sqlType = sqlType;
            this.baseDataType = baseDataType;
            this.isChangeful = isChangeful;
            this.isChangeSyn = false;
        }

        public ColumnModel(String name, String alias, String destName, String destAlias, SQLType sqlType, boolean isPrimaryKey, Object baseDataType, boolean isChangeful, String defaultValue) {
            super(name, alias);
            this.srcName = name;
            this.srcAlias = alias;
            this.destName = destName;
            this.destAlias = destAlias;
            this.isPk = isPrimaryKey;
            this.sqlType = sqlType;
            this.baseDataType = baseDataType;
            this.isChangeful = isChangeful;
            this.isChangeSyn = false;
            this.defaultValue = defaultValue;
        }

        public ColumnModel(String name, String alias, String destName, String destAlias, SQLType sqlType, boolean isPrimaryKey, Object baseDataType, boolean isChangeful, String defaultValue, String srcName, String srcAlias) {
            super(name, alias);
            this.srcName = srcName;
            this.srcAlias = srcAlias;
            this.destName = destName;
            this.destAlias = destAlias;
            this.isPk = isPrimaryKey;
            this.sqlType = sqlType;
            this.baseDataType = baseDataType;
            this.isChangeful = isChangeful;
            this.isChangeSyn = false;
            this.defaultValue = defaultValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public ColumnModel(String name, String alias, boolean isPrimaryKey, String baseDataType, boolean isChangeful) {
            this(name, alias, null, null, null, isPrimaryKey, baseDataType, isChangeful);
        }

        public ColumnModel(String name, String alias) {
            this(name, alias, false, null, false);
        }
    }

    public static class TableModel
    implements Serializable {
        private static final long serialVersionUID = 4984100858533057477L;
        public static final int RELATION_NONE = -1;
        public static final int RELATION_ONE_TO_MANY = 1;
        public static final int RELATION_MANY_TO_ONE = 2;
        public final String name;
        public final ColumnModel[] columns;
        public final ColumnModel pkColumn;
        public String srcEntity;
        public String desEntiry;
        public ColumnModel[] baseDataTypes;
        private transient Map tableRelations;

        public TableModel(String name, ColumnModel[] columns, String srcEntity, String desEntiry) {
            this.name = name;
            this.srcEntity = srcEntity;
            this.desEntiry = desEntiry;
            ColumnModel pkColumn = null;
            ArrayList<ColumnModel> _columns = new ArrayList<ColumnModel>();
            ArrayList<ColumnModel> baseDataTypes = new ArrayList<ColumnModel>();
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].isPk) {
                    pkColumn = columns[i];
                    _columns.add(0, columns[i]);
                } else {
                    _columns.add(columns[i]);
                }
                if (columns[i].baseDataType == null) continue;
                baseDataTypes.add(columns[i]);
            }
            this.columns = _columns.toArray(new ColumnModel[0]);
            this.pkColumn = pkColumn;
            this.baseDataTypes = baseDataTypes.toArray(new ColumnModel[0]);
        }

        void addRelation(TableModel relationTable, int relation) throws DIPException {
            switch (relation) {
                case 1: 
                case 2: {
                    if (this.tableRelations == null) {
                        this.tableRelations = new HashMap();
                    }
                    this.tableRelations.put(relationTable, new Integer(relation));
                    break;
                }
                default: {
                    throw new DIPException("\u672a\u77e5\u5173\u7cfb\u503c'" + relation + "'");
                }
            }
        }

        Map getTableRelations() {
            return this.tableRelations;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return ((TableModel)obj).name.equals(this.name);
        }

        public String toString() {
            return this.name;
        }

        public String getSrcEntity() {
            return this.srcEntity;
        }

        public void setSrcEntity(String srcEntity) {
            this.srcEntity = srcEntity;
        }

        public String getDesEntiry() {
            return this.desEntiry;
        }

        public void setDesEntiry(String desEntiry) {
            this.desEntiry = desEntiry;
        }
    }
}

