/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.process.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.csinterface.DynamicBillStatus;
import com.kingdee.eas.csinterface.DynamicBillTemplateEntryInfo;
import com.kingdee.eas.csinterface.DynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.IDynamicBillTemplate;
import com.kingdee.eas.csinterface.TransactionWrapperFacadeFactory;
import com.kingdee.eas.csinterface.app.TransactionBlock;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingType;
import com.kingdee.eas.csinterface.billmapping.ReportType;
import com.kingdee.eas.csinterface.billmapping.util.BillMappingUtil;
import com.kingdee.eas.csinterface.bizbill.metadata.info.DIPMetadata;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.UictUtils;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.DataRow;
import com.kingdee.eas.csinterface.data.model.DataTable;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.model.StructuredTableData;
import com.kingdee.eas.csinterface.data.process.IBatchProcessor;
import com.kingdee.eas.csinterface.monitor.app.FeedBackManager;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.monitor.app.SrcToMidBillMonitorLogInfo;
import com.kingdee.eas.csinterface.syncdatabase.EIPRelationCollection;
import com.kingdee.eas.csinterface.syncdatabase.EIPRelationFactory;
import com.kingdee.eas.csinterface.syncdatabase.IEIPRelation;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MidBillSaveBatchProcessor
implements IBatchProcessor {
    @Override
    public String getProcessorID() {
        return "MidBillSaveBatchProcessor";
    }

    @Override
    public StructuredTableData process(final Context ctx, final StructuredTableData data, final StructuredDataModel model) throws DIPException {
        IMetaDataPK pk = this.getMetaDataPK(model);
        final BOSObjectType bosType = this.getBosType(ctx, pk);
        final CoreBaseCollection middleColl = this.createMidBills(data, model, pk, bosType);
        this.checkReportMapping(ctx, middleColl, model, data);
        this.checkBaseDataMapping(ctx, middleColl, model, data);
        try {
            TransactionWrapperFacadeFactory.getLocalInstance(ctx).doInvokerWithTransaction(new TransactionBlock(){

                @Override
                public Object doTransaction() throws Exception {
                    MidBillSaveBatchProcessor.this.insertMidBills(ctx, bosType, middleColl);
                    FeedBackManager.addFeedBackLog(ctx, data, model);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new DIPException("\u6570\u636e\u66f4\u65b0\u5230\u4e2d\u95f4\u8868\u5f02\u5e38:" + e.getMessage(), e);
        }
        return data;
    }

    private void checkBaseDataMapping(Context ctx, CoreBaseCollection middleColl, StructuredDataModel model, StructuredTableData data) throws DIPException {
        BillMappingType type = (BillMappingType)((Object)model.getProperty("mappingType"));
        if (!BillMappingType.basedataIntegrate.equals((Object)type)) {
            return;
        }
        String number = (String)model.getProperty("number");
        MetaDataPK metaPk = new MetaDataPK(new DIPMetadata(number).getHeaderEntityPK());
        EntityObjectInfo entity = UictUtils.loadEntity((IMetaDataPK)metaPk);
        if (entity == null || entity.getType() == null) {
            throw new DIPException("\u8bbe\u7f6e\u4e2d\u95f4\u5355\u636e\u72b6\u6001\u5f02\u5e38,\u67e5\u8be2\u7f16\u7801\u4e3a" + number + "\u4e1a\u52a1\u5355\u636e\u6620\u5c04BOSTYPE\u5931\u8d25");
        }
        String srcBostype = entity.getType().toString();
        HashSet<String> headpks = new HashSet<String>();
        for (int i = 0; i < middleColl.size(); ++i) {
            headpks.add(middleColl.get(i).get("headpk").toString());
        }
        IEIPRelation instance = null;
        try {
            int i;
            instance = EIPRelationFactory.getLocalInstance(ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterBill = new FilterInfo();
            viewInfo.setFilter(filterBill);
            filterBill.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcBostype, CompareType.EQUALS));
            filterBill.getFilterItems().add(new FilterItemInfo("headpk", headpks, CompareType.INCLUDE));
            EIPRelationCollection coll = instance.getEIPRelationCollection(viewInfo);
            HashSet<String> exists = new HashSet<String>();
            for (i = 0; i < coll.size(); ++i) {
                exists.add(coll.get(i).getHeadpk());
            }
            for (i = 0; i < middleColl.size(); ++i) {
                if (!exists.contains(middleColl.get(i).get("headpk").toString())) continue;
                ((DynamicBillTemplateInfo)middleColl.get(i)).setMidBillStatus(DynamicBillStatus.updated);
            }
        }
        catch (BOSException e) {
            throw new DIPException("\u4e2d\u95f4\u5355\u9884\u8bbe\u72b6\u6001\u5931\u8d25", e);
        }
    }

    private void checkReportMapping(Context ctx, CoreBaseCollection middleColl, StructuredDataModel model, StructuredTableData data) throws DIPException {
        String billNumber = model.getModelName();
        boolean isReportMapping = false;
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)billNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("mappingType", (Object)"20", CompareType.EQUALS));
            isReportMapping = BillMappingFactory.getLocalInstance(ctx).exists(filter);
        }
        catch (Exception e) {
            throw new DIPException("\u5355\u636e\u6620\u5c04\u7f16\u7801(" + billNumber + ")\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002");
        }
        if (isReportMapping) {
            int errorCount = 0;
            SrcToMidBillMonitorLogInfo motorLog = MonitorManager.getCurrentSrcToMidBill();
            try {
                Class<?> cashFlowFactory = Class.forName("com.kingdee.eas.fi.rpt.batch.iref.ReportBillProcessImpl");
                ReportType reportType = (ReportType)((Object)model.getProperty("reportType"));
                Method method = cashFlowFactory.getMethod("deleteInvalidReport", Context.class, CoreBaseInfo.class, Map.class, ReportType.class);
                Map<String, String> reportFieldMap = BillMappingUtil.getReportFieldForProperty(ctx, billNumber);
                DataTable headDataTable = data.getFirstDataTable();
                for (int i = 0; i < middleColl.size(); ++i) {
                    CoreBaseInfo info = middleColl.get(i);
                    Object errorMsgObj = method.invoke(cashFlowFactory.newInstance(), new Object[]{ctx, info, reportFieldMap, reportType});
                    if (errorMsgObj == null || StringUtils.isEmpty((String)errorMsgObj.toString())) continue;
                    headDataTable.remove(info.get("headpk"));
                    middleColl.remove(info);
                    String context = motorLog.getContent();
                    if (StringUtil.isEmpty((String)context)) {
                        context = "";
                    }
                    motorLog.setContent(context + "\r\nheadpk =" + info.get("headpk") + "\u7684\u5355\u636e:" + errorMsgObj.toString());
                    ++errorCount;
                }
                motorLog.addIgnoreBillCount(errorCount);
            }
            catch (ClassNotFoundException e1) {
                ClassNotFoundException cause = e1;
                motorLog.setStackTrace(motorLog.getStackTrace() + "\r\n\u7f3a\u5c11\u5408\u5e76\u62a5\u8868\u7684\u9a8c\u8bc1\u8865\u4e01\r\n" + ThrowableHelper.toString((Throwable)cause));
                throw new DIPException("\u62a5\u8868\u4fdd\u5b58\u5f02\u5e38", e1);
            }
            catch (Exception e) {
                Exception cause = e;
                motorLog.setStackTrace(ThrowableHelper.toString((Throwable)cause));
                throw new DIPException("\u62a5\u8868\u4fdd\u5b58\u5f02\u5e38", e);
            }
        }
    }

    private BOSObjectType getBosType(Context ctx, IMetaDataPK pk) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(pk);
        BOSObjectType bosType = entity.getType();
        return bosType;
    }

    private IMetaDataPK getMetaDataPK(StructuredDataModel model) {
        DIPMetadata dm = new DIPMetadata(model.getModelName());
        String fullName = dm.getHeaderEntityPK();
        MetaDataPK pk = MetaDataPK.create((String)fullName);
        return pk;
    }

    private CoreBaseCollection createMidBills(StructuredTableData data, StructuredDataModel model, IMetaDataPK pk, BOSObjectType bosType) {
        CoreBaseCollection middleColl = new CoreBaseCollection();
        List list = data.getFirstTableRows();
        StructuredDataModel.TableModel headerModel = model.getPriorityTables()[0];
        StructuredDataModel.TableModel entryModel = model.getPriorityTables()[1];
        for (DataRow headRow : list) {
            DynamicBillTemplateInfo head = this.fillHead(headerModel, pk, bosType, middleColl, headRow);
            List<DataRow> entryRows = headRow.getFirstChildrenDataRows();
            for (DataRow entryRow : entryRows) {
                DynamicBillTemplateEntryInfo entry = this.fillEntry(entryModel, head, entryRow);
                head.getEntrys().add(entry);
            }
        }
        return middleColl;
    }

    private void insertMidBills(Context ctx, BOSObjectType bosType, CoreBaseCollection middleColl) throws DIPException {
        IDynamicBillTemplate instance;
        try {
            instance = (IDynamicBillTemplate)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        }
        catch (BOSException e) {
            throw new DIPException(e.getMessage(), e);
        }
        try {
            instance.addBatchMidBill(middleColl);
        }
        catch (Exception e) {
            throw new DIPException("\u6570\u636e\u66f4\u65b0\u5230\u4e2d\u95f4\u8868\u5f02\u5e38:" + e.getMessage(), e);
        }
    }

    private DynamicBillTemplateEntryInfo fillEntry(StructuredDataModel.TableModel entryTableModel, DynamicBillTemplateInfo head, DataRow entryRow) {
        Map entryFields = entryRow.getValues();
        DynamicBillTemplateEntryInfo entry = new DynamicBillTemplateEntryInfo();
        entry.setParent(head);
        StructuredDataModel.ColumnModel[] entryColumns = entryTableModel.columns;
        for (int i = 0; i < entryColumns.length; ++i) {
            Object value = entryFields.get(entryColumns[i].name);
            entry.put(entryColumns[i].destName, value);
        }
        return entry;
    }

    private DynamicBillTemplateInfo fillHead(StructuredDataModel.TableModel headerTableModel, IMetaDataPK pk, BOSObjectType bosType, CoreBaseCollection middleColl, DataRow headRow) {
        Map headFields = headRow.getValues();
        DynamicBillTemplateInfo head = new DynamicBillTemplateInfo();
        String headPk = (String)headFields.get("headPk");
        head.setNumber(headPk);
        head.setBizDate(new Date(System.currentTimeMillis()));
        head.setBOSType(bosType);
        head.setPK(pk);
        middleColl.add((CoreBaseInfo)head);
        StructuredDataModel.ColumnModel[] headerColumns = headerTableModel.columns;
        for (int i = 0; i < headerColumns.length; ++i) {
            Object value = headFields.get(headerColumns[i].name);
            head.put(headerColumns[i].destName, value);
        }
        return head;
    }
}

