/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.data.process.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.data.model.DataRow;
import com.kingdee.eas.csinterface.data.model.StructuredDataModel;
import com.kingdee.eas.csinterface.data.process.DataConvertException;
import com.kingdee.eas.csinterface.data.process.IRowProcessor;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeConversionProcessor
implements IRowProcessor {
    static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss,SSS";
    private final SimpleDateFormat DATETIME_FORMATER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    @Override
    public String getProcessorID() {
        return null;
    }

    @Override
    public void process(Context ctx, DataRow dataRow, StructuredDataModel structuredDataModel) throws DIPException {
        HashMap<String, SQLType> headerTypes = (HashMap<String, SQLType>)structuredDataModel.getProperty("headTypes");
        HashMap<String, SQLType> entryTypes = (HashMap<String, SQLType>)structuredDataModel.getProperty("entryTypes");
        if (headerTypes == null) {
            headerTypes = new HashMap<String, SQLType>();
            entryTypes = new HashMap<String, SQLType>();
            StructuredDataModel.TableModel[] tableModels = structuredDataModel.getPriorityTables();
            StructuredDataModel.ColumnModel[] headerColumnModels = tableModels[0].columns;
            StructuredDataModel.ColumnModel[] entryColumnModels = tableModels[1].columns;
            for (StructuredDataModel.ColumnModel hcm : headerColumnModels) {
                headerTypes.put(hcm.name, hcm.sqlType);
            }
            for (StructuredDataModel.ColumnModel ecm : entryColumnModels) {
                entryTypes.put(ecm.name, ecm.sqlType);
            }
            structuredDataModel.setProperty("headTypes", headerTypes);
            structuredDataModel.setProperty("entryTypes", entryTypes);
        }
        Map headerRowValues = dataRow.getValues();
        Set entrySet = headerRowValues.entrySet();
        for (Map.Entry entry : entrySet) {
            SQLType sqlType = (SQLType)headerTypes.get(entry.getKey());
            if (sqlType == null) {
                throw new DataConvertException("column '" + entry.getKey() + "' does not exist!");
            }
            this.transform(entry, sqlType);
        }
        List<DataRow> entryRows = dataRow.getFirstChildrenDataRows();
        for (DataRow entryRow : entryRows) {
            Map entryRowValues = entryRow.getValues();
            Set entryRowValuesSet = entryRowValues.entrySet();
            for (Map.Entry entry : entryRowValuesSet) {
                SQLType sqlType = (SQLType)entryTypes.get(entry.getKey());
                if (sqlType == null) {
                    throw new DataConvertException("column '" + entry.getKey() + "' does not exist!");
                }
                this.transform(entry, sqlType);
            }
        }
    }

    private void transform(Map.Entry entry, SQLType sqlType) throws DIPException {
        String key = (String)entry.getKey();
        String value = (String)entry.getValue();
        if (SQLType.INT.equals((Object)sqlType)) {
            entry.setValue(Integer.parseInt(value));
        } else if (SQLType.NUMERIC.equals((Object)sqlType)) {
            entry.setValue(new BigDecimal(value));
        } else if (!(SQLType.CHAR.equals((Object)sqlType) || SQLType.VARCHAR.equals((Object)sqlType) || SQLType.NCHAR.equals((Object)sqlType) || SQLType.NVARCHAR.equals((Object)sqlType))) {
            if (SQLType.DATETIME.equals((Object)sqlType)) {
                if (!StringUtils.isEmpty((String)value)) {
                    entry.setValue(Timestamp.valueOf(value));
                }
            } else {
                throw new DIPException("not support the type of conversion : " + sqlType);
            }
        }
    }
}

